/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.eforms.sdk;

import eu.europa.ted.eforms.sdk.SdkConstants;
import eu.europa.ted.eforms.sdk.component.SdkComponent;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.eforms.sdk.entity.SdkCodelist;
import eu.europa.ted.eforms.sdk.entity.SdkField;
import eu.europa.ted.eforms.sdk.entity.SdkNode;
import eu.europa.ted.eforms.sdk.repository.SdkCodelistRepository;
import eu.europa.ted.eforms.sdk.repository.SdkFieldRepository;
import eu.europa.ted.eforms.sdk.repository.SdkNodeRepository;
import eu.europa.ted.eforms.sdk.resource.PathResource;
import eu.europa.ted.eforms.sdk.resource.SdkResourceLoader;
import eu.europa.ted.eforms.xpath.XPathInfo;
import eu.europa.ted.eforms.xpath.XPathProcessor;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.path.NodePathExpression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.types.FieldTypes;
import eu.europa.ted.efx.xpath.XPathContextualizer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.ParseCancellationException;

@SdkComponent(versions={"1", "2"}, componentType=SdkComponentType.SYMBOL_RESOLVER)
public class SdkSymbolResolver
implements SymbolResolver {
    protected Map<String, SdkField> fieldById;
    protected Map<String, SdkNode> nodeById;
    protected Map<String, SdkCodelist> codelistById;
    Map<String, XPathInfo> additionalFieldInfoMap = new HashMap<String, XPathInfo>();

    @Override
    public final List<String> expandCodelist(String string) {
        SdkCodelist sdkCodelist = this.codelistById.get(string);
        if (sdkCodelist == null) {
            throw new ParseCancellationException(String.format("Codelist '%s' not found.", string));
        }
        return sdkCodelist.getCodes();
    }

    public SdkSymbolResolver(String string, Path path) throws InstantiationException {
        this.loadMapData(string, path);
    }

    protected void loadMapData(String string, Path path) throws InstantiationException {
        Path path2 = SdkResourceLoader.getResourceAsPath((String)string, (PathResource)SdkConstants.SdkResource.FIELDS_JSON, (Path)path);
        Path path3 = SdkResourceLoader.getResourceAsPath((String)string, (PathResource)SdkConstants.SdkResource.CODELISTS, (Path)path);
        this.fieldById = new SdkFieldRepository(string, path2);
        this.nodeById = new SdkNodeRepository(string, path2);
        this.codelistById = new SdkCodelistRepository(string, path3);
    }

    @Override
    public String getParentNodeOfField(String string) {
        SdkField sdkField = this.fieldById.get(string);
        if (sdkField != null) {
            return sdkField.getParentNodeId();
        }
        throw new ParseCancellationException(String.format("Unknown field '%s'", string));
    }

    @Override
    public PathExpression getAbsolutePathOfField(String string) {
        SdkField sdkField = this.fieldById.get(string);
        if (sdkField == null) {
            throw new ParseCancellationException(String.format("Unknown field identifier '%s'.", string));
        }
        return PathExpression.instantiate(sdkField.getXpathAbsolute(), FieldTypes.fromString(sdkField.getType()));
    }

    @Override
    public PathExpression getAbsolutePathOfNode(String string) {
        SdkNode sdkNode = this.nodeById.get(string);
        if (sdkNode == null) {
            throw new ParseCancellationException(String.format("Unknown node identifier '%s'.", string));
        }
        return new NodePathExpression(sdkNode.getXpathAbsolute());
    }

    @Override
    public PathExpression getRelativePathOfField(String string, PathExpression pathExpression) {
        PathExpression pathExpression2 = this.getAbsolutePathOfField(string);
        return XPathContextualizer.contextualize(pathExpression, pathExpression2);
    }

    @Override
    public PathExpression getRelativePathOfNode(String string, PathExpression pathExpression) {
        PathExpression pathExpression2 = this.getAbsolutePathOfNode(string);
        return XPathContextualizer.contextualize(pathExpression, pathExpression2);
    }

    @Override
    public PathExpression getRelativePath(PathExpression pathExpression, PathExpression pathExpression2) {
        return XPathContextualizer.contextualize(pathExpression2, pathExpression);
    }

    @Override
    public String getTypeOfField(String string) {
        SdkField sdkField = this.fieldById.get(string);
        if (sdkField == null) {
            throw new ParseCancellationException(String.format("Unknown field '%s'.", string));
        }
        return sdkField.getType();
    }

    @Override
    public String getRootCodelistOfField(String string) {
        SdkField sdkField = this.fieldById.get(string);
        if (sdkField == null) {
            throw new ParseCancellationException(String.format("Unknown field '%s'.", string));
        }
        String string2 = sdkField.getCodelistId();
        if (string2 == null) {
            throw new ParseCancellationException(String.format("No codelist for field '%s'.", string));
        }
        SdkCodelist sdkCodelist = this.codelistById.get(string2);
        if (sdkCodelist == null) {
            throw new ParseCancellationException(String.format("Unknown codelist '%s'.", string2));
        }
        return sdkCodelist.getRootCodelistId();
    }

    @Override
    public boolean isAttributeField(String string) {
        if (!this.additionalFieldInfoMap.containsKey(string)) {
            this.cacheAdditionalFieldInfo(string);
        }
        return this.additionalFieldInfoMap.get(string).isAttribute();
    }

    @Override
    public String getAttributeNameFromAttributeField(String string) {
        if (!this.additionalFieldInfoMap.containsKey(string)) {
            this.cacheAdditionalFieldInfo(string);
        }
        return this.additionalFieldInfoMap.get(string).getAttributeName();
    }

    @Override
    public PathExpression getAbsolutePathOfFieldWithoutTheAttribute(String string) {
        if (!this.additionalFieldInfoMap.containsKey(string)) {
            this.cacheAdditionalFieldInfo(string);
        }
        return Expression.instantiate(this.additionalFieldInfoMap.get(string).getPathToLastElement(), NodePathExpression.class);
    }

    private void cacheAdditionalFieldInfo(String string) {
        if (this.additionalFieldInfoMap.containsKey(string)) {
            return;
        }
        XPathInfo xPathInfo = XPathProcessor.parse((String)this.getAbsolutePathOfField(string).getScript());
        this.additionalFieldInfoMap.put(string, xPathInfo);
    }
}

