/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx;

import eu.europa.ted.efx.interfaces.TranslatorOptions;
import eu.europa.ted.efx.model.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class EfxTranslatorOptions
implements TranslatorOptions {
    public static final EfxTranslatorOptions DEFAULT = new EfxTranslatorOptions(DecimalFormat.XSL_DEFAULT, Locale.ENGLISH, new Locale[0]);
    private final DecimalFormat symbols;
    private Locale primaryLocale;
    private ArrayList<Locale> otherLocales;

    public EfxTranslatorOptions(DecimalFormat decimalFormat) {
        this(decimalFormat, Locale.ENGLISH, new Locale[0]);
    }

    public EfxTranslatorOptions(DecimalFormat decimalFormat, String string, String ... stringArray) {
        this(decimalFormat, Locale.forLanguageTag(string), (Locale[])Arrays.stream(stringArray).map(Locale::forLanguageTag).toArray(Locale[]::new));
    }

    public EfxTranslatorOptions(DecimalFormat decimalFormat, Locale locale, Locale ... localeArray) {
        this.symbols = decimalFormat;
        this.primaryLocale = locale;
        this.otherLocales = new ArrayList<Locale>(Arrays.asList(localeArray));
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return this.symbols;
    }

    @Override
    public String getPrimaryLanguage2LetterCode() {
        return this.primaryLocale.getLanguage();
    }

    @Override
    public String getPrimaryLanguage3LetterCode() {
        return this.primaryLocale.getISO3Language();
    }

    @Override
    public String[] getAllLanguage2LetterCodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.primaryLocale.getLanguage());
        for (Locale locale : this.otherLocales) {
            arrayList.add(locale.getLanguage());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String[] getAllLanguage3LetterCodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.primaryLocale.getISO3Language());
        for (Locale locale : this.otherLocales) {
            arrayList.add(locale.getISO3Language());
        }
        return arrayList.toArray(new String[0]);
    }

    public EfxTranslatorOptions withLanguage(String string) {
        this.primaryLocale = Locale.forLanguageTag(string);
        return this;
    }
}

