/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import eu.europa.ted.efx.model.ParsedEntity;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.variables.Identifier;
import eu.europa.ted.efx.model.variables.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class CallStack {
    private static final String TYPE_MISMATCH = "Type mismatch. Expected %s instead of %s.";
    private static final String UNDECLARED_IDENTIFIER = "Identifier not declared: ";
    private static final String IDENTIFIER_ALREADY_DECLARED = "Identifier already declared: ";
    private static final String STACK_UNDERFLOW = "Stack underflow. Return values were available in the dropped frame, but no stack frame is left to consume them.";
    Stack<StackFrame> frames = new Stack();

    public CallStack() {
        this.frames.push(new StackFrame());
    }

    public void pushStackFrame() {
        this.frames.push(new StackFrame());
    }

    public void popStackFrame() {
        StackFrame stackFrame = this.frames.pop();
        if (stackFrame.size() > 0) {
            if (this.frames.empty()) {
                throw new ParseCancellationException(STACK_UNDERFLOW);
            }
            this.frames.peek().addAll(stackFrame);
        }
    }

    public void declareIdentifier(Identifier identifier) {
        if (this.inScope(identifier.name)) {
            throw new ParseCancellationException(IDENTIFIER_ALREADY_DECLARED + identifier.name);
        }
        this.frames.peek().declareIdentifier(identifier);
    }

    boolean inScope(String string) {
        return this.frames.stream().anyMatch(stackFrame -> stackFrame.identifierRegistry.containsKey(string));
    }

    StackFrame findFrameContaining(String string) {
        return this.frames.stream().filter(stackFrame -> stackFrame.identifierRegistry.containsKey(string)).findFirst().orElse(null);
    }

    Optional<Expression> getParameter(String string) {
        return this.frames.stream().filter(stackFrame -> stackFrame.identifierRegistry.containsKey(string) && Parameter.class.isAssignableFrom(stackFrame.identifierRegistry.get(string).getClass())).findFirst().map(stackFrame -> ((Parameter)stackFrame.identifierRegistry.get((Object)string)).parameterValue);
    }

    Optional<Identifier> getIdentifier(String string) {
        return this.frames.stream().filter(stackFrame -> stackFrame.identifierRegistry.containsKey(string)).findFirst().map(stackFrame -> stackFrame.identifierRegistry.get(string));
    }

    public Class<? extends EfxDataType> getTypeOfIdentifier(String string) {
        Optional<Identifier> optional = this.getIdentifier(string);
        if (!optional.isPresent()) {
            throw new ParseCancellationException(UNDECLARED_IDENTIFIER + string);
        }
        return optional.get().dataType;
    }

    public void pushIdentifierReference(String string) {
        this.getParameter(string).ifPresentOrElse(expression -> this.push((ParsedEntity)expression), () -> this.getIdentifier(string).ifPresentOrElse(identifier -> this.push(identifier.referenceExpression), () -> {
            throw new ParseCancellationException(UNDECLARED_IDENTIFIER + string);
        }));
    }

    public void push(ParsedEntity parsedEntity) {
        this.frames.peek().push(parsedEntity);
    }

    public synchronized <T extends ParsedEntity> T pop(Class<T> clazz) {
        return this.frames.peek().pop(clazz);
    }

    public synchronized ParsedEntity peek() {
        return (ParsedEntity)this.frames.peek().peek();
    }

    public int size() {
        return this.frames.peek().size();
    }

    public boolean empty() {
        return this.frames.peek().empty();
    }

    public void clear() {
        this.frames.peek().clear();
    }

    class StackFrame
    extends Stack<ParsedEntity> {
        Map<String, Identifier> identifierRegistry = new HashMap<String, Identifier>();

        StackFrame() {
        }

        void declareIdentifier(Identifier identifier) {
            this.identifierRegistry.put(identifier.name, identifier);
        }

        synchronized <T extends ParsedEntity> T pop(Class<T> clazz) {
            Class<TypedExpression> clazz2;
            Class<TypedExpression> clazz3;
            Class<?> clazz4 = ((ParsedEntity)this.peek()).getClass();
            if (clazz.isAssignableFrom(clazz4)) {
                return (T)((ParsedEntity)clazz.cast(this.pop()));
            }
            if (TypedExpression.class.isAssignableFrom(clazz4) && TypedExpression.class.isAssignableFrom(clazz) && TypedExpression.canConvert(clazz3 = clazz4.asSubclass(TypedExpression.class), clazz2 = clazz.asSubclass(TypedExpression.class)).booleanValue()) {
                return (T)((ParsedEntity)clazz.cast(TypedExpression.from((TypedExpression)this.pop(), clazz2)));
            }
            throw new ParseCancellationException(String.format(CallStack.TYPE_MISMATCH, clazz.getSimpleName(), clazz4.getSimpleName()));
        }

        @Override
        public void clear() {
            super.clear();
            this.identifierRegistry.clear();
        }
    }
}

