/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.variables.Variable;

public abstract class Context {
    private final String symbol;
    private final PathExpression absolutePath;
    private final PathExpression relativePath;
    private final Variable variable;

    protected Context(String string, PathExpression pathExpression, PathExpression pathExpression2, Variable variable) {
        this.variable = variable;
        this.symbol = string;
        this.absolutePath = pathExpression;
        this.relativePath = pathExpression2 == null ? pathExpression : pathExpression2;
    }

    protected Context(String string, PathExpression pathExpression, PathExpression pathExpression2) {
        this(string, pathExpression, pathExpression2, null);
    }

    protected Context(String string, PathExpression pathExpression, Variable variable) {
        this(string, pathExpression, pathExpression, variable);
    }

    protected Context(String string, PathExpression pathExpression) {
        this(string, pathExpression, pathExpression);
    }

    public Boolean isFieldContext() {
        return this.getClass().equals(FieldContext.class);
    }

    public Boolean isNodeContext() {
        return this.getClass().equals(NodeContext.class);
    }

    public Variable variable() {
        return this.variable;
    }

    public String symbol() {
        return this.symbol;
    }

    public PathExpression absolutePath() {
        return this.absolutePath;
    }

    public PathExpression relativePath() {
        return this.relativePath;
    }

    public static class NodeContext
    extends Context {
        public NodeContext(String string, PathExpression pathExpression, PathExpression pathExpression2) {
            super(string, pathExpression, pathExpression2);
        }

        public NodeContext(String string, PathExpression pathExpression) {
            super(string, pathExpression);
        }
    }

    public static class FieldContext
    extends Context {
        public FieldContext(String string, PathExpression pathExpression, PathExpression pathExpression2, Variable variable) {
            super(string, pathExpression, pathExpression2, variable);
        }

        public FieldContext(String string, PathExpression pathExpression, PathExpression pathExpression2) {
            super(string, pathExpression, pathExpression2);
        }

        public FieldContext(String string, PathExpression pathExpression, Variable variable) {
            super(string, pathExpression, variable);
        }

        public FieldContext(String string, PathExpression pathExpression) {
            super(string, pathExpression);
        }
    }
}

