/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ContextStack
extends Stack<Context> {
    private final SymbolResolver symbols;
    private final Map<String, Context> variables = new HashMap<String, Context>();

    public ContextStack(SymbolResolver symbolResolver) {
        this.symbols = symbolResolver;
    }

    public Context.FieldContext pushFieldContext(String string) {
        PathExpression pathExpression = this.symbols.getAbsolutePathOfField(string);
        if (this.isEmpty()) {
            Context.FieldContext fieldContext = new Context.FieldContext(string, pathExpression);
            this.push(fieldContext);
            return fieldContext;
        }
        PathExpression pathExpression2 = this.symbols.getRelativePathOfField(string, this.absolutePath());
        Context.FieldContext fieldContext = new Context.FieldContext(string, pathExpression, pathExpression2);
        this.push(fieldContext);
        return fieldContext;
    }

    public Context.NodeContext pushNodeContext(String string) {
        PathExpression pathExpression = this.symbols.getAbsolutePathOfNode(string);
        if (this.isEmpty()) {
            Context.NodeContext nodeContext = new Context.NodeContext(string, pathExpression);
            this.push(nodeContext);
            return nodeContext;
        }
        PathExpression pathExpression2 = this.symbols.getRelativePathOfNode(string, this.absolutePath());
        Context.NodeContext nodeContext = new Context.NodeContext(string, pathExpression, pathExpression2);
        this.push(nodeContext);
        return nodeContext;
    }

    public void declareContextVariable(String string, Context context) {
        this.variables.put(string, context);
    }

    public Context getContextFromVariable(String string) {
        return this.variables.get(string);
    }

    public Boolean isFieldContext() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).isFieldContext();
    }

    public Boolean isNodeContext() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).isNodeContext();
    }

    public String symbol() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).symbol();
    }

    public PathExpression absolutePath() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).absolutePath();
    }

    public PathExpression relativePath() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).relativePath();
    }
}

