/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DecimalFormat
extends DecimalFormatSymbols {
    public static final DecimalFormat XSL_DEFAULT = DecimalFormat.getXslDefault();
    public static final DecimalFormat EFX_DEFAULT = DecimalFormat.getEfxDefault();

    DecimalFormat(Locale locale) {
        super(locale);
    }

    private static DecimalFormat getXslDefault() {
        DecimalFormat decimalFormat = new DecimalFormat(Locale.US);
        decimalFormat.setDecimalSeparator('.');
        decimalFormat.setGroupingSeparator(',');
        decimalFormat.setMinusSign('-');
        decimalFormat.setPercent('%');
        decimalFormat.setPerMill('\u2030');
        decimalFormat.setZeroDigit('0');
        decimalFormat.setDigit('#');
        decimalFormat.setPatternSeparator(';');
        decimalFormat.setInfinity("Infinity");
        decimalFormat.setNaN("NaN");
        return decimalFormat;
    }

    private static DecimalFormat getEfxDefault() {
        DecimalFormat decimalFormat = DecimalFormat.getXslDefault();
        decimalFormat.setDecimalSeparator(',');
        decimalFormat.setGroupingSeparator(' ');
        return decimalFormat;
    }

    public String adaptFormatString(String string) {
        String string2 = string;
        string2 = string2.replace(XSL_DEFAULT.getDecimalSeparator(), '\ue000');
        string2 = string2.replace(XSL_DEFAULT.getGroupingSeparator(), '\ue001');
        string2 = string2.replace(XSL_DEFAULT.getMinusSign(), '\ue002');
        string2 = string2.replace(XSL_DEFAULT.getPercent(), '\ue003');
        string2 = string2.replace(XSL_DEFAULT.getPerMill(), '\ue004');
        string2 = string2.replace(XSL_DEFAULT.getZeroDigit(), '\ue005');
        string2 = string2.replace(XSL_DEFAULT.getDigit(), '\ue006');
        string2 = string2.replace(XSL_DEFAULT.getPatternSeparator(), '\ue007');
        string2 = string2.replace('\ue000', this.getDecimalSeparator());
        string2 = string2.replace('\ue001', this.getGroupingSeparator());
        string2 = string2.replace('\ue002', this.getMinusSign());
        string2 = string2.replace('\ue003', this.getPercent());
        string2 = string2.replace('\ue004', this.getPerMill());
        string2 = string2.replace('\ue005', this.getZeroDigit());
        string2 = string2.replace('\ue006', this.getDigit());
        string2 = string2.replace('\ue007', this.getPatternSeparator());
        return string2;
    }
}

