/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model.expressions;

import eu.europa.ted.efx.model.ParsedEntity;
import java.lang.reflect.Constructor;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public interface Expression
extends ParsedEntity {
    public String getScript();

    public Boolean isLiteral();

    public static <T extends Expression> T instantiate(String string, Class<T> clazz) {
        return Expression.instantiate(string, false, clazz);
    }

    public static <T extends Expression> T from(Expression expression, Class<T> clazz) {
        return Expression.instantiate(expression.getScript(), expression.isLiteral(), clazz);
    }

    public static <T extends Expression> T instantiate(String string, Boolean bl, Class<T> clazz) {
        try {
            if (bl.booleanValue()) {
                Constructor<T> constructor = clazz.getConstructor(String.class, Boolean.class);
                return (T)((Expression)constructor.newInstance(string, bl));
            }
            Constructor<T> constructor = clazz.getConstructor(String.class);
            return (T)((Expression)constructor.newInstance(string));
        }
        catch (Exception exception) {
            throw new ParseCancellationException((Throwable)exception);
        }
    }

    public static <T extends Expression> T empty(Class<T> clazz) {
        return Expression.instantiate("", clazz);
    }

    public static abstract class Impl
    implements Expression {
        private final String script;
        private final Boolean isLiteral;

        @Override
        public String getScript() {
            return this.script;
        }

        @Override
        public Boolean isLiteral() {
            return this.isLiteral;
        }

        protected Impl(String string) {
            this(string, false);
        }

        protected Impl(String string, Boolean bl) {
            this.script = string;
            this.isLiteral = bl;
        }

        public final Boolean isEmpty() {
            return this.script.isEmpty();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (Expression.class.isAssignableFrom(object.getClass())) {
                return this.script.equals(((Expression)object).getScript());
            }
            return false;
        }
    }
}

