/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model.expressions;

import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.expressions.scalar.ScalarExpression;
import eu.europa.ted.efx.model.expressions.sequence.SequenceExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.EfxDataTypeAssociation;
import eu.europa.ted.efx.model.types.EfxExpressionType;
import eu.europa.ted.efx.model.types.EfxExpressionTypeAssociation;

public interface TypedExpression
extends Expression {
    public Class<? extends EfxExpressionType> getExpressionType();

    public Class<? extends EfxDataType> getDataType();

    public Boolean is(Class<? extends EfxDataType> var1);

    public Boolean is(Class<? extends EfxExpressionType> var1, Class<? extends EfxDataType> var2);

    public static <T extends EfxDataType, E extends TypedExpression> Class<? extends T> getEfxDataType(Class<? extends E> clazz, Class<? extends T> clazz2) {
        EfxDataTypeAssociation efxDataTypeAssociation = clazz.getAnnotation(EfxDataTypeAssociation.class);
        if (efxDataTypeAssociation == null) {
            return EfxDataType.ANY.asSubclass(clazz2);
        }
        return efxDataTypeAssociation.dataType().asSubclass(clazz2);
    }

    public static Class<? extends EfxDataType> getEfxDataType(Class<? extends TypedExpression> clazz) {
        EfxDataTypeAssociation efxDataTypeAssociation = clazz.getAnnotation(EfxDataTypeAssociation.class);
        if (efxDataTypeAssociation == null) {
            throw new IllegalArgumentException("Missing @EfxDataTypeAssociation annotation");
        }
        return efxDataTypeAssociation.dataType();
    }

    public static <T extends TypedExpression> T from(TypedExpression typedExpression, Class<T> clazz) {
        if (PathExpression.class.isAssignableFrom(clazz)) {
            return (T)((TypedExpression)clazz.cast(PathExpression.from(typedExpression, clazz.asSubclass(PathExpression.class))));
        }
        if (SequenceExpression.class.isAssignableFrom(clazz)) {
            return (T)((TypedExpression)clazz.cast(SequenceExpression.from(typedExpression, clazz.asSubclass(SequenceExpression.class))));
        }
        if (ScalarExpression.class.isAssignableFrom(clazz)) {
            return (T)((TypedExpression)clazz.cast(ScalarExpression.from(typedExpression, clazz.asSubclass(ScalarExpression.class))));
        }
        throw new RuntimeException("Unknown expression type: " + clazz);
    }

    public static <E extends EfxExpressionType, D extends EfxDataType> TypedExpression instantiate(String string, Class<E> clazz, Class<D> clazz2) {
        if (PathExpression.class.isAssignableFrom(clazz)) {
            return PathExpression.instantiate(string, clazz2);
        }
        if (SequenceExpression.class.isAssignableFrom(clazz)) {
            return SequenceExpression.instantiate(string, clazz2);
        }
        if (ScalarExpression.class.isAssignableFrom(clazz)) {
            return ScalarExpression.instantiate(string, clazz2);
        }
        throw new RuntimeException("Unknown expression type: " + clazz);
    }

    public static Boolean canConvert(Class<? extends TypedExpression> clazz, Class<? extends TypedExpression> clazz2) {
        Class<? extends EfxExpressionType> clazz3 = clazz.getAnnotation(EfxExpressionTypeAssociation.class).expressionType();
        Class<? extends EfxDataType> clazz4 = clazz.getAnnotation(EfxDataTypeAssociation.class).dataType();
        Class<? extends EfxExpressionType> clazz5 = clazz2.getAnnotation(EfxExpressionTypeAssociation.class).expressionType();
        Class<? extends EfxDataType> clazz6 = clazz2.getAnnotation(EfxDataTypeAssociation.class).dataType();
        return clazz5.isAssignableFrom(clazz3) && clazz6.isAssignableFrom(clazz4);
    }

    public static abstract class Impl<T extends EfxDataType>
    extends Expression.Impl
    implements TypedExpression {
        private Class<? extends EfxExpressionType> expressionType;
        private Class<? extends T> dataType;

        public Impl(String string, Class<? extends EfxExpressionType> clazz, Class<? extends T> clazz2) {
            this(string, false, clazz, clazz2);
        }

        public Impl(String string, Boolean bl, Class<? extends EfxExpressionType> clazz, Class<? extends T> clazz2) {
            super(string, bl);
            this.expressionType = clazz;
            this.dataType = clazz2;
        }

        @Override
        public Class<? extends EfxExpressionType> getExpressionType() {
            return this.expressionType;
        }

        public Class<? extends T> getDataType() {
            return this.dataType;
        }

        @Override
        public Boolean is(Class<? extends EfxDataType> clazz) {
            return clazz.isAssignableFrom(this.dataType);
        }

        @Override
        public Boolean is(Class<? extends EfxExpressionType> clazz, Class<? extends EfxDataType> clazz2) {
            return clazz.isAssignableFrom(this.expressionType) && clazz2.isAssignableFrom(this.dataType);
        }
    }
}

