/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model.expressions.path;

import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.path.BooleanPathExpression;
import eu.europa.ted.efx.model.expressions.path.DatePathExpression;
import eu.europa.ted.efx.model.expressions.path.DurationPathExpression;
import eu.europa.ted.efx.model.expressions.path.MultilingualStringPathExpression;
import eu.europa.ted.efx.model.expressions.path.NodePathExpression;
import eu.europa.ted.efx.model.expressions.path.NumericPathExpression;
import eu.europa.ted.efx.model.expressions.path.StringPathExpression;
import eu.europa.ted.efx.model.expressions.path.TimePathExpression;
import eu.europa.ted.efx.model.expressions.scalar.ScalarExpression;
import eu.europa.ted.efx.model.expressions.sequence.SequenceExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.EfxExpressionType;
import eu.europa.ted.efx.model.types.EfxExpressionTypeAssociation;
import eu.europa.ted.efx.model.types.FieldTypes;
import java.util.Map;

public interface PathExpression
extends ScalarExpression,
SequenceExpression,
EfxExpressionType.Path {
    public static final Map<FieldTypes, Class<? extends PathExpression>> fromFieldType = Map.ofEntries(Map.entry(FieldTypes.ID, StringPathExpression.class), Map.entry(FieldTypes.ID_REF, StringPathExpression.class), Map.entry(FieldTypes.TEXT, StringPathExpression.class), Map.entry(FieldTypes.TEXT_MULTILINGUAL, MultilingualStringPathExpression.class), Map.entry(FieldTypes.INDICATOR, BooleanPathExpression.class), Map.entry(FieldTypes.AMOUNT, NumericPathExpression.class), Map.entry(FieldTypes.NUMBER, NumericPathExpression.class), Map.entry(FieldTypes.MEASURE, DurationPathExpression.class), Map.entry(FieldTypes.CODE, StringPathExpression.class), Map.entry(FieldTypes.INTERNAL_CODE, StringPathExpression.class), Map.entry(FieldTypes.INTEGER, NumericPathExpression.class), Map.entry(FieldTypes.DATE, DatePathExpression.class), Map.entry(FieldTypes.ZONED_DATE, DatePathExpression.class), Map.entry(FieldTypes.TIME, TimePathExpression.class), Map.entry(FieldTypes.ZONED_TIME, TimePathExpression.class), Map.entry(FieldTypes.URL, StringPathExpression.class), Map.entry(FieldTypes.PHONE, StringPathExpression.class), Map.entry(FieldTypes.EMAIL, StringPathExpression.class));
    public static final Map<Class<? extends EfxDataType>, Class<? extends PathExpression>> fromEfxDataType = Map.ofEntries(Map.entry(EfxDataType.String.class, StringPathExpression.class), Map.entry(EfxDataType.MultilingualString.class, MultilingualStringPathExpression.class), Map.entry(EfxDataType.Boolean.class, BooleanPathExpression.class), Map.entry(EfxDataType.Number.class, NumericPathExpression.class), Map.entry(EfxDataType.Date.class, DatePathExpression.class), Map.entry(EfxDataType.Time.class, TimePathExpression.class), Map.entry(EfxDataType.Duration.class, DurationPathExpression.class), Map.entry(EfxDataType.Node.class, NodePathExpression.class));

    public static PathExpression instantiate(String string, FieldTypes fieldTypes) {
        return Expression.instantiate(string, fromFieldType.get((Object)fieldTypes));
    }

    public static PathExpression instantiate(String string, Class<? extends EfxDataType> clazz) {
        return Expression.instantiate(string, fromEfxDataType.get(clazz));
    }

    public static <T extends PathExpression> T from(TypedExpression typedExpression, Class<T> clazz) {
        return (T)((PathExpression)Expression.from(typedExpression, clazz));
    }

    @EfxExpressionTypeAssociation(expressionType=EfxExpressionType.Path.class)
    public static abstract class Impl<T extends EfxDataType>
    extends TypedExpression.Impl<T>
    implements PathExpression {
        protected Impl(String string, Class<? extends T> clazz) {
            super(string, EfxExpressionType.Path.class, clazz);
        }
    }
}

