/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model.expressions.scalar;

import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.scalar.BooleanExpression;
import eu.europa.ted.efx.model.expressions.scalar.DateExpression;
import eu.europa.ted.efx.model.expressions.scalar.DurationExpression;
import eu.europa.ted.efx.model.expressions.scalar.MultilingualStringExpression;
import eu.europa.ted.efx.model.expressions.scalar.NumericExpression;
import eu.europa.ted.efx.model.expressions.scalar.StringExpression;
import eu.europa.ted.efx.model.expressions.scalar.TimeExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.EfxExpressionType;
import eu.europa.ted.efx.model.types.EfxExpressionTypeAssociation;
import eu.europa.ted.efx.model.types.FieldTypes;
import java.util.Map;

public interface ScalarExpression
extends TypedExpression,
EfxExpressionType.Scalar {
    public static final Map<FieldTypes, Class<? extends ScalarExpression>> fromFieldType = Map.ofEntries(Map.entry(FieldTypes.ID, StringExpression.class), Map.entry(FieldTypes.ID_REF, StringExpression.class), Map.entry(FieldTypes.TEXT, StringExpression.class), Map.entry(FieldTypes.TEXT_MULTILINGUAL, MultilingualStringExpression.class), Map.entry(FieldTypes.INDICATOR, BooleanExpression.class), Map.entry(FieldTypes.AMOUNT, NumericExpression.class), Map.entry(FieldTypes.NUMBER, NumericExpression.class), Map.entry(FieldTypes.MEASURE, DurationExpression.class), Map.entry(FieldTypes.CODE, StringExpression.class), Map.entry(FieldTypes.INTERNAL_CODE, StringExpression.class), Map.entry(FieldTypes.INTEGER, NumericExpression.class), Map.entry(FieldTypes.DATE, DateExpression.class), Map.entry(FieldTypes.ZONED_DATE, DateExpression.class), Map.entry(FieldTypes.TIME, TimeExpression.class), Map.entry(FieldTypes.ZONED_TIME, TimeExpression.class), Map.entry(FieldTypes.URL, StringExpression.class), Map.entry(FieldTypes.PHONE, StringExpression.class), Map.entry(FieldTypes.EMAIL, StringExpression.class));
    public static final Map<Class<? extends EfxDataType>, Class<? extends ScalarExpression>> fromEfxDataType = Map.ofEntries(Map.entry(EfxDataType.String.class, StringExpression.class), Map.entry(EfxDataType.MultilingualString.class, MultilingualStringExpression.class), Map.entry(EfxDataType.Boolean.class, BooleanExpression.class), Map.entry(EfxDataType.Number.class, NumericExpression.class), Map.entry(EfxDataType.Date.class, DateExpression.class), Map.entry(EfxDataType.Time.class, TimeExpression.class), Map.entry(EfxDataType.Duration.class, DurationExpression.class));

    public static <T extends ScalarExpression> T from(TypedExpression typedExpression, Class<T> clazz) {
        return (T)((ScalarExpression)Expression.from(typedExpression, clazz));
    }

    public static ScalarExpression instantiate(String string, Class<? extends EfxDataType> clazz) {
        return Expression.instantiate(string, fromEfxDataType.get(clazz));
    }

    @EfxExpressionTypeAssociation(expressionType=EfxExpressionType.Scalar.class)
    public static abstract class Impl<T extends EfxDataType>
    extends TypedExpression.Impl<T>
    implements ScalarExpression {
        protected Impl(String string, Class<T> clazz) {
            super(string, EfxExpressionType.Scalar.class, clazz);
        }

        protected Impl(String string, Boolean bl, Class<? extends T> clazz) {
            super(string, bl, EfxExpressionType.Scalar.class, clazz);
        }
    }
}

