/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model.expressions.sequence;

import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.sequence.BooleanSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.DateSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.DurationSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.MultilingualStringSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.NumericSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.StringSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.TimeSequenceExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.EfxExpressionType;
import eu.europa.ted.efx.model.types.EfxExpressionTypeAssociation;
import eu.europa.ted.efx.model.types.FieldTypes;
import java.util.Map;

public interface SequenceExpression
extends TypedExpression,
EfxExpressionType.Sequence {
    public static final Map<FieldTypes, Class<? extends SequenceExpression>> fromFieldType = Map.ofEntries(Map.entry(FieldTypes.ID, StringSequenceExpression.class), Map.entry(FieldTypes.ID_REF, StringSequenceExpression.class), Map.entry(FieldTypes.TEXT, StringSequenceExpression.class), Map.entry(FieldTypes.TEXT_MULTILINGUAL, MultilingualStringSequenceExpression.class), Map.entry(FieldTypes.INDICATOR, BooleanSequenceExpression.class), Map.entry(FieldTypes.AMOUNT, NumericSequenceExpression.class), Map.entry(FieldTypes.NUMBER, NumericSequenceExpression.class), Map.entry(FieldTypes.MEASURE, DurationSequenceExpression.class), Map.entry(FieldTypes.CODE, StringSequenceExpression.class), Map.entry(FieldTypes.INTERNAL_CODE, StringSequenceExpression.class), Map.entry(FieldTypes.INTEGER, NumericSequenceExpression.class), Map.entry(FieldTypes.DATE, DateSequenceExpression.class), Map.entry(FieldTypes.ZONED_DATE, DateSequenceExpression.class), Map.entry(FieldTypes.TIME, TimeSequenceExpression.class), Map.entry(FieldTypes.ZONED_TIME, TimeSequenceExpression.class), Map.entry(FieldTypes.URL, StringSequenceExpression.class), Map.entry(FieldTypes.PHONE, StringSequenceExpression.class), Map.entry(FieldTypes.EMAIL, StringSequenceExpression.class));
    public static final Map<Class<? extends EfxDataType>, Class<? extends SequenceExpression>> fromEfxDataType = Map.ofEntries(Map.entry(EfxDataType.String.class, StringSequenceExpression.class), Map.entry(EfxDataType.MultilingualString.class, MultilingualStringSequenceExpression.class), Map.entry(EfxDataType.Boolean.class, BooleanSequenceExpression.class), Map.entry(EfxDataType.Number.class, NumericSequenceExpression.class), Map.entry(EfxDataType.Date.class, DateSequenceExpression.class), Map.entry(EfxDataType.Time.class, TimeSequenceExpression.class), Map.entry(EfxDataType.Duration.class, DurationSequenceExpression.class));

    public static <T extends SequenceExpression> T from(TypedExpression typedExpression, Class<? extends T> clazz) {
        return (T)((SequenceExpression)Expression.from(typedExpression, clazz));
    }

    public static SequenceExpression instantiate(String string, Class<? extends EfxDataType> clazz) {
        return Expression.instantiate(string, fromEfxDataType.get(clazz));
    }

    @EfxExpressionTypeAssociation(expressionType=EfxExpressionType.Sequence.class)
    public static abstract class Impl<T extends EfxDataType>
    extends TypedExpression.Impl<T>
    implements SequenceExpression {
        protected Impl(String string, Class<? extends T> clazz) {
            this(string, false, clazz);
        }

        protected Impl(String string, Boolean bl, Class<? extends T> clazz) {
            super(string, bl, EfxExpressionType.Sequence.class, clazz);
        }
    }
}

