/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model.templates;

import eu.europa.ted.efx.interfaces.MarkupGenerator;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.templates.Markup;
import eu.europa.ted.efx.model.variables.Variable;
import eu.europa.ted.efx.model.variables.VariableList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.lang3.tuple.Pair;

public class ContentBlock {
    private final ContentBlock parent;
    private final String id;
    private final Integer indentationLevel;
    private final Markup content;
    private final Context context;
    private final Queue<ContentBlock> children = new LinkedList<ContentBlock>();
    private final int number;
    private final VariableList variables;

    private ContentBlock() {
        this.parent = null;
        this.id = "block";
        this.indentationLevel = -1;
        this.content = new Markup("");
        this.context = null;
        this.number = 0;
        this.variables = new VariableList();
    }

    public ContentBlock(ContentBlock contentBlock, String string, int n, Markup markup, Context context, VariableList variableList) {
        this.parent = contentBlock;
        this.id = string;
        this.indentationLevel = contentBlock.indentationLevel + 1;
        this.content = markup;
        this.context = context;
        this.number = n;
        this.variables = variableList;
    }

    public static ContentBlock newRootBlock() {
        return new ContentBlock();
    }

    public ContentBlock addChild(int n, Markup markup, Context context, VariableList variableList) {
        int n2 = n >= 0 ? n : this.children.stream().map(contentBlock -> contentBlock.number).max(Comparator.naturalOrder()).orElse(0) + 1;
        String string = String.format("%s%02d", this.id, this.children.size() + 1);
        ContentBlock contentBlock2 = new ContentBlock(this, string, n2, markup, context, variableList);
        this.children.add(contentBlock2);
        return contentBlock2;
    }

    public ContentBlock addSibling(int n, Markup markup, Context context, VariableList variableList) {
        if (this.parent == null) {
            throw new ParseCancellationException("Cannot add sibling to root block");
        }
        return this.parent.addChild(n, markup, context, variableList);
    }

    public ContentBlock findParentByLevel(int n) {
        assert (this.indentationLevel >= n) : "Unexpected indentation tracker state.";
        ContentBlock contentBlock = this;
        while (contentBlock.indentationLevel > n) {
            contentBlock = contentBlock.parent;
        }
        return contentBlock;
    }

    public Queue<ContentBlock> getChildren() {
        return this.children;
    }

    public String getOutlineNumber() {
        if (this.number == 0 || this.children.size() == 0) {
            return "";
        }
        if (this.parent == null || this.parent.number == 0) {
            return String.format("%d", this.number);
        }
        String string = this.parent.getOutlineNumber();
        if (string.isEmpty()) {
            return String.format("%d", this.number);
        }
        return String.format("%s.%d", string, this.number);
    }

    public Integer getIndentationLevel() {
        return this.indentationLevel;
    }

    public Context getContext() {
        return this.context;
    }

    public Context getParentContext() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getContext();
    }

    public Set<Variable> getOwnVariables() {
        LinkedHashSet<Variable> linkedHashSet = new LinkedHashSet<Variable>();
        linkedHashSet.addAll(this.variables);
        return linkedHashSet;
    }

    public Set<Variable> getAllVariables() {
        if (this.parent == null) {
            return new LinkedHashSet<Variable>(this.getOwnVariables());
        }
        LinkedHashSet<Variable> linkedHashSet = new LinkedHashSet<Variable>();
        linkedHashSet.addAll(this.parent.getAllVariables());
        linkedHashSet.addAll(this.getOwnVariables());
        return linkedHashSet;
    }

    public Set<String> getTemplateParameters() {
        return this.getAllVariables().stream().map(variable -> variable.name).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Markup renderContent(MarkupGenerator markupGenerator) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.content.script);
        for (ContentBlock contentBlock : this.children) {
            stringBuilder.append('\n').append(contentBlock.renderCallTemplate((MarkupGenerator)markupGenerator).script);
        }
        return new Markup(stringBuilder.toString());
    }

    public void renderTemplate(MarkupGenerator markupGenerator, List<Markup> list) {
        list.add(markupGenerator.composeFragmentDefinition(this.id, this.getOutlineNumber(), this.renderContent(markupGenerator), this.getTemplateParameters()));
        for (ContentBlock contentBlock : this.children) {
            contentBlock.renderTemplate(markupGenerator, list);
        }
    }

    public Markup renderCallTemplate(MarkupGenerator markupGenerator) {
        LinkedHashSet<Pair<String, String>> linkedHashSet = new LinkedHashSet<Pair<String, String>>();
        if (this.parent != null) {
            linkedHashSet.addAll(this.parent.getAllVariables().stream().map(variable -> Pair.of((Object)variable.name, (Object)variable.referenceExpression.getScript())).collect(Collectors.toList()));
        }
        linkedHashSet.addAll(this.getOwnVariables().stream().map(variable -> Pair.of((Object)variable.name, (Object)variable.initializationExpression.getScript())).collect(Collectors.toList()));
        return markupGenerator.renderFragmentInvocation(this.id, this.context.relativePath(), linkedHashSet);
    }
}

