/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk1;

import eu.europa.ted.eforms.sdk.component.SdkComponent;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.efx.interfaces.EfxExpressionTranslator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.CallStack;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.ContextStack;
import eu.europa.ted.efx.model.ParsedEntity;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.iteration.IteratorExpression;
import eu.europa.ted.efx.model.expressions.iteration.IteratorListExpression;
import eu.europa.ted.efx.model.expressions.path.NodePathExpression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.expressions.path.StringPathExpression;
import eu.europa.ted.efx.model.expressions.scalar.BooleanExpression;
import eu.europa.ted.efx.model.expressions.scalar.DateExpression;
import eu.europa.ted.efx.model.expressions.scalar.DurationExpression;
import eu.europa.ted.efx.model.expressions.scalar.NumericExpression;
import eu.europa.ted.efx.model.expressions.scalar.ScalarExpression;
import eu.europa.ted.efx.model.expressions.scalar.StringExpression;
import eu.europa.ted.efx.model.expressions.scalar.TimeExpression;
import eu.europa.ted.efx.model.expressions.sequence.BooleanSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.DateSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.DurationSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.NumericSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.SequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.StringSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.TimeSequenceExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.FieldTypes;
import eu.europa.ted.efx.model.variables.Parameter;
import eu.europa.ted.efx.model.variables.Variable;
import eu.europa.ted.efx.sdk1.EfxBaseListener;
import eu.europa.ted.efx.sdk1.EfxLexer;
import eu.europa.ted.efx.sdk1.EfxParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;

@SdkComponent(versions={"1"}, componentType=SdkComponentType.EFX_EXPRESSION_TRANSLATOR)
public class EfxExpressionTranslatorV1
extends EfxBaseListener
implements EfxExpressionTranslator {
    private static final String NOT_MODIFIER = EfxLexer.VOCABULARY.getLiteralName(91).replaceAll("^'|'$", "");
    private static final String BEGIN_EXPRESSION_BLOCK = "{";
    private static final String END_EXPRESSION_BLOCK = "}";
    private static final String TYPE_MISMATCH_CANNOT_COMPARE_VALUES_OF_DIFFERENT_TYPES = "Type mismatch. Cannot compare values of different types: ";
    protected CallStack stack = new CallStack();
    protected ContextStack efxContext;
    protected SymbolResolver symbols;
    protected BaseErrorListener errorListener;
    protected ScriptGenerator script;
    private LinkedList<String> expressionParameters = new LinkedList();

    protected EfxExpressionTranslatorV1() {
    }

    public EfxExpressionTranslatorV1(SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener baseErrorListener) {
        this.symbols = symbolResolver;
        this.script = scriptGenerator;
        this.errorListener = baseErrorListener;
        this.efxContext = new ContextStack(this.symbols);
    }

    @Override
    public String translateExpression(String string, String ... stringArray) {
        this.expressionParameters.addAll(Arrays.asList(stringArray));
        EfxLexer efxLexer = new EfxLexer((CharStream)CharStreams.fromString((String)string));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)efxLexer);
        EfxParser efxParser = new EfxParser((TokenStream)commonTokenStream);
        if (this.errorListener != null) {
            efxLexer.removeErrorListeners();
            efxLexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            efxParser.removeErrorListeners();
            efxParser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.SingleExpressionContext singleExpressionContext = efxParser.singleExpression();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)singleExpressionContext);
        return this.getTranslatedScript();
    }

    private <T extends Expression> T translateParameter(String string, Class<T> clazz) {
        EfxExpressionTranslatorV1 efxExpressionTranslatorV1 = new EfxExpressionTranslatorV1(this.symbols, this.script, this.errorListener);
        EfxLexer efxLexer = new EfxLexer((CharStream)CharStreams.fromString((String)(BEGIN_EXPRESSION_BLOCK + string + END_EXPRESSION_BLOCK)));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)efxLexer);
        EfxParser efxParser = new EfxParser((TokenStream)commonTokenStream);
        if (this.errorListener != null) {
            efxLexer.removeErrorListeners();
            efxLexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            efxParser.removeErrorListeners();
            efxParser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.ParameterValueContext parameterValueContext = efxParser.parameterValue();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)efxExpressionTranslatorV1, (ParseTree)parameterValueContext);
        return Expression.instantiate(efxExpressionTranslatorV1.getTranslatedScript(), clazz);
    }

    private String getTranslatedScript() {
        StringBuilder stringBuilder = new StringBuilder(this.stack.size() * 100);
        while (!this.stack.empty()) {
            stringBuilder.insert(0, '\n').insert(0, this.stack.pop(Expression.class).getScript());
        }
        return stringBuilder.toString().trim();
    }

    protected static String getFieldIdFromChildSimpleFieldReferenceContext(ParserRuleContext parserRuleContext) {
        if (parserRuleContext instanceof EfxParser.SimpleFieldReferenceContext) {
            return ((EfxParser.SimpleFieldReferenceContext)parserRuleContext).FieldId().getText();
        }
        if (parserRuleContext instanceof EfxParser.AbsoluteFieldReferenceContext) {
            return ((EfxParser.AbsoluteFieldReferenceContext)parserRuleContext).reference.reference.simpleFieldReference().FieldId().getText();
        }
        if (parserRuleContext instanceof EfxParser.FieldReferenceWithFieldContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithFieldContextOverrideContext)parserRuleContext).reference.reference.simpleFieldReference().FieldId().getText();
        }
        if (parserRuleContext instanceof EfxParser.FieldReferenceWithNodeContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithNodeContextOverrideContext)parserRuleContext).reference.reference.reference.simpleFieldReference().FieldId().getText();
        }
        EfxParser.SimpleFieldReferenceContext simpleFieldReferenceContext = (EfxParser.SimpleFieldReferenceContext)parserRuleContext.getChild(EfxParser.SimpleFieldReferenceContext.class, 0);
        if (simpleFieldReferenceContext != null) {
            return simpleFieldReferenceContext.FieldId().getText();
        }
        for (ParseTree parseTree : parserRuleContext.children) {
            String string;
            if (!(parseTree instanceof ParserRuleContext) || (string = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext((ParserRuleContext)parseTree)) == null) continue;
            return string;
        }
        return null;
    }

    protected static String getNodeIdFromChildSimpleNodeReferenceContext(ParserRuleContext parserRuleContext) {
        if (parserRuleContext instanceof EfxParser.SimpleNodeReferenceContext) {
            return ((EfxParser.SimpleNodeReferenceContext)parserRuleContext).NodeId().getText();
        }
        for (ParseTree parseTree : parserRuleContext.children) {
            String string;
            if (!(parseTree instanceof ParserRuleContext) || (string = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext((ParserRuleContext)parseTree)) == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public void enterSingleExpression(EfxParser.SingleExpressionContext singleExpressionContext) {
        TerminalNode terminalNode = singleExpressionContext.FieldId();
        if (terminalNode != null) {
            this.efxContext.pushFieldContext(terminalNode.getText());
        } else {
            TerminalNode terminalNode2 = singleExpressionContext.NodeId();
            if (terminalNode2 != null) {
                this.efxContext.pushNodeContext(terminalNode2.getText());
            }
        }
    }

    @Override
    public void exitSingleExpression(EfxParser.SingleExpressionContext singleExpressionContext) {
        this.efxContext.pop();
    }

    @Override
    public void exitParenthesizedBooleanExpression(EfxParser.ParenthesizedBooleanExpressionContext parenthesizedBooleanExpressionContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(BooleanExpression.class), BooleanExpression.class));
    }

    @Override
    public void exitLogicalAndCondition(EfxParser.LogicalAndConditionContext logicalAndConditionContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeLogicalAnd(booleanExpression2, booleanExpression));
    }

    @Override
    public void exitLogicalOrCondition(EfxParser.LogicalOrConditionContext logicalOrConditionContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeLogicalOr(booleanExpression2, booleanExpression));
    }

    @Override
    public void exitFieldValueComparison(EfxParser.FieldValueComparisonContext fieldValueComparisonContext) {
        ScalarExpression scalarExpression = this.stack.pop(ScalarExpression.class);
        ScalarExpression scalarExpression2 = this.stack.pop(ScalarExpression.class);
        if (!(scalarExpression2.getClass().isAssignableFrom(scalarExpression.getClass()) || scalarExpression.getClass().isAssignableFrom(scalarExpression2.getClass()) || scalarExpression2.getDataType().isAssignableFrom(scalarExpression.getDataType()) || scalarExpression.getDataType().isAssignableFrom(scalarExpression2.getDataType()) || scalarExpression.getDataType().isAssignableFrom(scalarExpression2.getDataType()) || scalarExpression2.getDataType().isAssignableFrom(scalarExpression.getDataType()))) {
            throw new ParseCancellationException(TYPE_MISMATCH_CANNOT_COMPARE_VALUES_OF_DIFFERENT_TYPES + scalarExpression2.getClass() + " and " + scalarExpression.getClass());
        }
        this.stack.push(this.script.composeComparisonOperation(scalarExpression2, fieldValueComparisonContext.operator.getText(), scalarExpression));
    }

    @Override
    public void exitStringComparison(EfxParser.StringComparisonContext stringComparisonContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeComparisonOperation(stringExpression2, stringComparisonContext.operator.getText(), stringExpression));
    }

    @Override
    public void exitNumericComparison(EfxParser.NumericComparisonContext numericComparisonContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeComparisonOperation(numericExpression2, numericComparisonContext.operator.getText(), numericExpression));
    }

    @Override
    public void exitBooleanComparison(EfxParser.BooleanComparisonContext booleanComparisonContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeComparisonOperation(booleanExpression2, booleanComparisonContext.operator.getText(), booleanExpression));
    }

    @Override
    public void exitDateComparison(EfxParser.DateComparisonContext dateComparisonContext) {
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        DateExpression dateExpression2 = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeComparisonOperation(dateExpression2, dateComparisonContext.operator.getText(), dateExpression));
    }

    @Override
    public void exitTimeComparison(EfxParser.TimeComparisonContext timeComparisonContext) {
        TimeExpression timeExpression = this.stack.pop(TimeExpression.class);
        TimeExpression timeExpression2 = this.stack.pop(TimeExpression.class);
        this.stack.push(this.script.composeComparisonOperation(timeExpression2, timeComparisonContext.operator.getText(), timeExpression));
    }

    @Override
    public void exitDurationComparison(EfxParser.DurationComparisonContext durationComparisonContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeComparisonOperation(durationExpression2, durationComparisonContext.operator.getText(), durationExpression));
    }

    @Override
    public void exitEmptinessCondition(EfxParser.EmptinessConditionContext emptinessConditionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        String string = emptinessConditionContext.modifier != null && emptinessConditionContext.modifier.getText().equals(NOT_MODIFIER) ? "!=" : "==";
        this.stack.push(this.script.composeComparisonOperation(stringExpression, string, this.script.getStringLiteralFromUnquotedString("")));
    }

    @Override
    public void exitPresenceCondition(EfxParser.PresenceConditionContext presenceConditionContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        if (presenceConditionContext.modifier != null && presenceConditionContext.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeExistsCondition(pathExpression)));
        } else {
            this.stack.push(this.script.composeExistsCondition(pathExpression));
        }
    }

    @Override
    public void exitUniqueValueCondition(EfxParser.UniqueValueConditionContext uniqueValueConditionContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        PathExpression pathExpression2 = (PathExpression)this.stack.pop(pathExpression.getClass());
        if (uniqueValueConditionContext.modifier != null && uniqueValueConditionContext.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeUniqueValueCondition(pathExpression2, pathExpression)));
        } else {
            this.stack.push(this.script.composeUniqueValueCondition(pathExpression2, pathExpression));
        }
    }

    @Override
    public void exitLikePatternCondition(EfxParser.LikePatternConditionContext likePatternConditionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        BooleanExpression booleanExpression = this.script.composePatternMatchCondition(stringExpression, likePatternConditionContext.pattern.getText());
        if (likePatternConditionContext.modifier != null && likePatternConditionContext.modifier.getText().equals(NOT_MODIFIER)) {
            booleanExpression = this.script.composeLogicalNot(booleanExpression);
        }
        this.stack.push(booleanExpression);
    }

    @Override
    public void exitStringInListCondition(EfxParser.StringInListConditionContext stringInListConditionContext) {
        this.exitInListCondition(stringInListConditionContext.modifier, StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitBooleanInListCondition(EfxParser.BooleanInListConditionContext booleanInListConditionContext) {
        this.exitInListCondition(booleanInListConditionContext.modifier, BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitNumberInListCondition(EfxParser.NumberInListConditionContext numberInListConditionContext) {
        this.exitInListCondition(numberInListConditionContext.modifier, NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitDateInListCondition(EfxParser.DateInListConditionContext dateInListConditionContext) {
        this.exitInListCondition(dateInListConditionContext.modifier, DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeInListCondition(EfxParser.TimeInListConditionContext timeInListConditionContext) {
        this.exitInListCondition(timeInListConditionContext.modifier, TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationInListCondition(EfxParser.DurationInListConditionContext durationInListConditionContext) {
        this.exitInListCondition(durationInListConditionContext.modifier, DurationExpression.class, DurationSequenceExpression.class);
    }

    private void exitInListCondition(Token token, Class<? extends ScalarExpression> clazz, Class<? extends SequenceExpression> clazz2) {
        SequenceExpression sequenceExpression = this.stack.pop(clazz2);
        ScalarExpression scalarExpression = this.stack.pop(clazz);
        BooleanExpression booleanExpression = this.script.composeContainsCondition(scalarExpression, sequenceExpression);
        if (token != null && token.getText().equals(NOT_MODIFIER)) {
            booleanExpression = this.script.composeLogicalNot(booleanExpression);
        }
        this.stack.push(booleanExpression);
    }

    @Override
    public void exitQuantifiedExpression(EfxParser.QuantifiedExpressionContext quantifiedExpressionContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        if (quantifiedExpressionContext.Every() != null) {
            this.stack.push(this.script.composeAllSatisfy(this.stack.pop(IteratorListExpression.class), booleanExpression));
        } else {
            this.stack.push(this.script.composeAnySatisfies(this.stack.pop(IteratorListExpression.class), booleanExpression));
        }
    }

    @Override
    public void exitAdditionExpression(EfxParser.AdditionExpressionContext additionExpressionContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(numericExpression2, additionExpressionContext.operator.getText(), numericExpression));
    }

    @Override
    public void exitMultiplicationExpression(EfxParser.MultiplicationExpressionContext multiplicationExpressionContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(numericExpression2, multiplicationExpressionContext.operator.getText(), numericExpression));
    }

    @Override
    public void exitParenthesizedNumericExpression(EfxParser.ParenthesizedNumericExpressionContext parenthesizedNumericExpressionContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(NumericExpression.class), NumericExpression.class));
    }

    @Override
    public void exitDurationAdditionExpression(EfxParser.DurationAdditionExpressionContext durationAdditionExpressionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeAddition(durationExpression2, durationExpression));
    }

    @Override
    public void exitDurationSubtractionExpression(EfxParser.DurationSubtractionExpressionContext durationSubtractionExpressionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeSubtraction(durationExpression2, durationExpression));
    }

    @Override
    public void exitDurationLeftMultiplicationExpression(EfxParser.DurationLeftMultiplicationExpressionContext durationLeftMultiplicationExpressionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeMultiplication(numericExpression, durationExpression));
    }

    @Override
    public void exitDurationRightMultiplicationExpression(EfxParser.DurationRightMultiplicationExpressionContext durationRightMultiplicationExpressionContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeMultiplication(numericExpression, durationExpression));
    }

    @Override
    public void exitDateSubtractionExpression(EfxParser.DateSubtractionExpressionContext dateSubtractionExpressionContext) {
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        DateExpression dateExpression2 = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeSubtraction(dateExpression, dateExpression2));
    }

    @Override
    public void exitCodeList(EfxParser.CodeListContext codeListContext) {
        if (this.stack.empty()) {
            this.stack.push(this.script.composeList(Collections.emptyList(), StringSequenceExpression.class));
        }
    }

    @Override
    public void exitStringList(EfxParser.StringListContext stringListContext) {
        this.exitList(stringListContext.stringExpression().size(), StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitBooleanList(EfxParser.BooleanListContext booleanListContext) {
        this.exitList(booleanListContext.booleanExpression().size(), BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitNumericList(EfxParser.NumericListContext numericListContext) {
        this.exitList(numericListContext.numericExpression().size(), NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitDateList(EfxParser.DateListContext dateListContext) {
        this.exitList(dateListContext.dateExpression().size(), DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeList(EfxParser.TimeListContext timeListContext) {
        this.exitList(timeListContext.timeExpression().size(), TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationList(EfxParser.DurationListContext durationListContext) {
        this.exitList(durationListContext.durationExpression().size(), DurationExpression.class, DurationSequenceExpression.class);
    }

    private <T extends ScalarExpression> void exitList(int n, Class<T> clazz, Class<? extends SequenceExpression> clazz2) {
        if (this.stack.empty() || n == 0) {
            this.stack.push(this.script.composeList(Collections.emptyList(), clazz2));
            return;
        }
        ArrayList<ScalarExpression> arrayList = new ArrayList<ScalarExpression>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(0, (ScalarExpression)this.stack.pop(clazz));
        }
        this.stack.push(this.script.composeList(arrayList, clazz2));
    }

    @Override
    public void exitUntypedConditionalExpression(EfxParser.UntypedConditionalExpressionContext untypedConditionalExpressionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (clazz == EfxDataType.Boolean.class) {
            this.exitConditionalBooleanExpression();
        } else if (clazz == EfxDataType.Number.class) {
            this.exitConditionalNumericExpression();
        } else if (clazz == EfxDataType.String.class) {
            this.exitConditionalStringExpression();
        } else if (clazz == EfxDataType.Date.class) {
            this.exitConditionalDateExpression();
        } else if (clazz == EfxDataType.Time.class) {
            this.exitConditionalTimeExpression();
        } else if (clazz == EfxDataType.Duration.class) {
            this.exitConditionalDurationExpression();
        } else {
            throw new IllegalStateException("Unknown type " + clazz);
        }
    }

    @Override
    public void exitConditionalBooleanExpression(EfxParser.ConditionalBooleanExpressionContext conditionalBooleanExpressionContext) {
        this.exitConditionalBooleanExpression();
    }

    @Override
    public void exitConditionalNumericExpression(EfxParser.ConditionalNumericExpressionContext conditionalNumericExpressionContext) {
        this.exitConditionalNumericExpression();
    }

    @Override
    public void exitConditionalStringExpression(EfxParser.ConditionalStringExpressionContext conditionalStringExpressionContext) {
        this.exitConditionalStringExpression();
    }

    @Override
    public void exitConditionalDateExpression(EfxParser.ConditionalDateExpressionContext conditionalDateExpressionContext) {
        this.exitConditionalDateExpression();
    }

    @Override
    public void exitConditionalTimeExpression(EfxParser.ConditionalTimeExpressionContext conditionalTimeExpressionContext) {
        this.exitConditionalTimeExpression();
    }

    @Override
    public void exitConditionalDurationExpression(EfxParser.ConditionalDurationExpressionContext conditionalDurationExpressionContext) {
        this.exitConditionalDurationExpression();
    }

    private void exitConditionalBooleanExpression() {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression3 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression3, booleanExpression2, booleanExpression, BooleanExpression.class));
    }

    private void exitConditionalNumericExpression() {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, numericExpression2, numericExpression, NumericExpression.class));
    }

    private void exitConditionalStringExpression() {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, stringExpression2, stringExpression, StringExpression.class));
    }

    private void exitConditionalDateExpression() {
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        DateExpression dateExpression2 = this.stack.pop(DateExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, dateExpression2, dateExpression, DateExpression.class));
    }

    private void exitConditionalTimeExpression() {
        TimeExpression timeExpression = this.stack.pop(TimeExpression.class);
        TimeExpression timeExpression2 = this.stack.pop(TimeExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, timeExpression2, timeExpression, TimeExpression.class));
    }

    private void exitConditionalDurationExpression() {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, durationExpression2, durationExpression, DurationExpression.class));
    }

    @Override
    public void exitStringIteratorExpression(EfxParser.StringIteratorExpressionContext stringIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV1.getVariableName(stringIteratorExpressionContext.stringVariableDeclaration()), StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitBooleanIteratorExpression(EfxParser.BooleanIteratorExpressionContext booleanIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV1.getVariableName(booleanIteratorExpressionContext.booleanVariableDeclaration()), BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitNumericIteratorExpression(EfxParser.NumericIteratorExpressionContext numericIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV1.getVariableName(numericIteratorExpressionContext.numericVariableDeclaration()), NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitDateIteratorExpression(EfxParser.DateIteratorExpressionContext dateIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV1.getVariableName(dateIteratorExpressionContext.dateVariableDeclaration()), DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeIteratorExpression(EfxParser.TimeIteratorExpressionContext timeIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV1.getVariableName(timeIteratorExpressionContext.timeVariableDeclaration()), TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationIteratorExpression(EfxParser.DurationIteratorExpressionContext durationIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV1.getVariableName(durationIteratorExpressionContext.durationVariableDeclaration()), DurationExpression.class, DurationSequenceExpression.class);
    }

    @Override
    public void exitContextIteratorExpression(EfxParser.ContextIteratorExpressionContext contextIteratorExpressionContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        Class<?> clazz = pathExpression.getClass();
        String string = EfxExpressionTranslatorV1.getVariableName(contextIteratorExpressionContext.contextVariableDeclaration());
        Variable variable = new Variable(string, (Expression)this.script.composeVariableDeclaration(string, clazz), (TypedExpression)Expression.empty(clazz), (TypedExpression)this.script.composeVariableReference(string, clazz));
        this.stack.declareIdentifier(variable);
        this.stack.push(this.script.composeIteratorExpression(variable.declarationExpression, pathExpression));
        if (contextIteratorExpressionContext.fieldContext() != null) {
            String string2 = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(contextIteratorExpressionContext.fieldContext());
            this.efxContext.declareContextVariable(variable.name, new Context.FieldContext(string2, this.symbols.getAbsolutePathOfField(string2), this.symbols.getRelativePathOfField(string2, this.efxContext.absolutePath())));
        } else if (contextIteratorExpressionContext.nodeContext() != null) {
            String string3 = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(contextIteratorExpressionContext.nodeContext());
            this.efxContext.declareContextVariable(variable.name, new Context.NodeContext(string3, this.symbols.getAbsolutePathOfNode(string3), this.symbols.getRelativePathOfNode(string3, this.efxContext.absolutePath())));
        }
    }

    @Override
    public void exitIteratorList(EfxParser.IteratorListContext iteratorListContext) {
        ArrayList<IteratorExpression> arrayList = new ArrayList<IteratorExpression>();
        for (int i = 0; i < iteratorListContext.iteratorExpression().size(); ++i) {
            arrayList.add(0, this.stack.pop(IteratorExpression.class));
        }
        this.stack.push(this.script.composeIteratorList(arrayList));
    }

    @Override
    public void exitParenthesizedStringsFromIteration(EfxParser.ParenthesizedStringsFromIterationContext parenthesizedStringsFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(StringSequenceExpression.class), StringSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedNumbersFromIteration(EfxParser.ParenthesizedNumbersFromIterationContext parenthesizedNumbersFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(NumericSequenceExpression.class), NumericSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedBooleansFromIteration(EfxParser.ParenthesizedBooleansFromIterationContext parenthesizedBooleansFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(BooleanSequenceExpression.class), BooleanSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedDatesFromIteration(EfxParser.ParenthesizedDatesFromIterationContext parenthesizedDatesFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(DateSequenceExpression.class), DateSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedTimesFromIteration(EfxParser.ParenthesizedTimesFromIterationContext parenthesizedTimesFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(TimeSequenceExpression.class), TimeSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedDurationsFromITeration(EfxParser.ParenthesizedDurationsFromITerationContext parenthesizedDurationsFromITerationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(DurationSequenceExpression.class), DurationSequenceExpression.class));
    }

    @Override
    public void exitStringSequenceFromIteration(EfxParser.StringSequenceFromIterationContext stringSequenceFromIterationContext) {
        this.exitIterationExpression(StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitNumericSequenceFromIteration(EfxParser.NumericSequenceFromIterationContext numericSequenceFromIterationContext) {
        this.exitIterationExpression(NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitBooleanSequenceFromIteration(EfxParser.BooleanSequenceFromIterationContext booleanSequenceFromIterationContext) {
        this.exitIterationExpression(BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitDateSequenceFromIteration(EfxParser.DateSequenceFromIterationContext dateSequenceFromIterationContext) {
        this.exitIterationExpression(DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeSequenceFromIteration(EfxParser.TimeSequenceFromIterationContext timeSequenceFromIterationContext) {
        this.exitIterationExpression(TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationSequenceFromIteration(EfxParser.DurationSequenceFromIterationContext durationSequenceFromIterationContext) {
        this.exitIterationExpression(DurationExpression.class, DurationSequenceExpression.class);
    }

    public <T1 extends ScalarExpression, T2 extends SequenceExpression> void exitIteratorExpression(String string, Class<T1> clazz, Class<T2> clazz2) {
        T1 T1 = this.script.composeVariableDeclaration(string, clazz);
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz2);
        ScalarExpression scalarExpression = (ScalarExpression)this.script.composeVariableReference(string, clazz);
        Variable variable = new Variable(string, (Expression)T1, sequenceExpression, scalarExpression);
        this.stack.declareIdentifier(variable);
        this.stack.push(this.script.composeIteratorExpression(variable.declarationExpression, sequenceExpression));
    }

    public <T extends ScalarExpression> void exitIterationExpression(Class<T> clazz, Class<? extends SequenceExpression> clazz2) {
        ScalarExpression scalarExpression = (ScalarExpression)this.stack.pop(clazz);
        IteratorListExpression iteratorListExpression = this.stack.pop(IteratorListExpression.class);
        this.stack.push(this.script.composeForExpression(iteratorListExpression, scalarExpression, clazz2));
    }

    @Override
    public void exitNumericLiteral(EfxParser.NumericLiteralContext numericLiteralContext) {
        this.stack.push(this.script.getNumericLiteralEquivalent(numericLiteralContext.getText()));
    }

    @Override
    public void exitStringLiteral(EfxParser.StringLiteralContext stringLiteralContext) {
        this.stack.push(this.script.getStringLiteralEquivalent(stringLiteralContext.getText()));
    }

    @Override
    public void exitTrueBooleanLiteral(EfxParser.TrueBooleanLiteralContext trueBooleanLiteralContext) {
        this.stack.push(this.script.getBooleanEquivalent(true));
    }

    @Override
    public void exitFalseBooleanLiteral(EfxParser.FalseBooleanLiteralContext falseBooleanLiteralContext) {
        this.stack.push(this.script.getBooleanEquivalent(false));
    }

    @Override
    public void exitDateLiteral(EfxParser.DateLiteralContext dateLiteralContext) {
        this.stack.push(this.script.getDateLiteralEquivalent(dateLiteralContext.DATE().getText()));
    }

    @Override
    public void exitTimeLiteral(EfxParser.TimeLiteralContext timeLiteralContext) {
        this.stack.push(this.script.getTimeLiteralEquivalent(timeLiteralContext.TIME().getText()));
    }

    @Override
    public void exitDurationLiteral(EfxParser.DurationLiteralContext durationLiteralContext) {
        this.stack.push(this.script.getDurationLiteralEquivalent(durationLiteralContext.getText()));
    }

    @Override
    public void exitSimpleNodeReference(EfxParser.SimpleNodeReferenceContext simpleNodeReferenceContext) {
        this.stack.push(this.symbols.getRelativePathOfNode(simpleNodeReferenceContext.NodeId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void exitSimpleFieldReference(EfxParser.SimpleFieldReferenceContext simpleFieldReferenceContext) {
        this.stack.push(this.symbols.getRelativePathOfField(simpleFieldReferenceContext.FieldId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void enterAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext absoluteFieldReferenceContext) {
        if (absoluteFieldReferenceContext.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext absoluteFieldReferenceContext) {
        if (absoluteFieldReferenceContext.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void enterAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext absoluteNodeReferenceContext) {
        if (absoluteNodeReferenceContext.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext absoluteNodeReferenceContext) {
        if (absoluteNodeReferenceContext.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void exitNodeReferenceWithPredicate(EfxParser.NodeReferenceWithPredicateContext nodeReferenceWithPredicateContext) {
        if (nodeReferenceWithPredicateContext.predicate() != null) {
            BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
            PathExpression pathExpression = this.stack.pop(NodePathExpression.class);
            this.stack.push(this.script.composeNodeReferenceWithPredicate(pathExpression, booleanExpression));
        }
    }

    @Override
    public void exitFieldReferenceWithPredicate(EfxParser.FieldReferenceWithPredicateContext fieldReferenceWithPredicateContext) {
        if (fieldReferenceWithPredicateContext.predicate() != null) {
            BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.composeFieldReferenceWithPredicate(pathExpression, booleanExpression));
        }
    }

    @Override
    public void enterPredicate(EfxParser.PredicateContext predicateContext) {
        String string = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(predicateContext.getParent());
        if (string != null) {
            this.efxContext.pushNodeContext(string);
        } else {
            String string2 = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(predicateContext.getParent());
            this.efxContext.pushFieldContext(string2);
        }
    }

    @Override
    public void exitPredicate(EfxParser.PredicateContext predicateContext) {
        this.efxContext.pop();
    }

    @Override
    public void exitFieldReferenceWithAxis(EfxParser.FieldReferenceWithAxisContext fieldReferenceWithAxisContext) {
        if (fieldReferenceWithAxisContext.axis() != null) {
            this.stack.push(this.script.composeFieldReferenceWithAxis(this.stack.pop(PathExpression.class), fieldReferenceWithAxisContext.axis().Axis().getText()));
        }
    }

    @Override
    public void exitNoticeReference(EfxParser.NoticeReferenceContext noticeReferenceContext) {
        this.stack.push(this.script.composeExternalReference(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void enterFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext fieldReferenceInOtherNoticeContext) {
        if (fieldReferenceInOtherNoticeContext.noticeReference() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext fieldReferenceInOtherNoticeContext) {
        if (fieldReferenceInOtherNoticeContext.noticeReference() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            PathExpression pathExpression2 = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.composeFieldInExternalReference(pathExpression2, pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitScalarFromFieldReference(EfxParser.ScalarFromFieldReferenceContext scalarFromFieldReferenceContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(scalarFromFieldReferenceContext);
        if (this.symbols.isAttributeField(string)) {
            this.stack.push(this.script.composeFieldAttributeReference(this.symbols.getRelativePath(this.symbols.getAbsolutePathOfFieldWithoutTheAttribute(string), ((Context)this.efxContext.peek()).absolutePath()), this.symbols.getAttributeNameFromAttributeField(string), PathExpression.fromFieldType.get((Object)FieldTypes.fromString(this.symbols.getTypeOfField(string)))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(pathExpression));
        }
    }

    @Override
    public void exitSequenceFromFieldReference(EfxParser.SequenceFromFieldReferenceContext sequenceFromFieldReferenceContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(sequenceFromFieldReferenceContext);
        if (this.symbols.isAttributeField(string)) {
            this.stack.push(this.script.composeFieldAttributeReference(this.symbols.getRelativePath(this.symbols.getAbsolutePathOfFieldWithoutTheAttribute(string), ((Context)this.efxContext.peek()).absolutePath()), this.symbols.getAttributeNameFromAttributeField(string), PathExpression.fromFieldType.get((Object)FieldTypes.fromString(this.symbols.getTypeOfField(string)))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(pathExpression));
        }
    }

    @Override
    public void exitScalarFromAttributeReference(EfxParser.ScalarFromAttributeReferenceContext scalarFromAttributeReferenceContext) {
        this.stack.push(this.script.composeFieldAttributeReference(this.stack.pop(PathExpression.class), scalarFromAttributeReferenceContext.attributeReference().Identifier().getText(), StringPathExpression.class));
    }

    @Override
    public void exitSequenceFromAttributeReference(EfxParser.SequenceFromAttributeReferenceContext sequenceFromAttributeReferenceContext) {
        this.stack.push(this.script.composeFieldAttributeReference(this.stack.pop(PathExpression.class), sequenceFromAttributeReferenceContext.attributeReference().Identifier().getText(), StringPathExpression.class));
    }

    @Override
    public void exitContextFieldSpecifier(EfxParser.ContextFieldSpecifierContext contextFieldSpecifierContext) {
        this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(contextFieldSpecifierContext.field);
        this.efxContext.push(new Context.FieldContext(string, this.symbols.getAbsolutePathOfField(string), this.symbols.getRelativePathOfField(string, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithFieldContextOverride(EfxParser.FieldReferenceWithFieldContextOverrideContext fieldReferenceWithFieldContextOverrideContext) {
        if (fieldReferenceWithFieldContextOverrideContext.contextFieldSpecifier() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitContextNodeSpecifier(EfxParser.ContextNodeSpecifierContext contextNodeSpecifierContext) {
        this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(contextNodeSpecifierContext.node);
        this.efxContext.push(new Context.NodeContext(string, this.symbols.getAbsolutePathOfNode(string), this.symbols.getRelativePathOfNode(string, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithNodeContextOverride(EfxParser.FieldReferenceWithNodeContextOverrideContext fieldReferenceWithNodeContextOverrideContext) {
        if (fieldReferenceWithNodeContextOverrideContext.contextNodeSpecifier() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitContextVariableSpecifier(EfxParser.ContextVariableSpecifierContext contextVariableSpecifierContext) {
        Context context = this.efxContext.getContextFromVariable(EfxExpressionTranslatorV1.getVariableName(contextVariableSpecifierContext.variableReference()));
        if (context.isFieldContext().booleanValue()) {
            this.efxContext.push(new Context.FieldContext(context.symbol(), this.symbols.getAbsolutePathOfField(context.symbol()), this.symbols.getRelativePathOfField(context.symbol(), this.efxContext.absolutePath())));
        } else if (context.isNodeContext().booleanValue()) {
            this.efxContext.push(new Context.NodeContext(context.symbol(), this.symbols.getAbsolutePathOfNode(context.symbol()), this.symbols.getRelativePathOfNode(context.symbol(), this.efxContext.absolutePath())));
        } else {
            throw new IllegalStateException("Variable context is neither a field nor a node context.");
        }
    }

    @Override
    public void exitFieldReferenceWithVariableContextOverride(EfxParser.FieldReferenceWithVariableContextOverrideContext fieldReferenceWithVariableContextOverrideContext) {
        if (fieldReferenceWithVariableContextOverrideContext.contextVariableSpecifier() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            PathExpression pathExpression2 = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.joinPaths(pathExpression2, pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitCodelistReference(EfxParser.CodelistReferenceContext codelistReferenceContext) {
        this.stack.push(this.script.composeList(this.symbols.expandCodelist(codelistReferenceContext.codeListId.getText()).stream().map(string -> this.script.getStringLiteralFromUnquotedString((String)string)).collect(Collectors.toList()), StringSequenceExpression.class));
    }

    @Override
    public void exitVariableReference(EfxParser.VariableReferenceContext variableReferenceContext) {
        String string = EfxExpressionTranslatorV1.getVariableName(variableReferenceContext);
        this.stack.pushIdentifierReference(string);
    }

    @Override
    public void exitStringParameterDeclaration(EfxParser.StringParameterDeclarationContext stringParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV1.getVariableName(stringParameterDeclarationContext), StringExpression.class);
    }

    @Override
    public void exitNumericParameterDeclaration(EfxParser.NumericParameterDeclarationContext numericParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV1.getVariableName(numericParameterDeclarationContext), NumericExpression.class);
    }

    @Override
    public void exitBooleanParameterDeclaration(EfxParser.BooleanParameterDeclarationContext booleanParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV1.getVariableName(booleanParameterDeclarationContext), BooleanExpression.class);
    }

    @Override
    public void exitDateParameterDeclaration(EfxParser.DateParameterDeclarationContext dateParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV1.getVariableName(dateParameterDeclarationContext), DateExpression.class);
    }

    @Override
    public void exitTimeParameterDeclaration(EfxParser.TimeParameterDeclarationContext timeParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV1.getVariableName(timeParameterDeclarationContext), TimeExpression.class);
    }

    @Override
    public void exitDurationParameterDeclaration(EfxParser.DurationParameterDeclarationContext durationParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV1.getVariableName(durationParameterDeclarationContext), DurationExpression.class);
    }

    private void exitParameterDeclaration(String string, Class<? extends TypedExpression> clazz) {
        if (this.expressionParameters.isEmpty()) {
            throw new ParseCancellationException("No parameter passed for " + string);
        }
        Parameter parameter = new Parameter(string, this.script.composeParameterDeclaration(string, clazz), this.script.composeVariableReference(string, clazz), this.translateParameter(this.expressionParameters.pop(), clazz));
        this.stack.declareIdentifier(parameter);
    }

    @Override
    public void exitNotFunction(EfxParser.NotFunctionContext notFunctionContext) {
        this.stack.push(this.script.composeLogicalNot(this.stack.pop(BooleanExpression.class)));
    }

    @Override
    public void exitContainsFunction(EfxParser.ContainsFunctionContext containsFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeContainsCondition(stringExpression2, stringExpression));
    }

    @Override
    public void exitStartsWithFunction(EfxParser.StartsWithFunctionContext startsWithFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeStartsWithCondition(stringExpression2, stringExpression));
    }

    @Override
    public void exitEndsWithFunction(EfxParser.EndsWithFunctionContext endsWithFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeEndsWithCondition(stringExpression2, stringExpression));
    }

    @Override
    public void exitSequenceEqualFunction(EfxParser.SequenceEqualFunctionContext sequenceEqualFunctionContext) {
        SequenceExpression sequenceExpression = this.stack.pop(SequenceExpression.class);
        SequenceExpression sequenceExpression2 = this.stack.pop(SequenceExpression.class);
        this.stack.push(this.script.composeSequenceEqualFunction(sequenceExpression2, sequenceExpression));
    }

    @Override
    public void exitCountFunction(EfxParser.CountFunctionContext countFunctionContext) {
        SequenceExpression sequenceExpression = this.stack.pop(SequenceExpression.class);
        this.stack.push(this.script.composeCountOperation(sequenceExpression));
    }

    @Override
    public void exitNumberFunction(EfxParser.NumberFunctionContext numberFunctionContext) {
        this.stack.push(this.script.composeToNumberConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitSumFunction(EfxParser.SumFunctionContext sumFunctionContext) {
        this.stack.push(this.script.composeSumOperation(this.stack.pop(NumericSequenceExpression.class)));
    }

    @Override
    public void exitStringLengthFunction(EfxParser.StringLengthFunctionContext stringLengthFunctionContext) {
        this.stack.push(this.script.composeStringLengthCalculation(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitSubstringFunction(EfxParser.SubstringFunctionContext substringFunctionContext) {
        NumericExpression numericExpression = substringFunctionContext.length != null ? this.stack.pop(NumericExpression.class) : null;
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        if (numericExpression != null) {
            this.stack.push(this.script.composeSubstringExtraction(stringExpression, numericExpression2, numericExpression));
        } else {
            this.stack.push(this.script.composeSubstringExtraction(stringExpression, numericExpression2));
        }
    }

    @Override
    public void exitToStringFunction(EfxParser.ToStringFunctionContext toStringFunctionContext) {
        this.stack.push(this.script.composeToStringConversion(this.stack.pop(NumericExpression.class)));
    }

    @Override
    public void exitConcatFunction(EfxParser.ConcatFunctionContext concatFunctionContext) {
        if (this.stack.empty() || concatFunctionContext.stringExpression().size() == 0) {
            this.stack.push(this.script.composeStringConcatenation(Collections.emptyList()));
            return;
        }
        ArrayList<StringExpression> arrayList = new ArrayList<StringExpression>();
        for (int i = 0; i < concatFunctionContext.stringExpression().size(); ++i) {
            arrayList.add(0, this.stack.pop(StringExpression.class));
        }
        this.stack.push(this.script.composeStringConcatenation(arrayList));
    }

    @Override
    public void exitFormatNumberFunction(EfxParser.FormatNumberFunctionContext formatNumberFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeNumberFormatting(numericExpression, stringExpression));
    }

    @Override
    public void exitDateFromStringFunction(EfxParser.DateFromStringFunctionContext dateFromStringFunctionContext) {
        this.stack.push(this.script.composeToDateConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitDatePlusMeasureFunction(EfxParser.DatePlusMeasureFunctionContext datePlusMeasureFunctionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeAddition(dateExpression, durationExpression));
    }

    @Override
    public void exitDateMinusMeasureFunction(EfxParser.DateMinusMeasureFunctionContext dateMinusMeasureFunctionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeSubtraction(dateExpression, durationExpression));
    }

    @Override
    public void exitTimeFromStringFunction(EfxParser.TimeFromStringFunctionContext timeFromStringFunctionContext) {
        this.stack.push(this.script.composeToTimeConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitDayTimeDurationFromStringFunction(EfxParser.DayTimeDurationFromStringFunctionContext dayTimeDurationFromStringFunctionContext) {
        this.stack.push(this.script.composeToDayTimeDurationConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitYearMonthDurationFromStringFunction(EfxParser.YearMonthDurationFromStringFunctionContext yearMonthDurationFromStringFunctionContext) {
        this.stack.push(this.script.composeToYearMonthDurationConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitDistinctValuesFunction(EfxParser.DistinctValuesFunctionContext distinctValuesFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitDistinctValuesFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeDistinctValuesFunction(sequenceExpression, clazz));
    }

    @Override
    public void exitUnionFunction(EfxParser.UnionFunctionContext unionFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitUnionFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        SequenceExpression sequenceExpression2 = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeUnionFunction(sequenceExpression2, sequenceExpression, clazz));
    }

    @Override
    public void exitIntersectFunction(EfxParser.IntersectFunctionContext intersectFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitIntersectFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        SequenceExpression sequenceExpression2 = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeIntersectFunction(sequenceExpression2, sequenceExpression, clazz));
    }

    @Override
    public void exitExceptFunction(EfxParser.ExceptFunctionContext exceptFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitExceptFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        SequenceExpression sequenceExpression2 = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeExceptFunction(sequenceExpression2, sequenceExpression, clazz));
    }

    protected static String getLexerSymbol(int n) {
        return EfxLexer.VOCABULARY.getLiteralName(n).replaceAll("^'|'$", "");
    }

    private static String getVariableName(String string) {
        return StringUtils.stripStart((String)string, (String)"$");
    }

    private static String getVariableName(EfxParser.VariableReferenceContext variableReferenceContext) {
        return EfxExpressionTranslatorV1.getVariableName(variableReferenceContext.Variable().getText());
    }

    protected static String getVariableName(EfxParser.ContextVariableDeclarationContext contextVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(contextVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.StringVariableDeclarationContext stringVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(stringVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.NumericVariableDeclarationContext numericVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(numericVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.BooleanVariableDeclarationContext booleanVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(booleanVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DateVariableDeclarationContext dateVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(dateVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.TimeVariableDeclarationContext timeVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(timeVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DurationVariableDeclarationContext durationVariableDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(durationVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.StringParameterDeclarationContext stringParameterDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(stringParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.NumericParameterDeclarationContext numericParameterDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(numericParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.BooleanParameterDeclarationContext booleanParameterDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(booleanParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DateParameterDeclarationContext dateParameterDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(dateParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.TimeParameterDeclarationContext timeParameterDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(timeParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DurationParameterDeclarationContext durationParameterDeclarationContext) {
        return EfxExpressionTranslatorV1.getVariableName(durationParameterDeclarationContext.Variable().getText());
    }
}

