/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk1;

import eu.europa.ted.eforms.sdk.component.SdkComponent;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.efx.interfaces.EfxTemplateTranslator;
import eu.europa.ted.efx.interfaces.MarkupGenerator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.expressions.path.StringPathExpression;
import eu.europa.ted.efx.model.expressions.scalar.DateExpression;
import eu.europa.ted.efx.model.expressions.scalar.StringExpression;
import eu.europa.ted.efx.model.expressions.sequence.DateSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.StringSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.TimeSequenceExpression;
import eu.europa.ted.efx.model.templates.ContentBlock;
import eu.europa.ted.efx.model.templates.ContentBlockStack;
import eu.europa.ted.efx.model.templates.Markup;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.variables.Variable;
import eu.europa.ted.efx.model.variables.VariableList;
import eu.europa.ted.efx.sdk1.EfxExpressionTranslatorV1;
import eu.europa.ted.efx.sdk1.EfxLexer;
import eu.europa.ted.efx.sdk1.EfxParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkComponent(versions={"1"}, componentType=SdkComponentType.EFX_TEMPLATE_TRANSLATOR)
public class EfxTemplateTranslatorV1
extends EfxExpressionTranslatorV1
implements EfxTemplateTranslator {
    private static final Logger logger = LoggerFactory.getLogger(EfxTemplateTranslatorV1.class);
    private static final String INCONSISTENT_INDENTATION_SPACES = "Inconsistent indentation. Expected a multiple of %d spaces.";
    private static final String INDENTATION_LEVEL_SKIPPED = "Indentation level skipped.";
    private static final String START_INDENT_AT_ZERO = "Incorrect indentation. Please do not indent the first level in your template.";
    private static final String MIXED_INDENTATION = "Do not mix indentation methods. Stick with either tabs or spaces.";
    private static final String UNEXPECTED_INDENTATION = "Unexpected indentation tracker state.";
    private static final String LABEL_TYPE_NAME = EfxTemplateTranslatorV1.getLexerSymbol(35);
    private static final String LABEL_TYPE_WHEN = EfxTemplateTranslatorV1.getLexerSymbol(36).replace("-true", "");
    private static final String SHORTHAND_CONTEXT_FIELD_LABEL_REFERENCE = EfxTemplateTranslatorV1.getLexerSymbol(12);
    private static final String ASSET_TYPE_INDICATOR = EfxTemplateTranslatorV1.getLexerSymbol(28);
    private static final String ASSET_TYPE_BT = EfxTemplateTranslatorV1.getLexerSymbol(20);
    private static final String ASSET_TYPE_FIELD = EfxTemplateTranslatorV1.getLexerSymbol(21);
    private static final String ASSET_TYPE_NODE = EfxTemplateTranslatorV1.getLexerSymbol(22);
    private static final String ASSET_TYPE_CODE = EfxTemplateTranslatorV1.getLexerSymbol(27);
    private Indent indentWith = Indent.UNDETERMINED;
    private int indentSpaces = -1;
    MarkupGenerator markup;
    final ContentBlock rootBlock = ContentBlock.newRootBlock();
    ContentBlockStack blockStack = new ContentBlockStack();

    private EfxTemplateTranslatorV1() {
    }

    public EfxTemplateTranslatorV1(MarkupGenerator markupGenerator, SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener baseErrorListener) {
        super(symbolResolver, scriptGenerator, baseErrorListener);
        this.markup = markupGenerator;
    }

    @Override
    public String renderTemplate(Path path) throws IOException {
        return this.renderTemplate(CharStreams.fromPath((Path)path));
    }

    @Override
    public String renderTemplate(String string) {
        return this.renderTemplate((CharStream)CharStreams.fromString((String)string));
    }

    @Override
    public String renderTemplate(InputStream inputStream) throws IOException {
        return this.renderTemplate(CharStreams.fromStream((InputStream)inputStream));
    }

    private String renderTemplate(CharStream charStream) {
        logger.debug("Rendering template");
        EfxLexer efxLexer = new EfxLexer(charStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)efxLexer);
        EfxParser efxParser = new EfxParser((TokenStream)commonTokenStream);
        if (this.errorListener != null) {
            efxLexer.removeErrorListeners();
            efxLexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            efxParser.removeErrorListeners();
            efxParser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.TemplateFileContext templateFileContext = efxParser.templateFile();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)templateFileContext);
        logger.debug("Finished rendering template");
        return this.getTranslatedMarkup();
    }

    private String getTranslatedMarkup() {
        logger.debug("Getting translated markup.");
        StringBuilder stringBuilder = new StringBuilder(64);
        while (!this.stack.empty()) {
            stringBuilder.insert(0, '\n').insert(0, this.stack.pop(Markup.class).script);
        }
        logger.debug("Finished getting translated markup.");
        return stringBuilder.toString().trim();
    }

    @Override
    public void enterTemplateFile(EfxParser.TemplateFileContext templateFileContext) {
        assert (this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
    }

    @Override
    public void exitTemplateFile(EfxParser.TemplateFileContext templateFileContext) {
        this.blockStack.pop();
        ArrayList<Markup> arrayList = new ArrayList<Markup>();
        ArrayList<Markup> arrayList2 = new ArrayList<Markup>();
        for (ContentBlock contentBlock : this.rootBlock.getChildren()) {
            arrayList.add(contentBlock.renderCallTemplate(this.markup));
            contentBlock.renderTemplate(this.markup, arrayList2);
        }
        Markup markup = this.markup.composeOutputFile(arrayList, arrayList2);
        this.stack.push(markup);
    }

    @Override
    public void exitTextTemplate(EfxParser.TextTemplateContext textTemplateContext) {
        Markup markup = textTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        String string = textTemplateContext.textBlock() != null ? textTemplateContext.textBlock().getText() : "";
        this.stack.push(this.markup.renderFreeText(string).join(markup));
    }

    @Override
    public void exitLabelTemplate(EfxParser.LabelTemplateContext labelTemplateContext) {
        Markup markup = labelTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Markup markup2 = labelTemplateContext.labelBlock() != null ? this.stack.pop(Markup.class) : Markup.empty();
        this.stack.push(markup2.join(markup));
    }

    @Override
    public void exitExpressionTemplate(EfxParser.ExpressionTemplateContext expressionTemplateContext) {
        Markup markup = expressionTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Expression expression = this.stack.pop(Expression.class);
        this.stack.push(this.markup.renderVariableExpression(expression).join(markup));
    }

    @Override
    public void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext standardLabelReferenceContext) {
        if (!this.stack.empty() && StringSequenceExpression.class.isAssignableFrom(this.stack.peek().getClass()) && standardLabelReferenceContext.assetId() != null) {
            StringSequenceExpression stringSequenceExpression = this.stack.pop(StringSequenceExpression.class);
            this.exitStandardLabelReference(standardLabelReferenceContext, stringSequenceExpression);
        } else {
            StringExpression stringExpression = standardLabelReferenceContext.assetId() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
            this.exitStandardLabelReference(standardLabelReferenceContext, stringExpression);
        }
    }

    private void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext standardLabelReferenceContext, StringExpression stringExpression) {
        StringExpression stringExpression2 = standardLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        StringExpression stringExpression3 = standardLabelReferenceContext.assetType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(stringExpression3, this.script.getStringLiteralFromUnquotedString("|"), stringExpression2, this.script.getStringLiteralFromUnquotedString("|"), stringExpression))));
    }

    private void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext standardLabelReferenceContext, StringSequenceExpression stringSequenceExpression) {
        StringExpression stringExpression = standardLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        StringExpression stringExpression2 = standardLabelReferenceContext.assetType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", StringExpression.class), StringExpression.empty(), this.script.composeVariableReference("item", StringExpression.class));
        this.stack.push(this.markup.renderLabelFromExpression(this.script.composeDistinctValuesFunction(this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, stringSequenceExpression))), this.script.composeStringConcatenation(List.of(stringExpression2, this.script.getStringLiteralFromUnquotedString("|"), stringExpression, this.script.getStringLiteralFromUnquotedString("|"), new StringExpression(variable.referenceExpression.getScript()))), StringSequenceExpression.class), StringSequenceExpression.class)));
    }

    @Override
    public void exitShorthandBtLabelReference(EfxParser.ShorthandBtLabelReferenceContext shorthandBtLabelReferenceContext) {
        StringExpression stringExpression = this.script.getStringLiteralFromUnquotedString(shorthandBtLabelReferenceContext.BtId().getText());
        StringExpression stringExpression2 = shorthandBtLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_BT), this.script.getStringLiteralFromUnquotedString("|"), stringExpression2, this.script.getStringLiteralFromUnquotedString("|"), stringExpression))));
    }

    @Override
    public void exitShorthandFieldLabelReference(EfxParser.ShorthandFieldLabelReferenceContext shorthandFieldLabelReferenceContext) {
        StringExpression stringExpression;
        String string = shorthandFieldLabelReferenceContext.FieldId().getText();
        StringExpression stringExpression2 = stringExpression = shorthandFieldLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        if (stringExpression.getScript().equals("value")) {
            this.shorthandIndirectLabelReference(string);
        } else {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), stringExpression, this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string)))));
        }
    }

    @Override
    public void exitShorthandIndirectLabelReference(EfxParser.ShorthandIndirectLabelReferenceContext shorthandIndirectLabelReferenceContext) {
        this.shorthandIndirectLabelReference(shorthandIndirectLabelReferenceContext.FieldId().getText());
    }

    private void shorthandIndirectLabelReference(String string) {
        Context context = (Context)this.efxContext.peek();
        String string2 = this.symbols.getTypeOfField(string);
        PathExpression pathExpression = this.symbols.isAttributeField(string) ? this.script.composeFieldAttributeReference(this.symbols.getRelativePath(this.symbols.getAbsolutePathOfFieldWithoutTheAttribute(string), context.absolutePath()), this.symbols.getAttributeNameFromAttributeField(string), StringPathExpression.class) : this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(string, context.absolutePath()));
        Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", StringExpression.class), StringExpression.empty(), this.script.composeVariableReference("item", StringExpression.class));
        switch (string2) {
            case "indicator": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeDistinctValuesFunction(this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, pathExpression))), this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_INDICATOR), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_WHEN), this.script.getStringLiteralFromUnquotedString("-"), new StringExpression(variable.referenceExpression.getScript()), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string))), StringSequenceExpression.class), StringSequenceExpression.class)));
                break;
            }
            case "code": 
            case "internal-code": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeDistinctValuesFunction(this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, pathExpression))), this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_CODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_NAME), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.symbols.getRootCodelistOfField(string)), this.script.getStringLiteralFromUnquotedString("."), new StringExpression(variable.referenceExpression.getScript()))), StringSequenceExpression.class), StringSequenceExpression.class)));
                break;
            }
            default: {
                throw new ParseCancellationException(String.format("Unexpected field type '%s'. Expected a field of either type 'code' or 'indicator'.", string2));
            }
        }
    }

    @Override
    public void exitShorthandLabelReferenceFromContext(EfxParser.ShorthandLabelReferenceFromContextContext shorthandLabelReferenceFromContextContext) {
        String string = shorthandLabelReferenceFromContextContext.LabelType().getText();
        if (this.efxContext.isFieldContext().booleanValue()) {
            if (string.equals(SHORTHAND_CONTEXT_FIELD_LABEL_REFERENCE)) {
                this.shorthandIndirectLabelReference(this.efxContext.symbol());
            } else {
                this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol())))));
            }
        } else if (this.efxContext.isNodeContext().booleanValue()) {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_NODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol())))));
        }
    }

    @Override
    public void exitShorthandIndirectLabelReferenceFromContextField(EfxParser.ShorthandIndirectLabelReferenceFromContextFieldContext shorthandIndirectLabelReferenceFromContextFieldContext) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The #value shorthand syntax can only be used if a field is declared as context.");
        }
        this.shorthandIndirectLabelReference(this.efxContext.symbol());
    }

    @Override
    public void exitAssetType(EfxParser.AssetTypeContext assetTypeContext) {
        if (assetTypeContext.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(assetTypeContext.getText()));
        }
    }

    @Override
    public void exitLabelType(EfxParser.LabelTypeContext labelTypeContext) {
        if (labelTypeContext.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(labelTypeContext.getText()));
        }
    }

    @Override
    public void exitAssetId(EfxParser.AssetIdContext assetIdContext) {
        if (assetIdContext.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(assetIdContext.getText()));
        }
    }

    @Override
    public void exitStandardExpressionBlock(EfxParser.StandardExpressionBlockContext standardExpressionBlockContext) {
        Expression expression = this.stack.pop(Expression.class);
        if (TypedExpression.class.isAssignableFrom(expression.getClass())) {
            if (EfxDataType.Date.class.isAssignableFrom(((TypedExpression)expression).getDataType())) {
                Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", DateExpression.class), DateExpression.empty(), this.script.composeVariableReference("item", DateExpression.class));
                expression = this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, new DateSequenceExpression(expression.getScript())))), new StringExpression("format-date($item, '[D01]/[M01]/[Y0001]')"), StringSequenceExpression.class);
            } else if (EfxDataType.Time.class.isAssignableFrom(((TypedExpression)expression).getDataType())) {
                Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", DateExpression.class), DateExpression.empty(), this.script.composeVariableReference("item", DateExpression.class));
                expression = this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, new TimeSequenceExpression(expression.getScript())))), new StringExpression("format-time($item, '[H01]:[m01] [Z]')"), StringSequenceExpression.class);
            }
        }
        this.stack.push(expression);
    }

    @Override
    public void exitShorthandFieldValueReferenceFromContextField(EfxParser.ShorthandFieldValueReferenceFromContextFieldContext shorthandFieldValueReferenceFromContextFieldContext) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The $value shorthand syntax can only be used when a field is declared as the context.");
        }
        this.stack.push(this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(this.efxContext.symbol(), this.efxContext.absolutePath())));
    }

    @Override
    public void exitContextDeclarationBlock(EfxParser.ContextDeclarationBlockContext contextDeclarationBlockContext) {
        String string = EfxTemplateTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(contextDeclarationBlockContext);
        if (string != null) {
            this.efxContext.push(new Context.FieldContext(string, this.stack.pop(PathExpression.class)));
        } else {
            String string2 = EfxTemplateTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(contextDeclarationBlockContext);
            assert (string2 != null) : "We should have been able to locate the FieldId or NodeId declared as context.";
            this.efxContext.push(new Context.NodeContext(string2, this.stack.pop(PathExpression.class)));
        }
    }

    @Override
    public void enterTemplateLine(EfxParser.TemplateLineContext templateLineContext) {
        int n = this.getIndentLevel(templateLineContext);
        int n2 = n - this.blockStack.currentIndentationLevel();
        if (n2 > 1) {
            throw new ParseCancellationException(INDENTATION_LEVEL_SKIPPED);
        }
        if (n2 == 1) {
            if (this.blockStack.isEmpty()) {
                throw new ParseCancellationException(START_INDENT_AT_ZERO);
            }
            this.stack.pushStackFrame();
        } else if (n2 < 0) {
            for (int i = n2; i < 0; ++i) {
                assert (!this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
                assert (this.blockStack.currentIndentationLevel() > n) : "Unexpected indentation tracker state.";
                this.blockStack.pop();
                this.stack.popStackFrame();
            }
            this.stack.popStackFrame();
            this.stack.pushStackFrame();
            assert (this.blockStack.currentIndentationLevel() == n) : "Unexpected indentation tracker state.";
        } else if (n2 == 0) {
            this.stack.popStackFrame();
            this.stack.pushStackFrame();
        }
    }

    @Override
    public void exitTemplateLine(EfxParser.TemplateLineContext templateLineContext) {
        Context context = (Context)this.efxContext.pop();
        int n = this.getIndentLevel(templateLineContext);
        int n2 = n - this.blockStack.currentIndentationLevel();
        Markup markup = templateLineContext.template() != null ? this.stack.pop(Markup.class) : new Markup("");
        VariableList variableList = new VariableList();
        Integer n3 = templateLineContext.OutlineNumber() != null ? Integer.parseInt(templateLineContext.OutlineNumber().getText().trim()) : -1;
        assert (this.stack.empty()) : "Stack should be empty at this point.";
        this.stack.clear();
        if (n2 > 1) {
            throw new ParseCancellationException(INDENTATION_LEVEL_SKIPPED);
        }
        if (n2 == 1) {
            if (this.blockStack.isEmpty()) {
                throw new ParseCancellationException(START_INDENT_AT_ZERO);
            }
            this.blockStack.pushChild(n3, markup, this.relativizeContext(context, this.blockStack.currentContext()), variableList);
        } else if (n2 < 0) {
            this.blockStack.pushSibling(n3, markup, this.relativizeContext(context, this.blockStack.parentContext()), variableList);
        } else if (n2 == 0) {
            if (this.blockStack.isEmpty()) {
                assert (n == 0) : "Unexpected indentation tracker state.";
                this.blockStack.push(this.rootBlock.addChild(n3, markup, this.relativizeContext(context, this.rootBlock.getContext()), variableList));
            } else {
                this.blockStack.pushSibling(n3, markup, this.relativizeContext(context, this.blockStack.parentContext()), variableList);
            }
        }
    }

    private Context relativizeContext(Context context, Context context2) {
        if (context2 == null) {
            return context;
        }
        if (context.isFieldContext().booleanValue()) {
            return new Context.FieldContext(context.symbol(), context.absolutePath(), this.symbols.getRelativePath(context.absolutePath(), context2.absolutePath()));
        }
        assert (context.isNodeContext().booleanValue()) : "Child context should be either a FieldContext NodeContext.";
        return new Context.NodeContext(context.symbol(), context.absolutePath(), this.symbols.getRelativePath(context.absolutePath(), context2.absolutePath()));
    }

    private int getIndentLevel(EfxParser.TemplateLineContext templateLineContext) {
        if (templateLineContext.MixedIndent() != null) {
            throw new ParseCancellationException(MIXED_INDENTATION);
        }
        if (templateLineContext.Spaces() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.SPACES;
                this.indentSpaces = templateLineContext.Spaces().getText().length();
            } else if (this.indentWith == Indent.TABS) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            if (templateLineContext.Spaces().getText().length() % this.indentSpaces != 0) {
                throw new ParseCancellationException(String.format(INCONSISTENT_INDENTATION_SPACES, this.indentSpaces));
            }
            return templateLineContext.Spaces().getText().length() / this.indentSpaces;
        }
        if (templateLineContext.Tabs() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.TABS;
            } else if (this.indentWith == Indent.SPACES) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            return templateLineContext.Tabs().getText().length();
        }
        return 0;
    }

    private static enum Indent {
        TABS,
        SPACES,
        UNDETERMINED;

    }
}

