/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk2;

import eu.europa.ted.eforms.sdk.component.SdkComponent;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.efx.interfaces.EfxExpressionTranslator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.CallStack;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.ContextStack;
import eu.europa.ted.efx.model.ParsedEntity;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.iteration.IteratorExpression;
import eu.europa.ted.efx.model.expressions.iteration.IteratorListExpression;
import eu.europa.ted.efx.model.expressions.path.MultilingualStringPathExpression;
import eu.europa.ted.efx.model.expressions.path.NodePathExpression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.expressions.path.StringPathExpression;
import eu.europa.ted.efx.model.expressions.scalar.BooleanExpression;
import eu.europa.ted.efx.model.expressions.scalar.DateExpression;
import eu.europa.ted.efx.model.expressions.scalar.DurationExpression;
import eu.europa.ted.efx.model.expressions.scalar.NumericExpression;
import eu.europa.ted.efx.model.expressions.scalar.ScalarExpression;
import eu.europa.ted.efx.model.expressions.scalar.StringExpression;
import eu.europa.ted.efx.model.expressions.scalar.TimeExpression;
import eu.europa.ted.efx.model.expressions.sequence.BooleanSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.DateSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.DurationSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.NumericSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.SequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.StringSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.TimeSequenceExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.FieldTypes;
import eu.europa.ted.efx.model.variables.Parameter;
import eu.europa.ted.efx.model.variables.Variable;
import eu.europa.ted.efx.sdk2.EfxBaseListener;
import eu.europa.ted.efx.sdk2.EfxLexer;
import eu.europa.ted.efx.sdk2.EfxParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;

@SdkComponent(versions={"2"}, componentType=SdkComponentType.EFX_EXPRESSION_TRANSLATOR)
public class EfxExpressionTranslatorV2
extends EfxBaseListener
implements EfxExpressionTranslator {
    private static final String NOT_MODIFIER = EfxLexer.VOCABULARY.getLiteralName(89).replaceAll("^'|'$", "");
    private static final String VARIABLE_PREFIX = EfxLexer.VOCABULARY.getLiteralName(118).replaceAll("^'|'$", "");
    private static final String ATTRIBUTE_PREFIX = EfxLexer.VOCABULARY.getLiteralName(119).replaceAll("^'|'$", "");
    private static final String CODELIST_PREFIX = EfxLexer.VOCABULARY.getLiteralName(120).replaceAll("^'|'$", "");
    private static final String BEGIN_EXPRESSION_BLOCK = "{";
    private static final String END_EXPRESSION_BLOCK = "}";
    protected CallStack stack = new CallStack();
    protected ContextStack efxContext;
    protected SymbolResolver symbols;
    protected BaseErrorListener errorListener;
    protected ScriptGenerator script;
    private LinkedList<String> expressionParameters = new LinkedList();
    private static String textTypeName = EfxExpressionTranslatorV2.getLexerSymbol(70);
    private static String booleanTypeName = EfxExpressionTranslatorV2.getLexerSymbol(72);
    private static String numericTypeName = EfxExpressionTranslatorV2.getLexerSymbol(71);
    private static String dateTypeName = EfxExpressionTranslatorV2.getLexerSymbol(73);
    private static String timeTypeName = EfxExpressionTranslatorV2.getLexerSymbol(74);
    private static String durationTypeName = EfxExpressionTranslatorV2.getLexerSymbol(75);
    private static final Map<String, String> eFormsToEfxTypeMap = Map.ofEntries(Map.entry(FieldTypes.ID.getName(), textTypeName), Map.entry(FieldTypes.ID_REF.getName(), textTypeName), Map.entry(FieldTypes.TEXT.getName(), textTypeName), Map.entry(FieldTypes.TEXT_MULTILINGUAL.getName(), textTypeName), Map.entry(FieldTypes.INDICATOR.getName(), booleanTypeName), Map.entry(FieldTypes.AMOUNT.getName(), numericTypeName), Map.entry(FieldTypes.NUMBER.getName(), numericTypeName), Map.entry(FieldTypes.MEASURE.getName(), durationTypeName), Map.entry(FieldTypes.CODE.getName(), textTypeName), Map.entry(FieldTypes.INTERNAL_CODE.getName(), textTypeName), Map.entry(FieldTypes.INTEGER.getName(), numericTypeName), Map.entry(FieldTypes.DATE.getName(), dateTypeName), Map.entry(FieldTypes.ZONED_DATE.getName(), dateTypeName), Map.entry(FieldTypes.TIME.getName(), timeTypeName), Map.entry(FieldTypes.ZONED_TIME.getName(), timeTypeName), Map.entry(FieldTypes.URL.getName(), textTypeName), Map.entry(FieldTypes.PHONE.getName(), textTypeName), Map.entry(FieldTypes.EMAIL.getName(), textTypeName));
    private static final Map<Class<? extends EfxDataType>, String> javaToEfxTypeMap = Map.ofEntries(Map.entry(EfxDataType.String.class, textTypeName), Map.entry(EfxDataType.Boolean.class, booleanTypeName), Map.entry(EfxDataType.Number.class, numericTypeName), Map.entry(EfxDataType.Duration.class, durationTypeName), Map.entry(EfxDataType.Date.class, dateTypeName), Map.entry(EfxDataType.Time.class, timeTypeName));

    protected EfxExpressionTranslatorV2() {
    }

    public EfxExpressionTranslatorV2(SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener baseErrorListener) {
        this.symbols = symbolResolver;
        this.script = scriptGenerator;
        this.errorListener = baseErrorListener;
        this.efxContext = new ContextStack(this.symbols);
    }

    @Override
    public String translateExpression(String string, String ... stringArray) {
        this.expressionParameters.addAll(Arrays.asList(stringArray));
        ExpressionPreprocessor expressionPreprocessor = new ExpressionPreprocessor(string);
        String string2 = expressionPreprocessor.processExpression();
        EfxLexer efxLexer = new EfxLexer((CharStream)CharStreams.fromString((String)string2));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)efxLexer);
        EfxParser efxParser = new EfxParser((TokenStream)commonTokenStream);
        if (this.errorListener != null) {
            efxLexer.removeErrorListeners();
            efxLexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            efxParser.removeErrorListeners();
            efxParser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.SingleExpressionContext singleExpressionContext = efxParser.singleExpression();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)singleExpressionContext);
        return this.getTranslatedScript();
    }

    private <T extends Expression> T translateParameter(String string, Class<T> clazz) {
        EfxExpressionTranslatorV2 efxExpressionTranslatorV2 = new EfxExpressionTranslatorV2(this.symbols, this.script, this.errorListener);
        EfxLexer efxLexer = new EfxLexer((CharStream)CharStreams.fromString((String)(BEGIN_EXPRESSION_BLOCK + string + END_EXPRESSION_BLOCK)));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)efxLexer);
        EfxParser efxParser = new EfxParser((TokenStream)commonTokenStream);
        if (this.errorListener != null) {
            efxLexer.removeErrorListeners();
            efxLexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            efxParser.removeErrorListeners();
            efxParser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.ParameterValueContext parameterValueContext = efxParser.parameterValue();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)efxExpressionTranslatorV2, (ParseTree)parameterValueContext);
        return Expression.instantiate(efxExpressionTranslatorV2.getTranslatedScript(), clazz);
    }

    private String getTranslatedScript() {
        StringBuilder stringBuilder = new StringBuilder(this.stack.size() * 100);
        while (!this.stack.empty()) {
            stringBuilder.insert(0, '\n').insert(0, this.stack.pop(Expression.class).getScript());
        }
        return stringBuilder.toString().trim();
    }

    protected static String getFieldIdFromChildSimpleFieldReferenceContext(ParserRuleContext parserRuleContext) {
        if (parserRuleContext instanceof EfxParser.SimpleFieldReferenceContext) {
            return ((EfxParser.SimpleFieldReferenceContext)parserRuleContext).FieldId().getText();
        }
        if (parserRuleContext instanceof EfxParser.AbsoluteFieldReferenceContext) {
            return ((EfxParser.AbsoluteFieldReferenceContext)parserRuleContext).reference.reference.simpleFieldReference().FieldId().getText();
        }
        if (parserRuleContext instanceof EfxParser.FieldReferenceWithFieldContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithFieldContextOverrideContext)parserRuleContext).reference.reference.simpleFieldReference().FieldId().getText();
        }
        if (parserRuleContext instanceof EfxParser.FieldReferenceWithNodeContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithNodeContextOverrideContext)parserRuleContext).reference.reference.reference.simpleFieldReference().FieldId().getText();
        }
        EfxParser.SimpleFieldReferenceContext simpleFieldReferenceContext = (EfxParser.SimpleFieldReferenceContext)parserRuleContext.getChild(EfxParser.SimpleFieldReferenceContext.class, 0);
        if (simpleFieldReferenceContext != null) {
            return simpleFieldReferenceContext.FieldId().getText();
        }
        for (ParseTree parseTree : parserRuleContext.children) {
            String string;
            if (!(parseTree instanceof ParserRuleContext) || (string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext((ParserRuleContext)parseTree)) == null) continue;
            return string;
        }
        return null;
    }

    protected static String getNodeIdFromChildSimpleNodeReferenceContext(ParserRuleContext parserRuleContext) {
        if (parserRuleContext instanceof EfxParser.SimpleNodeReferenceContext) {
            return ((EfxParser.SimpleNodeReferenceContext)parserRuleContext).NodeId().getText();
        }
        for (ParseTree parseTree : parserRuleContext.children) {
            String string;
            if (!(parseTree instanceof ParserRuleContext) || (string = EfxExpressionTranslatorV2.getNodeIdFromChildSimpleNodeReferenceContext((ParserRuleContext)parseTree)) == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public void enterSingleExpression(EfxParser.SingleExpressionContext singleExpressionContext) {
        TerminalNode terminalNode = singleExpressionContext.FieldId();
        if (terminalNode != null) {
            this.efxContext.pushFieldContext(terminalNode.getText());
        } else {
            TerminalNode terminalNode2 = singleExpressionContext.NodeId();
            if (terminalNode2 != null) {
                this.efxContext.pushNodeContext(terminalNode2.getText());
            }
        }
    }

    @Override
    public void exitSingleExpression(EfxParser.SingleExpressionContext singleExpressionContext) {
        this.efxContext.pop();
    }

    @Override
    public void exitParenthesizedBooleanExpression(EfxParser.ParenthesizedBooleanExpressionContext parenthesizedBooleanExpressionContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(BooleanExpression.class), BooleanExpression.class));
    }

    @Override
    public void exitLogicalAndCondition(EfxParser.LogicalAndConditionContext logicalAndConditionContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeLogicalAnd(booleanExpression2, booleanExpression));
    }

    @Override
    public void exitLogicalOrCondition(EfxParser.LogicalOrConditionContext logicalOrConditionContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeLogicalOr(booleanExpression2, booleanExpression));
    }

    @Override
    public void exitStringComparison(EfxParser.StringComparisonContext stringComparisonContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeComparisonOperation(stringExpression2, stringComparisonContext.operator.getText(), stringExpression));
    }

    @Override
    public void exitNumericComparison(EfxParser.NumericComparisonContext numericComparisonContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeComparisonOperation(numericExpression2, numericComparisonContext.operator.getText(), numericExpression));
    }

    @Override
    public void exitBooleanComparison(EfxParser.BooleanComparisonContext booleanComparisonContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeComparisonOperation(booleanExpression2, booleanComparisonContext.operator.getText(), booleanExpression));
    }

    @Override
    public void exitDateComparison(EfxParser.DateComparisonContext dateComparisonContext) {
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        DateExpression dateExpression2 = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeComparisonOperation(dateExpression2, dateComparisonContext.operator.getText(), dateExpression));
    }

    @Override
    public void exitTimeComparison(EfxParser.TimeComparisonContext timeComparisonContext) {
        TimeExpression timeExpression = this.stack.pop(TimeExpression.class);
        TimeExpression timeExpression2 = this.stack.pop(TimeExpression.class);
        this.stack.push(this.script.composeComparisonOperation(timeExpression2, timeComparisonContext.operator.getText(), timeExpression));
    }

    @Override
    public void exitDurationComparison(EfxParser.DurationComparisonContext durationComparisonContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeComparisonOperation(durationExpression2, durationComparisonContext.operator.getText(), durationExpression));
    }

    @Override
    public void exitEmptinessCondition(EfxParser.EmptinessConditionContext emptinessConditionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        String string = emptinessConditionContext.modifier != null && emptinessConditionContext.modifier.getText().equals(NOT_MODIFIER) ? "!=" : "==";
        this.stack.push(this.script.composeComparisonOperation(stringExpression, string, this.script.getStringLiteralFromUnquotedString("")));
    }

    @Override
    public void exitPresenceCondition(EfxParser.PresenceConditionContext presenceConditionContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        if (presenceConditionContext.modifier != null && presenceConditionContext.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeExistsCondition(pathExpression)));
        } else {
            this.stack.push(this.script.composeExistsCondition(pathExpression));
        }
    }

    @Override
    public void exitUniqueValueCondition(EfxParser.UniqueValueConditionContext uniqueValueConditionContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        PathExpression pathExpression2 = (PathExpression)this.stack.pop(pathExpression.getClass());
        if (uniqueValueConditionContext.modifier != null && uniqueValueConditionContext.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeUniqueValueCondition(pathExpression2, pathExpression)));
        } else {
            this.stack.push(this.script.composeUniqueValueCondition(pathExpression2, pathExpression));
        }
    }

    @Override
    public void exitLikePatternCondition(EfxParser.LikePatternConditionContext likePatternConditionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        BooleanExpression booleanExpression = this.script.composePatternMatchCondition(stringExpression, likePatternConditionContext.pattern.getText());
        if (likePatternConditionContext.modifier != null && likePatternConditionContext.modifier.getText().equals(NOT_MODIFIER)) {
            booleanExpression = this.script.composeLogicalNot(booleanExpression);
        }
        this.stack.push(booleanExpression);
    }

    @Override
    public void exitStringInListCondition(EfxParser.StringInListConditionContext stringInListConditionContext) {
        this.exitInListCondition(stringInListConditionContext.modifier, StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitBooleanInListCondition(EfxParser.BooleanInListConditionContext booleanInListConditionContext) {
        this.exitInListCondition(booleanInListConditionContext.modifier, BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitNumberInListCondition(EfxParser.NumberInListConditionContext numberInListConditionContext) {
        this.exitInListCondition(numberInListConditionContext.modifier, NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitDateInListCondition(EfxParser.DateInListConditionContext dateInListConditionContext) {
        this.exitInListCondition(dateInListConditionContext.modifier, DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeInListCondition(EfxParser.TimeInListConditionContext timeInListConditionContext) {
        this.exitInListCondition(timeInListConditionContext.modifier, TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationInListCondition(EfxParser.DurationInListConditionContext durationInListConditionContext) {
        this.exitInListCondition(durationInListConditionContext.modifier, DurationExpression.class, DurationSequenceExpression.class);
    }

    private void exitInListCondition(Token token, Class<? extends ScalarExpression> clazz, Class<? extends SequenceExpression> clazz2) {
        SequenceExpression sequenceExpression = this.stack.pop(clazz2);
        ScalarExpression scalarExpression = this.stack.pop(clazz);
        BooleanExpression booleanExpression = this.script.composeContainsCondition(scalarExpression, sequenceExpression);
        if (token != null && token.getText().equals(NOT_MODIFIER)) {
            booleanExpression = this.script.composeLogicalNot(booleanExpression);
        }
        this.stack.push(booleanExpression);
    }

    @Override
    public void enterQuantifiedExpression(EfxParser.QuantifiedExpressionContext quantifiedExpressionContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitQuantifiedExpression(EfxParser.QuantifiedExpressionContext quantifiedExpressionContext) {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        if (quantifiedExpressionContext.Every() != null) {
            this.stack.push(this.script.composeAllSatisfy(this.stack.pop(IteratorListExpression.class), booleanExpression));
        } else {
            this.stack.push(this.script.composeAnySatisfies(this.stack.pop(IteratorListExpression.class), booleanExpression));
        }
        this.stack.popStackFrame();
    }

    @Override
    public void exitAdditionExpression(EfxParser.AdditionExpressionContext additionExpressionContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(numericExpression2, additionExpressionContext.operator.getText(), numericExpression));
    }

    @Override
    public void exitMultiplicationExpression(EfxParser.MultiplicationExpressionContext multiplicationExpressionContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(numericExpression2, multiplicationExpressionContext.operator.getText(), numericExpression));
    }

    @Override
    public void exitParenthesizedNumericExpression(EfxParser.ParenthesizedNumericExpressionContext parenthesizedNumericExpressionContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(NumericExpression.class), NumericExpression.class));
    }

    @Override
    public void exitDurationAdditionExpression(EfxParser.DurationAdditionExpressionContext durationAdditionExpressionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeAddition(durationExpression2, durationExpression));
    }

    @Override
    public void exitDurationSubtractionExpression(EfxParser.DurationSubtractionExpressionContext durationSubtractionExpressionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeSubtraction(durationExpression2, durationExpression));
    }

    @Override
    public void exitDurationLeftMultiplicationExpression(EfxParser.DurationLeftMultiplicationExpressionContext durationLeftMultiplicationExpressionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeMultiplication(numericExpression, durationExpression));
    }

    @Override
    public void exitDurationRightMultiplicationExpression(EfxParser.DurationRightMultiplicationExpressionContext durationRightMultiplicationExpressionContext) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        this.stack.push(this.script.composeMultiplication(numericExpression, durationExpression));
    }

    @Override
    public void exitDateSubtractionExpression(EfxParser.DateSubtractionExpressionContext dateSubtractionExpressionContext) {
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        DateExpression dateExpression2 = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeSubtraction(dateExpression, dateExpression2));
    }

    @Override
    public void exitCodeList(EfxParser.CodeListContext codeListContext) {
        if (this.stack.empty()) {
            this.stack.push(this.script.composeList(Collections.emptyList(), StringSequenceExpression.class));
        }
    }

    @Override
    public void exitStringList(EfxParser.StringListContext stringListContext) {
        this.exitList(stringListContext.stringExpression().size(), StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitBooleanList(EfxParser.BooleanListContext booleanListContext) {
        this.exitList(booleanListContext.booleanExpression().size(), BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitNumericList(EfxParser.NumericListContext numericListContext) {
        this.exitList(numericListContext.numericExpression().size(), NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitDateList(EfxParser.DateListContext dateListContext) {
        this.exitList(dateListContext.dateExpression().size(), DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeList(EfxParser.TimeListContext timeListContext) {
        this.exitList(timeListContext.timeExpression().size(), TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationList(EfxParser.DurationListContext durationListContext) {
        this.exitList(durationListContext.durationExpression().size(), DurationExpression.class, DurationSequenceExpression.class);
    }

    private <T extends ScalarExpression> void exitList(int n, Class<T> clazz, Class<? extends SequenceExpression> clazz2) {
        if (this.stack.empty() || n == 0) {
            this.stack.push(this.script.composeList(Collections.emptyList(), clazz2));
            return;
        }
        ArrayList<ScalarExpression> arrayList = new ArrayList<ScalarExpression>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(0, (ScalarExpression)this.stack.pop(clazz));
        }
        this.stack.push(this.script.composeList(arrayList, clazz2));
    }

    @Override
    public void exitConditionalBooleanExpression(EfxParser.ConditionalBooleanExpressionContext conditionalBooleanExpressionContext) {
        this.exitConditionalBooleanExpression();
    }

    @Override
    public void exitConditionalNumericExpression(EfxParser.ConditionalNumericExpressionContext conditionalNumericExpressionContext) {
        this.exitConditionalNumericExpression();
    }

    @Override
    public void exitConditionalStringExpression(EfxParser.ConditionalStringExpressionContext conditionalStringExpressionContext) {
        this.exitConditionalStringExpression();
    }

    @Override
    public void exitConditionalDateExpression(EfxParser.ConditionalDateExpressionContext conditionalDateExpressionContext) {
        this.exitConditionalDateExpression();
    }

    @Override
    public void exitConditionalTimeExpression(EfxParser.ConditionalTimeExpressionContext conditionalTimeExpressionContext) {
        this.exitConditionalTimeExpression();
    }

    @Override
    public void exitConditionalDurationExpression(EfxParser.ConditionalDurationExpressionContext conditionalDurationExpressionContext) {
        this.exitConditionalDurationExpression();
    }

    private void exitConditionalBooleanExpression() {
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression2 = this.stack.pop(BooleanExpression.class);
        BooleanExpression booleanExpression3 = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression3, booleanExpression2, booleanExpression, BooleanExpression.class));
    }

    private void exitConditionalNumericExpression() {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, numericExpression2, numericExpression, NumericExpression.class));
    }

    private void exitConditionalStringExpression() {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, stringExpression2, stringExpression, StringExpression.class));
    }

    private void exitConditionalDateExpression() {
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        DateExpression dateExpression2 = this.stack.pop(DateExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, dateExpression2, dateExpression, DateExpression.class));
    }

    private void exitConditionalTimeExpression() {
        TimeExpression timeExpression = this.stack.pop(TimeExpression.class);
        TimeExpression timeExpression2 = this.stack.pop(TimeExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, timeExpression2, timeExpression, TimeExpression.class));
    }

    private void exitConditionalDurationExpression() {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DurationExpression durationExpression2 = this.stack.pop(DurationExpression.class);
        BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(booleanExpression, durationExpression2, durationExpression, DurationExpression.class));
    }

    @Override
    public void exitStringIteratorExpression(EfxParser.StringIteratorExpressionContext stringIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV2.getVariableName(stringIteratorExpressionContext.stringVariableDeclaration()), StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitBooleanIteratorExpression(EfxParser.BooleanIteratorExpressionContext booleanIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV2.getVariableName(booleanIteratorExpressionContext.booleanVariableDeclaration()), BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitNumericIteratorExpression(EfxParser.NumericIteratorExpressionContext numericIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV2.getVariableName(numericIteratorExpressionContext.numericVariableDeclaration()), NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitDateIteratorExpression(EfxParser.DateIteratorExpressionContext dateIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV2.getVariableName(dateIteratorExpressionContext.dateVariableDeclaration()), DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeIteratorExpression(EfxParser.TimeIteratorExpressionContext timeIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV2.getVariableName(timeIteratorExpressionContext.timeVariableDeclaration()), TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationIteratorExpression(EfxParser.DurationIteratorExpressionContext durationIteratorExpressionContext) {
        this.exitIteratorExpression(EfxExpressionTranslatorV2.getVariableName(durationIteratorExpressionContext.durationVariableDeclaration()), DurationExpression.class, DurationSequenceExpression.class);
    }

    @Override
    public void exitContextIteratorExpression(EfxParser.ContextIteratorExpressionContext contextIteratorExpressionContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        Class<?> clazz = pathExpression.getClass();
        String string = EfxExpressionTranslatorV2.getVariableName(contextIteratorExpressionContext.contextVariableDeclaration());
        Variable variable = new Variable(string, (Expression)this.script.composeVariableDeclaration(string, clazz), (TypedExpression)Expression.empty(clazz), (TypedExpression)this.script.composeVariableReference(string, clazz));
        this.stack.declareIdentifier(variable);
        this.stack.push(this.script.composeIteratorExpression(variable.declarationExpression, pathExpression));
        if (contextIteratorExpressionContext.fieldContext() != null) {
            String string2 = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(contextIteratorExpressionContext.fieldContext());
            this.efxContext.declareContextVariable(variable.name, new Context.FieldContext(string2, this.symbols.getAbsolutePathOfField(string2), this.symbols.getRelativePathOfField(string2, this.efxContext.absolutePath())));
        } else if (contextIteratorExpressionContext.nodeContext() != null) {
            String string3 = EfxExpressionTranslatorV2.getNodeIdFromChildSimpleNodeReferenceContext(contextIteratorExpressionContext.nodeContext());
            this.efxContext.declareContextVariable(variable.name, new Context.NodeContext(string3, this.symbols.getAbsolutePathOfNode(string3), this.symbols.getRelativePathOfNode(string3, this.efxContext.absolutePath())));
        }
    }

    @Override
    public void exitIteratorList(EfxParser.IteratorListContext iteratorListContext) {
        ArrayList<IteratorExpression> arrayList = new ArrayList<IteratorExpression>();
        for (int i = 0; i < iteratorListContext.iteratorExpression().size(); ++i) {
            arrayList.add(0, this.stack.pop(IteratorExpression.class));
        }
        this.stack.push(this.script.composeIteratorList(arrayList));
    }

    @Override
    public void exitParenthesizedStringsFromIteration(EfxParser.ParenthesizedStringsFromIterationContext parenthesizedStringsFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(StringSequenceExpression.class), StringSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedNumbersFromIteration(EfxParser.ParenthesizedNumbersFromIterationContext parenthesizedNumbersFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(NumericSequenceExpression.class), NumericSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedBooleansFromIteration(EfxParser.ParenthesizedBooleansFromIterationContext parenthesizedBooleansFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(BooleanSequenceExpression.class), BooleanSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedDatesFromIteration(EfxParser.ParenthesizedDatesFromIterationContext parenthesizedDatesFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(DateSequenceExpression.class), DateSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedTimesFromIteration(EfxParser.ParenthesizedTimesFromIterationContext parenthesizedTimesFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(TimeSequenceExpression.class), TimeSequenceExpression.class));
    }

    @Override
    public void exitParenthesizedDurationsFromIteration(EfxParser.ParenthesizedDurationsFromIterationContext parenthesizedDurationsFromIterationContext) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(DurationSequenceExpression.class), DurationSequenceExpression.class));
    }

    @Override
    public void enterStringSequenceFromIteration(EfxParser.StringSequenceFromIterationContext stringSequenceFromIterationContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitStringSequenceFromIteration(EfxParser.StringSequenceFromIterationContext stringSequenceFromIterationContext) {
        this.exitIterationExpression(StringExpression.class, StringSequenceExpression.class);
        this.stack.popStackFrame();
    }

    @Override
    public void enterNumericSequenceFromIteration(EfxParser.NumericSequenceFromIterationContext numericSequenceFromIterationContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitNumericSequenceFromIteration(EfxParser.NumericSequenceFromIterationContext numericSequenceFromIterationContext) {
        this.exitIterationExpression(NumericExpression.class, NumericSequenceExpression.class);
        this.stack.popStackFrame();
    }

    @Override
    public void enterBooleanSequenceFromIteration(EfxParser.BooleanSequenceFromIterationContext booleanSequenceFromIterationContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitBooleanSequenceFromIteration(EfxParser.BooleanSequenceFromIterationContext booleanSequenceFromIterationContext) {
        this.exitIterationExpression(BooleanExpression.class, BooleanSequenceExpression.class);
        this.stack.popStackFrame();
    }

    @Override
    public void enterDateSequenceFromIteration(EfxParser.DateSequenceFromIterationContext dateSequenceFromIterationContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitDateSequenceFromIteration(EfxParser.DateSequenceFromIterationContext dateSequenceFromIterationContext) {
        this.exitIterationExpression(DateExpression.class, DateSequenceExpression.class);
        this.stack.popStackFrame();
    }

    @Override
    public void enterTimeSequenceFromIteration(EfxParser.TimeSequenceFromIterationContext timeSequenceFromIterationContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitTimeSequenceFromIteration(EfxParser.TimeSequenceFromIterationContext timeSequenceFromIterationContext) {
        this.exitIterationExpression(TimeExpression.class, TimeSequenceExpression.class);
        this.stack.popStackFrame();
    }

    @Override
    public void enterDurationSequenceFromIteration(EfxParser.DurationSequenceFromIterationContext durationSequenceFromIterationContext) {
        this.stack.pushStackFrame();
    }

    @Override
    public void exitDurationSequenceFromIteration(EfxParser.DurationSequenceFromIterationContext durationSequenceFromIterationContext) {
        this.exitIterationExpression(DurationExpression.class, DurationSequenceExpression.class);
        this.stack.popStackFrame();
    }

    public <T1 extends ScalarExpression, T2 extends SequenceExpression> void exitIteratorExpression(String string, Class<T1> clazz, Class<T2> clazz2) {
        T1 T1 = this.script.composeVariableDeclaration(string, clazz);
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz2);
        ScalarExpression scalarExpression = (ScalarExpression)this.script.composeVariableReference(string, clazz);
        Variable variable = new Variable(string, (Expression)T1, sequenceExpression, scalarExpression);
        this.stack.declareIdentifier(variable);
        this.stack.push(this.script.composeIteratorExpression(variable.declarationExpression, sequenceExpression));
    }

    public <T extends ScalarExpression> void exitIterationExpression(Class<T> clazz, Class<? extends SequenceExpression> clazz2) {
        ScalarExpression scalarExpression = (ScalarExpression)this.stack.pop(clazz);
        IteratorListExpression iteratorListExpression = this.stack.pop(IteratorListExpression.class);
        this.stack.push(this.script.composeForExpression(iteratorListExpression, scalarExpression, clazz2));
    }

    @Override
    public void exitNumericLiteral(EfxParser.NumericLiteralContext numericLiteralContext) {
        this.stack.push(this.script.getNumericLiteralEquivalent(numericLiteralContext.getText()));
    }

    @Override
    public void exitStringLiteral(EfxParser.StringLiteralContext stringLiteralContext) {
        this.stack.push(this.script.getStringLiteralEquivalent(stringLiteralContext.getText()));
    }

    @Override
    public void exitTrueBooleanLiteral(EfxParser.TrueBooleanLiteralContext trueBooleanLiteralContext) {
        this.stack.push(this.script.getBooleanEquivalent(true));
    }

    @Override
    public void exitFalseBooleanLiteral(EfxParser.FalseBooleanLiteralContext falseBooleanLiteralContext) {
        this.stack.push(this.script.getBooleanEquivalent(false));
    }

    @Override
    public void exitDateLiteral(EfxParser.DateLiteralContext dateLiteralContext) {
        this.stack.push(this.script.getDateLiteralEquivalent(dateLiteralContext.DATE().getText()));
    }

    @Override
    public void exitTimeLiteral(EfxParser.TimeLiteralContext timeLiteralContext) {
        this.stack.push(this.script.getTimeLiteralEquivalent(timeLiteralContext.TIME().getText()));
    }

    @Override
    public void exitDurationLiteral(EfxParser.DurationLiteralContext durationLiteralContext) {
        this.stack.push(this.script.getDurationLiteralEquivalent(durationLiteralContext.getText()));
    }

    @Override
    public void exitSimpleNodeReference(EfxParser.SimpleNodeReferenceContext simpleNodeReferenceContext) {
        this.stack.push(this.symbols.getRelativePathOfNode(simpleNodeReferenceContext.NodeId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void exitSimpleFieldReference(EfxParser.SimpleFieldReferenceContext simpleFieldReferenceContext) {
        this.stack.push(this.symbols.getRelativePathOfField(simpleFieldReferenceContext.FieldId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void enterAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext absoluteFieldReferenceContext) {
        if (absoluteFieldReferenceContext.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext absoluteFieldReferenceContext) {
        if (absoluteFieldReferenceContext.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void enterAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext absoluteNodeReferenceContext) {
        if (absoluteNodeReferenceContext.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext absoluteNodeReferenceContext) {
        if (absoluteNodeReferenceContext.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void exitNodeReferenceWithPredicate(EfxParser.NodeReferenceWithPredicateContext nodeReferenceWithPredicateContext) {
        if (nodeReferenceWithPredicateContext.predicate() != null) {
            BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
            PathExpression pathExpression = this.stack.pop(NodePathExpression.class);
            this.stack.push(this.script.composeNodeReferenceWithPredicate(pathExpression, booleanExpression));
        }
    }

    @Override
    public void exitFieldReferenceWithPredicate(EfxParser.FieldReferenceWithPredicateContext fieldReferenceWithPredicateContext) {
        if (fieldReferenceWithPredicateContext.predicate() != null) {
            BooleanExpression booleanExpression = this.stack.pop(BooleanExpression.class);
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.composeFieldReferenceWithPredicate(pathExpression, booleanExpression));
        }
    }

    @Override
    public void enterPredicate(EfxParser.PredicateContext predicateContext) {
        String string = EfxExpressionTranslatorV2.getNodeIdFromChildSimpleNodeReferenceContext(predicateContext.getParent());
        if (string != null) {
            this.efxContext.pushNodeContext(string);
        } else {
            String string2 = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(predicateContext.getParent());
            this.efxContext.pushFieldContext(string2);
        }
    }

    @Override
    public void exitPredicate(EfxParser.PredicateContext predicateContext) {
        this.efxContext.pop();
    }

    @Override
    public void exitFieldReferenceWithAxis(EfxParser.FieldReferenceWithAxisContext fieldReferenceWithAxisContext) {
        if (fieldReferenceWithAxisContext.axis() != null) {
            this.stack.push(this.script.composeFieldReferenceWithAxis(this.stack.pop(PathExpression.class), fieldReferenceWithAxisContext.axis().Axis().getText()));
        }
    }

    @Override
    public void exitNoticeReference(EfxParser.NoticeReferenceContext noticeReferenceContext) {
        this.stack.push(this.script.composeExternalReference(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void enterFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext fieldReferenceInOtherNoticeContext) {
        if (fieldReferenceInOtherNoticeContext.noticeReference() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext fieldReferenceInOtherNoticeContext) {
        if (fieldReferenceInOtherNoticeContext.noticeReference() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            PathExpression pathExpression2 = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.composeFieldInExternalReference(pathExpression2, pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitScalarFromFieldReference(EfxParser.ScalarFromFieldReferenceContext scalarFromFieldReferenceContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(scalarFromFieldReferenceContext);
        if (this.symbols.isAttributeField(string)) {
            this.stack.push(this.script.composeFieldAttributeReference(this.symbols.getRelativePath(this.symbols.getAbsolutePathOfFieldWithoutTheAttribute(string), ((Context)this.efxContext.peek()).absolutePath()), this.symbols.getAttributeNameFromAttributeField(string), PathExpression.fromFieldType.get((Object)FieldTypes.fromString(this.symbols.getTypeOfField(string)))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(pathExpression));
        }
    }

    @Override
    public void exitSequenceFromFieldReference(EfxParser.SequenceFromFieldReferenceContext sequenceFromFieldReferenceContext) {
        PathExpression pathExpression = this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(sequenceFromFieldReferenceContext);
        if (this.symbols.isAttributeField(string)) {
            this.stack.push(this.script.composeFieldAttributeReference(this.symbols.getRelativePath(this.symbols.getAbsolutePathOfFieldWithoutTheAttribute(string), ((Context)this.efxContext.peek()).absolutePath()), this.symbols.getAttributeNameFromAttributeField(string), PathExpression.fromFieldType.get((Object)FieldTypes.fromString(this.symbols.getTypeOfField(string)))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(pathExpression));
        }
    }

    @Override
    public void exitScalarFromAttributeReference(EfxParser.ScalarFromAttributeReferenceContext scalarFromAttributeReferenceContext) {
        this.stack.push(this.script.composeFieldAttributeReference(this.stack.pop(PathExpression.class), this.getAttributeName(scalarFromAttributeReferenceContext), StringPathExpression.class));
    }

    @Override
    public void exitSequenceFromAttributeReference(EfxParser.SequenceFromAttributeReferenceContext sequenceFromAttributeReferenceContext) {
        this.stack.push(this.script.composeFieldAttributeReference(this.stack.pop(PathExpression.class), this.getAttributeName(sequenceFromAttributeReferenceContext), StringPathExpression.class));
    }

    @Override
    public void exitContextFieldSpecifier(EfxParser.ContextFieldSpecifierContext contextFieldSpecifierContext) {
        this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(contextFieldSpecifierContext.field);
        this.efxContext.push(new Context.FieldContext(string, this.symbols.getAbsolutePathOfField(string), this.symbols.getRelativePathOfField(string, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithFieldContextOverride(EfxParser.FieldReferenceWithFieldContextOverrideContext fieldReferenceWithFieldContextOverrideContext) {
        if (fieldReferenceWithFieldContextOverrideContext.contextFieldSpecifier() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitContextNodeSpecifier(EfxParser.ContextNodeSpecifierContext contextNodeSpecifierContext) {
        this.stack.pop(PathExpression.class);
        String string = EfxExpressionTranslatorV2.getNodeIdFromChildSimpleNodeReferenceContext(contextNodeSpecifierContext.node);
        this.efxContext.push(new Context.NodeContext(string, this.symbols.getAbsolutePathOfNode(string), this.symbols.getRelativePathOfNode(string, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithNodeContextOverride(EfxParser.FieldReferenceWithNodeContextOverrideContext fieldReferenceWithNodeContextOverrideContext) {
        if (fieldReferenceWithNodeContextOverrideContext.contextNodeSpecifier() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitContextVariableSpecifier(EfxParser.ContextVariableSpecifierContext contextVariableSpecifierContext) {
        Context context = this.efxContext.getContextFromVariable(EfxExpressionTranslatorV2.getVariableName(contextVariableSpecifierContext.variableReference()));
        if (context.isFieldContext().booleanValue()) {
            this.efxContext.push(new Context.FieldContext(context.symbol(), this.symbols.getAbsolutePathOfField(context.symbol()), this.symbols.getRelativePathOfField(context.symbol(), this.efxContext.absolutePath())));
        } else if (context.isNodeContext().booleanValue()) {
            this.efxContext.push(new Context.NodeContext(context.symbol(), this.symbols.getAbsolutePathOfNode(context.symbol()), this.symbols.getRelativePathOfNode(context.symbol(), this.efxContext.absolutePath())));
        } else {
            throw new IllegalStateException("Variable context is neither a field nor a node context.");
        }
    }

    @Override
    public void exitFieldReferenceWithVariableContextOverride(EfxParser.FieldReferenceWithVariableContextOverrideContext fieldReferenceWithVariableContextOverrideContext) {
        if (fieldReferenceWithVariableContextOverrideContext.contextVariableSpecifier() != null) {
            PathExpression pathExpression = this.stack.pop(PathExpression.class);
            PathExpression pathExpression2 = this.stack.pop(PathExpression.class);
            this.stack.push(this.script.joinPaths(pathExpression2, pathExpression));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitCodelistReference(EfxParser.CodelistReferenceContext codelistReferenceContext) {
        this.stack.push(this.script.composeList(this.symbols.expandCodelist(this.getCodelistName(codelistReferenceContext)).stream().map(string -> this.script.getStringLiteralFromUnquotedString((String)string)).collect(Collectors.toList()), StringSequenceExpression.class));
    }

    @Override
    public void exitVariableReference(EfxParser.VariableReferenceContext variableReferenceContext) {
        String string = EfxExpressionTranslatorV2.getVariableName(variableReferenceContext);
        this.stack.pushIdentifierReference(string);
    }

    @Override
    public void exitStringAtSequenceIndex(EfxParser.StringAtSequenceIndexContext stringAtSequenceIndexContext) {
        this.exitSequenceAtIndex(StringExpression.class, StringSequenceExpression.class);
    }

    @Override
    public void exitNumericAtSequenceIndex(EfxParser.NumericAtSequenceIndexContext numericAtSequenceIndexContext) {
        this.exitSequenceAtIndex(NumericExpression.class, NumericSequenceExpression.class);
    }

    @Override
    public void exitBooleanAtSequenceIndex(EfxParser.BooleanAtSequenceIndexContext booleanAtSequenceIndexContext) {
        this.exitSequenceAtIndex(BooleanExpression.class, BooleanSequenceExpression.class);
    }

    @Override
    public void exitDateAtSequenceIndex(EfxParser.DateAtSequenceIndexContext dateAtSequenceIndexContext) {
        this.exitSequenceAtIndex(DateExpression.class, DateSequenceExpression.class);
    }

    @Override
    public void exitTimeAtSequenceIndex(EfxParser.TimeAtSequenceIndexContext timeAtSequenceIndexContext) {
        this.exitSequenceAtIndex(TimeExpression.class, TimeSequenceExpression.class);
    }

    @Override
    public void exitDurationAtSequenceIndex(EfxParser.DurationAtSequenceIndexContext durationAtSequenceIndexContext) {
        this.exitSequenceAtIndex(DurationExpression.class, DurationSequenceExpression.class);
    }

    private <T extends SequenceExpression> void exitSequenceAtIndex(Class<? extends ScalarExpression> clazz, Class<T> clazz2) {
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz2);
        this.stack.push(this.script.composeIndexer(sequenceExpression, numericExpression, clazz));
    }

    @Override
    public void exitStringParameterDeclaration(EfxParser.StringParameterDeclarationContext stringParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV2.getVariableName(stringParameterDeclarationContext), StringExpression.class);
    }

    @Override
    public void exitNumericParameterDeclaration(EfxParser.NumericParameterDeclarationContext numericParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV2.getVariableName(numericParameterDeclarationContext), NumericExpression.class);
    }

    @Override
    public void exitBooleanParameterDeclaration(EfxParser.BooleanParameterDeclarationContext booleanParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV2.getVariableName(booleanParameterDeclarationContext), BooleanExpression.class);
    }

    @Override
    public void exitDateParameterDeclaration(EfxParser.DateParameterDeclarationContext dateParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV2.getVariableName(dateParameterDeclarationContext), DateExpression.class);
    }

    @Override
    public void exitTimeParameterDeclaration(EfxParser.TimeParameterDeclarationContext timeParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV2.getVariableName(timeParameterDeclarationContext), TimeExpression.class);
    }

    @Override
    public void exitDurationParameterDeclaration(EfxParser.DurationParameterDeclarationContext durationParameterDeclarationContext) {
        this.exitParameterDeclaration(EfxExpressionTranslatorV2.getVariableName(durationParameterDeclarationContext), DurationExpression.class);
    }

    private void exitParameterDeclaration(String string, Class<? extends TypedExpression> clazz) {
        if (this.expressionParameters.isEmpty()) {
            throw new ParseCancellationException("No parameter passed for " + string);
        }
        Parameter parameter = new Parameter(string, this.script.composeParameterDeclaration(string, clazz), this.script.composeVariableReference(string, clazz), this.translateParameter(this.expressionParameters.pop(), clazz));
        this.stack.declareIdentifier(parameter);
    }

    @Override
    public void exitNotFunction(EfxParser.NotFunctionContext notFunctionContext) {
        this.stack.push(this.script.composeLogicalNot(this.stack.pop(BooleanExpression.class)));
    }

    @Override
    public void exitContainsFunction(EfxParser.ContainsFunctionContext containsFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeContainsCondition(stringExpression2, stringExpression));
    }

    @Override
    public void exitStartsWithFunction(EfxParser.StartsWithFunctionContext startsWithFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeStartsWithCondition(stringExpression2, stringExpression));
    }

    @Override
    public void exitEndsWithFunction(EfxParser.EndsWithFunctionContext endsWithFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringExpression stringExpression2 = this.stack.pop(StringExpression.class);
        this.stack.push(this.script.composeEndsWithCondition(stringExpression2, stringExpression));
    }

    @Override
    public void exitSequenceEqualFunction(EfxParser.SequenceEqualFunctionContext sequenceEqualFunctionContext) {
        SequenceExpression sequenceExpression = this.stack.pop(SequenceExpression.class);
        SequenceExpression sequenceExpression2 = this.stack.pop(SequenceExpression.class);
        this.stack.push(this.script.composeSequenceEqualFunction(sequenceExpression2, sequenceExpression));
    }

    @Override
    public void exitCountFunction(EfxParser.CountFunctionContext countFunctionContext) {
        SequenceExpression sequenceExpression = this.stack.pop(SequenceExpression.class);
        this.stack.push(this.script.composeCountOperation(sequenceExpression));
    }

    @Override
    public void exitNumberFunction(EfxParser.NumberFunctionContext numberFunctionContext) {
        this.stack.push(this.script.composeToNumberConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitSumFunction(EfxParser.SumFunctionContext sumFunctionContext) {
        this.stack.push(this.script.composeSumOperation(this.stack.pop(NumericSequenceExpression.class)));
    }

    @Override
    public void exitStringLengthFunction(EfxParser.StringLengthFunctionContext stringLengthFunctionContext) {
        this.stack.push(this.script.composeStringLengthCalculation(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitSubstringFunction(EfxParser.SubstringFunctionContext substringFunctionContext) {
        NumericExpression numericExpression = substringFunctionContext.length != null ? this.stack.pop(NumericExpression.class) : null;
        NumericExpression numericExpression2 = this.stack.pop(NumericExpression.class);
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        if (numericExpression != null) {
            this.stack.push(this.script.composeSubstringExtraction(stringExpression, numericExpression2, numericExpression));
        } else {
            this.stack.push(this.script.composeSubstringExtraction(stringExpression, numericExpression2));
        }
    }

    @Override
    public void exitToStringFunction(EfxParser.ToStringFunctionContext toStringFunctionContext) {
        this.stack.push(this.script.composeToStringConversion(this.stack.pop(NumericExpression.class)));
    }

    @Override
    public void exitConcatFunction(EfxParser.ConcatFunctionContext concatFunctionContext) {
        if (this.stack.empty() || concatFunctionContext.stringExpression().size() == 0) {
            this.stack.push(this.script.composeStringConcatenation(Collections.emptyList()));
            return;
        }
        ArrayList<StringExpression> arrayList = new ArrayList<StringExpression>();
        for (int i = 0; i < concatFunctionContext.stringExpression().size(); ++i) {
            arrayList.add(0, this.stack.pop(StringExpression.class));
        }
        this.stack.push(this.script.composeStringConcatenation(arrayList));
    }

    @Override
    public void exitFormatNumberFunction(EfxParser.FormatNumberFunctionContext formatNumberFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        NumericExpression numericExpression = this.stack.pop(NumericExpression.class);
        this.stack.push(this.script.composeNumberFormatting(numericExpression, stringExpression));
    }

    @Override
    public void exitUpperCaseFunction(EfxParser.UpperCaseFunctionContext upperCaseFunctionContext) {
        this.stack.push(this.script.composeToUpperCaseConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitLowerCaseFunction(EfxParser.LowerCaseFunctionContext lowerCaseFunctionContext) {
        this.stack.push(this.script.composeToLowerCaseConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitStringJoinFunction(EfxParser.StringJoinFunctionContext stringJoinFunctionContext) {
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        StringSequenceExpression stringSequenceExpression = this.stack.pop(StringSequenceExpression.class);
        this.stack.push(this.script.composeStringJoin(stringSequenceExpression, stringExpression));
    }

    @Override
    public void exitPreferredLanguageFunction(EfxParser.PreferredLanguageFunctionContext preferredLanguageFunctionContext) {
        this.stack.push(this.script.getPreferredLanguage(this.stack.pop(MultilingualStringPathExpression.class)));
    }

    @Override
    public void exitPreferredLanguageTextFunction(EfxParser.PreferredLanguageTextFunctionContext preferredLanguageTextFunctionContext) {
        this.stack.push(this.script.getTextInPreferredLanguage(this.stack.pop(MultilingualStringPathExpression.class)));
    }

    @Override
    public void exitDateFromStringFunction(EfxParser.DateFromStringFunctionContext dateFromStringFunctionContext) {
        this.stack.push(this.script.composeToDateConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitDatePlusMeasureFunction(EfxParser.DatePlusMeasureFunctionContext datePlusMeasureFunctionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeAddition(dateExpression, durationExpression));
    }

    @Override
    public void exitDateMinusMeasureFunction(EfxParser.DateMinusMeasureFunctionContext dateMinusMeasureFunctionContext) {
        DurationExpression durationExpression = this.stack.pop(DurationExpression.class);
        DateExpression dateExpression = this.stack.pop(DateExpression.class);
        this.stack.push(this.script.composeSubtraction(dateExpression, durationExpression));
    }

    @Override
    public void exitTimeFromStringFunction(EfxParser.TimeFromStringFunctionContext timeFromStringFunctionContext) {
        this.stack.push(this.script.composeToTimeConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitDayTimeDurationFromStringFunction(EfxParser.DayTimeDurationFromStringFunctionContext dayTimeDurationFromStringFunctionContext) {
        this.stack.push(this.script.composeToDayTimeDurationConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitYearMonthDurationFromStringFunction(EfxParser.YearMonthDurationFromStringFunctionContext yearMonthDurationFromStringFunctionContext) {
        this.stack.push(this.script.composeToYearMonthDurationConversion(this.stack.pop(StringExpression.class)));
    }

    @Override
    public void exitDistinctValuesFunction(EfxParser.DistinctValuesFunctionContext distinctValuesFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitDistinctValuesFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitDistinctValuesFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeDistinctValuesFunction(sequenceExpression, clazz));
    }

    @Override
    public void exitUnionFunction(EfxParser.UnionFunctionContext unionFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitUnionFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitUnionFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        SequenceExpression sequenceExpression2 = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeUnionFunction(sequenceExpression2, sequenceExpression, clazz));
    }

    @Override
    public void exitIntersectFunction(EfxParser.IntersectFunctionContext intersectFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitIntersectFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitIntersectFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        SequenceExpression sequenceExpression2 = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeIntersectFunction(sequenceExpression2, sequenceExpression, clazz));
    }

    @Override
    public void exitExceptFunction(EfxParser.ExceptFunctionContext exceptFunctionContext) {
        ParsedEntity parsedEntity = this.stack.peek();
        assert (parsedEntity instanceof TypedExpression) : "Expected a TypedExpression at the top of the stack.";
        Class<? extends EfxDataType> clazz = ((TypedExpression)parsedEntity).getDataType();
        if (EfxDataType.String.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(StringSequenceExpression.class);
        } else if (EfxDataType.Number.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(NumericSequenceExpression.class);
        } else if (EfxDataType.Boolean.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(BooleanSequenceExpression.class);
        } else if (EfxDataType.Date.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(DateSequenceExpression.class);
        } else if (EfxDataType.Time.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(TimeSequenceExpression.class);
        } else if (EfxDataType.Duration.class.isAssignableFrom(clazz)) {
            this.exitExceptFunction(DurationSequenceExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + clazz.getSimpleName());
        }
    }

    private <T extends SequenceExpression> void exitExceptFunction(Class<T> clazz) {
        SequenceExpression sequenceExpression = (SequenceExpression)this.stack.pop(clazz);
        SequenceExpression sequenceExpression2 = (SequenceExpression)this.stack.pop(clazz);
        this.stack.push(this.script.composeExceptFunction(sequenceExpression2, sequenceExpression, clazz));
    }

    protected static String getLexerSymbol(int n) {
        return EfxLexer.VOCABULARY.getLiteralName(n).replaceAll("^'|'$", "");
    }

    protected String getCodelistName(String string) {
        return StringUtils.substringAfter((String)string, (String)CODELIST_PREFIX);
    }

    private String getCodelistName(EfxParser.CodelistReferenceContext codelistReferenceContext) {
        return this.getCodelistName(codelistReferenceContext.CodelistId().getText());
    }

    protected String getAttributeName(String string) {
        return StringUtils.substringAfter((String)string, (String)ATTRIBUTE_PREFIX);
    }

    private String getAttributeName(EfxParser.SequenceFromAttributeReferenceContext sequenceFromAttributeReferenceContext) {
        return this.getAttributeName(sequenceFromAttributeReferenceContext.attributeReference().Attribute().getText());
    }

    private String getAttributeName(EfxParser.ScalarFromAttributeReferenceContext scalarFromAttributeReferenceContext) {
        return this.getAttributeName(scalarFromAttributeReferenceContext.attributeReference().Attribute().getText());
    }

    protected static String getVariableName(String string) {
        return StringUtils.substringAfter((String)string, (String)VARIABLE_PREFIX);
    }

    private static String getVariableName(EfxParser.VariableReferenceContext variableReferenceContext) {
        return EfxExpressionTranslatorV2.getVariableName(variableReferenceContext.Variable().getText());
    }

    protected static String getVariableName(EfxParser.ContextVariableDeclarationContext contextVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(contextVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.StringVariableDeclarationContext stringVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(stringVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.NumericVariableDeclarationContext numericVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(numericVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.BooleanVariableDeclarationContext booleanVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(booleanVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DateVariableDeclarationContext dateVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(dateVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.TimeVariableDeclarationContext timeVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(timeVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DurationVariableDeclarationContext durationVariableDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(durationVariableDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.StringParameterDeclarationContext stringParameterDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(stringParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.NumericParameterDeclarationContext numericParameterDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(numericParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.BooleanParameterDeclarationContext booleanParameterDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(booleanParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DateParameterDeclarationContext dateParameterDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(dateParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.TimeParameterDeclarationContext timeParameterDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(timeParameterDeclarationContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DurationParameterDeclarationContext durationParameterDeclarationContext) {
        return EfxExpressionTranslatorV2.getVariableName(durationParameterDeclarationContext.Variable().getText());
    }

    @Override
    public void exitLateBoundSequence(EfxParser.LateBoundSequenceContext lateBoundSequenceContext) {
        assert (false) : "This should have been handled by the preprocessor: " + lateBoundSequenceContext.getText() + ". Check any changes that you might have made in the EFX grammar that may have broken this assumption.";
    }

    @Override
    public void exitLateBoundScalar(EfxParser.LateBoundScalarContext lateBoundScalarContext) {
        assert (false) : "This should have been handled by the preprocessor: " + lateBoundScalarContext.getText() + ". Check any changes that you might have made in the EFX grammar that may have broken this assumption.";
    }

    class ExpressionPreprocessor
    extends EfxBaseListener {
        final SymbolResolver symbols;
        final BaseErrorListener errorListener;
        final EfxLexer lexer;
        final CommonTokenStream tokens;
        final EfxParser parser;
        final TokenStreamRewriter rewriter;
        final CallStack stack = new CallStack();

        ExpressionPreprocessor(String string) {
            this((CharStream)CharStreams.fromString((String)string));
        }

        ExpressionPreprocessor(CharStream charStream) {
            this.symbols = EfxExpressionTranslatorV2.this.symbols;
            this.errorListener = EfxExpressionTranslatorV2.this.errorListener;
            this.lexer = new EfxLexer(charStream);
            this.tokens = new CommonTokenStream((TokenSource)this.lexer);
            this.parser = new EfxParser((TokenStream)this.tokens);
            this.rewriter = new TokenStreamRewriter((TokenStream)this.tokens);
            if (this.errorListener != null) {
                this.lexer.removeErrorListeners();
                this.lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
                this.parser.removeErrorListeners();
                this.parser.addErrorListener((ANTLRErrorListener)this.errorListener);
            }
        }

        String processExpression() {
            EfxParser.SingleExpressionContext singleExpressionContext = this.parser.singleExpression();
            ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
            parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)singleExpressionContext);
            return this.rewriter.getText();
        }

        @Override
        public void exitScalarFromFieldReference(EfxParser.ScalarFromFieldReferenceContext scalarFromFieldReferenceContext) {
            if (!this.hasParentContextOfType(scalarFromFieldReferenceContext, EfxParser.LateBoundScalarContext.class)) {
                return;
            }
            String string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(scalarFromFieldReferenceContext);
            String string2 = eFormsToEfxTypeMap.get(this.symbols.getTypeOfField(string));
            this.rewriter.insertBefore(scalarFromFieldReferenceContext.getStart(), (Object)("(" + string2 + ")"));
        }

        @Override
        public void exitScalarFromAttributeReference(EfxParser.ScalarFromAttributeReferenceContext scalarFromAttributeReferenceContext) {
            if (!this.hasParentContextOfType(scalarFromAttributeReferenceContext, EfxParser.LateBoundScalarContext.class)) {
                return;
            }
            this.rewriter.insertBefore(scalarFromAttributeReferenceContext.getStart(), (Object)("(" + textTypeName + ")"));
        }

        @Override
        public void exitSequenceFromFieldReference(EfxParser.SequenceFromFieldReferenceContext sequenceFromFieldReferenceContext) {
            if (!this.hasParentContextOfType(sequenceFromFieldReferenceContext, EfxParser.LateBoundSequenceContext.class)) {
                return;
            }
            String string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(sequenceFromFieldReferenceContext);
            String string2 = eFormsToEfxTypeMap.get(this.symbols.getTypeOfField(string));
            if (string2 != null) {
                this.rewriter.insertBefore(sequenceFromFieldReferenceContext.getStart(), (Object)("(" + string2 + ")"));
            }
        }

        @Override
        public void exitSequenceFromAttributeReference(EfxParser.SequenceFromAttributeReferenceContext sequenceFromAttributeReferenceContext) {
            if (!this.hasParentContextOfType(sequenceFromAttributeReferenceContext, EfxParser.LateBoundSequenceContext.class)) {
                return;
            }
            this.rewriter.insertBefore(sequenceFromAttributeReferenceContext.getStart(), (Object)("(" + textTypeName + ")"));
        }

        @Override
        public void exitVariableReference(EfxParser.VariableReferenceContext variableReferenceContext) {
            if (!this.hasParentContextOfType(variableReferenceContext, EfxParser.LateBoundScalarContext.class)) {
                return;
            }
            String string = EfxExpressionTranslatorV2.getVariableName(variableReferenceContext);
            String string2 = javaToEfxTypeMap.get(this.stack.getTypeOfIdentifier(string));
            if (string2 != null) {
                this.rewriter.insertBefore(variableReferenceContext.Variable().getSymbol(), (Object)("(" + string2 + ")"));
            }
        }

        boolean hasParentContextOfType(ParserRuleContext parserRuleContext, Class<? extends ParserRuleContext> clazz) {
            for (ParserRuleContext parserRuleContext2 = parserRuleContext.getParent(); parserRuleContext2 != null; parserRuleContext2 = parserRuleContext2.getParent()) {
                if (!clazz.isInstance(parserRuleContext2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void exitStringVariableDeclaration(EfxParser.StringVariableDeclarationContext stringVariableDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(stringVariableDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, StringExpression.empty(), StringExpression.empty(), StringExpression.empty()));
        }

        @Override
        public void exitBooleanVariableDeclaration(EfxParser.BooleanVariableDeclarationContext booleanVariableDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(booleanVariableDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, BooleanExpression.empty(), BooleanExpression.empty(), BooleanExpression.empty()));
        }

        @Override
        public void exitNumericVariableDeclaration(EfxParser.NumericVariableDeclarationContext numericVariableDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(numericVariableDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, NumericExpression.empty(), NumericExpression.empty(), NumericExpression.empty()));
        }

        @Override
        public void exitDateVariableDeclaration(EfxParser.DateVariableDeclarationContext dateVariableDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(dateVariableDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, DateExpression.empty(), DateExpression.empty(), DateExpression.empty()));
        }

        @Override
        public void exitTimeVariableDeclaration(EfxParser.TimeVariableDeclarationContext timeVariableDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(timeVariableDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, TimeExpression.empty(), TimeExpression.empty(), TimeExpression.empty()));
        }

        @Override
        public void exitDurationVariableDeclaration(EfxParser.DurationVariableDeclarationContext durationVariableDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(durationVariableDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, DurationExpression.empty(), DurationExpression.empty(), DurationExpression.empty()));
        }

        @Override
        public void exitContextIteratorExpression(EfxParser.ContextIteratorExpressionContext contextIteratorExpressionContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(contextIteratorExpressionContext.contextVariableDeclaration());
            this.stack.declareIdentifier(new Variable(string, DurationExpression.empty(), DurationExpression.empty(), DurationExpression.empty()));
        }

        @Override
        public void exitStringParameterDeclaration(EfxParser.StringParameterDeclarationContext stringParameterDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(stringParameterDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, StringExpression.empty(), StringExpression.empty(), StringExpression.empty()));
        }

        @Override
        public void exitNumericParameterDeclaration(EfxParser.NumericParameterDeclarationContext numericParameterDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(numericParameterDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, NumericExpression.empty(), NumericExpression.empty(), NumericExpression.empty()));
        }

        @Override
        public void exitBooleanParameterDeclaration(EfxParser.BooleanParameterDeclarationContext booleanParameterDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(booleanParameterDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, BooleanExpression.empty(), BooleanExpression.empty(), BooleanExpression.empty()));
        }

        @Override
        public void exitDateParameterDeclaration(EfxParser.DateParameterDeclarationContext dateParameterDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(dateParameterDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, DateExpression.empty(), DateExpression.empty(), DateExpression.empty()));
        }

        @Override
        public void exitTimeParameterDeclaration(EfxParser.TimeParameterDeclarationContext timeParameterDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(timeParameterDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, TimeExpression.empty(), TimeExpression.empty(), TimeExpression.empty()));
        }

        @Override
        public void exitDurationParameterDeclaration(EfxParser.DurationParameterDeclarationContext durationParameterDeclarationContext) {
            String string = EfxExpressionTranslatorV2.getVariableName(durationParameterDeclarationContext);
            this.stack.declareIdentifier(new Variable(string, DurationExpression.empty(), DurationExpression.empty(), DurationExpression.empty()));
        }

        @Override
        public void enterQuantifiedExpression(EfxParser.QuantifiedExpressionContext quantifiedExpressionContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitQuantifiedExpression(EfxParser.QuantifiedExpressionContext quantifiedExpressionContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterStringSequenceFromIteration(EfxParser.StringSequenceFromIterationContext stringSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitStringSequenceFromIteration(EfxParser.StringSequenceFromIterationContext stringSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterNumericSequenceFromIteration(EfxParser.NumericSequenceFromIterationContext numericSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitNumericSequenceFromIteration(EfxParser.NumericSequenceFromIterationContext numericSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterBooleanSequenceFromIteration(EfxParser.BooleanSequenceFromIterationContext booleanSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitBooleanSequenceFromIteration(EfxParser.BooleanSequenceFromIterationContext booleanSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterDateSequenceFromIteration(EfxParser.DateSequenceFromIterationContext dateSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitDateSequenceFromIteration(EfxParser.DateSequenceFromIterationContext dateSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterTimeSequenceFromIteration(EfxParser.TimeSequenceFromIterationContext timeSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitTimeSequenceFromIteration(EfxParser.TimeSequenceFromIterationContext timeSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterDurationSequenceFromIteration(EfxParser.DurationSequenceFromIterationContext durationSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitDurationSequenceFromIteration(EfxParser.DurationSequenceFromIterationContext durationSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }

        @Override
        public void enterLateBoundSequenceFromIteration(EfxParser.LateBoundSequenceFromIterationContext lateBoundSequenceFromIterationContext) {
            this.stack.pushStackFrame();
        }

        @Override
        public void exitLateBoundSequenceFromIteration(EfxParser.LateBoundSequenceFromIterationContext lateBoundSequenceFromIterationContext) {
            this.stack.popStackFrame();
        }
    }
}

