/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk2;

import eu.europa.ted.eforms.sdk.component.SdkComponent;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.efx.interfaces.EfxTemplateTranslator;
import eu.europa.ted.efx.interfaces.MarkupGenerator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.path.NodePathExpression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.expressions.path.StringPathExpression;
import eu.europa.ted.efx.model.expressions.scalar.BooleanExpression;
import eu.europa.ted.efx.model.expressions.scalar.DateExpression;
import eu.europa.ted.efx.model.expressions.scalar.DurationExpression;
import eu.europa.ted.efx.model.expressions.scalar.NumericExpression;
import eu.europa.ted.efx.model.expressions.scalar.ScalarExpression;
import eu.europa.ted.efx.model.expressions.scalar.StringExpression;
import eu.europa.ted.efx.model.expressions.scalar.TimeExpression;
import eu.europa.ted.efx.model.expressions.sequence.DateSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.StringSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.TimeSequenceExpression;
import eu.europa.ted.efx.model.templates.ContentBlock;
import eu.europa.ted.efx.model.templates.ContentBlockStack;
import eu.europa.ted.efx.model.templates.Markup;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.model.types.FieldTypes;
import eu.europa.ted.efx.model.variables.Variable;
import eu.europa.ted.efx.model.variables.VariableList;
import eu.europa.ted.efx.sdk2.EfxExpressionTranslatorV2;
import eu.europa.ted.efx.sdk2.EfxLexer;
import eu.europa.ted.efx.sdk2.EfxParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkComponent(versions={"2"}, componentType=SdkComponentType.EFX_TEMPLATE_TRANSLATOR)
public class EfxTemplateTranslatorV2
extends EfxExpressionTranslatorV2
implements EfxTemplateTranslator {
    private static final Logger logger = LoggerFactory.getLogger(EfxTemplateTranslatorV2.class);
    private static final String INCONSISTENT_INDENTATION_SPACES = "Inconsistent indentation. Expected a multiple of %d spaces.";
    private static final String INDENTATION_LEVEL_SKIPPED = "Indentation level skipped.";
    private static final String START_INDENT_AT_ZERO = "Incorrect indentation. Please do not indent the first level in your template.";
    private static final String MIXED_INDENTATION = "Do not mix indentation methods. Stick with either tabs or spaces.";
    private static final String UNEXPECTED_INDENTATION = "Unexpected indentation tracker state.";
    private static final String LABEL_TYPE_NAME = EfxTemplateTranslatorV2.getLexerSymbol(34);
    private static final String LABEL_TYPE_WHEN = EfxTemplateTranslatorV2.getLexerSymbol(35).replace("-true", "");
    private static final String SHORTHAND_CONTEXT_FIELD_LABEL_REFERENCE = EfxTemplateTranslatorV2.getLexerSymbol(14);
    private static final String ASSET_TYPE_INDICATOR = EfxTemplateTranslatorV2.getLexerSymbol(72);
    private static final String ASSET_TYPE_BT = EfxTemplateTranslatorV2.getLexerSymbol(23);
    private static final String ASSET_TYPE_FIELD = EfxTemplateTranslatorV2.getLexerSymbol(24);
    private static final String ASSET_TYPE_NODE = EfxTemplateTranslatorV2.getLexerSymbol(25);
    private static final String ASSET_TYPE_CODE = EfxTemplateTranslatorV2.getLexerSymbol(69);
    private Indent indentWith = Indent.UNDETERMINED;
    private int indentSpaces = -1;
    MarkupGenerator markup;
    final ContentBlock rootBlock = ContentBlock.newRootBlock();
    ContentBlockStack blockStack = new ContentBlockStack();

    private EfxTemplateTranslatorV2() {
    }

    public EfxTemplateTranslatorV2(MarkupGenerator markupGenerator, SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener baseErrorListener) {
        super(symbolResolver, scriptGenerator, baseErrorListener);
        this.markup = markupGenerator;
    }

    @Override
    public String renderTemplate(Path path) throws IOException {
        return this.renderTemplate(CharStreams.fromPath((Path)path));
    }

    @Override
    public String renderTemplate(String string) {
        return this.renderTemplate((CharStream)CharStreams.fromString((String)string));
    }

    @Override
    public String renderTemplate(InputStream inputStream) throws IOException {
        return this.renderTemplate(CharStreams.fromStream((InputStream)inputStream));
    }

    private String renderTemplate(CharStream charStream) {
        logger.debug("Rendering template");
        TemplatePreprocessor templatePreprocessor = new TemplatePreprocessor(charStream);
        String string = templatePreprocessor.processTemplate();
        EfxLexer efxLexer = new EfxLexer((CharStream)CharStreams.fromString((String)string));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)efxLexer);
        EfxParser efxParser = new EfxParser((TokenStream)commonTokenStream);
        if (this.errorListener != null) {
            efxLexer.removeErrorListeners();
            efxLexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            efxParser.removeErrorListeners();
            efxParser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.TemplateFileContext templateFileContext = efxParser.templateFile();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)templateFileContext);
        logger.debug("Finished rendering template");
        return this.getTranslatedMarkup();
    }

    private String getTranslatedMarkup() {
        logger.debug("Getting translated markup.");
        StringBuilder stringBuilder = new StringBuilder(64);
        while (!this.stack.empty()) {
            stringBuilder.insert(0, '\n').insert(0, this.stack.pop(Markup.class).script);
        }
        logger.debug("Finished getting translated markup.");
        return stringBuilder.toString().trim();
    }

    @Override
    public void enterTemplateFile(EfxParser.TemplateFileContext templateFileContext) {
        assert (this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
    }

    @Override
    public void exitTemplateFile(EfxParser.TemplateFileContext templateFileContext) {
        this.blockStack.pop();
        ArrayList<Markup> arrayList = new ArrayList<Markup>();
        ArrayList<Markup> arrayList2 = new ArrayList<Markup>();
        for (ContentBlock contentBlock : this.rootBlock.getChildren()) {
            arrayList.add(contentBlock.renderCallTemplate(this.markup));
            contentBlock.renderTemplate(this.markup, arrayList2);
        }
        Markup markup = this.markup.composeOutputFile(arrayList, arrayList2);
        this.stack.push(markup);
    }

    @Override
    public void exitTextTemplate(EfxParser.TextTemplateContext textTemplateContext) {
        Markup markup = textTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        String string = textTemplateContext.textBlock() != null ? textTemplateContext.textBlock().getText() : "";
        this.stack.push(this.markup.renderFreeText(string).join(markup));
    }

    @Override
    public void exitLabelTemplate(EfxParser.LabelTemplateContext labelTemplateContext) {
        Markup markup = labelTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Markup markup2 = labelTemplateContext.labelBlock() != null ? this.stack.pop(Markup.class) : Markup.empty();
        this.stack.push(markup2.join(markup));
    }

    @Override
    public void exitExpressionTemplate(EfxParser.ExpressionTemplateContext expressionTemplateContext) {
        Markup markup = expressionTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Expression expression = this.stack.pop(Expression.class);
        this.stack.push(this.markup.renderVariableExpression(expression).join(markup));
    }

    @Override
    public void exitSecondaryTemplate(EfxParser.SecondaryTemplateContext secondaryTemplateContext) {
        Markup markup = secondaryTemplateContext.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        this.stack.push(this.markup.renderLineBreak().join(markup));
    }

    @Override
    public void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext standardLabelReferenceContext) {
        if (!this.stack.empty() && StringSequenceExpression.class.isAssignableFrom(this.stack.peek().getClass()) && standardLabelReferenceContext.assetId() != null) {
            StringSequenceExpression stringSequenceExpression = this.stack.pop(StringSequenceExpression.class);
            this.exitStandardLabelReference(standardLabelReferenceContext, stringSequenceExpression);
        } else {
            NumericExpression numericExpression = standardLabelReferenceContext.pluraliser() != null ? this.stack.pop(NumericExpression.class) : NumericExpression.empty();
            StringExpression stringExpression = standardLabelReferenceContext.assetId() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
            this.exitStandardLabelReference(standardLabelReferenceContext, stringExpression, numericExpression);
        }
    }

    private void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext standardLabelReferenceContext, StringExpression stringExpression, NumericExpression numericExpression) {
        StringExpression stringExpression2 = standardLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        StringExpression stringExpression3 = standardLabelReferenceContext.assetType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(stringExpression3, this.script.getStringLiteralFromUnquotedString("|"), stringExpression2, this.script.getStringLiteralFromUnquotedString("|"), stringExpression)), numericExpression));
    }

    private void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext standardLabelReferenceContext, StringSequenceExpression stringSequenceExpression) {
        StringExpression stringExpression = standardLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        StringExpression stringExpression2 = standardLabelReferenceContext.assetType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", StringExpression.class), StringExpression.empty(), this.script.composeVariableReference("item", StringExpression.class));
        this.stack.push(this.markup.renderLabelFromExpression(this.script.composeDistinctValuesFunction(this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, stringSequenceExpression))), this.script.composeStringConcatenation(List.of(stringExpression2, this.script.getStringLiteralFromUnquotedString("|"), stringExpression, this.script.getStringLiteralFromUnquotedString("|"), new StringExpression(variable.referenceExpression.getScript()))), StringSequenceExpression.class), StringSequenceExpression.class)));
    }

    @Override
    public void exitShorthandBtLabelReference(EfxParser.ShorthandBtLabelReferenceContext shorthandBtLabelReferenceContext) {
        NumericExpression numericExpression = shorthandBtLabelReferenceContext.pluraliser() != null ? this.stack.pop(NumericExpression.class) : NumericExpression.empty();
        StringExpression stringExpression = this.script.getStringLiteralFromUnquotedString(shorthandBtLabelReferenceContext.BtId().getText());
        StringExpression stringExpression2 = shorthandBtLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_BT), this.script.getStringLiteralFromUnquotedString("|"), stringExpression2, this.script.getStringLiteralFromUnquotedString("|"), stringExpression)), numericExpression));
    }

    @Override
    public void exitShorthandFieldLabelReference(EfxParser.ShorthandFieldLabelReferenceContext shorthandFieldLabelReferenceContext) {
        StringExpression stringExpression;
        String string = shorthandFieldLabelReferenceContext.FieldId().getText();
        NumericExpression numericExpression = shorthandFieldLabelReferenceContext.pluraliser() != null ? this.stack.pop(NumericExpression.class) : NumericExpression.empty();
        StringExpression stringExpression2 = stringExpression = shorthandFieldLabelReferenceContext.labelType() != null ? this.stack.pop(StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        if (stringExpression.getScript().equals("value")) {
            this.shorthandIndirectLabelReference(string, numericExpression);
        } else {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), stringExpression, this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string))), numericExpression));
        }
    }

    @Override
    public void exitShorthandIndirectLabelReference(EfxParser.ShorthandIndirectLabelReferenceContext shorthandIndirectLabelReferenceContext) {
        NumericExpression numericExpression = shorthandIndirectLabelReferenceContext.pluraliser() != null ? this.stack.pop(NumericExpression.class) : NumericExpression.empty();
        this.shorthandIndirectLabelReference(shorthandIndirectLabelReferenceContext.FieldId().getText(), numericExpression);
    }

    private void shorthandIndirectLabelReference(String string, NumericExpression numericExpression) {
        Context context = (Context)this.efxContext.peek();
        String string2 = this.symbols.getTypeOfField(string);
        PathExpression pathExpression = this.symbols.isAttributeField(string) ? this.script.composeFieldAttributeReference(this.symbols.getRelativePath(this.symbols.getAbsolutePathOfFieldWithoutTheAttribute(string), context.absolutePath()), this.symbols.getAttributeNameFromAttributeField(string), StringPathExpression.class) : this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(string, context.absolutePath()));
        Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", StringExpression.class), StringExpression.empty(), this.script.composeVariableReference("item", StringExpression.class));
        switch (string2) {
            case "indicator": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeDistinctValuesFunction(this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, pathExpression))), this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_INDICATOR), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_WHEN), this.script.getStringLiteralFromUnquotedString("-"), new StringExpression(variable.referenceExpression.getScript()), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string))), StringSequenceExpression.class), StringSequenceExpression.class), numericExpression));
                break;
            }
            case "code": 
            case "internal-code": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeDistinctValuesFunction(this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, pathExpression))), this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_CODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_NAME), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.symbols.getRootCodelistOfField(string)), this.script.getStringLiteralFromUnquotedString("."), new StringExpression(variable.referenceExpression.getScript()))), StringSequenceExpression.class), StringSequenceExpression.class), numericExpression));
                break;
            }
            default: {
                throw new ParseCancellationException(String.format("Unexpected field type '%s'. Expected a field of either type 'code' or 'indicator'.", string2));
            }
        }
    }

    @Override
    public void exitShorthandLabelReferenceFromContext(EfxParser.ShorthandLabelReferenceFromContextContext shorthandLabelReferenceFromContextContext) {
        NumericExpression numericExpression = shorthandLabelReferenceFromContextContext.pluraliser() != null ? this.stack.pop(NumericExpression.class) : NumericExpression.empty();
        String string = shorthandLabelReferenceFromContextContext.LabelType().getText();
        if (this.efxContext.isFieldContext().booleanValue()) {
            if (string.equals(SHORTHAND_CONTEXT_FIELD_LABEL_REFERENCE)) {
                this.shorthandIndirectLabelReference(this.efxContext.symbol(), numericExpression);
            } else {
                this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol()))), numericExpression));
            }
        } else if (this.efxContext.isNodeContext().booleanValue()) {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_NODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(string), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol()))), numericExpression));
        }
    }

    @Override
    public void exitShorthandIndirectLabelReferenceFromContextField(EfxParser.ShorthandIndirectLabelReferenceFromContextFieldContext shorthandIndirectLabelReferenceFromContextFieldContext) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The #value shorthand syntax can only be used if a field is declared as context.");
        }
        this.shorthandIndirectLabelReference(this.efxContext.symbol(), NumericExpression.empty());
    }

    @Override
    public void exitAssetType(EfxParser.AssetTypeContext assetTypeContext) {
        if (assetTypeContext.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(assetTypeContext.getText()));
        }
    }

    @Override
    public void exitLabelType(EfxParser.LabelTypeContext labelTypeContext) {
        if (labelTypeContext.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(labelTypeContext.getText()));
        }
    }

    @Override
    public void exitAssetId(EfxParser.AssetIdContext assetIdContext) {
        if (assetIdContext.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(assetIdContext.getText()));
        }
    }

    @Override
    public void exitComputedLabelReference(EfxParser.ComputedLabelReferenceContext computedLabelReferenceContext) {
        NumericExpression numericExpression = computedLabelReferenceContext.pluraliser() != null ? this.stack.pop(NumericExpression.class) : NumericExpression.empty();
        StringExpression stringExpression = this.stack.pop(StringExpression.class);
        this.stack.push(this.markup.renderLabelFromExpression(stringExpression, numericExpression));
    }

    @Override
    public void exitStandardExpressionBlock(EfxParser.StandardExpressionBlockContext standardExpressionBlockContext) {
        Expression expression = this.stack.pop(Expression.class);
        if (TypedExpression.class.isAssignableFrom(expression.getClass())) {
            if (EfxDataType.Date.class.isAssignableFrom(((TypedExpression)expression).getDataType())) {
                Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", DateExpression.class), DateExpression.empty(), this.script.composeVariableReference("item", DateExpression.class));
                expression = this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, new DateSequenceExpression(expression.getScript())))), new StringExpression("format-date($item, '[D01]/[M01]/[Y0001]')"), StringSequenceExpression.class);
            } else if (EfxDataType.Time.class.isAssignableFrom(((TypedExpression)expression).getDataType())) {
                Variable variable = new Variable("item", this.script.composeVariableDeclaration("item", DateExpression.class), DateExpression.empty(), this.script.composeVariableReference("item", DateExpression.class));
                expression = this.script.composeForExpression(this.script.composeIteratorList(List.of(this.script.composeIteratorExpression(variable.declarationExpression, new TimeSequenceExpression(expression.getScript())))), new StringExpression("format-time($item, '[H01]:[m01] [Z]')"), StringSequenceExpression.class);
            }
        }
        this.stack.push(expression);
    }

    @Override
    public void exitShorthandFieldValueReferenceFromContextField(EfxParser.ShorthandFieldValueReferenceFromContextFieldContext shorthandFieldValueReferenceFromContextFieldContext) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The $value shorthand syntax can only be used when a field is declared as the context.");
        }
        this.stack.push(this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(this.efxContext.symbol(), this.efxContext.absolutePath())));
    }

    @Override
    public void exitContextDeclaration(EfxParser.ContextDeclarationContext contextDeclarationContext) {
        String string;
        switch (string = contextDeclarationContext.shortcut != null ? contextDeclarationContext.shortcut.getText() : "none") {
            case ".": {
                this.exitSameContextDeclaration();
                break;
            }
            case "..": {
                this.exitParentContextDeclaration();
                break;
            }
            case "/": {
                this.exitRootContextDeclaration();
                break;
            }
            default: {
                PathExpression pathExpression = this.stack.pop(PathExpression.class);
                String string2 = EfxTemplateTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(contextDeclarationContext);
                if (string2 != null) {
                    Variable variable = this.getContextVariable(contextDeclarationContext, pathExpression);
                    if (variable != null) {
                        VariableList variableList = this.stack.pop(VariableList.class);
                        variableList.add(variable);
                        this.stack.push(variableList);
                    }
                    this.exitFieldContextDeclaration(string2, pathExpression, variable);
                    break;
                }
                String string3 = EfxTemplateTranslatorV2.getNodeIdFromChildSimpleNodeReferenceContext(contextDeclarationContext);
                assert (string3 != null) : "We should have been able to locate the FieldId or NodeId declared as context.";
                this.exitNodeContextDeclaration(string3, pathExpression);
            }
        }
    }

    private void exitSameContextDeclaration() {
        Context context = this.blockStack.currentContext();
        PathExpression pathExpression = context.absolutePath();
        String string = context.symbol();
        if (context.isFieldContext().booleanValue()) {
            this.exitFieldContextDeclaration(string, pathExpression, null);
        } else if (context.isNodeContext().booleanValue()) {
            this.exitNodeContextDeclaration(string, pathExpression);
        }
    }

    private void exitParentContextDeclaration() {
        Context context = this.blockStack.parentContext();
        PathExpression pathExpression = context.absolutePath();
        String string = context.symbol();
        if (context.isFieldContext().booleanValue()) {
            this.exitFieldContextDeclaration(string, pathExpression, null);
        } else if (context.isNodeContext().booleanValue()) {
            this.exitNodeContextDeclaration(string, pathExpression);
        }
    }

    private void exitRootContextDeclaration() {
        NodePathExpression nodePathExpression = new NodePathExpression("/*");
        String string = "ND-Root";
        this.exitNodeContextDeclaration(string, nodePathExpression);
    }

    private void exitFieldContextDeclaration(String string, PathExpression pathExpression, Variable variable) {
        this.efxContext.push(new Context.FieldContext(string, pathExpression, variable));
        if (variable != null) {
            this.stack.declareIdentifier(variable);
        }
    }

    private void exitNodeContextDeclaration(String string, PathExpression pathExpression) {
        this.efxContext.push(new Context.NodeContext(string, pathExpression));
    }

    private Variable getContextVariable(EfxParser.ContextDeclarationContext contextDeclarationContext, PathExpression pathExpression) {
        if (contextDeclarationContext.contextVariableInitializer() == null) {
            return null;
        }
        String string = EfxTemplateTranslatorV2.getVariableName(contextDeclarationContext.contextVariableInitializer());
        Class<?> clazz = pathExpression.getClass();
        return new Variable(string, (Expression)this.script.composeVariableDeclaration(string, clazz), this.symbols.getRelativePath(pathExpression, pathExpression), (TypedExpression)this.script.composeVariableReference(string, clazz));
    }

    @Override
    public void exitStringVariableInitializer(EfxParser.StringVariableInitializerContext stringVariableInitializerContext) {
        this.exitVariableInitializer(EfxTemplateTranslatorV2.getVariableName(stringVariableInitializerContext), StringExpression.class);
    }

    @Override
    public void exitBooleanVariableInitializer(EfxParser.BooleanVariableInitializerContext booleanVariableInitializerContext) {
        this.exitVariableInitializer(EfxTemplateTranslatorV2.getVariableName(booleanVariableInitializerContext), BooleanExpression.class);
    }

    @Override
    public void exitNumericVariableInitializer(EfxParser.NumericVariableInitializerContext numericVariableInitializerContext) {
        this.exitVariableInitializer(EfxTemplateTranslatorV2.getVariableName(numericVariableInitializerContext), NumericExpression.class);
    }

    @Override
    public void exitDateVariableInitializer(EfxParser.DateVariableInitializerContext dateVariableInitializerContext) {
        this.exitVariableInitializer(EfxTemplateTranslatorV2.getVariableName(dateVariableInitializerContext), DateExpression.class);
    }

    @Override
    public void exitTimeVariableInitializer(EfxParser.TimeVariableInitializerContext timeVariableInitializerContext) {
        this.exitVariableInitializer(EfxTemplateTranslatorV2.getVariableName(timeVariableInitializerContext), TimeExpression.class);
    }

    @Override
    public void exitDurationVariableInitializer(EfxParser.DurationVariableInitializerContext durationVariableInitializerContext) {
        this.exitVariableInitializer(EfxTemplateTranslatorV2.getVariableName(durationVariableInitializerContext), DurationExpression.class);
    }

    private void exitVariableInitializer(String string, Class<? extends ScalarExpression> clazz) {
        ScalarExpression scalarExpression = this.stack.pop(clazz);
        VariableList variableList = this.stack.pop(VariableList.class);
        try {
            Variable variable = new Variable(string, (Expression)this.script.composeVariableDeclaration(string, scalarExpression.getClass()), scalarExpression, (TypedExpression)this.script.composeVariableReference(string, scalarExpression.getClass()));
            variableList.add(variable);
            this.stack.push(variableList);
            this.stack.declareIdentifier(variable);
        }
        catch (Exception exception) {
            throw new ParseCancellationException((Throwable)exception);
        }
    }

    @Override
    public void enterContextDeclarationBlock(EfxParser.ContextDeclarationBlockContext contextDeclarationBlockContext) {
        this.stack.push(new VariableList());
    }

    @Override
    public void enterTemplateLine(EfxParser.TemplateLineContext templateLineContext) {
        int n = this.getIndentLevel(templateLineContext);
        int n2 = n - this.blockStack.currentIndentationLevel();
        if (n2 > 1) {
            throw new ParseCancellationException(INDENTATION_LEVEL_SKIPPED);
        }
        if (n2 == 1) {
            if (this.blockStack.isEmpty()) {
                throw new ParseCancellationException(START_INDENT_AT_ZERO);
            }
            this.stack.pushStackFrame();
        } else if (n2 < 0) {
            for (int i = n2; i < 0; ++i) {
                assert (!this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
                assert (this.blockStack.currentIndentationLevel() > n) : "Unexpected indentation tracker state.";
                this.blockStack.pop();
                this.stack.popStackFrame();
            }
            this.stack.popStackFrame();
            this.stack.pushStackFrame();
            assert (this.blockStack.currentIndentationLevel() == n) : "Unexpected indentation tracker state.";
        } else if (n2 == 0) {
            this.stack.popStackFrame();
            this.stack.pushStackFrame();
        }
    }

    @Override
    public void exitTemplateLine(EfxParser.TemplateLineContext templateLineContext) {
        Context context = (Context)this.efxContext.pop();
        int n = this.getIndentLevel(templateLineContext);
        int n2 = n - this.blockStack.currentIndentationLevel();
        Markup markup = templateLineContext.template() != null ? this.stack.pop(Markup.class) : new Markup("");
        VariableList variableList = this.stack.pop(VariableList.class);
        Integer n3 = templateLineContext.OutlineNumber() != null ? Integer.parseInt(templateLineContext.OutlineNumber().getText().trim()) : -1;
        assert (this.stack.empty()) : "Stack should be empty at this point.";
        if (n2 > 1) {
            throw new ParseCancellationException(INDENTATION_LEVEL_SKIPPED);
        }
        if (n2 == 1) {
            if (this.blockStack.isEmpty()) {
                throw new ParseCancellationException(START_INDENT_AT_ZERO);
            }
            this.blockStack.pushChild(n3, markup, this.relativizeContext(context, this.blockStack.currentContext()), variableList);
        } else if (n2 < 0) {
            this.blockStack.pushSibling(n3, markup, this.relativizeContext(context, this.blockStack.parentContext()), variableList);
        } else if (n2 == 0) {
            if (this.blockStack.isEmpty()) {
                assert (n == 0) : "Unexpected indentation tracker state.";
                this.blockStack.push(this.rootBlock.addChild(n3, markup, this.relativizeContext(context, this.rootBlock.getContext()), variableList));
            } else {
                this.blockStack.pushSibling(n3, markup, this.relativizeContext(context, this.blockStack.parentContext()), variableList);
            }
        }
    }

    private Context relativizeContext(Context context, Context context2) {
        if (context2 == null) {
            return context;
        }
        if (context.isFieldContext().booleanValue()) {
            return new Context.FieldContext(context.symbol(), context.absolutePath(), this.symbols.getRelativePath(context.absolutePath(), context2.absolutePath()), context.variable());
        }
        assert (context.isNodeContext().booleanValue()) : "Child context should be either a FieldContext NodeContext.";
        return new Context.NodeContext(context.symbol(), context.absolutePath(), this.symbols.getRelativePath(context.absolutePath(), context2.absolutePath()));
    }

    private int getIndentLevel(EfxParser.TemplateLineContext templateLineContext) {
        if (templateLineContext.MixedIndent() != null) {
            throw new ParseCancellationException(MIXED_INDENTATION);
        }
        if (templateLineContext.Spaces() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.SPACES;
                this.indentSpaces = templateLineContext.Spaces().getText().length();
            } else if (this.indentWith == Indent.TABS) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            if (templateLineContext.Spaces().getText().length() % this.indentSpaces != 0) {
                throw new ParseCancellationException(String.format(INCONSISTENT_INDENTATION_SPACES, this.indentSpaces));
            }
            return templateLineContext.Spaces().getText().length() / this.indentSpaces;
        }
        if (templateLineContext.Tabs() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.TABS;
            } else if (this.indentWith == Indent.SPACES) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            return templateLineContext.Tabs().getText().length();
        }
        return 0;
    }

    private static String getVariableName(EfxParser.StringVariableInitializerContext stringVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(stringVariableInitializerContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.NumericVariableInitializerContext numericVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(numericVariableInitializerContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.BooleanVariableInitializerContext booleanVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(booleanVariableInitializerContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DateVariableInitializerContext dateVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(dateVariableInitializerContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.TimeVariableInitializerContext timeVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(timeVariableInitializerContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.DurationVariableInitializerContext durationVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(durationVariableInitializerContext.Variable().getText());
    }

    private static String getVariableName(EfxParser.ContextVariableInitializerContext contextVariableInitializerContext) {
        return EfxTemplateTranslatorV2.getVariableName(contextVariableInitializerContext.Variable().getText());
    }

    class TemplatePreprocessor
    extends EfxExpressionTranslatorV2.ExpressionPreprocessor {
        Stack<Integer> levels;

        TemplatePreprocessor(CharStream charStream) {
            super(charStream);
            this.levels = new Stack();
        }

        String processTemplate() {
            EfxParser.TemplateFileContext templateFileContext = this.parser.templateFile();
            ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
            parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)templateFileContext);
            return this.rewriter.getText();
        }

        @Override
        public void exitContextDeclaration(EfxParser.ContextDeclarationContext contextDeclarationContext) {
            EfxParser.ContextVariableInitializerContext contextVariableInitializerContext;
            String string = EfxExpressionTranslatorV2.getFieldIdFromChildSimpleFieldReferenceContext(contextDeclarationContext);
            if (string != null && (contextVariableInitializerContext = contextDeclarationContext.contextVariableInitializer()) != null) {
                FieldTypes fieldTypes = FieldTypes.fromString(this.symbols.getTypeOfField(string));
                this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(contextVariableInitializerContext), PathExpression.instantiate("", fieldTypes), PathExpression.instantiate("", fieldTypes), PathExpression.instantiate("", fieldTypes)));
            }
        }

        @Override
        public void exitStringVariableInitializer(EfxParser.StringVariableInitializerContext stringVariableInitializerContext) {
            this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(stringVariableInitializerContext), StringExpression.empty(), StringExpression.empty(), StringExpression.empty()));
        }

        @Override
        public void exitBooleanVariableInitializer(EfxParser.BooleanVariableInitializerContext booleanVariableInitializerContext) {
            this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(booleanVariableInitializerContext), BooleanExpression.empty(), BooleanExpression.empty(), BooleanExpression.empty()));
        }

        @Override
        public void exitNumericVariableInitializer(EfxParser.NumericVariableInitializerContext numericVariableInitializerContext) {
            this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(numericVariableInitializerContext), NumericExpression.empty(), NumericExpression.empty(), NumericExpression.empty()));
        }

        @Override
        public void exitDateVariableInitializer(EfxParser.DateVariableInitializerContext dateVariableInitializerContext) {
            this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(dateVariableInitializerContext), DateExpression.empty(), DateExpression.empty(), DateExpression.empty()));
        }

        @Override
        public void exitTimeVariableInitializer(EfxParser.TimeVariableInitializerContext timeVariableInitializerContext) {
            this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(timeVariableInitializerContext), TimeExpression.empty(), TimeExpression.empty(), TimeExpression.empty()));
        }

        @Override
        public void exitDurationVariableInitializer(EfxParser.DurationVariableInitializerContext durationVariableInitializerContext) {
            this.stack.declareIdentifier(new Variable(EfxTemplateTranslatorV2.getVariableName(durationVariableInitializerContext), DurationExpression.empty(), DurationExpression.empty(), DurationExpression.empty()));
        }

        @Override
        public void enterTemplateLine(EfxParser.TemplateLineContext templateLineContext) {
            int n = EfxTemplateTranslatorV2.this.getIndentLevel(templateLineContext);
            int n2 = n - (this.levels.isEmpty() ? 0 : this.levels.peek());
            if (n2 > 1) {
                throw new ParseCancellationException(EfxTemplateTranslatorV2.INDENTATION_LEVEL_SKIPPED);
            }
            if (n2 == 1) {
                if (this.levels.isEmpty()) {
                    throw new ParseCancellationException(EfxTemplateTranslatorV2.START_INDENT_AT_ZERO);
                }
                this.stack.pushStackFrame();
            } else if (n2 < 0) {
                for (int i = n2; i < 0; ++i) {
                    assert (!this.levels.isEmpty()) : "Unexpected indentation tracker state.";
                    assert (this.levels.peek() > n) : "Unexpected indentation tracker state.";
                    this.levels.pop();
                    this.stack.popStackFrame();
                }
                this.stack.popStackFrame();
                this.stack.pushStackFrame();
                assert (this.levels.peek() == n) : "Unexpected indentation tracker state.";
            } else if (n2 == 0) {
                this.stack.popStackFrame();
                this.stack.pushStackFrame();
            }
        }

        @Override
        public void exitTemplateLine(EfxParser.TemplateLineContext templateLineContext) {
            int n = EfxTemplateTranslatorV2.this.getIndentLevel(templateLineContext);
            int n2 = n - (this.levels.isEmpty() ? 0 : this.levels.peek());
            assert (this.stack.empty()) : "Stack should be empty at this point.";
            if (n2 > 1) {
                throw new ParseCancellationException(EfxTemplateTranslatorV2.INDENTATION_LEVEL_SKIPPED);
            }
            if (n2 == 1) {
                if (this.levels.isEmpty()) {
                    throw new ParseCancellationException(EfxTemplateTranslatorV2.START_INDENT_AT_ZERO);
                }
                this.levels.push(this.levels.peek() + 1);
            } else if (n2 == 0 && this.levels.isEmpty()) {
                assert (n == 0) : "Unexpected indentation tracker state.";
                this.levels.push(0);
            }
        }
    }

    private static enum Indent {
        TABS,
        SPACES,
        UNDETERMINED;

    }
}

