/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.xpath;

import eu.europa.ted.eforms.sdk.component.SdkComponent;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.eforms.xpath.XPathProcessor;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.TranslatorOptions;
import eu.europa.ted.efx.model.expressions.Expression;
import eu.europa.ted.efx.model.expressions.TypedExpression;
import eu.europa.ted.efx.model.expressions.iteration.IteratorExpression;
import eu.europa.ted.efx.model.expressions.iteration.IteratorListExpression;
import eu.europa.ted.efx.model.expressions.path.NodePathExpression;
import eu.europa.ted.efx.model.expressions.path.PathExpression;
import eu.europa.ted.efx.model.expressions.scalar.BooleanExpression;
import eu.europa.ted.efx.model.expressions.scalar.DateExpression;
import eu.europa.ted.efx.model.expressions.scalar.DurationExpression;
import eu.europa.ted.efx.model.expressions.scalar.NumericExpression;
import eu.europa.ted.efx.model.expressions.scalar.ScalarExpression;
import eu.europa.ted.efx.model.expressions.scalar.StringExpression;
import eu.europa.ted.efx.model.expressions.scalar.TimeExpression;
import eu.europa.ted.efx.model.expressions.sequence.NumericSequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.SequenceExpression;
import eu.europa.ted.efx.model.expressions.sequence.StringSequenceExpression;
import eu.europa.ted.efx.model.types.EfxDataType;
import eu.europa.ted.efx.xpath.XPathContextualizer;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;

@SdkComponent(versions={"2"}, componentType=SdkComponentType.SCRIPT_GENERATOR)
public class XPathScriptGenerator
implements ScriptGenerator {
    private static final Map<String, String> operators = Map.ofEntries(Map.entry("+", "+"), Map.entry("-", "-"), Map.entry("*", "*"), Map.entry("/", "div"), Map.entry("%", "mod"), Map.entry("==", "="), Map.entry("!=", "!="), Map.entry("<", "<"), Map.entry("<=", "<="), Map.entry(">", ">"), Map.entry(">=", ">="));
    protected TranslatorOptions translatorOptions;

    public XPathScriptGenerator(TranslatorOptions translatorOptions) {
        this.translatorOptions = translatorOptions;
    }

    @Override
    public PathExpression composeNodeReferenceWithPredicate(PathExpression pathExpression, BooleanExpression booleanExpression) {
        return PathExpression.instantiate(pathExpression.getScript() + "[" + booleanExpression.getScript() + "]", EfxDataType.Node.class);
    }

    @Override
    public PathExpression composeFieldReferenceWithPredicate(PathExpression pathExpression, BooleanExpression booleanExpression) {
        return PathExpression.instantiate(pathExpression.getScript() + "[" + booleanExpression.getScript() + "]", pathExpression.getDataType());
    }

    @Override
    public PathExpression composeFieldReferenceWithAxis(PathExpression pathExpression, String string) {
        String string2 = XPathProcessor.addAxis((String)string, (String)pathExpression.getScript());
        return PathExpression.instantiate(string2, pathExpression.getDataType());
    }

    @Override
    public PathExpression composeFieldValueReference(PathExpression pathExpression) {
        if (pathExpression.is(EfxDataType.String.class).booleanValue()) {
            return PathExpression.instantiate(pathExpression.getScript() + "/normalize-space(text())", pathExpression.getDataType());
        }
        if (pathExpression.is(EfxDataType.Number.class).booleanValue()) {
            return PathExpression.instantiate(pathExpression.getScript() + "/number()", pathExpression.getDataType());
        }
        if (pathExpression.is(EfxDataType.Date.class).booleanValue()) {
            return PathExpression.instantiate(pathExpression.getScript() + "/xs:date(text())", pathExpression.getDataType());
        }
        if (pathExpression.is(EfxDataType.Time.class).booleanValue()) {
            return PathExpression.instantiate(pathExpression.getScript() + "/xs:time(text())", pathExpression.getDataType());
        }
        if (pathExpression.is(EfxDataType.Duration.class).booleanValue()) {
            return PathExpression.instantiate("(for $F in " + pathExpression.getScript() + " return (if ($F/@unitCode='WEEK') then xs:dayTimeDuration(concat('P', $F/number() * 7, 'D')) else if ($F/@unitCode='DAY') then xs:dayTimeDuration(concat('P', $F/number(), 'D')) else if ($F/@unitCode='YEAR') then xs:yearMonthDuration(concat('P', $F/number(), 'Y')) else if ($F/@unitCode='MONTH') then xs:yearMonthDuration(concat('P', $F/number(), 'M')) else ()))", pathExpression.getDataType());
        }
        return PathExpression.instantiate(pathExpression.getScript(), pathExpression.getDataType());
    }

    @Override
    public <T extends PathExpression> T composeFieldAttributeReference(PathExpression pathExpression, String string, Class<T> clazz) {
        return (T)((PathExpression)Expression.instantiate(pathExpression.getScript() + (pathExpression.getScript().isEmpty() ? "" : "/") + "@" + string, clazz));
    }

    @Override
    public <T extends TypedExpression> T composeVariableReference(String string, Class<T> clazz) {
        return (T)((TypedExpression)Expression.instantiate("$" + string, clazz));
    }

    @Override
    public <T extends TypedExpression> T composeVariableDeclaration(String string, Class<T> clazz) {
        return (T)((TypedExpression)Expression.instantiate("$" + string, clazz));
    }

    @Override
    public <T extends TypedExpression> T composeParameterDeclaration(String string, Class<T> clazz) {
        return (T)((TypedExpression)Expression.empty(clazz));
    }

    @Override
    public <T extends SequenceExpression> T composeList(List<? extends ScalarExpression> list, Class<T> clazz) {
        if (list == null || list.isEmpty()) {
            return (T)((SequenceExpression)Expression.instantiate("()", clazz));
        }
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (ScalarExpression scalarExpression : list) {
            stringJoiner.add(scalarExpression.getScript());
        }
        return (T)((SequenceExpression)Expression.instantiate(stringJoiner.toString(), clazz));
    }

    @Override
    public NumericExpression getNumericLiteralEquivalent(String string) {
        return new NumericExpression(string, true);
    }

    @Override
    public StringExpression getStringLiteralEquivalent(String string) {
        return new StringExpression(string, true);
    }

    @Override
    public BooleanExpression getBooleanEquivalent(boolean bl) {
        return new BooleanExpression(bl ? "true()" : "false()", true);
    }

    @Override
    public DateExpression getDateLiteralEquivalent(String string) {
        return new DateExpression("xs:date(" + this.quoted(string) + ")", true);
    }

    @Override
    public TimeExpression getTimeLiteralEquivalent(String string) {
        return new TimeExpression("xs:time(" + this.quoted(string) + ")", true);
    }

    @Override
    public DurationExpression getDurationLiteralEquivalent(String string) {
        if (string.contains("M") || string.contains("Y")) {
            return new DurationExpression("xs:yearMonthDuration(" + this.quoted(string) + ")", true);
        }
        if (string.contains("W")) {
            int n = this.getWeeksFromDurationLiteral(string);
            return new DurationExpression("xs:dayTimeDuration(" + this.quoted(String.format("P%dD", n * 7)) + ")", true);
        }
        return new DurationExpression("xs:dayTimeDuration(" + this.quoted(string) + ")", true);
    }

    @Override
    public BooleanExpression composeContainsCondition(ScalarExpression scalarExpression, SequenceExpression sequenceExpression) {
        return new BooleanExpression(String.format("%s = %s", scalarExpression.getScript(), sequenceExpression.getScript()));
    }

    @Override
    public BooleanExpression composePatternMatchCondition(StringExpression stringExpression, String string) {
        return new BooleanExpression(String.format("fn:matches(normalize-space(%s), %s)", stringExpression.getScript(), string));
    }

    @Override
    public BooleanExpression composeAllSatisfy(IteratorListExpression iteratorListExpression, BooleanExpression booleanExpression) {
        return new BooleanExpression("every " + iteratorListExpression.getScript() + " satisfies " + booleanExpression.getScript());
    }

    @Override
    public BooleanExpression composeAnySatisfies(IteratorListExpression iteratorListExpression, BooleanExpression booleanExpression) {
        return new BooleanExpression("some " + iteratorListExpression.getScript() + " satisfies " + booleanExpression.getScript());
    }

    @Override
    public <T extends TypedExpression> T composeConditionalExpression(BooleanExpression booleanExpression, T t, T t2, Class<T> clazz) {
        return (T)((TypedExpression)Expression.instantiate("(if " + booleanExpression.getScript() + " then " + t.getScript() + " else " + t2.getScript() + ")", clazz));
    }

    @Override
    public <T extends SequenceExpression> T composeForExpression(IteratorListExpression iteratorListExpression, ScalarExpression scalarExpression, Class<T> clazz) {
        return (T)((SequenceExpression)Expression.instantiate("for " + iteratorListExpression.getScript() + " return " + scalarExpression.getScript(), clazz));
    }

    @Override
    public IteratorExpression composeIteratorExpression(Expression expression, SequenceExpression sequenceExpression) {
        return new IteratorExpression(expression.getScript() + " in " + sequenceExpression.getScript());
    }

    @Override
    public IteratorListExpression composeIteratorList(List<IteratorExpression> list) {
        return new IteratorListExpression(list.stream().map(iteratorExpression -> iteratorExpression.getScript()).collect(Collectors.joining(", ", "", "")));
    }

    @Override
    public <T extends Expression> T composeParenthesizedExpression(T t, Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            return (T)((Expression)constructor.newInstance("(" + t.getScript() + ")"));
        }
        catch (Exception exception) {
            throw new ParseCancellationException((Throwable)exception);
        }
    }

    @Override
    public PathExpression composeExternalReference(StringExpression stringExpression) {
        return new NodePathExpression("fn:doc(concat($urlPrefix, " + stringExpression.getScript() + "))");
    }

    @Override
    public PathExpression composeFieldInExternalReference(PathExpression pathExpression, PathExpression pathExpression2) {
        return PathExpression.instantiate(pathExpression.getScript() + pathExpression2.getScript(), pathExpression2.getDataType());
    }

    @Override
    public PathExpression joinPaths(PathExpression pathExpression, PathExpression pathExpression2) {
        return XPathContextualizer.join(pathExpression, pathExpression2);
    }

    @Override
    public <T extends ScalarExpression> T composeIndexer(SequenceExpression sequenceExpression, NumericExpression numericExpression, Class<T> clazz) {
        return (T)((ScalarExpression)Expression.instantiate(String.format("%s[%s]", sequenceExpression.getScript(), numericExpression.getScript()), clazz));
    }

    @Override
    public BooleanExpression composeLogicalAnd(BooleanExpression booleanExpression, BooleanExpression booleanExpression2) {
        return new BooleanExpression(String.format("%s and %s", booleanExpression.getScript(), booleanExpression2.getScript()));
    }

    @Override
    public BooleanExpression composeLogicalOr(BooleanExpression booleanExpression, BooleanExpression booleanExpression2) {
        return new BooleanExpression(String.format("%s or %s", booleanExpression.getScript(), booleanExpression2.getScript()));
    }

    @Override
    public BooleanExpression composeLogicalNot(BooleanExpression booleanExpression) {
        return new BooleanExpression(String.format("not(%s)", booleanExpression.getScript()));
    }

    @Override
    public BooleanExpression composeExistsCondition(PathExpression pathExpression) {
        return new BooleanExpression(pathExpression.getScript());
    }

    @Override
    public BooleanExpression composeUniqueValueCondition(PathExpression pathExpression, PathExpression pathExpression2) {
        return new BooleanExpression("count(for $x in " + pathExpression.getScript() + ", $y in " + pathExpression2.getScript() + "[. = $x] return $y) = 1");
    }

    @Override
    public BooleanExpression composeContainsCondition(StringExpression stringExpression, StringExpression stringExpression2) {
        return new BooleanExpression("contains(" + stringExpression.getScript() + ", " + stringExpression2.getScript() + ")");
    }

    @Override
    public BooleanExpression composeStartsWithCondition(StringExpression stringExpression, StringExpression stringExpression2) {
        return new BooleanExpression("starts-with(" + stringExpression.getScript() + ", " + stringExpression2.getScript() + ")");
    }

    @Override
    public BooleanExpression composeEndsWithCondition(StringExpression stringExpression, StringExpression stringExpression2) {
        return new BooleanExpression("ends-with(" + stringExpression.getScript() + ", " + stringExpression2.getScript() + ")");
    }

    @Override
    public BooleanExpression composeComparisonOperation(ScalarExpression scalarExpression, String string, ScalarExpression scalarExpression2) {
        if (scalarExpression.is(EfxDataType.Duration.class).booleanValue()) {
            return new BooleanExpression("boolean(for $T in (current-date()) return ($T + " + scalarExpression.getScript() + " " + operators.get(string) + " $T + " + scalarExpression2.getScript() + "))");
        }
        return new BooleanExpression(scalarExpression.getScript() + " " + operators.get(string) + " " + scalarExpression2.getScript());
    }

    @Override
    public BooleanExpression composeSequenceEqualFunction(SequenceExpression sequenceExpression, SequenceExpression sequenceExpression2) {
        return new BooleanExpression("deep-equal(sort(" + sequenceExpression.getScript() + "), sort(" + sequenceExpression2.getScript() + "))");
    }

    @Override
    public NumericExpression composeCountOperation(SequenceExpression sequenceExpression) {
        return new NumericExpression("count(" + sequenceExpression.getScript() + ")");
    }

    @Override
    public NumericExpression composeToNumberConversion(StringExpression stringExpression) {
        return new NumericExpression("number(" + stringExpression.getScript() + ")");
    }

    @Override
    public NumericExpression composeSumOperation(NumericSequenceExpression numericSequenceExpression) {
        return new NumericExpression("sum(" + numericSequenceExpression.getScript() + ")");
    }

    @Override
    public NumericExpression composeStringLengthCalculation(StringExpression stringExpression) {
        return new NumericExpression("string-length(" + stringExpression.getScript() + ")");
    }

    @Override
    public NumericExpression composeNumericOperation(NumericExpression numericExpression, String string, NumericExpression numericExpression2) {
        return new NumericExpression(numericExpression.getScript() + " " + operators.get(string) + " " + numericExpression2.getScript());
    }

    @Override
    public StringExpression composeSubstringExtraction(StringExpression stringExpression, NumericExpression numericExpression, NumericExpression numericExpression2) {
        return new StringExpression("substring(" + stringExpression.getScript() + ", " + numericExpression.getScript() + ", " + numericExpression2.getScript() + ")");
    }

    @Override
    public StringExpression composeSubstringExtraction(StringExpression stringExpression, NumericExpression numericExpression) {
        return new StringExpression("substring(" + stringExpression.getScript() + ", " + numericExpression.getScript() + ")");
    }

    @Override
    public StringExpression composeToStringConversion(NumericExpression numericExpression) {
        String string = this.translatorOptions.getDecimalFormat().adaptFormatString("0.##########");
        return new StringExpression("format-number(" + numericExpression.getScript() + ", '" + string + "')");
    }

    @Override
    public StringExpression composeToUpperCaseConversion(StringExpression stringExpression) {
        return new StringExpression("upper-case(" + stringExpression.getScript() + ")");
    }

    @Override
    public StringExpression composeToLowerCaseConversion(StringExpression stringExpression) {
        return new StringExpression("lower-case(" + stringExpression.getScript() + ")");
    }

    @Override
    public StringExpression composeStringConcatenation(List<StringExpression> list) {
        return new StringExpression("concat(" + list.stream().map(stringExpression -> stringExpression.getScript()).collect(Collectors.joining(", ")) + ")");
    }

    @Override
    public StringExpression composeStringJoin(StringSequenceExpression stringSequenceExpression, StringExpression stringExpression) {
        return new StringExpression("string-join(" + stringSequenceExpression.getScript() + ", " + stringExpression.getScript() + ")");
    }

    @Override
    public StringExpression composeNumberFormatting(NumericExpression numericExpression, StringExpression stringExpression) {
        String string = stringExpression.isLiteral() != false ? this.translatorOptions.getDecimalFormat().adaptFormatString(stringExpression.getScript()) : stringExpression.getScript();
        return new StringExpression("format-number(" + numericExpression.getScript() + ", " + string + ")");
    }

    @Override
    public StringExpression getStringLiteralFromUnquotedString(String string) {
        return new StringExpression("'" + string + "'", true);
    }

    @Override
    public StringExpression getPreferredLanguage(PathExpression pathExpression) {
        return new StringExpression("efx:preferred-language(" + pathExpression.getScript() + ")");
    }

    @Override
    public StringExpression getTextInPreferredLanguage(PathExpression pathExpression) {
        return new StringExpression("efx:preferred-language-text(" + pathExpression.getScript() + ")");
    }

    @Override
    public DateExpression composeToDateConversion(StringExpression stringExpression) {
        return new DateExpression("xs:date(" + stringExpression.getScript() + ")");
    }

    @Override
    public DateExpression composeAddition(DateExpression dateExpression, DurationExpression durationExpression) {
        return new DateExpression("(" + dateExpression.getScript() + " + " + durationExpression.getScript() + ")");
    }

    @Override
    public DateExpression composeSubtraction(DateExpression dateExpression, DurationExpression durationExpression) {
        return new DateExpression("(" + dateExpression.getScript() + " - " + durationExpression.getScript() + ")");
    }

    @Override
    public TimeExpression composeToTimeConversion(StringExpression stringExpression) {
        return new TimeExpression("xs:time(" + stringExpression.getScript() + ")");
    }

    @Override
    public DurationExpression composeToDayTimeDurationConversion(StringExpression stringExpression) {
        return new DurationExpression("xs:dayTimeDuration(" + stringExpression.getScript() + ")");
    }

    @Override
    public DurationExpression composeToYearMonthDurationConversion(StringExpression stringExpression) {
        return new DurationExpression("xs:yearMonthDuration(" + stringExpression.getScript() + ")");
    }

    @Override
    public DurationExpression composeSubtraction(DateExpression dateExpression, DateExpression dateExpression2) {
        return new DurationExpression("xs:dayTimeDuration(" + dateExpression2.getScript() + " " + operators.get("-") + " " + dateExpression.getScript() + ")");
    }

    @Override
    public DurationExpression composeMultiplication(NumericExpression numericExpression, DurationExpression durationExpression) {
        return new DurationExpression("(" + numericExpression.getScript() + " * " + durationExpression.getScript() + ")");
    }

    @Override
    public DurationExpression composeAddition(DurationExpression durationExpression, DurationExpression durationExpression2) {
        return new DurationExpression("(" + durationExpression.getScript() + " + " + durationExpression2.getScript() + ")");
    }

    @Override
    public DurationExpression composeSubtraction(DurationExpression durationExpression, DurationExpression durationExpression2) {
        return new DurationExpression("(" + durationExpression.getScript() + " - " + durationExpression2.getScript() + ")");
    }

    @Override
    public <T extends SequenceExpression> T composeDistinctValuesFunction(T t, Class<T> clazz) {
        return (T)((SequenceExpression)Expression.instantiate("distinct-values(" + t.getScript() + ")", clazz));
    }

    @Override
    public <T extends SequenceExpression> T composeUnionFunction(T t, T t2, Class<T> clazz) {
        return (T)((SequenceExpression)Expression.instantiate("distinct-values((" + t.getScript() + ", " + t2.getScript() + "))", clazz));
    }

    @Override
    public <T extends SequenceExpression> T composeIntersectFunction(T t, T t2, Class<T> clazz) {
        return (T)((SequenceExpression)Expression.instantiate("distinct-values(for $L1 in " + t.getScript() + " return if (some $L2 in " + t2.getScript() + " satisfies $L1 = $L2) then $L1 else ())", clazz));
    }

    @Override
    public <T extends SequenceExpression> T composeExceptFunction(T t, T t2, Class<T> clazz) {
        return (T)((SequenceExpression)Expression.instantiate("distinct-values(for $L1 in " + t.getScript() + " return if (every $L2 in " + t2.getScript() + " satisfies $L1 != $L2) then $L1 else ())", clazz));
    }

    private String quoted(String string) {
        return "'" + string.replaceAll("\"", "").replaceAll("'", "") + "'";
    }

    private int getWeeksFromDurationLiteral(String string) {
        Matcher matcher = Pattern.compile("(?<=[^0-9])[0-9]+(?=W)").matcher(string);
        return matcher.find() ? Integer.parseInt(matcher.group()) : 0;
    }
}

