/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore.virtuoso;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.internal.Util;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.Iteration;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.impl.ListBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.sql.ExtendedString;
import virtuoso.sql.RdfBox;

public final class VirtuosoJdbcTripleStore
implements TripleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtuosoJdbcTripleStore.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 1111;
    private static final String DEFAULT_USERNAME = "dba";
    private static final String DEFAULT_PASSWORD = "dba";
    private static final int DEFAULT_FETCH_SIZE = 200;
    private static final long GRACE_PERIOD = 5000L;
    private final VirtuosoConnectionPoolDataSource source = new VirtuosoConnectionPoolDataSource();
    private final int fetchSize;
    private final AtomicLong transactionCounter;

    public VirtuosoJdbcTripleStore(@Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password, @Nullable Integer fetchSize) {
        this.source.setServerName((String)Objects.firstNonNull((Object)host, (Object)DEFAULT_HOST));
        this.source.setPortNumber(((Integer)Objects.firstNonNull((Object)port, (Object)1111)).intValue());
        this.source.setUser((String)Objects.firstNonNull((Object)username, (Object)"dba"));
        this.source.setPassword((String)Objects.firstNonNull((Object)password, (Object)"dba"));
        this.fetchSize = (Integer)Objects.firstNonNull((Object)fetchSize, (Object)200);
        this.transactionCounter = new AtomicLong(0L);
        Preconditions.checkArgument((this.fetchSize > 0 ? 1 : 0) != 0);
        LOGGER.info("VirtuosoTripleStore configured, URL={}, fetchSize={}", (Object)(this.source.getServerName() + ":" + this.source.getPortNumber()), (Object)fetchSize);
    }

    public void init() throws IOException {
    }

    public TripleTransaction begin(boolean readOnly) throws DataCorruptedException, IOException {
        return new VirtuosoTransaction(readOnly);
    }

    public void reset() throws IOException {
        Connection connection = null;
        try {
            connection = this.source.getConnection();
            connection.setReadOnly(false);
            connection.setAutoCommit(true);
            connection.prepareCall("RDF_GLOBAL_RESET ()").execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        finally {
            Util.closeQuietly((Object)connection);
        }
    }

    public void close() {
        try {
            this.source.close();
        }
        catch (SQLException ex) {
            LOGGER.error("Failed to shutdown Virtuoso driver", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static Value castValue(Object value) throws IllegalArgumentException {
        ValueFactory vf = Data.getValueFactory();
        if (value == null) {
            return null;
        }
        if (value instanceof ExtendedString) {
            ExtendedString es = (ExtendedString)value;
            String string = es.toString();
            try {
                if (es.getIriType() == 1 && (es.getStrType() & 1) == 1) {
                    if (string.startsWith("_:")) {
                        string = string.substring(2);
                        return vf.createBNode(string);
                    }
                    if (string.indexOf(58) < 0) {
                        return vf.createURI(":" + string);
                    }
                    return vf.createURI(string);
                }
                if (es.getIriType() == 2) {
                    return vf.createBNode(string);
                }
                return vf.createLiteral(string);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Invalid value from Virtuoso: \"" + string + "\", STRTYPE = " + es.getIriType(), ex);
            }
        }
        if (value instanceof RdfBox) {
            RdfBox rb = (RdfBox)value;
            if (rb.getLang() != null) {
                return vf.createLiteral(rb.toString(), rb.getLang());
            }
            if (rb.getType() != null) {
                return vf.createLiteral(rb.toString(), vf.createURI(rb.getType()));
            }
            return vf.createLiteral(rb.toString());
        }
        if (value instanceof Blob) {
            return vf.createLiteral(value.toString(), XMLSchema.HEXBINARY);
        }
        if (value instanceof Date) {
            return (Value)Data.convert((Object)new java.util.Date(((Date)value).getTime()), Value.class);
        }
        if (value instanceof Timestamp) {
            return (Value)Data.convert((Object)new Date(((Timestamp)value).getTime()), Value.class);
        }
        if (value instanceof Time) {
            return vf.createLiteral(value.toString(), XMLSchema.TIME);
        }
        try {
            return (Value)Data.convert((Object)value, Value.class);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not parse value: " + value, ex);
        }
    }

    private static String sqlForQuery(String query, @Nullable Dataset dataset, @Nullable BindingSet bindings) {
        StringBuilder builder = new StringBuilder("sparql\n ");
        if (dataset != null) {
            Set empty = Collections.emptySet();
            for (URI uri : (Set)Objects.firstNonNull((Object)dataset.getDefaultGraphs(), empty)) {
                builder.append(" define input:default-graph-uri <" + uri + "> \n");
            }
            for (URI uri : (Set)Objects.firstNonNull((Object)dataset.getNamedGraphs(), empty)) {
                builder.append(" define input:named-graph-uri <" + uri + "> \n");
            }
        }
        if (bindings != null && bindings.size() > 0) {
            int i = 0;
            int length = query.length();
            block2: while (i < query.length()) {
                char ch;
                if ((ch = query.charAt(i++)) == '\\' && i < length) {
                    builder.append(ch).append(query.charAt(i++));
                    continue;
                }
                if (ch == '\"' || ch == '\'') {
                    builder.append(ch);
                    while (i < length) {
                        char c = query.charAt(i++);
                        builder.append(c);
                        if (c != ch) continue;
                        continue block2;
                    }
                    continue;
                }
                if ((ch == '?' || ch == '$') && i < length && VirtuosoJdbcTripleStore.isVarFirstChar(query.charAt(i))) {
                    int j;
                    for (j = i + 1; j < length && VirtuosoJdbcTripleStore.isVarMiddleChar(query.charAt(j)); ++j) {
                    }
                    String name = query.substring(i, j);
                    Value value = bindings.getValue(name);
                    if (value != null) {
                        builder.append(Data.toString((Object)value, null));
                    } else {
                        builder.append(ch).append(name);
                    }
                    i = j;
                    continue;
                }
                builder.append(ch);
            }
        } else {
            builder.append(query);
        }
        return builder.toString();
    }

    private static boolean isVarFirstChar(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || c == '_' || '\u00c0' <= c && c <= '\u00d6' || '\u00d8' <= c && c <= '\u00f6' || '\u00f8' <= c && c <= '\u02ff' || '\u0370' <= c && c <= '\u037d' || '\u037f' <= c && c <= '\u1fff' || '\u200c' <= c && c <= '\u200d' || '\u2070' <= c && c <= '\u218f' || '\u2c00' <= c && c <= '\u2fef' || '\u3001' <= c && c <= '\ud7ff' || '\uf900' <= c && c <= '\ufdcf' || '\ufdf0' <= c && c <= '\ufffd';
    }

    private static boolean isVarMiddleChar(char c) {
        return VirtuosoJdbcTripleStore.isVarFirstChar(c) || c == '\u00b7' || '\u0300' <= c && c <= '\u036f' || '\u203f' <= c && c <= '\u2040';
    }

    private static boolean isPartialResultException(Throwable ex) {
        return ex.getMessage() != null && ex.getMessage().contains("Returning incomplete results");
    }

    private static void killConnection(Object connection) throws Throwable {
        if (connection instanceof ConnectionWrapper) {
            Field field = ConnectionWrapper.class.getDeclaredField("pconn");
            field.setAccessible(true);
            VirtuosoJdbcTripleStore.killConnection(field.get(connection));
        } else if (connection instanceof VirtuosoPooledConnection) {
            VirtuosoJdbcTripleStore.killConnection(((VirtuosoPooledConnection)connection).getVirtuosoConnection());
        } else if (connection instanceof VirtuosoConnection) {
            Field field = VirtuosoConnection.class.getDeclaredField("socket");
            field.setAccessible(true);
            Closeable socket = (Closeable)field.get(connection);
            socket.close();
        } else {
            throw new Exception("Don't know how to kill connection " + connection.getClass().getName());
        }
    }

    private final class VirtuosoTransaction
    implements TripleTransaction {
        private final Connection connection;
        private final boolean readOnly;
        private final String id;

        VirtuosoTransaction(boolean readOnly) throws IOException {
            this.readOnly = readOnly;
            this.id = "Virtuoso TX" + VirtuosoJdbcTripleStore.this.transactionCounter.incrementAndGet();
            Connection connection = null;
            try {
                connection = VirtuosoJdbcTripleStore.this.source.getConnection();
                connection.setReadOnly(readOnly);
                connection.setAutoCommit(true);
            }
            catch (SQLException ex) {
                Util.closeQuietly((Object)connection);
                throw new IOException("Could not connect to Virtuoso", ex);
            }
            this.connection = connection;
        }

        private void checkWritable() {
            if (this.readOnly) {
                throw new IllegalStateException("Write operation not allowed on read-only transaction");
            }
        }

        public CloseableIteration<? extends org.openrdf.model.Statement, ? extends Exception> get(final Resource subject, final URI predicate, final Value object, final Resource context) throws IOException, IllegalStateException {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT * WHERE { GRAPH ");
            builder.append(context == null ? "?c" : Data.toString((Object)context, null));
            builder.append(" { ");
            builder.append(subject == null ? "?s" : Data.toString((Object)subject, null));
            builder.append(' ');
            builder.append(predicate == null ? "?p" : Data.toString((Object)predicate, null));
            builder.append(' ');
            builder.append(object == null ? "?o" : Data.toString((Object)object, null));
            builder.append(" } }");
            String query = builder.toString();
            return new ConvertingIteration<BindingSet, org.openrdf.model.Statement, Exception>((Iteration)new VirtuosoQueryIteration(query, null, null, null)){

                protected org.openrdf.model.Statement convert(BindingSet tuple) throws Exception {
                    Resource s = subject != null ? subject : (Resource)tuple.getValue("s");
                    URI p = predicate != null ? predicate : (URI)tuple.getValue("p");
                    Value o = object != null ? object : tuple.getValue("o");
                    Resource c = context != null ? context : (Resource)tuple.getValue("c");
                    return Data.getValueFactory().createStatement(s, p, o, c);
                }
            };
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> query(SelectQuery query, BindingSet bindings, Long timeout) throws IOException, UnsupportedOperationException, IllegalStateException {
            return new VirtuosoQueryIteration(query.getString(), query.getDataset(), bindings, timeout);
        }

        public void infer(Handler<? super org.openrdf.model.Statement> handler) throws IOException, IllegalStateException {
            this.checkWritable();
            if (handler != null) {
                try {
                    handler.handle(null);
                }
                catch (Throwable ex) {
                    Throwables.propagateIfPossible((Throwable)ex, IOException.class);
                    throw new RuntimeException(ex);
                }
            }
        }

        public void add(Iterable<? extends org.openrdf.model.Statement> statements) throws IOException, IllegalStateException {
            Preconditions.checkNotNull(statements);
            this.checkWritable();
            throw new UnsupportedOperationException();
        }

        public void remove(Iterable<? extends org.openrdf.model.Statement> statements) throws IOException, IllegalStateException {
            Preconditions.checkNotNull(statements);
            this.checkWritable();
            throw new UnsupportedOperationException();
        }

        public void end(boolean commit) throws DataCorruptedException, IOException, IllegalStateException {
            try {
                ListenableScheduledFuture future = Data.getExecutor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtuosoJdbcTripleStore.killConnection(VirtuosoTransaction.this.connection);
                            LOGGER.warn("{} - killed Virtuoso JDBC connection", (Object)this);
                        }
                        catch (Throwable ex) {
                            LOGGER.debug(this + " - failed to kill Virtuoso JDBC connection " + "(connection class is " + VirtuosoTransaction.this.connection.getClass() + ")", ex);
                        }
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
                this.connection.close();
                future.cancel(false);
            }
            catch (SQLException ex) {
                LOGGER.error(this + " - failed to close connection", (Throwable)ex);
            }
        }

        public String toString() {
            return this.id;
        }

        private final class VirtuosoQueryIteration
        implements CloseableIteration<BindingSet, QueryEvaluationException> {
            private final List<String> variables;
            private Statement statement;
            private ResultSet cursor;
            private BindingSet tuple;

            public VirtuosoQueryIteration(@Nullable String query, @Nullable Dataset dataset, @Nullable BindingSet bindings, Long timeout) throws IOException {
                try {
                    String sql = VirtuosoJdbcTripleStore.sqlForQuery(query, dataset, bindings);
                    int msTimeout = timeout == null ? 0 : timeout.intValue();
                    try {
                        VirtuosoTransaction.this.connection.prepareCall("set result_timeout = " + msTimeout).execute();
                    }
                    catch (Throwable ex) {
                        LOGGER.warn(VirtuosoTransaction.this + " - failed to set result_timeout = " + msTimeout + " on Virtuoso JDBC connection (proceeding anyway)", ex);
                    }
                    this.statement = VirtuosoTransaction.this.connection.createStatement();
                    this.statement.setFetchSize(VirtuosoJdbcTripleStore.this.fetchSize);
                    if (timeout != null) {
                        this.statement.setQueryTimeout((int)((timeout + 5000L) / 1000L));
                    }
                    this.variables = Lists.newArrayList();
                    this.tuple = null;
                    this.cursor = this.statement.executeQuery(sql);
                    ResultSetMetaData metadata = this.cursor.getMetaData();
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        this.variables.add(metadata.getColumnName(i));
                    }
                }
                catch (Throwable ex) {
                    if (VirtuosoJdbcTripleStore.isPartialResultException(ex)) {
                        LOGGER.debug("{} -no results / partial results returned due to expired timeout", (Object)VirtuosoTransaction.this);
                        Util.closeQuietly((Object)this);
                    }
                    throw new IOException("Could not obtain query result set", ex);
                }
            }

            public boolean hasNext() throws QueryEvaluationException {
                if (this.tuple == null) {
                    this.tuple = this.advance();
                }
                return this.tuple != null;
            }

            public BindingSet next() throws QueryEvaluationException {
                if (this.tuple == null) {
                    this.tuple = this.advance();
                }
                if (this.tuple == null) {
                    throw new NoSuchElementException();
                }
                BindingSet result = this.tuple;
                this.tuple = null;
                return result;
            }

            public void remove() throws QueryEvaluationException {
                throw new UnsupportedOperationException();
            }

            public void close() throws QueryEvaluationException {
                if (this.statement != null) {
                    ListenableScheduledFuture future = Data.getExecutor().schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VirtuosoTransaction.this.end(false);
                                LOGGER.warn(VirtuosoTransaction.this + " - forced closure of Virtuoso transaction " + "after unsuccessfull attempt at closing Virtuoso iteration");
                            }
                            catch (Throwable ex) {
                                LOGGER.debug(VirtuosoTransaction.this + " - failed to close Virtuoso transaction after " + "unsuccessfull attempt at closing Virtuoso iteration", ex);
                            }
                        }
                    }, 1000L, TimeUnit.MILLISECONDS);
                    try {
                        this.cursor.close();
                        this.statement.close();
                        future.cancel(false);
                    }
                    catch (SQLException e) {
                        throw new QueryEvaluationException((Throwable)e);
                    }
                    finally {
                        this.statement = null;
                        this.cursor = null;
                    }
                }
            }

            protected void finalize() throws Throwable {
                Util.closeQuietly((Object)this);
            }

            private BindingSet advance() throws QueryEvaluationException {
                try {
                    BindingSet result = null;
                    if (this.cursor != null) {
                        if (this.cursor.next()) {
                            int size = this.variables.size();
                            Value[] values = new Value[size];
                            for (int i = 0; i < size; ++i) {
                                values[i] = VirtuosoJdbcTripleStore.castValue(this.cursor.getObject(this.variables.get(i)));
                            }
                            return new ListBindingSet(this.variables, values);
                        }
                        this.close();
                    }
                    return result;
                }
                catch (Exception ex) {
                    if (VirtuosoJdbcTripleStore.isPartialResultException(ex)) {
                        LOGGER.debug("{} - partial results returned due to expired timeout", (Object)VirtuosoTransaction.this);
                        return null;
                    }
                    throw new QueryEvaluationException("Could not retrieve next query result", (Throwable)ex);
                }
            }
        }
    }
}

