/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore.virtuoso;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import eu.fbk.knowledgestore.triplestore.virtuoso.VirtuosoTripleTransaction;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.sql.ConnectionPoolDataSource;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.sesame2.driver.VirtuosoRepository;
import virtuoso.sesame2.driver.VirtuosoRepositoryConnection;

public final class VirtuosoTripleStore
implements TripleStore {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 1111;
    private static final String DEFAULT_USERNAME = "dba";
    private static final String DEFAULT_PASSWORD = "dba";
    private static final boolean DEFAULT_POOLING = false;
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final int DEFAULT_FETCH_SIZE = 200;
    private static final String DEFAULT_MARKER_FILENAME = "virtuoso.bulk.transaction";
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtuosoTripleStore.class);
    private final VirtuosoRepository virtuoso;
    private final FileSystem fileSystem;
    private final Path markerPath;

    public VirtuosoTripleStore(FileSystem fileSystem, @Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password) {
        this(fileSystem, host, port, username, password, null, null, null, null);
    }

    public VirtuosoTripleStore(FileSystem fileSystem, @Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password, @Nullable Boolean pooling, @Nullable Integer batchSize, @Nullable Integer fetchSize, @Nullable String markerFilename) {
        String actualMarkerFilename = (String)Objects.firstNonNull((Object)markerFilename, (Object)DEFAULT_MARKER_FILENAME);
        String actualHost = (String)Objects.firstNonNull((Object)host, (Object)DEFAULT_HOST);
        int actualPort = (Integer)Objects.firstNonNull((Object)port, (Object)1111);
        String actualUsername = (String)Objects.firstNonNull((Object)username, (Object)"dba");
        String actualPassword = (String)Objects.firstNonNull((Object)password, (Object)"dba");
        boolean actualPooling = (Boolean)Objects.firstNonNull((Object)pooling, (Object)false);
        int actualBatchSize = (Integer)Objects.firstNonNull((Object)batchSize, (Object)5000);
        int actualFetchSize = (Integer)Objects.firstNonNull((Object)fetchSize, (Object)200);
        Preconditions.checkArgument((actualPort > 0 && actualPort < 65536 ? 1 : 0) != 0);
        Preconditions.checkArgument((actualBatchSize > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((actualFetchSize > 0 ? 1 : 0) != 0);
        if (actualPooling) {
            VirtuosoConnectionPoolDataSource source = new VirtuosoConnectionPoolDataSource();
            source.setServerName(actualHost);
            source.setPortNumber(actualPort);
            source.setUser(actualUsername);
            source.setPassword(actualPassword);
            this.virtuoso = new VirtuosoRepository((ConnectionPoolDataSource)source, "sesame:nil", true);
        } else {
            String url = String.format("jdbc:virtuoso://%s:%d", actualHost, actualPort);
            this.virtuoso = new VirtuosoRepository(url, actualUsername, actualPassword, "sesame:nil", true);
        }
        this.virtuoso.setBatchSize(actualBatchSize);
        this.virtuoso.setFetchSize(actualFetchSize);
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.markerPath = new Path(actualMarkerFilename).makeQualified(fileSystem);
        LOGGER.info("VirtuosoTripleStore URL: {}", (Object)(actualHost + ":" + actualPort));
        LOGGER.info("VirtuosoTripleStore marker: {}", (Object)this.markerPath);
    }

    public void init() throws IOException {
        try {
            this.virtuoso.initialize();
        }
        catch (RepositoryException ex) {
            throw new IOException("Failed to initialize Virtuoso driver", ex);
        }
    }

    public TripleTransaction begin(boolean readOnly) throws DataCorruptedException, IOException {
        if (this.existsTransactionMarker()) {
            throw new DataCorruptedException("The triple store performed a bulk operation that didn't complete successfully.");
        }
        return new VirtuosoTripleTransaction(this, readOnly);
    }

    public void reset() throws IOException {
        VirtuosoRepositoryConnection connection = null;
        try {
            connection = (VirtuosoRepositoryConnection)this.virtuoso.getConnection();
            connection.getQuadStoreConnection().prepareCall("RDF_GLOBAL_RESET ()").execute();
        }
        catch (RepositoryException ex) {
            throw new IOException("Could not connect to Virtuoso server", ex);
        }
        catch (SQLException e) {
            throw new IOException("Something went wrong while invoking stored procedure.", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (RepositoryException re) {
                    throw new IOException("Error while closing connection.", re);
                }
            }
        }
        boolean removedTransactionMarker = this.removeTransactionMarker();
        LOGGER.info("Database reset. Transaction marker removed: " + removedTransactionMarker);
    }

    public void close() {
        try {
            this.virtuoso.shutDown();
        }
        catch (RepositoryException ex) {
            LOGGER.error("Failed to shutdown Virtuoso driver", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    VirtuosoRepository getVirtuoso() {
        return this.virtuoso;
    }

    boolean existsTransactionMarker() throws IOException {
        return false;
    }

    boolean addTransactionMarker() throws IOException {
        return false;
    }

    boolean removeTransactionMarker() throws IOException {
        return false;
    }
}

