/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore.virtuoso;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import eu.fbk.knowledgestore.triplestore.virtuoso.VirtuosoTripleStore;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import virtuoso.sesame2.driver.VirtuosoRepositoryConnection;

final class VirtuosoTripleTransaction
implements TripleTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtuosoTripleTransaction.class);
    private final VirtuosoTripleStore store;
    private final VirtuosoRepositoryConnection connection;
    private final boolean readOnly;
    private final long ts;

    VirtuosoTripleTransaction(VirtuosoTripleStore store, boolean readOnly) throws IOException {
        VirtuosoRepositoryConnection connection;
        assert (store != null);
        long ts = System.currentTimeMillis();
        try {
            connection = (VirtuosoRepositoryConnection)store.getVirtuoso().getConnection();
        }
        catch (RepositoryException ex) {
            throw new IOException("Could not connect to Virtuoso", ex);
        }
        this.store = store;
        this.connection = connection;
        this.readOnly = readOnly;
        this.ts = ts;
        try {
            connection.getQuadStoreConnection().setAutoCommit(true);
            connection.getQuadStoreConnection().setReadOnly(readOnly);
        }
        catch (Throwable ex) {
            try {
                connection.close();
            }
            catch (RepositoryException ex2) {
                LOGGER.error("Cannot close connection after begin() failure", ex);
            }
            throw new IOException("Cannot setup read-only transaction", ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " started in " + (readOnly ? "read-only" : "read-write") + " mode, " + (System.currentTimeMillis() - ts) + " ms");
        }
    }

    private void checkWritable() {
        if (this.readOnly) {
            throw new IllegalStateException("Write operation not allowed on read-only transaction");
        }
    }

    @Nullable
    private <T, E extends Exception> CloseableIteration<T, E> logClose(@Nullable CloseableIteration<T, E> iteration) {
        if (iteration == null || !LOGGER.isDebugEnabled()) {
            return iteration;
        }
        final long ts = System.currentTimeMillis();
        return new IterationWrapper<T, E>((Iteration)iteration){

            protected void handleClose() throws Exception {
                try {
                    super.handleClose();
                }
                finally {
                    LOGGER.debug("Virtuoso iteration closed after {} ms", (Object)(System.currentTimeMillis() - ts));
                }
            }
        };
    }

    public CloseableIteration<? extends Statement, ? extends Exception> get(@Nullable Resource subject, @Nullable URI predicate, @Nullable Value object, @Nullable Resource context) throws IOException, IllegalStateException {
        try {
            CloseableIteratorIteration result;
            long ts = System.currentTimeMillis();
            if (subject == null || predicate == null || object == null || context == null) {
                result = this.logClose((CloseableIteration)this.connection.getStatements(subject, predicate, object, false, new Resource[]{context}));
                LOGGER.debug("Virtuoso getStatements() iteration obtained in {} ms", (Object)(System.currentTimeMillis() - ts));
            } else {
                UnmodifiableIterator iterator = this.connection.hasStatement(subject, predicate, object, false, new Resource[]{context}) ? Collections.emptyIterator() : Iterators.singletonIterator((Object)new ContextStatementImpl(subject, predicate, object, context));
                result = new CloseableIteratorIteration(iterator);
                LOGGER.debug("Virtuoso hasStatement() evaluated in {} ms", (Object)(System.currentTimeMillis() - ts));
            }
            return result;
        }
        catch (RepositoryException re) {
            throw new IOException("Error while checking statement.", re);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> query(SelectQuery query, @Nullable BindingSet bindings, @Nullable Long timeout) throws DataCorruptedException, IOException, UnsupportedOperationException {
        TupleQuery tupleQuery;
        LOGGER.debug("Evaluating query:\n{}", (Object)query);
        try {
            tupleQuery = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, query.getString());
        }
        catch (RepositoryException ex) {
            throw new IOException("Failed to prepare SPARQL tuple query:\n" + query, ex);
        }
        catch (MalformedQueryException ex) {
            throw new UnsupportedOperationException("SPARQL query rejected as malformed by Virtuoso:\n" + query, ex);
        }
        if (bindings != null) {
            for (Binding binding : bindings) {
                tupleQuery.setBinding(binding.getName(), binding.getValue());
            }
        }
        int msTimeout = timeout == null ? 0 : timeout.intValue();
        try {
            this.connection.getQuadStoreConnection().prepareCall("set result_timeout = " + msTimeout).execute();
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to set result_timeout = " + msTimeout + " on Virtuoso JDBC connection", ex);
        }
        try {
            long ts = System.currentTimeMillis();
            CloseableIteration result = tupleQuery.evaluate();
            result = new IterationWrapper<BindingSet, QueryEvaluationException>((Iteration)result){

                public boolean hasNext() throws QueryEvaluationException {
                    try {
                        return super.hasNext();
                    }
                    catch (QueryEvaluationException ex) {
                        if (VirtuosoTripleTransaction.isPartialResultException(ex)) {
                            return false;
                        }
                        throw ex;
                    }
                }
            };
            result = this.logClose(result);
            LOGGER.debug("Virtuoso iteration obtained in {} ms", (Object)(System.currentTimeMillis() - ts));
            return result;
        }
        catch (QueryEvaluationException ex) {
            if (VirtuosoTripleTransaction.isPartialResultException(ex)) {
                return new EmptyIteration();
            }
            throw new IOException("Failed to execute query - " + ex.getMessage(), ex);
        }
    }

    public void infer(@Nullable Handler<? super Statement> handler) throws IOException, IllegalStateException {
        this.checkWritable();
        if (handler != null) {
            try {
                handler.handle(null);
            }
            catch (Throwable ex) {
                Throwables.propagateIfPossible((Throwable)ex, IOException.class);
                throw new RuntimeException(ex);
            }
        }
    }

    public void add(Statement statement) throws DataCorruptedException, IOException {
        Preconditions.checkNotNull((Object)statement);
        this.checkWritable();
        try {
            this.connection.add(statement, new Resource[0]);
        }
        catch (RepositoryException ex) {
            throw new IOException("Failed to add statement: " + statement, ex);
        }
    }

    public void add(Iterable<? extends Statement> stream) throws IOException, IllegalStateException {
        this.addBulk(stream, false);
    }

    public void addBulk(Iterable<? extends Statement> statements, boolean transaction) throws DataCorruptedException, IOException {
        Preconditions.checkNotNull(statements);
        this.checkWritable();
        try {
            if (!transaction && !this.store.existsTransactionMarker()) {
                this.store.addTransactionMarker();
                this.connection.getQuadStoreConnection().prepareCall("log_enable(2)").execute();
            }
            this.connection.add(statements, new Resource[0]);
            this.connection.commit();
        }
        catch (SQLException sqle) {
            throw new IllegalStateException("Invalid internal operation.", sqle);
        }
        catch (RepositoryException e) {
            throw new DataCorruptedException("Error while adding bulk data.", (Throwable)e);
        }
    }

    public void remove(Statement statement) throws DataCorruptedException, IOException {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0);
        this.checkWritable();
        try {
            this.connection.remove(statement, new Resource[0]);
        }
        catch (RepositoryException ex) {
            throw new IOException("Failed to remove statement: " + statement, ex);
        }
    }

    public void remove(Iterable<? extends Statement> stream) throws IOException, IllegalStateException {
        this.removeBulk(stream, false);
    }

    public void removeBulk(Iterable<? extends Statement> statements, boolean transaction) throws DataCorruptedException, IOException {
        Preconditions.checkNotNull(statements);
        this.checkWritable();
        try {
            if (!transaction && !this.store.existsTransactionMarker()) {
                this.store.addTransactionMarker();
                this.connection.getQuadStoreConnection().prepareCall("log_enable(2)").execute();
            }
            this.connection.remove(statements, new Resource[0]);
            this.connection.commit();
        }
        catch (SQLException sqle) {
            throw new IllegalStateException("Invalid internal operation.", sqle);
        }
        catch (RepositoryException e) {
            throw new DataCorruptedException("Error while adding bulk data.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void end(boolean commit) throws IOException {
        boolean committed;
        long ts;
        block19: {
            ts = System.currentTimeMillis();
            committed = false;
            try {
                if (this.readOnly) break block19;
                if (commit) {
                    try {
                        if (this.store.existsTransactionMarker()) {
                            this.connection.getQuadStoreConnection().prepareCall("log_enable(1)").execute();
                            this.store.removeTransactionMarker();
                        }
                        this.connection.commit();
                        committed = true;
                        break block19;
                    }
                    catch (Throwable ex) {
                        try {
                            if (this.store.existsTransactionMarker()) {
                                throw new DataCorruptedException("Cannot rollback! Modifications performed outside a transaction.");
                            }
                            this.connection.rollback();
                            LOGGER.debug("{} rolled back after commit failure", (Object)this);
                            throw new IOException("Failed to commit transaction (rollback forced)", ex);
                        }
                        catch (RepositoryException ex2) {
                            throw new DataCorruptedException("Failed to rollback transaction after commit failure", ex);
                        }
                    }
                }
                try {
                    this.connection.rollback();
                }
                catch (Throwable ex) {
                    throw new DataCorruptedException("Failed to rollback transaction", ex);
                }
            }
            catch (Throwable throwable) {
                try {
                    VirtuosoTripleTransaction.closeVirtuosoRepositoryConnection(this.connection);
                }
                catch (RepositoryException ex) {
                    try {
                        LOGGER.error("Failed to close connection", (Throwable)ex);
                    }
                    catch (Throwable throwable2) {
                        if (!LOGGER.isDebugEnabled()) throw throwable2;
                        long now = System.currentTimeMillis();
                        LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                        throw throwable2;
                    }
                    if (!LOGGER.isDebugEnabled()) throw throwable;
                    long now = System.currentTimeMillis();
                    LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                    throw throwable;
                }
                if (!LOGGER.isDebugEnabled()) throw throwable;
                long now = System.currentTimeMillis();
                LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                throw throwable;
            }
        }
        try {
            VirtuosoTripleTransaction.closeVirtuosoRepositoryConnection(this.connection);
        }
        catch (RepositoryException ex) {
            try {
                LOGGER.error("Failed to close connection", (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (!LOGGER.isDebugEnabled()) throw throwable;
                long now = System.currentTimeMillis();
                LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                throw throwable;
            }
            if (!LOGGER.isDebugEnabled()) return;
            long now = System.currentTimeMillis();
            LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
            return;
        }
        if (!LOGGER.isDebugEnabled()) return;
        long now = System.currentTimeMillis();
        LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
        return;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static boolean isPartialResultException(QueryEvaluationException ex) {
        return ex.getMessage() != null && ex.getMessage().contains("Returning incomplete results");
    }

    private static void closeVirtuosoRepositoryConnection(final VirtuosoRepositoryConnection connection) throws RepositoryException {
        ListenableScheduledFuture future = Data.getExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                Connection jdbcConnection = connection.getQuadStoreConnection();
                try {
                    Field field = jdbcConnection.getClass().getDeclaredField("socket");
                    field.setAccessible(true);
                    Closeable socket = (Closeable)field.get(jdbcConnection);
                    socket.close();
                    LOGGER.warn("Closed socket backing virtuoso connection");
                }
                catch (Throwable ex) {
                    LOGGER.debug("Failed to close socket backing virtuoso connection (connection class is " + jdbcConnection.getClass() + ")", ex);
                }
            }
        }, 1000L, TimeUnit.MILLISECONDS);
        try {
            connection.close();
        }
        finally {
            future.cancel(false);
        }
    }
}

