/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.datastore;

import com.google.common.base.Preconditions;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.datastore.ForwardingDataStore;
import eu.fbk.knowledgestore.datastore.ForwardingDataTransaction;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingDataStore
extends ForwardingDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingDataStore.class);
    private final DataStore delegate;

    public LoggingDataStore(DataStore delegate) {
        this.delegate = (DataStore)Preconditions.checkNotNull((Object)delegate);
        LOGGER.debug("{} configured", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected DataStore delegate() {
        return this.delegate;
    }

    @Override
    public void init() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.init();
            LOGGER.debug("{} - initialized in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.init();
        }
    }

    @Override
    public DataTransaction begin(boolean readOnly) throws IOException, IllegalStateException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            LoggingDataTransaction transaction = new LoggingDataTransaction(super.begin(readOnly));
            LOGGER.debug("{} - started in {} mode in {} ms", new Object[]{transaction, readOnly ? "read-only" : "read-write", System.currentTimeMillis() - ts});
            return transaction;
        }
        return super.begin(readOnly);
    }

    @Override
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.close();
            LOGGER.debug("{} - closed in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.close();
        }
    }

    private static final class LoggingDataTransaction
    extends ForwardingDataTransaction {
        private final DataTransaction delegate;

        LoggingDataTransaction(DataTransaction delegate) {
            this.delegate = (DataTransaction)Preconditions.checkNotNull((Object)delegate);
        }

        @Override
        protected DataTransaction delegate() {
            return this.delegate;
        }

        @Nullable
        private <T> Stream<T> logClose(@Nullable Stream<T> stream, final String name, final long ts) {
            final AtomicLong count = new AtomicLong(0L);
            final AtomicBoolean eof = new AtomicBoolean(false);
            return stream.track(count, eof).onClose(new Object[]{new Runnable(){

                @Override
                public void run() {
                    LOGGER.debug("{} - {} closed after {} ms, {} records, eof={}", new Object[]{LoggingDataTransaction.this, name, System.currentTimeMillis() - ts, count, eof});
                }
            }});
        }

        @Override
        public Stream<Record> lookup(URI type, Set<? extends URI> ids, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                String name = "lookup() result stream for " + Data.toString((Object)type, (Map)Data.getNamespaceMap()) + ", " + ids.size() + " ids" + (properties == null ? "" : ", " + properties.size() + " properties");
                long ts = System.currentTimeMillis();
                Stream<Record> result = super.lookup(type, ids, properties);
                LOGGER.debug("{} - {} obtained in {} ms", new Object[]{this, name, System.currentTimeMillis() - ts});
                return this.logClose(result, name, ts);
            }
            return super.lookup(type, ids, properties);
        }

        @Override
        public Stream<Record> retrieve(URI type, @Nullable XPath condition, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                String name = "retrieve() result stream for " + Data.toString((Object)type, (Map)Data.getNamespaceMap()) + (condition == null ? "" : ", " + condition.toString()) + (properties == null ? "" : ", " + properties.size() + " properties");
                long ts = System.currentTimeMillis();
                Stream<Record> result = super.retrieve(type, condition, properties);
                LOGGER.debug("{} - {} obtained in {} ms", new Object[]{this, name, System.currentTimeMillis() - ts});
                return this.logClose(result, name, ts);
            }
            return super.retrieve(type, condition, properties);
        }

        @Override
        public long count(URI type, @Nullable XPath condition) throws IOException, IllegalArgumentException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} - counting {}{}", new Object[]{this, Data.toString((Object)type, (Map)Data.getNamespaceMap()), condition == null ? "" : ", " + condition.toString()});
                long ts = System.currentTimeMillis();
                long result = super.count(type, condition);
                LOGGER.debug("{} - count result {} obtained in {} ms", new Object[]{this, result, System.currentTimeMillis() - ts});
                return result;
            }
            return super.count(type, condition);
        }

        @Override
        public Stream<Record> match(Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} - evaluating match: conditions={}, ids={}, properties={}", new Object[]{this, conditions, ids, properties});
                String name = "match() result stream";
                long ts = System.currentTimeMillis();
                Stream<Record> result = super.match(conditions, ids, properties);
                LOGGER.debug("{} - {} obtained in {} ms", new Object[]{this, "match() result stream", System.currentTimeMillis() - ts});
                return this.logClose(result, "match() result stream", ts);
            }
            return super.match(conditions, ids, properties);
        }

        @Override
        public void store(URI type, Record record) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                long ts = System.currentTimeMillis();
                super.store(type, record);
                LOGGER.debug("{} - {} {} stored in {} ms", new Object[]{this, Data.toString((Object)type, (Map)Data.getNamespaceMap()), record, System.currentTimeMillis() - ts});
            } else {
                super.store(type, record);
            }
        }

        @Override
        public void delete(URI type, URI id) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                long ts = System.currentTimeMillis();
                super.delete(type, id);
                LOGGER.debug("{} - {} {} deleted in {} ms", new Object[]{this, Data.toString((Object)type, (Map)Data.getNamespaceMap()), id, System.currentTimeMillis() - ts});
            } else {
                super.delete(type, id);
            }
        }

        @Override
        public void end(boolean commit) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                long ts = System.currentTimeMillis();
                super.end(commit);
                LOGGER.debug("{} - {} done in {} ms", new Object[]{this, commit ? "commit" : "rollback", System.currentTimeMillis() - ts});
            } else {
                super.end(commit);
            }
        }
    }
}

