/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.datastore.ForwardingDataStore;
import eu.fbk.knowledgestore.datastore.ForwardingDataTransaction;
import eu.fbk.knowledgestore.internal.Util;
import eu.fbk.knowledgestore.runtime.Synchronizer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SynchronizedDataStore
extends ForwardingDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedDataStore.class);
    private static final int NEW = 0;
    private static final int INITIALIZED = 1;
    private static final int CLOSED = 2;
    private final DataStore delegate;
    private final Synchronizer synchronizer;
    private final Set<DataTransaction> transactions;
    private final AtomicInteger state;

    public SynchronizedDataStore(DataStore delegate, String synchronizerSpec) {
        this(delegate, Synchronizer.create(synchronizerSpec));
    }

    public SynchronizedDataStore(DataStore delegate, Synchronizer synchronizer) {
        this.delegate = (DataStore)Preconditions.checkNotNull((Object)delegate);
        this.synchronizer = (Synchronizer)Preconditions.checkNotNull((Object)synchronizer);
        this.transactions = Sets.newHashSet();
        this.state = new AtomicInteger(0);
        LOGGER.debug("{} configured, synchronizer=", (Object)this.getClass().getSimpleName(), (Object)synchronizer);
    }

    @Override
    protected DataStore delegate() {
        return this.delegate;
    }

    private void checkState(int expected) {
        int state = this.state.get();
        if (state != expected) {
            throw new IllegalStateException("DataStore " + (state == 0 ? "not initialized" : (state == 1 ? "already initialized" : "already closed")));
        }
    }

    @Override
    public synchronized void init() throws IOException {
        this.checkState(0);
        super.init();
        this.state.set(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTransaction begin(boolean readOnly) throws IOException, IllegalStateException {
        this.checkState(1);
        this.synchronizer.beginTransaction(readOnly);
        DataTransaction transaction = null;
        try {
            SynchronizedDataStore synchronizedDataStore = this;
            synchronized (synchronizedDataStore) {
                this.checkState(1);
                transaction = this.delegate().begin(readOnly);
                transaction = new SynchronizedDataTransaction(transaction, readOnly);
                Set<DataTransaction> set = this.transactions;
                synchronized (set) {
                    this.transactions.add(transaction);
                }
            }
        }
        finally {
            if (transaction == null) {
                this.synchronizer.endTransaction(readOnly);
            }
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList transactionsToEnd;
        if (!this.state.compareAndSet(1, 2) && !this.state.compareAndSet(0, 2)) {
            return;
        }
        Set<DataTransaction> set = this.transactions;
        synchronized (set) {
            transactionsToEnd = Lists.newArrayList(this.transactions);
        }
        try {
            for (DataTransaction transaction : transactionsToEnd) {
                try {
                    LOGGER.warn("Forcing rollback of DataTransaction " + transaction + "due to closure of DataStore");
                    transaction.end(false);
                }
                catch (Throwable ex) {
                    LOGGER.error("Exception caught while ending DataTransaction " + transaction + "(rollback assumed): " + ex.getMessage(), ex);
                }
            }
        }
        finally {
            super.close();
        }
    }

    private final class SynchronizedDataTransaction
    extends ForwardingDataTransaction {
        private final DataTransaction delegate;
        private final List<WeakReference<Stream<?>>> streams;
        private final boolean readOnly;
        private final AtomicBoolean ended;

        SynchronizedDataTransaction(DataTransaction delegate, boolean readOnly) {
            this.delegate = (DataTransaction)Preconditions.checkNotNull((Object)delegate);
            this.streams = Lists.newArrayList();
            this.readOnly = readOnly;
            this.ended = new AtomicBoolean(false);
        }

        @Override
        protected DataTransaction delegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends Stream<?>> T registerStream(@Nullable T stream) {
            List<WeakReference<Stream<?>>> list = this.streams;
            synchronized (list) {
                if (stream == null) {
                    return null;
                }
                if (this.ended.get()) {
                    Util.closeQuietly(stream);
                } else {
                    int size = this.streams.size();
                    for (int i = size - 1; i >= 0; --i) {
                        if (this.streams.get(i).get() != null) continue;
                        this.streams.remove(i);
                    }
                    this.streams.add(new WeakReference<T>(stream));
                }
            }
            return stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeStreams() {
            List<WeakReference<Stream<?>>> list = this.streams;
            synchronized (list) {
                int size = this.streams.size();
                for (int i = size - 1; i >= 0; --i) {
                    Util.closeQuietly(this.streams.remove(i).get());
                }
            }
        }

        private void checkState() {
            if (this.ended.get()) {
                throw new IllegalStateException("DataTransaction already ended");
            }
        }

        private void checkWritable() {
            if (this.readOnly) {
                throw new IllegalStateException("DataTransaction is read-only");
            }
        }

        @Override
        public synchronized Stream<Record> lookup(URI type, Set<? extends URI> ids, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            this.checkState();
            return this.registerStream(super.lookup(type, ids, properties));
        }

        @Override
        public synchronized Stream<Record> retrieve(URI type, @Nullable XPath condition, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            this.checkState();
            return this.registerStream(super.retrieve(type, condition, properties));
        }

        @Override
        public synchronized long count(URI type, @Nullable XPath condition) throws IOException, IllegalArgumentException, IllegalStateException {
            this.checkState();
            return super.count(type, condition);
        }

        @Override
        public Stream<Record> match(Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws IOException, IllegalStateException {
            this.checkState();
            return this.registerStream(super.match(conditions, ids, properties));
        }

        @Override
        public void store(URI type, Record record) throws IOException, IllegalStateException {
            this.checkState();
            this.checkWritable();
            super.store(type, record);
        }

        @Override
        public void delete(URI type, URI id) throws IOException, IllegalStateException {
            this.checkState();
            this.checkWritable();
            super.delete(type, id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void end(boolean commit) throws IOException, IllegalStateException {
            if (!this.ended.compareAndSet(false, true)) {
                return;
            }
            this.closeStreams();
            SynchronizedDataStore.this.synchronizer.beginCommit();
            try {
                super.end(commit);
            }
            finally {
                SynchronizedDataStore.this.synchronizer.endCommit();
                SynchronizedDataStore.this.synchronizer.endTransaction(this.readOnly);
                Set set = SynchronizedDataStore.this.transactions;
                synchronized (set) {
                    SynchronizedDataStore.this.transactions.remove(this);
                }
            }
        }
    }
}

