/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.filestore;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.filestore.FileExistsException;
import eu.fbk.knowledgestore.filestore.FileMissingException;
import eu.fbk.knowledgestore.filestore.FileStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileStore
implements FileStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileStore.class);
    private static final String DEFAULT_PATH = "files";
    private final FileSystem fileSystem;
    private final Path rootPath;

    public HadoopFileStore(FileSystem fileSystem, @Nullable String path) {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.rootPath = new Path((String)Objects.firstNonNull((Object)path, (Object)DEFAULT_PATH)).makeQualified(this.fileSystem);
        LOGGER.info("{} configured, path={}", (Object)this.getClass().getSimpleName(), (Object)this.rootPath);
    }

    @Override
    public void init() throws IOException {
        if (!this.fileSystem.exists(this.rootPath)) {
            this.fileSystem.mkdirs(this.rootPath);
        }
    }

    @Override
    public InputStream read(String fileName) throws FileMissingException, IOException {
        Path path = this.getFullPath(fileName);
        try {
            FSDataInputStream stream = this.fileSystem.open(path);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reading file " + this.getRelativePath(path));
            }
            return stream;
        }
        catch (IOException ex) {
            if (!this.fileSystem.exists(path)) {
                throw new FileMissingException(fileName, "Cannot read non-existing file");
            }
            throw ex;
        }
    }

    @Override
    public OutputStream write(String fileName) throws FileExistsException, IOException {
        Path path = this.getFullPath(fileName);
        try {
            FSDataOutputStream stream = this.fileSystem.create(path, false);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating file " + this.getRelativePath(path));
            }
            return stream;
        }
        catch (IOException ex) {
            if (this.fileSystem.exists(path)) {
                throw new FileExistsException(fileName, "Cannot overwrite file");
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String fileName) throws FileMissingException, IOException {
        Path path = this.getFullPath(fileName);
        boolean deleted = false;
        try {
            deleted = this.fileSystem.delete(path, false);
        }
        finally {
            if (!deleted && !this.fileSystem.exists(path)) {
                throw new FileMissingException(fileName, "Cannot delete non-existing file.");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted file " + this.getRelativePath(path));
        }
    }

    @Override
    public Stream<String> list() throws IOException {
        return Stream.create((Iterator)((Object)new HadoopIterator()));
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private Path getFullPath(String fileName) {
        String typeDirectory = ((String)Objects.firstNonNull((Object)Data.extensionToMimeType((String)fileName), (Object)"application/octet-stream")).replace('/', '_');
        String bucketDirectory = Data.hash((Object[])new Object[]{fileName}).substring(0, 2);
        return new Path(this.rootPath, typeDirectory + "/" + bucketDirectory + "/" + fileName);
    }

    private String getRelativePath(Path path) {
        return path.toString().substring(this.rootPath.toString().length());
    }

    private class HadoopIterator
    extends AbstractIterator<String> {
        private final FileStatus[] typeDirectories;
        private FileStatus[] bucketDirectories;
        private FileStatus[] files;
        private int typeIndex;
        private int bucketIndex;
        private int fileIndex;

        HadoopIterator() throws IOException {
            this.typeDirectories = HadoopFileStore.this.fileSystem.listStatus(HadoopFileStore.this.rootPath);
            this.bucketDirectories = new FileStatus[0];
            this.files = new FileStatus[0];
        }

        protected String computeNext() {
            try {
                while (true) {
                    FileStatus typeDirectory;
                    if (this.fileIndex < this.files.length) {
                        FileStatus file;
                        if ((file = this.files[this.fileIndex++]).isDir()) continue;
                        return file.getPath().getName();
                    }
                    if (this.bucketIndex < this.bucketDirectories.length) {
                        FileStatus bucketDirectory;
                        if (!(bucketDirectory = this.bucketDirectories[this.bucketIndex++]).isDir()) continue;
                        this.files = HadoopFileStore.this.fileSystem.listStatus(bucketDirectory.getPath());
                        this.fileIndex = 0;
                        continue;
                    }
                    if (this.typeIndex >= this.typeDirectories.length) break;
                    if (!(typeDirectory = this.typeDirectories[this.typeIndex++]).isDir()) continue;
                    this.bucketDirectories = HadoopFileStore.this.fileSystem.listStatus(typeDirectory.getPath());
                    this.bucketIndex = 0;
                }
                return (String)this.endOfData();
            }
            catch (Throwable ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
    }
}

