/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.DefaultParanamer;
import com.thoughtworks.paranamer.Paranamer;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.XPath;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public final class Factory {
    private static final String SCHEME = "java:";
    private static final Paranamer PARANAMER = new CachingParanamer((Paranamer)new AdaptiveParanamer(new Paranamer[]{new DefaultParanamer(), new BytecodeReadingParanamer()}));
    private static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{[^\\}]+\\}");

    public static Map<URI, Object> instantiate(Iterable<? extends Statement> model, URI ... ids) {
        Value o;
        LinkedHashMap types = Maps.newLinkedHashMap();
        ArrayListMultimap stmt = ArrayListMultimap.create();
        for (Statement statement : model) {
            Resource s = statement.getSubject();
            URI p = statement.getPredicate();
            o = statement.getObject();
            if (p.equals((Object)RDF.TYPE) && o instanceof URI && o.stringValue().startsWith(SCHEME)) {
                types.put(s, (URI)o);
                continue;
            }
            if (!p.stringValue().startsWith(SCHEME)) continue;
            stmt.put((Object)s, (Object)statement);
        }
        if (ids != null && ids.length > 0) {
            int n;
            HashSet subjs = Sets.newHashSet((Object[])ids);
            do {
                n = subjs.size();
                for (Statement statement : stmt.values()) {
                    o = statement.getObject();
                    if (!(o instanceof Resource)) continue;
                    subjs.add((Resource)o);
                }
            } while (subjs.size() > n);
            types.keySet().retainAll(subjs);
        }
        HashMap map = Maps.newHashMap();
        while (!types.isEmpty()) {
            int n = types.size();
            for (Resource s : Lists.newArrayList(types.keySet())) {
                Collection statements = stmt.get((Object)s);
                boolean dependent = false;
                for (Statement statement : statements) {
                    Value o2 = statement.getObject();
                    if (!(o2 instanceof Resource) || !types.keySet().contains(o2)) continue;
                    dependent = true;
                    break;
                }
                if (dependent) continue;
                URI implementation = (URI)types.get(s);
                ArrayListMultimap properties = ArrayListMultimap.create();
                for (Statement statement : statements) {
                    URI p = statement.getPredicate();
                    Value o3 = statement.getObject();
                    Object obj = map.get(o3);
                    properties.put((Object)p.stringValue().substring(SCHEME.length()), obj != null ? obj : o3);
                }
                Preconditions.checkArgument((implementation != null ? 1 : 0) != 0, (String)"No implementation specified for %s", (Object[])new Object[]{s});
                map.put(s, Factory.instantiate(properties.asMap(), implementation, Object.class));
                types.remove(s);
            }
            Preconditions.checkArgument((types.size() < n ? 1 : 0) != 0, (Object)("Cannot instantiate " + stmt.keySet() + " - detected circular dependencies"));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            Resource s = (Resource)entry.getKey();
            Object obj = entry.getValue();
            if (!(s instanceof URI) || ids != null && ids.length != 0 && !Arrays.asList(ids).contains(s)) continue;
            builder.put((Object)((URI)s), obj);
        }
        return builder.build();
    }

    public static <T> T instantiate(Iterable<? extends Statement> model, URI id, Class<T> type) {
        return type.cast(Factory.instantiate(model, id).get(id));
    }

    public static <T> T instantiate(Map<String, ? extends Object> properties, URI implementation, Class<T> type) {
        Class<?> clazz;
        String uriString = implementation.stringValue();
        Preconditions.checkArgument((boolean)uriString.startsWith(SCHEME));
        int index = uriString.indexOf("#");
        String className = uriString.substring(5, index > 0 ? index : uriString.length());
        String methodName = index < 0 ? null : uriString.substring(index + 1);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("No class for " + implementation);
        }
        LinkedHashMap props = Maps.newLinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : properties.entrySet()) {
            props.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        if (clazz == Record.class) {
            Preconditions.checkArgument((boolean)type.isAssignableFrom(Record.class));
            Record record = Record.create();
            for (Map.Entry<String, ? extends Object> entry : properties.entrySet()) {
                record.set(Data.getValueFactory().createURI(SCHEME + entry.getKey()), entry.getValue(), new Object[0]);
            }
            return type.cast(record);
        }
        HashMap setters = Maps.newHashMap();
        for (Method m : clazz.getMethods()) {
            String name = m.getName();
            if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 1 || !name.startsWith("set")) continue;
            setters.put(name.substring(3).toLowerCase(), m);
        }
        HashSet hashSet = Sets.newHashSet(props.keySet());
        hashSet.removeAll(setters.keySet());
        if (methodName == null) {
            for (Constructor<?> c : clazz.getConstructors()) {
                HashSet args = Sets.newHashSet((Object[])Factory.signature(c));
                boolean acceptMap = false;
                for (int i = 0; i < c.getParameterTypes().length; ++i) {
                    acceptMap = acceptMap || c.getParameterTypes()[i].isAssignableFrom(Map.class) || c.getParameterTypes()[i].isAssignableFrom(Properties.class);
                }
                if (!args.containsAll(hashSet) && !acceptMap) continue;
                return type.cast(Factory.callSetters(Factory.callConstructor(c, props), setters, props));
            }
            throw new IllegalArgumentException("No suitable constructor for " + implementation + " supporting properties " + Joiner.on((String)", ").join(props.keySet()));
        }
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName) || !Modifier.isStatic(m.getModifiers())) continue;
            HashSet args = Sets.newHashSet((Object[])Factory.signature(m));
            if (methodName.equals("builder")) {
                Class<?> builderClazz = m.getReturnType();
                Method build = null;
                HashMap builderSetters = Maps.newHashMap();
                for (Method setter : builderClazz.getMethods()) {
                    String name = setter.getName();
                    if (name.equals("build")) {
                        build = setter;
                    }
                    if (Modifier.isStatic(setter.getModifiers()) || setter.getReturnType() != builderClazz || setter.getParameterTypes().length != 1) continue;
                    if (name.startsWith("set")) {
                        name = name.substring(3);
                    } else if (name.startsWith("with")) {
                        name = name.substring(4);
                    }
                    builderSetters.put(name.toLowerCase(), setter);
                }
                args.addAll(builderSetters.keySet());
                args.addAll(Arrays.asList(Factory.signature(build)));
                if (build == null || !args.containsAll(props.keySet())) continue;
                return type.cast(Factory.callSetters(Factory.callBuilder(m, builderSetters, build, props), setters, props));
            }
            if (!args.containsAll(props.keySet())) continue;
            return type.cast(Factory.callSetters(Factory.callMethod(m, null, props), setters, props));
        }
        throw new IllegalArgumentException("No suitable '" + methodName + "' method for " + implementation + " supporting properties " + Joiner.on((String)", ").join(props.keySet()));
    }

    private static String[] signature(AccessibleObject member) {
        String[] names = PARANAMER.lookupParameterNames(member, false);
        if (names != null) {
            names = (String[])names.clone();
            for (int i = 0; i < names.length; ++i) {
                names[i] = names[i].trim().toLowerCase();
            }
        } else if (member instanceof Constructor) {
            names = new String[((Constructor)member).getParameterTypes().length];
        } else if (member instanceof Method) {
            names = new String[((Method)member).getParameterTypes().length];
        } else {
            throw new Error("Unexpected member " + member);
        }
        return names;
    }

    private static Object callConstructor(Constructor<?> constructor, Map<String, Object> properties) {
        Type[] argTypes = constructor.getGenericParameterTypes();
        String[] argNames = Factory.signature(constructor);
        Object[] argValues = Factory.convertArgs(properties, argNames, argTypes);
        try {
            return constructor.newInstance(argValues);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Invocation of constructor '" + constructor + "' with parameters " + Arrays.asList(argValues) + " failed", ex);
        }
    }

    private static Object callMethod(Method method, Object object, Map<String, Object> properties) {
        Type[] argTypes = method.getGenericParameterTypes();
        String[] argNames = Factory.signature(method);
        Object[] argValues = Factory.convertArgs(properties, argNames, argTypes);
        try {
            return method.invoke(object, argValues);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Invocation of method '" + method + "' on object " + object + " with parameters " + Arrays.asList(argValues) + " failed", ex);
        }
    }

    private static Object callBuilder(Method builder, Map<String, Method> setters, Method build, Map<String, Object> properties) {
        Object obj = Factory.callMethod(builder, null, properties);
        Factory.callSetters(obj, setters, properties);
        return Factory.callMethod(build, obj, properties);
    }

    private static Object callSetters(Object object, Map<String, Method> setters, Map<String, Object> properties) {
        for (Map.Entry<String, Method> entry : setters.entrySet()) {
            String name = entry.getKey();
            Method setter = entry.getValue();
            Object value = properties.get(name);
            if (value == null && !properties.containsKey(name)) continue;
            Factory.callMethod(setter, object, (Map<String, Object>)ImmutableMap.of((Object)name, (Object)value));
        }
        return object;
    }

    private static Object[] convertArgs(Map<String, Object> properties, String[] names, Type[] types) {
        assert (names.length == types.length);
        int length = names.length;
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            String name = names[i];
            Type type = types[i];
            TypeToken token = TypeToken.of((Type)type);
            if (token.getRawType().isAssignableFrom(Map.class)) {
                Type valueType = ((ParameterizedType)token.getSupertype(Map.class).getType()).getActualTypeArguments()[1];
                HashMap map = Maps.newHashMapWithExpectedSize((int)properties.size());
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    map.put(entry.getKey(), Factory.convertMany(entry.getValue(), valueType));
                }
                result[i] = map;
                continue;
            }
            if (token.getRawType().isAssignableFrom(Properties.class)) {
                Properties props = new Properties();
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    try {
                        props.setProperty(entry.getKey(), (String)Factory.convertMany(entry.getValue(), String.class));
                    }
                    catch (Throwable ex) {}
                }
                result[i] = props;
                continue;
            }
            result[i] = Factory.convertMany(properties.get(name), type);
        }
        return result;
    }

    private static Object convertMany(@Nullable Object value, Type type) {
        TypeToken token = TypeToken.of((Type)type);
        Class clazz = token.getRawType();
        Type elementType = type;
        if (Iterable.class.isAssignableFrom(clazz)) {
            elementType = ((ParameterizedType)token.getSupertype(Iterable.class).getType()).getActualTypeArguments()[0];
        } else if (clazz.isArray()) {
            elementType = token.getComponentType().getType();
        }
        Class elementClass = TypeToken.of((Type)elementType).getRawType();
        ArrayList values = Lists.newArrayList();
        if (value != null) {
            if (value instanceof Iterable) {
                for (Object v : (Iterable)value) {
                    values.add(Factory.convertSingle(Factory.expand(v), elementClass));
                }
            } else if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    values.add(Factory.convertSingle(Factory.expand(Array.get(value, i)), elementClass));
                }
            } else {
                values.add(Factory.convertSingle(Factory.expand(value), elementClass));
            }
        }
        if (clazz.isAssignableFrom(List.class)) {
            return values;
        }
        if (clazz.isAssignableFrom(Set.class)) {
            return Sets.newHashSet((Iterable)values);
        }
        if (clazz.isArray()) {
            return Iterables.toArray((Iterable)values, clazz.getComponentType());
        }
        if (!values.isEmpty()) {
            return values.get(0);
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (elementClass == Byte.TYPE) {
            return (byte)0;
        }
        if (elementClass == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (elementClass == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    private static Object convertSingle(Object object, Class<?> type) {
        if (type == XPath.class) {
            return object instanceof XPath || object == null ? (XPath)object : XPath.parse((String)((String)Factory.convertSingle(object, String.class)), (Object[])new Object[0]);
        }
        return Data.convert((Object)object, type);
    }

    private static Object expand(Object object) {
        String string;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Literal) {
            string = ((Literal)object).getLabel();
        } else {
            return object;
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        Matcher matcher = PLACEHOLDER.matcher(string);
        while (matcher.find()) {
            builder.append(string.substring(index, matcher.start()));
            String property = string.substring(matcher.start() + 2, matcher.end() - 1);
            String value = System.getProperty(property);
            if (value != null) {
                if (property.equals("user.dir") || property.equals("user.home") || property.equals("java.home") || property.equals("java.io.tmpdir") || property.equals("java.ext.dirs")) {
                    value = value.replace('\\', '/');
                }
                builder.append(value);
            }
            index = matcher.end();
        }
        builder.append(string.substring(index));
        String expanded = builder.toString();
        if (object instanceof String) {
            return expanded;
        }
        Literal l = (Literal)object;
        URI dt = l.getDatatype();
        String lang = l.getLanguage();
        return dt != null ? Data.getValueFactory().createLiteral(expanded, dt) : Data.getValueFactory().createLiteral(expanded, lang);
    }
}

