/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore;

import com.google.common.base.Preconditions;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.triplestore.ForwardingTripleStore;
import eu.fbk.knowledgestore.triplestore.ForwardingTripleTransaction;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingTripleStore
extends ForwardingTripleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingTripleStore.class);
    private final TripleStore delegate;

    public LoggingTripleStore(TripleStore delegate) {
        this.delegate = (TripleStore)Preconditions.checkNotNull((Object)delegate);
        LOGGER.debug("{} configured", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected TripleStore delegate() {
        return this.delegate;
    }

    @Override
    public void init() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.init();
            LOGGER.debug("{} - initialized in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.init();
        }
    }

    @Override
    public TripleTransaction begin(boolean readOnly) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            LoggingTripleTransaction transaction = new LoggingTripleTransaction(super.begin(readOnly));
            LOGGER.debug("{} - started in {} mode in {} ms", new Object[]{transaction, readOnly ? "read-only" : "read-write", System.currentTimeMillis() - ts});
            return transaction;
        }
        return super.begin(readOnly);
    }

    @Override
    public void reset() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.reset();
            LOGGER.debug("{} - reset done in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.reset();
        }
    }

    @Override
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.close();
            LOGGER.debug("{} - closed in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.close();
        }
    }

    private static final class LoggingTripleTransaction
    extends ForwardingTripleTransaction {
        private final TripleTransaction delegate;

        LoggingTripleTransaction(TripleTransaction delegate) {
            this.delegate = (TripleTransaction)Preconditions.checkNotNull((Object)delegate);
        }

        @Override
        protected TripleTransaction delegate() {
            return this.delegate;
        }

        private String format(@Nullable Value value) {
            return value == null ? "*" : Data.toString((Object)value, (Map)Data.getNamespaceMap());
        }

        @Nullable
        private <T, E extends Exception> CloseableIteration<T, E> logClose(@Nullable CloseableIteration<T, E> iteration, final String name, final long ts) {
            return iteration == null ? null : new IterationWrapper<T, E>((Iteration)iteration){

                protected void handleClose() throws Exception {
                    try {
                        super.handleClose();
                    }
                    catch (Throwable throwable) {
                        LOGGER.debug("{} - {} closed after {} ms", new Object[]{LoggingTripleTransaction.this, name, System.currentTimeMillis() - ts});
                        throw throwable;
                    }
                    LOGGER.debug("{} - {} closed after {} ms", new Object[]{LoggingTripleTransaction.this, name, System.currentTimeMillis() - ts});
                }
            };
        }

        @Override
        public CloseableIteration<? extends Statement, ? extends Exception> get(@Nullable Resource subject, @Nullable URI predicate, @Nullable Value object, @Nullable Resource context) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                String name = "get() statement iteration for <" + this.format((Value)subject) + ", " + this.format((Value)predicate) + ", " + this.format(object) + ", " + this.format((Value)context) + ">";
                long ts = System.currentTimeMillis();
                CloseableIteration<? extends Statement, ? extends Exception> result = this.logClose(super.get(subject, predicate, object, context), name, ts);
                LOGGER.debug("{} - {} obtained in {} ms", new Object[]{this, name, System.currentTimeMillis() - ts});
                return result;
            }
            return super.get(subject, predicate, object, context);
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> query(SelectQuery query, @Nullable BindingSet bindings, Long timeout) throws IOException, UnsupportedOperationException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Evaluating query ({} bindings, {} timeout):\n{}", new Object[]{bindings == null ? 0 : bindings.size(), timeout, query});
                String name = "query() result iteration";
                long ts = System.currentTimeMillis();
                CloseableIteration<BindingSet, QueryEvaluationException> result = this.logClose(super.query(query, bindings, timeout), "query() result iteration", ts);
                LOGGER.debug("{} - {} obtained in {} ms", new Object[]{this, "query() result iteration", System.currentTimeMillis() - ts});
                return result;
            }
            return super.query(query, bindings, timeout);
        }

        @Override
        public void infer(@Nullable Handler<? super Statement> handler) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} - start materializing inferences");
                long ts = System.currentTimeMillis();
                super.infer(handler);
                LOGGER.debug("{} - inferences materialized in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
            } else {
                super.infer(handler);
            }
        }

        @Override
        public void add(Iterable<? extends Statement> statements) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                AtomicLong count = new AtomicLong();
                AtomicBoolean eof = new AtomicBoolean();
                Stream stream = Stream.create(statements).track(count, eof);
                long ts = System.currentTimeMillis();
                super.remove((Iterable<? extends Statement>)stream);
                LOGGER.debug("{} - {} statements removed in {} ms{}", new Object[]{this, count, System.currentTimeMillis() - ts, eof.get() ? ", EOF" : ""});
            } else {
                super.add(statements);
            }
        }

        @Override
        public void remove(Iterable<? extends Statement> statements) throws IOException, IllegalStateException {
            if (LOGGER.isDebugEnabled()) {
                AtomicLong count = new AtomicLong();
                AtomicBoolean eof = new AtomicBoolean();
                Stream stream = Stream.create(statements).track(count, eof);
                long ts = System.currentTimeMillis();
                super.remove((Iterable<? extends Statement>)stream);
                LOGGER.debug("{} - {} statements removed in {} ms{}", new Object[]{this, count, System.currentTimeMillis() - ts, eof.get() ? ", EOF" : ""});
            } else {
                super.remove(statements);
            }
        }

        @Override
        public void end(boolean commit) throws IOException {
            if (LOGGER.isDebugEnabled()) {
                long ts = System.currentTimeMillis();
                super.end(commit);
                LOGGER.debug("{} - {} done in {} ms", new Object[]{this, commit ? "commit" : "rollback", System.currentTimeMillis() - ts});
            } else {
                super.end(commit);
            }
        }
    }
}

