/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.internal.Util;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryTripleStore
implements TripleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryTripleStore.class);
    private final Repository repository;

    public RepositoryTripleStore(Sail sail) {
        this((Repository)new SailRepository(sail));
    }

    public RepositoryTripleStore(Repository repository) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        LOGGER.info("RepositoryTripleStore configured, backend={}", (Object)repository.getClass().getSimpleName());
    }

    @Override
    public void init() throws IOException {
        try {
            this.repository.initialize();
        }
        catch (Throwable ex) {
            throw new IOException("Could not initialize Sesame repository");
        }
    }

    @Override
    public TripleTransaction begin(boolean readOnly) throws IOException {
        return new RepositoryTripleTransaction(readOnly);
    }

    @Override
    public void reset() throws IOException {
        RepositoryConnection connection = null;
        try {
            connection = this.repository.getConnection();
            connection.clear(new Resource[0]);
            connection.clearNamespaces();
            LOGGER.info("Sesame repository successfully resetted");
        }
        catch (RepositoryException ex) {
            throw new IOException("Could not reset Sesame repository", ex);
        }
        finally {
            Util.closeQuietly((Object)connection);
        }
    }

    @Override
    public void close() {
        try {
            this.repository.shutDown();
        }
        catch (RepositoryException ex) {
            LOGGER.error("Failed to shutdown Sesame repository", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class RepositoryTripleTransaction
    implements TripleTransaction {
        private final RepositoryConnection connection;
        private final boolean readOnly;
        private final long ts;
        private boolean dirty;

        RepositoryTripleTransaction(boolean readOnly) throws IOException {
            RepositoryConnection connection;
            long ts = System.currentTimeMillis();
            try {
                connection = RepositoryTripleStore.this.repository.getConnection();
            }
            catch (RepositoryException ex) {
                throw new IOException("Could not connect to Sesame repository", ex);
            }
            this.connection = connection;
            this.readOnly = readOnly;
            this.ts = ts;
            this.dirty = false;
            try {
                connection.begin();
            }
            catch (Throwable ex) {
                Util.closeQuietly((Object)connection);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " started in " + (readOnly ? "read-only" : "read-write") + " mode, " + (System.currentTimeMillis() - ts) + " ms");
            }
        }

        private void checkWritable() {
            if (this.readOnly) {
                throw new IllegalStateException("Write operation not allowed on read-only transaction");
            }
        }

        @Nullable
        private <T, E extends Exception> CloseableIteration<T, E> logClose(@Nullable CloseableIteration<T, E> iteration) {
            if (iteration == null || !LOGGER.isDebugEnabled()) {
                return iteration;
            }
            final long ts = System.currentTimeMillis();
            return new IterationWrapper<T, E>((Iteration)iteration){

                protected void handleClose() throws Exception {
                    try {
                        super.handleClose();
                    }
                    finally {
                        LOGGER.debug("Repository iteration closed after {} ms", (Object)(System.currentTimeMillis() - ts));
                    }
                }
            };
        }

        @Override
        public CloseableIteration<? extends Statement, ? extends Exception> get(Resource subject, URI predicate, Value object, Resource context) throws IOException, IllegalStateException {
            try {
                CloseableIteratorIteration result;
                long ts = System.currentTimeMillis();
                if (subject == null || predicate == null || object == null || context == null) {
                    result = this.logClose((CloseableIteration)this.connection.getStatements(subject, predicate, object, false, new Resource[]{context}));
                    LOGGER.debug("getStatements() iteration obtained in {} ms", (Object)(System.currentTimeMillis() - ts));
                } else {
                    UnmodifiableIterator iterator = this.connection.hasStatement(subject, predicate, object, true, new Resource[]{context}) ? Iterators.emptyIterator() : Iterators.singletonIterator((Object)new ContextStatementImpl(subject, predicate, object, context));
                    result = new CloseableIteratorIteration((Iterator)iterator);
                    LOGGER.debug("hasStatement() evaluated in {} ms", (Object)(System.currentTimeMillis() - ts));
                }
                return result;
            }
            catch (RepositoryException ex) {
                throw new IOException("Error while retrieving matching statements", ex);
            }
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> query(SelectQuery query, BindingSet bindings, @Nullable Long timeout) throws IOException, UnsupportedOperationException, IllegalStateException {
            TupleQuery tupleQuery;
            LOGGER.debug("Evaluating query:\n{}", (Object)query.getString());
            try {
                tupleQuery = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, query.getString());
            }
            catch (RepositoryException ex) {
                throw new IOException("Failed to prepare SPARQL tuple query:\n" + query, ex);
            }
            catch (MalformedQueryException ex) {
                throw new UnsupportedOperationException("SPARQL query rejected as malformed by Sesame repository:\n" + query, ex);
            }
            if (bindings != null) {
                for (Binding binding : bindings) {
                    tupleQuery.setBinding(binding.getName(), binding.getValue());
                }
            }
            if (timeout != null) {
                tupleQuery.setMaxQueryTime(timeout.intValue());
            }
            long ts = System.currentTimeMillis();
            try {
                CloseableIteration result = this.logClose((CloseableIteration)tupleQuery.evaluate());
                LOGGER.debug("Query result iteration obtained in {} ms", (Object)(System.currentTimeMillis() - ts));
                return result;
            }
            catch (QueryEvaluationException ex) {
                StringBuilder builder = new StringBuilder();
                boolean emitQuery = false;
                builder.append("Query evaluation failed after ").append(System.currentTimeMillis() - ts).append(" ms");
                if (ex.getMessage() != null) {
                    builder.append("\n").append(ex.getMessage());
                    boolean bl = emitQuery = !ex.getMessage().contains(query.getString());
                }
                if (emitQuery) {
                    builder.append("\nFailed query:\n\n").append(query);
                }
                throw new IOException(builder.toString(), ex);
            }
        }

        @Override
        public void infer(Handler<? super Statement> handler) throws IOException, IllegalStateException {
            this.checkWritable();
            if (handler != null) {
                try {
                    handler.handle(null);
                }
                catch (Throwable ex) {
                    Throwables.propagateIfPossible((Throwable)ex, IOException.class);
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        public void add(Iterable<? extends Statement> statements) throws IOException, IllegalStateException {
            Preconditions.checkNotNull(statements);
            this.checkWritable();
            try {
                this.dirty = true;
                this.connection.add(statements, new Resource[0]);
            }
            catch (RepositoryException ex) {
                throw new DataCorruptedException("Error while adding statements", ex);
            }
        }

        @Override
        public void remove(Iterable<? extends Statement> statements) throws IOException, IllegalStateException {
            Preconditions.checkNotNull(statements);
            this.checkWritable();
            try {
                this.dirty = true;
                this.connection.remove(statements, new Resource[0]);
            }
            catch (RepositoryException ex) {
                throw new DataCorruptedException("Error while removing statements", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void end(boolean commit) throws DataCorruptedException, IOException, IllegalStateException {
            boolean committed;
            long ts;
            block17: {
                ts = System.currentTimeMillis();
                committed = false;
                try {
                    if (!this.dirty) break block17;
                    if (commit) {
                        try {
                            this.connection.commit();
                            committed = true;
                            break block17;
                        }
                        catch (Throwable ex) {
                            try {
                                this.connection.rollback();
                                LOGGER.debug("{} rolled back after commit failure", (Object)this);
                                throw new IOException("Failed to commit transaction (rollback forced)", ex);
                            }
                            catch (RepositoryException ex2) {
                                throw new DataCorruptedException("Failed to rollback transaction after commit failure", ex);
                            }
                        }
                    }
                    try {
                        this.connection.rollback();
                    }
                    catch (Throwable ex) {
                        throw new DataCorruptedException("Failed to rollback transaction", ex);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.connection.close();
                    }
                    catch (RepositoryException ex) {
                        try {
                            LOGGER.error("Failed to close connection", (Throwable)ex);
                        }
                        catch (Throwable throwable2) {
                            if (!LOGGER.isDebugEnabled()) throw throwable2;
                            long now = System.currentTimeMillis();
                            LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                            throw throwable2;
                        }
                        if (!LOGGER.isDebugEnabled()) throw throwable;
                        long now = System.currentTimeMillis();
                        LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                        throw throwable;
                    }
                    if (!LOGGER.isDebugEnabled()) throw throwable;
                    long now = System.currentTimeMillis();
                    LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                    throw throwable;
                }
            }
            try {
                this.connection.close();
            }
            catch (RepositoryException ex) {
                try {
                    LOGGER.error("Failed to close connection", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (!LOGGER.isDebugEnabled()) throw throwable;
                    long now = System.currentTimeMillis();
                    LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                    throw throwable;
                }
                if (!LOGGER.isDebugEnabled()) return;
                long now = System.currentTimeMillis();
                LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
                return;
            }
            if (!LOGGER.isDebugEnabled()) return;
            long now = System.currentTimeMillis();
            LOGGER.debug("{} {} and closed in {} ms, tx duration {} ms", new Object[]{this, committed ? "committed" : "rolled back", now - ts, now - this.ts});
            return;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

