/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import eu.fbk.knowledgestore.data.ParseException;
import eu.fbk.knowledgestore.triplestore.SPARQLRenderer;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParserUtil;

public final class SelectQuery
implements Serializable {
    private static final long serialVersionUID = -3361485014094610488L;
    private static final Cache<String, SelectQuery> CACHE = CacheBuilder.newBuilder().softValues().build();
    private final String string;
    private final TupleExpr expression;
    @Nullable
    private final Dataset dataset;

    public static SelectQuery from(String string) throws ParseException {
        Preconditions.checkNotNull((Object)string);
        SelectQuery query = (SelectQuery)CACHE.getIfPresent((Object)string);
        if (query == null) {
            ParsedTupleQuery parsedQuery;
            try {
                parsedQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)string, null);
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException(string, "SPARQL query not in SELECT form", (Throwable)ex);
            }
            catch (MalformedQueryException ex) {
                throw new ParseException(string, "Invalid SPARQL query: " + ex.getMessage(), (Throwable)ex);
            }
            query = new SelectQuery(string, parsedQuery.getTupleExpr(), parsedQuery.getDataset());
            CACHE.put((Object)string, (Object)query);
        }
        return query;
    }

    public static SelectQuery from(TupleExpr expression, @Nullable Dataset dataset) throws ParseException {
        Preconditions.checkNotNull((Object)expression);
        try {
            String string = new SPARQLRenderer(null, true).render(expression, dataset);
            SelectQuery query = (SelectQuery)CACHE.getIfPresent((Object)string);
            if (query == null) {
                query = new SelectQuery(string, expression, dataset);
                CACHE.put((Object)string, (Object)query);
            }
            return query;
        }
        catch (Exception ex) {
            throw new ParseException(expression.toString(), "The supplied algebraic expression does not denote a valid SPARQL query", (Throwable)ex);
        }
    }

    private SelectQuery(String string, TupleExpr expression, @Nullable Dataset dataset) {
        this.string = string;
        this.expression = expression;
        this.dataset = dataset;
    }

    public String getString() {
        return this.string;
    }

    public TupleExpr getExpression() {
        return this.expression;
    }

    @Nullable
    public Dataset getDataset() {
        return this.dataset;
    }

    public SelectQuery replaceDataset(@Nullable Dataset dataset) {
        if (Objects.equal((Object)this.dataset, (Object)dataset)) {
            return this;
        }
        try {
            return SelectQuery.from(this.expression, dataset);
        }
        catch (ParseException ex) {
            throw new Error("Unexpected error - replacing dataset made the query invalid (!)", ex);
        }
    }

    public SelectQuery replaceVariables(final BindingSet bindings) {
        if (bindings.size() == 0) {
            return this;
        }
        TupleExpr newExpression = this.expression.clone();
        newExpression.visit((QueryModelVisitor)new QueryModelVisitorBase<RuntimeException>(){

            public void meet(Var var) {
                if (!var.hasValue() && bindings.hasBinding(var.getName())) {
                    Value value = bindings.getValue(var.getName());
                    var.setValue(value);
                }
            }
        });
        try {
            return SelectQuery.from(newExpression, this.dataset);
        }
        catch (ParseException ex) {
            throw new Error("Unexpected error - replacing variables made the query invalid (!)", ex);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelectQuery)) {
            return false;
        }
        SelectQuery other = (SelectQuery)object;
        return this.string.equals(other.string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public String toString() {
        return this.string;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.string);
    }

    private static final class SerializedForm {
        private final String string;

        SerializedForm(String string) {
            this.string = string;
        }

        private Object readResolve() throws ObjectStreamException {
            SelectQuery query = (SelectQuery)CACHE.getIfPresent((Object)this.string);
            if (query == null) {
                try {
                    query = SelectQuery.from(this.string);
                }
                catch (ParseException ex) {
                    throw new Error("Serialized form denotes an invalid SPARQL queries (!)", ex);
                }
            }
            return query;
        }
    }
}

