/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.internal.Util;
import eu.fbk.knowledgestore.internal.rdf.RDFUtil;
import eu.fbk.knowledgestore.runtime.Component;
import eu.fbk.knowledgestore.runtime.Factory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Launcher.class);
    private static final int EX_OK = 0;
    private static final int EX_USAGE = 64;
    private static final int EX_CONFIG = 78;
    private static final int EX_IOERR = 74;
    private static final int EX_UNAVAILABLE = 69;
    private static final String SIGNAL_SHUTDOWN = "INT";
    private static final String SIGNAL_RELOAD = "USR2";
    private static final String SIGNAL_STATUS = "STATUS";
    private static final String PROGRAM_EXECUTABLE = Launcher.retrieveProperty("launcher.executable", String.class, "ks");
    @Nullable
    private static final String PROGRAM_DESCRIPTION = Launcher.retrieveProperty("launcher.description", String.class, null);
    private static final String PROGRAM_DISCLAIMER = Launcher.retrieveResource(Launcher.class.getName().replace('.', '/') + ".disclaimer");
    private static final String PROGRAM_VERSION = Launcher.retrieveVersion();
    private static final String DEFAULT_CONFIG = Launcher.retrieveProperty("launcher.config", String.class, "config.xml");
    private static final String DEFAULT_THREAD_NAME = "worker-%02d";
    private static final int DEFAULT_THREAD_COUNT = 32;
    private static final String DEFAULT_LOG_CONFIG = Launcher.retrieveProperty("launcher.logging", String.class, "logback.xml");
    private static final String PROPERTY_LOG_CONFIG = "logConfig";
    private static final String PROPERTY_THREAD_COUNT = "threadCount";
    private static final String PROPERTY_THREAD_NAME = "threadName";
    private static final String PROPERTY_COMPONENT = "component";
    private static final URI LAUNCHER_URI = new URIImpl("obj:launcher");
    private static final int WIDTH = 80;
    private static Component component;

    public static void main(String ... args) {
        Options options = new Options();
        options.addOption("c", "config", true, "use service configuration file / classpath resource (default '" + DEFAULT_CONFIG + "')");
        options.addOption("v", "version", false, "display version and copyright information, then exit");
        options.addOption("h", "help", false, "display usage information, then exit");
        int status = 0;
        try {
            CommandLine cmd = new GnuParser().parse(options, args);
            if (cmd.hasOption("v")) {
                System.out.println(String.format("%s (FBK KnowledgeStore) %s\njava %s bit (%s) %s\n%s", PROGRAM_EXECUTABLE, PROGRAM_VERSION, System.getProperty("sun.arch.data.model"), System.getProperty("java.vendor"), System.getProperty("java.version"), PROGRAM_DISCLAIMER));
            } else if (cmd.hasOption("h")) {
                status = 64;
            } else {
                String configLocation = cmd.getOptionValue('c', DEFAULT_CONFIG);
                if (cmd.getArgList().contains("__start")) {
                    Launcher.start(configLocation);
                } else if (cmd.getArgList().contains("__stop")) {
                    Launcher.stop();
                } else {
                    Launcher.run(configLocation);
                }
            }
        }
        catch (ParseException ex) {
            System.err.println("SYNTAX ERROR: " + ex.getMessage());
            status = 64;
        }
        catch (ServiceConfigurationError ex) {
            System.err.println("INVALID CONFIGURATION: " + ex.getMessage());
            Throwables.getRootCause((Throwable)ex).printStackTrace();
            status = 78;
        }
        catch (Throwable ex) {
            System.err.print("EXECUTION FAILED: ");
            ex.printStackTrace();
            int n = status = ex instanceof IOException ? 74 : 69;
        }
        if (status == 64) {
            PrintWriter out = new PrintWriter(System.out);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printUsage(out, 80, PROGRAM_EXECUTABLE, options);
            if (PROGRAM_DESCRIPTION != null) {
                formatter.printWrapped(out, 80, "\n" + PROGRAM_DESCRIPTION.trim());
            }
            out.println("\nOptions");
            formatter.printOptions(out, 80, options, 2, 2);
            out.flush();
        }
        if (status != 0) {
            System.err.println("[exit status: " + status + "]");
        } else {
            System.out.println("[exit status: " + status + "]");
        }
        System.out.flush();
        System.err.flush();
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String configLocation) throws Throwable {
        Preconditions.checkNotNull((Object)configLocation);
        final AtomicReference<Object> pendingSignal = new AtomicReference<Object>(null);
        final Thread mainThread = Thread.currentThread();
        final ReentrantLock lock = new ReentrantLock();
        Thread shutdownHandler = new Thread("shutdown"){

            @Override
            public void run() {
                pendingSignal.set(Launcher.SIGNAL_SHUTDOWN);
                mainThread.interrupt();
                lock.lock();
                lock.unlock();
            }
        };
        final AtomicReference<Object> oldHandlerHolder = new AtomicReference<Object>(null);
        SignalHandler reloadHandler = null;
        try {
            new Signal(SIGNAL_RELOAD);
            reloadHandler = new SignalHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handle(Signal signal) {
                    String name = signal.getName();
                    try {
                        pendingSignal.compareAndSet(null, name);
                        mainThread.interrupt();
                    }
                    finally {
                        Object oldHandler = oldHandlerHolder.get();
                        if (oldHandler != null) {
                            ((SignalHandler)oldHandler).handle(signal);
                        }
                    }
                }
            };
        }
        catch (Throwable ex) {
            // empty catch block
        }
        Launcher.start(configLocation);
        lock.lock();
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHandler);
            if (reloadHandler != null) {
                try {
                    oldHandlerHolder.set(Signal.handle(new Signal(SIGNAL_RELOAD), reloadHandler));
                }
                catch (Throwable ex) {
                    reloadHandler = null;
                }
            }
            if (LOGGER.isInfoEnabled()) {
                StringBuilder builder = new StringBuilder("Issue ");
                builder.append("q\\n/SIG").append(SIGNAL_SHUTDOWN).append(" to end, ");
                String sig = reloadHandler == null ? "" : "/SIGUSR2";
                builder.append("r\\n").append(sig).append(" to reload, ");
                builder.append("i\\n").append(" to show info");
                LOGGER.info(builder.toString());
            }
            while (true) {
                try {
                    while (pendingSignal.get() == null && System.in.available() > 0) {
                        char ch = (char)System.in.read();
                        if (ch == 'q' || ch == 'Q') {
                            pendingSignal.set(SIGNAL_SHUTDOWN);
                            continue;
                        }
                        if (ch == 'r' || ch == 'R') {
                            pendingSignal.set(SIGNAL_RELOAD);
                            continue;
                        }
                        if (ch != 'i' && ch != 'I') continue;
                        pendingSignal.set(SIGNAL_STATUS);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    if (pendingSignal.get() == null) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                String signal = pendingSignal.getAndSet(null);
                if (SIGNAL_SHUTDOWN.equals(signal)) {
                    break;
                }
                if (SIGNAL_RELOAD.equals(signal)) {
                    Launcher.stop();
                    Launcher.start(configLocation);
                    continue;
                }
                if (!SIGNAL_STATUS.equals(signal)) continue;
                LOGGER.info(Launcher.status(true));
            }
        }
        finally {
            try {
                Launcher.stop();
            }
            finally {
                if (reloadHandler != null) {
                    SignalHandler oldHandler = oldHandlerHolder.get();
                    Signal.handle(new Signal(SIGNAL_RELOAD), oldHandler);
                }
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHandler);
                }
                catch (Throwable ex) {}
                try {
                    ((LoggerContext)LoggerFactory.getILoggerFactory()).stop();
                }
                catch (Throwable ex) {}
                lock.unlock();
            }
        }
    }

    private static void start(String configLocation) throws Throwable {
        Component newComponent;
        Preconditions.checkNotNull((Object)configLocation);
        if (component != null) {
            return;
        }
        InputStream stream = Launcher.retrieveURL(configLocation).openStream();
        RDFFormat format = RDFFormat.forFileName((String)configLocation);
        List config = RDFUtil.readRDF((InputStream)stream, (RDFFormat)format, (Map)Data.getNamespaceMap(), null, (boolean)false).toList();
        stream.close();
        String threadName = DEFAULT_THREAD_NAME;
        int threadCount = 32;
        String logConfig = DEFAULT_LOG_CONFIG;
        URI componentURI = null;
        for (Statement statement : config) {
            Resource s = statement.getSubject();
            URI p = statement.getPredicate();
            Value o = statement.getObject();
            if (!s.equals(LAUNCHER_URI)) continue;
            if (p.getLocalName().equals(PROPERTY_THREAD_NAME)) {
                threadName = (String)Data.convert((Object)o, String.class);
                continue;
            }
            if (p.getLocalName().equals(PROPERTY_THREAD_COUNT)) {
                threadCount = (Integer)Data.convert((Object)o, Integer.class);
                continue;
            }
            if (p.getLocalName().equals(PROPERTY_LOG_CONFIG)) {
                logConfig = (String)Data.convert((Object)o, String.class);
                continue;
            }
            if (!p.getLocalName().equals(PROPERTY_COMPONENT)) continue;
            componentURI = (URI)o;
        }
        Data.setExecutor((ScheduledExecutorService)Util.newScheduler((int)threadCount, (String)threadName, (boolean)true));
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(Launcher.retrieveURL(logConfig));
        }
        catch (JoranException je) {
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        String vendor = System.getProperty("java.vendor");
        int index = vendor.indexOf(32);
        vendor = index < 0 ? vendor : vendor.substring(0, index);
        String header = String.format("%s %s / java %s (%s) %s / %s", PROGRAM_EXECUTABLE, PROGRAM_VERSION, System.getProperty("sun.arch.data.model"), vendor, System.getProperty("java.version"), System.getProperty("os.name")).toLowerCase();
        String line = Strings.repeat((String)"-", (int)header.length());
        LOGGER.info(line);
        LOGGER.info(header);
        LOGGER.info(line);
        LOGGER.info("Using: {}", (Object)configLocation);
        LOGGER.info("Using: {}", (Object)logConfig);
        LOGGER.info("Using: {} threads", (Object)threadCount);
        try {
            newComponent = Factory.instantiate((Iterable<? extends Statement>)config, componentURI, Component.class);
        }
        catch (Throwable ex) {
            throw new ServiceConfigurationError("Configuration failed: " + ex.getMessage(), ex);
        }
        newComponent.init();
        LOGGER.info("Service started");
        component = newComponent;
    }

    private static void stop() {
        LOGGER.info("Stopping service ...");
        if (component == null) {
            return;
        }
        try {
            component.close();
            LOGGER.info("Service stopped");
        }
        catch (Throwable ex) {
            LOGGER.error("Close failed: " + ex.getMessage(), ex);
        }
        component = null;
    }

    private static String status(boolean verbose) {
        StringBuilder builder = new StringBuilder();
        builder.append(component != null ? "running" : "not running");
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        long days = uptime / 86400000L;
        long hours = uptime / 3600000L - days * 24L;
        long minutes = uptime / 60000L - (days * 24L + hours) * 60L;
        long gctime = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gctime += bean.getCollectionTime();
        }
        builder.append(", ").append(days == 0L ? "" : days + "d").append(hours == 0L ? "" : hours + "h").append(minutes).append("m uptime (").append(gctime * 100L / uptime).append("% gc)");
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        long used = heap.getUsed() + nonHeap.getUsed();
        long committed = heap.getCommitted() + nonHeap.getCommitted();
        long mb = 0x100000L;
        long max = 0L;
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            max += bean.getPeakUsage().getUsed();
        }
        builder.append("; ").append(used / 0x100000L).append("/").append(committed / 0x100000L).append("/").append(max / 0x100000L).append(" MB mem used/committed/max");
        int numThreads = ManagementFactory.getThreadMXBean().getThreadCount();
        int daemonThreads = ManagementFactory.getThreadMXBean().getDaemonThreadCount();
        int maxThreads = ManagementFactory.getThreadMXBean().getPeakThreadCount();
        long startedThreads = ManagementFactory.getThreadMXBean().getTotalStartedThreadCount();
        builder.append("; ").append(daemonThreads).append("/").append(numThreads - daemonThreads).append("/").append(maxThreads).append("/").append(startedThreads).append(" threads daemon/non-daemon/max/started");
        long[] deadlocked = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
        if (verbose || deadlocked != null) {
            ThreadInfo[] infos;
            int maxState = 10;
            int maxName = 0;
            Set<Thread> threads = Thread.getAllStackTraces().keySet();
            for (ThreadInfo info : infos = ManagementFactory.getThreadMXBean().dumpAllThreads(false, false)) {
                maxState = Math.max(maxState, info.getThreadState().toString().length());
                maxName = Math.max(maxName, info.getThreadName().length());
            }
            for (ThreadInfo info : infos) {
                String state = info.getThreadState().toString().toLowerCase();
                if (deadlocked != null) {
                    for (long id : deadlocked) {
                        if (info.getThreadId() != id) continue;
                        state = "deadlocked";
                    }
                }
                boolean daemon = false;
                boolean interrupted = false;
                for (Thread thread : threads) {
                    if (!thread.getName().equals(info.getThreadName())) continue;
                    daemon = thread.isDaemon();
                    interrupted = thread.isInterrupted();
                    break;
                }
                StackTraceElement element = null;
                StackTraceElement[] trace = info.getStackTrace();
                if (trace != null && trace.length > 0) {
                    element = trace[0];
                    for (int i = 0; i < trace.length; ++i) {
                        if (!trace[i].getClassName().startsWith("eu.fbk")) continue;
                        element = trace[i];
                        break;
                    }
                }
                builder.append(String.format("\n  %-11s  %-" + maxState + "s  %-" + maxName + "s  ", (daemon ? "" : "non-") + "daemon" + (interrupted ? "*" : ""), state, info.getThreadName()));
                builder.append(element == null ? "" : element.toString());
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveVersion() {
        String string;
        String name = "META-INF/maven/eu.fbk.knowledgestore/ks-runtime/pom.properties";
        URL url = Launcher.class.getClassLoader().getResource("META-INF/maven/eu.fbk.knowledgestore/ks-runtime/pom.properties");
        if (url == null) {
            return "devel";
        }
        InputStream stream = url.openStream();
        try {
            Properties properties = new Properties();
            properties.load(stream);
            string = properties.getProperty("version").trim();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return "unknown version";
            }
        }
        stream.close();
        return string;
    }

    private static URL retrieveURL(String name) {
        try {
            File file;
            URL url = Launcher.class.getClassLoader().getResource(name);
            if (url == null && (file = new File(name)).exists() && !file.isDirectory()) {
                url = file.toURI().toURL();
            }
            return (URL)Preconditions.checkNotNull((Object)url);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Invalid path: " + name);
        }
    }

    private static String retrieveResource(String name) {
        try {
            return Resources.toString((URL)Launcher.retrieveURL(name), (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            throw new Error("Cannot load " + name + ": " + ex.getMessage(), ex);
        }
    }

    @Nullable
    private static <T> T retrieveProperty(String property, Class<T> type, T defaultValue) {
        String value = System.getProperty(property);
        if (value != null) {
            try {
                return (T)Data.convert((Object)value, type);
            }
            catch (Throwable ex) {
                System.err.println(ex.getMessage());
            }
        }
        return defaultValue;
    }

    private Launcher() {
    }
}

