/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.internal.Util;
import eu.fbk.knowledgestore.runtime.Synchronizer;
import eu.fbk.knowledgestore.triplestore.ForwardingTripleStore;
import eu.fbk.knowledgestore.triplestore.ForwardingTripleTransaction;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedTripleStore
extends ForwardingTripleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedTripleStore.class);
    private static final int NEW = 0;
    private static final int INITIALIZED = 1;
    private static final int CLOSED = 2;
    private final TripleStore delegate;
    private final Synchronizer synchronizer;
    private final List<TripleTransaction> transactions;
    private final AtomicInteger state;

    public SynchronizedTripleStore(TripleStore delegate, String synchronizerSpec) {
        this(delegate, Synchronizer.create(synchronizerSpec));
    }

    public SynchronizedTripleStore(TripleStore delegate, Synchronizer synchronizer) {
        this.delegate = (TripleStore)Preconditions.checkNotNull((Object)delegate);
        this.synchronizer = (Synchronizer)Preconditions.checkNotNull((Object)synchronizer);
        this.transactions = Lists.newArrayList();
        this.state = new AtomicInteger(0);
        LOGGER.debug("{} configured, synchronizer={}", (Object)this.getClass().getSimpleName(), (Object)synchronizer);
    }

    @Override
    protected TripleStore delegate() {
        return this.delegate;
    }

    private void checkState(int expected) {
        int state = this.state.get();
        if (state != expected) {
            throw new IllegalStateException("TripleStore " + (state == 0 ? "not initialized" : (state == 1 ? "already initialized" : "already closed")));
        }
    }

    @Override
    public synchronized void init() throws IOException {
        this.checkState(0);
        super.init();
        this.state.set(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TripleTransaction begin(boolean readOnly) throws IOException {
        this.checkState(1);
        this.synchronizer.beginTransaction(readOnly);
        TripleTransaction transaction = null;
        try {
            SynchronizedTripleStore synchronizedTripleStore = this;
            synchronized (synchronizedTripleStore) {
                this.checkState(1);
                transaction = this.delegate().begin(readOnly);
                if (Thread.interrupted()) {
                    transaction.end(false);
                    throw new IllegalStateException("Interrupted");
                }
                transaction = new SynchronizedTripleTransaction(transaction, readOnly);
                List<TripleTransaction> list = this.transactions;
                synchronized (list) {
                    this.transactions.add(transaction);
                }
            }
        }
        finally {
            if (transaction == null) {
                this.synchronizer.endTransaction(readOnly);
            }
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        this.checkState(1);
        this.synchronizer.beginExclusive();
        try {
            SynchronizedTripleStore synchronizedTripleStore = this;
            synchronized (synchronizedTripleStore) {
                this.checkState(1);
                this.delegate().reset();
            }
        }
        finally {
            this.synchronizer.endExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList transactionsToEnd;
        if (!this.state.compareAndSet(1, 2) && !this.state.compareAndSet(0, 2)) {
            return;
        }
        List<TripleTransaction> list = this.transactions;
        synchronized (list) {
            transactionsToEnd = Lists.newArrayList(this.transactions);
        }
        try {
            for (TripleTransaction transaction : transactionsToEnd) {
                try {
                    LOGGER.warn("Forcing rollback of tx " + transaction + " due to closure of TripleStore");
                    transaction.end(false);
                }
                catch (Throwable ex) {
                    LOGGER.error("Exception caught while ending tx " + transaction + " (rollback assumed): " + ex.getMessage(), ex);
                }
            }
        }
        finally {
            super.close();
        }
    }

    private final class SynchronizedTripleTransaction
    extends ForwardingTripleTransaction {
        private final TripleTransaction delegate;
        private final List<WeakReference<CloseableIteration<?, ?>>> iterations;
        private final boolean readOnly;
        private final AtomicBoolean ended;

        SynchronizedTripleTransaction(TripleTransaction delegate, boolean readOnly) {
            this.delegate = delegate;
            this.iterations = Lists.newArrayList();
            this.readOnly = readOnly;
            this.ended = new AtomicBoolean(false);
        }

        @Override
        protected TripleTransaction delegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends CloseableIteration<?, ?>> T registerIteration(@Nullable T iteration) {
            List<WeakReference<CloseableIteration<?, ?>>> list = this.iterations;
            synchronized (list) {
                if (iteration == null) {
                    return null;
                }
                if (this.ended.get() || Thread.interrupted()) {
                    Util.closeQuietly(iteration);
                    throw new IllegalStateException("Closed / interrupted");
                }
                int size = this.iterations.size();
                for (int i = size - 1; i >= 0; --i) {
                    if (this.iterations.get(i).get() != null) continue;
                    this.iterations.remove(i);
                }
                this.iterations.add(new WeakReference<T>(iteration));
            }
            return iteration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeIterations() {
            List<WeakReference<CloseableIteration<?, ?>>> list = this.iterations;
            synchronized (list) {
                int size = this.iterations.size();
                for (int i = size - 1; i >= 0; --i) {
                    Util.closeQuietly(this.iterations.remove(i).get());
                }
            }
        }

        private void checkState() {
            if (this.ended.get()) {
                throw new IllegalStateException("DataTransaction already ended");
            }
            if (Thread.interrupted()) {
                throw new IllegalStateException("Interrupted");
            }
        }

        @Override
        public synchronized CloseableIteration<? extends Statement, ? extends Exception> get(@Nullable Resource subject, @Nullable URI predicate, @Nullable Value object, @Nullable Resource context) throws IOException, IllegalStateException {
            this.checkState();
            return this.registerIteration(super.get(subject, predicate, object, context));
        }

        @Override
        public synchronized CloseableIteration<BindingSet, QueryEvaluationException> query(SelectQuery query, @Nullable BindingSet bindings, @Nullable Long timeout) throws IOException, UnsupportedOperationException {
            this.checkState();
            return this.registerIteration(super.query(query, bindings, timeout));
        }

        @Override
        public synchronized void infer(@Nullable Handler<? super Statement> handler) throws IOException, IllegalStateException {
            this.checkState();
            super.infer(handler);
        }

        @Override
        public synchronized void add(Iterable<? extends Statement> stream) throws IOException, IllegalStateException {
            this.checkState();
            super.add(stream);
        }

        @Override
        public synchronized void remove(Iterable<? extends Statement> stream) throws IOException, IllegalStateException {
            this.checkState();
            super.remove(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void end(boolean commit) throws IOException {
            if (!this.ended.compareAndSet(false, true)) {
                return;
            }
            this.closeIterations();
            SynchronizedTripleStore.this.synchronizer.beginCommit();
            try {
                super.end(commit);
            }
            finally {
                SynchronizedTripleStore.this.synchronizer.endCommit();
                SynchronizedTripleStore.this.synchronizer.endTransaction(this.readOnly);
                List list = SynchronizedTripleStore.this.transactions;
                synchronized (list) {
                    SynchronizedTripleStore.this.transactions.remove(this);
                }
            }
        }
    }
}

