/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.datastore;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.internal.Util;
import eu.fbk.knowledgestore.internal.rdf.RDFUtil;
import eu.fbk.knowledgestore.runtime.Files;
import eu.fbk.knowledgestore.vocabulary.KS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDataStore
implements DataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryDataStore.class);
    private static final String PATH_DEFAULT = "datastore.ttl";
    private Map<URI, Map<URI, Record>> tables;
    private int revision;
    private boolean initialized;
    private boolean closed;
    private final FileSystem fileSystem;
    private final Path filePath;

    public MemoryDataStore(FileSystem fileSystem, @Nullable String path) {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.filePath = new Path((String)Objects.firstNonNull((Object)path, (Object)PATH_DEFAULT)).makeQualified(this.fileSystem);
        this.tables = Maps.newHashMap();
        this.revision = 1;
        this.initialized = false;
        this.closed = false;
        for (URI supportedType : DataStore.SUPPORTED_TYPES) {
            this.tables.put(supportedType, Maps.newLinkedHashMap());
        }
        LOGGER.info("{} configured, path={}", (Object)this.getClass().getSimpleName(), (Object)this.filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() throws IOException, IllegalStateException {
        FSDataInputStream stream;
        block4: {
            Preconditions.checkState((!this.initialized && !this.closed ? 1 : 0) != 0);
            this.initialized = true;
            stream = null;
            try {
                if (this.fileSystem.exists(this.filePath)) {
                    stream = Files.readWithBackup(this.fileSystem, this.filePath);
                    RDFFormat format = RDFFormat.forFileName((String)this.filePath.getName());
                    List records = Record.decode((Stream)RDFUtil.readRDF((InputStream)stream, (RDFFormat)format, null, null, (boolean)false), (Iterable)ImmutableSet.of((Object)KS.RESOURCE, (Object)KS.MENTION, (Object)KS.ENTITY, (Object)KS.CONTEXT), (Boolean)false).toList();
                    for (Record record : records) {
                        URI id = (URI)Preconditions.checkNotNull((Object)record.getID());
                        URI type = (URI)Preconditions.checkNotNull((Object)record.getSystemType());
                        this.tables.get(type).put(id, record);
                    }
                    LOGGER.info("{} initialized, {} records loaded", (Object)this.getClass().getSimpleName(), (Object)records.size());
                    break block4;
                }
                LOGGER.info("{} initialized, no record loaded", (Object)this.getClass().getSimpleName());
            }
            catch (Throwable throwable) {
                Util.closeQuietly(stream);
                throw throwable;
            }
        }
        Util.closeQuietly((Object)stream);
    }

    @Override
    public synchronized DataTransaction begin(boolean readOnly) throws IOException, IllegalStateException {
        Preconditions.checkState((this.initialized && !this.closed ? 1 : 0) != 0);
        return new MemoryDataTransaction(readOnly);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(Map<URI, Map<URI, Record>> tables, int revision) throws IOException {
        if (this.revision != revision) {
            throw new IOException("Commit failed due to concurrent modifications " + this.revision + ", " + revision);
        }
        FSDataOutputStream stream = null;
        try {
            stream = Files.writeWithBackup(this.fileSystem, this.filePath);
            ArrayList records = Lists.newArrayList();
            for (URI type : tables.keySet()) {
                records.addAll(tables.get(type).values());
            }
            RDFFormat format = RDFFormat.forFileName((String)this.filePath.getName());
            RDFUtil.writeRDF((OutputStream)stream, (RDFFormat)format, (Map)Data.getNamespaceMap(), null, (Stream)Record.encode((Stream)Stream.create((Iterable)records), (Iterable)ImmutableSet.of()));
            ++this.revision;
            this.tables = tables;
            LOGGER.info("MemoryDataStore updated, {} records persisted", (Object)records.size());
        }
        catch (Throwable ex) {
            try {
                LOGGER.error("MemoryDataStore update failed", ex);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(stream);
                throw throwable;
            }
            Util.closeQuietly((Object)stream);
        }
        Util.closeQuietly((Object)stream);
    }

    private class MemoryDataTransaction
    implements DataTransaction {
        private final Map<URI, Map<URI, Record>> tables;
        private final int revision;
        private final boolean readOnly;
        private boolean ended;

        MemoryDataTransaction(boolean readOnly) {
            Map tables = MemoryDataStore.this.tables;
            if (!readOnly) {
                tables = Maps.newHashMap();
                for (Map.Entry entry : MemoryDataStore.this.tables.entrySet()) {
                    tables.put(entry.getKey(), Maps.newLinkedHashMap((Map)((Map)entry.getValue())));
                }
            }
            this.tables = tables;
            this.revision = MemoryDataStore.this.revision;
            this.readOnly = readOnly;
            this.ended = false;
        }

        private Map<URI, Record> getTable(URI type) {
            Map<URI, Record> table = this.tables.get(type);
            if (table != null) {
                return table;
            }
            throw new IllegalArgumentException("Unsupported type " + type);
        }

        private Stream<Record> select(final Map<URI, Record> table, Stream<? extends URI> stream) {
            return stream.transform((Function)new Function<URI, Record>(){

                public Record apply(URI id) {
                    return (Record)table.get(id);
                }
            }, 0);
        }

        private Stream<Record> filter(Stream<Record> stream, @Nullable XPath xpath) {
            if (xpath == null) {
                return stream;
            }
            return stream.filter(xpath.asPredicate(), 0);
        }

        private Stream<Record> project(Stream<Record> stream, @Nullable Iterable<? extends URI> properties) {
            final URI[] array = properties == null ? null : (URI[])Iterables.toArray(properties, URI.class);
            return stream.transform((Function)new Function<Record, Record>(){

                public final Record apply(Record input) {
                    Record result = Record.create((Record)input, (boolean)true);
                    if (array != null) {
                        result.retain(array);
                    }
                    return result;
                }
            }, 0);
        }

        @Override
        public synchronized Stream<Record> lookup(URI type, Set<? extends URI> ids, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            Preconditions.checkState((!this.ended ? 1 : 0) != 0);
            Map<URI, Record> table = this.getTable(type);
            return this.project(this.select(table, (Stream<? extends URI>)Stream.create(ids)), properties);
        }

        @Override
        public synchronized Stream<Record> retrieve(URI type, @Nullable XPath condition, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            Preconditions.checkState((!this.ended ? 1 : 0) != 0);
            Map<URI, Record> table = this.getTable(type);
            return this.project(this.filter((Stream<Record>)Stream.create(table.values()), condition), properties);
        }

        @Override
        public synchronized long count(URI type, @Nullable XPath condition) throws IOException, IllegalArgumentException, IllegalStateException {
            Preconditions.checkState((!this.ended ? 1 : 0) != 0);
            Map<URI, Record> table = this.getTable(type);
            return this.filter((Stream<Record>)Stream.create(table.values()), condition).count();
        }

        @Override
        public Stream<Record> match(Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws IOException, IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void store(URI type, Record record) throws IOException, IllegalStateException {
            Preconditions.checkState((!this.ended ? 1 : 0) != 0);
            Preconditions.checkState((!this.readOnly ? 1 : 0) != 0);
            Preconditions.checkArgument((record.getID() != null ? 1 : 0) != 0);
            Map<URI, Record> table = this.getTable(type);
            table.put(record.getID(), Record.create((Record)record, (boolean)true));
        }

        @Override
        public void delete(URI type, URI id) throws IOException, IllegalStateException {
            Preconditions.checkState((!this.ended ? 1 : 0) != 0);
            Preconditions.checkState((!this.readOnly ? 1 : 0) != 0);
            Preconditions.checkArgument((id != null ? 1 : 0) != 0);
            Map<URI, Record> table = this.getTable(type);
            table.remove(id);
        }

        @Override
        public synchronized void end(boolean commit) throws IOException, IllegalStateException {
            if (!this.ended) {
                this.ended = true;
                if (commit && !this.readOnly) {
                    MemoryDataStore.this.update(this.tables, this.revision);
                }
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

