/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.fbk.knowledgestore.runtime.Files;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class Dictionary<T extends Serializable> {
    private static final long MAX_CLOCK_SKEW = 60000L;
    private Class<T> clazz;
    private final FileSystem fs;
    private final Path path;
    private volatile List<T> keyToObjectIndex;
    private volatile Map<T, Integer> objectToKeyIndex;
    private long lastAccessed;

    public Dictionary(Class<T> objectClass, String fileURL) throws IOException {
        Preconditions.checkNotNull(objectClass);
        Preconditions.checkNotNull((Object)fileURL);
        this.clazz = objectClass;
        this.fs = FileSystem.get((URI)URI.create(fileURL), (Configuration)new Configuration(true));
        this.path = new Path(URI.create(fileURL).getPath());
        this.keyToObjectIndex = Lists.newArrayList();
        this.objectToKeyIndex = Maps.newHashMap();
        this.reload();
    }

    public Dictionary(Class<T> objectClass, FileSystem fs, Path path) throws IOException {
        Preconditions.checkNotNull(objectClass);
        Preconditions.checkNotNull((Object)fs);
        Preconditions.checkNotNull((Object)path);
        this.clazz = objectClass;
        this.fs = fs;
        this.path = path;
        this.keyToObjectIndex = Lists.newArrayList();
        this.objectToKeyIndex = Maps.newHashMap();
        this.reload();
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    public String getDictionaryURL() {
        String base = this.fs.getUri().toString();
        String path = this.path.toString();
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return base + path;
    }

    private synchronized void reload() throws IOException {
        FileStatus stat = Files.stat(this.fs, this.path);
        if (stat == null || stat.getModificationTime() < this.lastAccessed - 60000L) {
            return;
        }
        ImmutableList.Builder keyToObjectIndexBuilder = ImmutableList.builder();
        ImmutableMap.Builder objectToKeyIndexBuilder = ImmutableMap.builder();
        ObjectInputStream stream = new ObjectInputStream((InputStream)Files.readWithBackup(this.fs, this.path));
        assert (stream != null);
        Serializable object = null;
        try {
            int size = stream.readInt();
            for (int key = 1; key <= size; ++key) {
                object = (Serializable)this.clazz.cast(stream.readObject());
                keyToObjectIndexBuilder.add((Object)object);
                objectToKeyIndexBuilder.put((Object)object, (Object)key);
            }
        }
        catch (ClassCastException ex) {
            assert (object != null);
            throw new IOException("Cannot read from " + this.path + ": found " + object.getClass().getName() + ", expected " + this.clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Cannot read from " + this.path + ": either the content is " + "malformed, or it encodes data of another dictionary using classes not " + "available in this JVM");
        }
        finally {
            stream.close();
        }
        this.keyToObjectIndex = keyToObjectIndexBuilder.build();
        this.objectToKeyIndex = objectToKeyIndexBuilder.build();
        this.lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(Iterable<T> newObjects) throws IOException {
        this.reload();
        ImmutableList keyToObjectIndex = this.keyToObjectIndex;
        ImmutableMap objectToKeyIndex = this.objectToKeyIndex;
        ArrayList missing = Lists.newArrayList();
        for (Serializable object : newObjects) {
            if (objectToKeyIndex.containsKey(object)) continue;
            missing.add(object);
        }
        if (missing.isEmpty()) {
            return;
        }
        keyToObjectIndex = ImmutableList.copyOf((Iterable)Iterables.concat(keyToObjectIndex, (Iterable)missing));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(objectToKeyIndex);
        int key = objectToKeyIndex.size();
        for (Serializable object : missing) {
            builder.put((Object)object, (Object)(++key));
        }
        objectToKeyIndex = builder.build();
        try (ObjectOutputStream stream = new ObjectOutputStream((OutputStream)Files.writeWithBackup(this.fs, this.path));){
            stream.writeInt(keyToObjectIndex.size());
            for (Serializable object : keyToObjectIndex) {
                stream.writeObject(object);
            }
        }
        this.lastAccessed = System.currentTimeMillis();
        this.keyToObjectIndex = keyToObjectIndex;
        this.objectToKeyIndex = objectToKeyIndex;
    }

    public T objectFor(int key) throws IOException, NoSuchElementException {
        return this.objectFor(key, true);
    }

    @Nullable
    public T objectFor(int key, boolean mustExist) throws IOException, NoSuchElementException {
        Preconditions.checkArgument((key > 0 ? 1 : 0) != 0, (String)"Non-positive key %d", (Object[])new Object[]{key});
        List<T> index = this.keyToObjectIndex;
        if (key > index.size()) {
            this.reload();
            index = this.keyToObjectIndex;
        }
        if (key <= index.size()) {
            return (T)((Serializable)index.get(key - 1));
        }
        if (!mustExist) {
            return null;
        }
        throw new NoSuchElementException("No object for key " + key);
    }

    public List<T> objectsFor(Iterable<? extends Integer> keys, boolean mustExist) throws IOException, NoSuchElementException {
        List<T> index = this.keyToObjectIndex;
        Iterator<? extends Integer> iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            Preconditions.checkArgument((key > 0 ? 1 : 0) != 0, (String)"Non-positive key %d", (Object[])new Object[]{key});
            if (key <= index.size()) continue;
            this.reload();
            index = this.keyToObjectIndex;
            break;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)Iterables.size(keys));
        ArrayList missing = null;
        Iterator<? extends Integer> iterator2 = keys.iterator();
        while (iterator2.hasNext()) {
            int key = iterator2.next();
            if (key <= index.size()) {
                result.add(index.get(key - 1));
                continue;
            }
            if (!mustExist) continue;
            if (missing == null) {
                missing = Lists.newArrayList();
            }
            missing.add(key);
        }
        if (missing != null) {
            throw new NoSuchElementException("No objects for keys " + Joiner.on((String)", ").join(missing));
        }
        return result;
    }

    public Integer keyFor(T object) throws IOException {
        Integer key = this.keyFor(object, true);
        assert (key != null);
        return key;
    }

    @Nullable
    public Integer keyFor(T object, boolean mayGenerate) throws IOException {
        Preconditions.checkNotNull(object);
        Integer key = this.objectToKeyIndex.get(object);
        if (key == null && mayGenerate) {
            this.update(Collections.singletonList(object));
            key = this.objectToKeyIndex.get(object);
        }
        return key;
    }

    public List<Integer> keysFor(Iterable<? extends T> objects, boolean mayGenerate) throws IOException {
        Preconditions.checkNotNull(objects);
        Map<T, Integer> index = this.objectToKeyIndex;
        ArrayList result = Lists.newArrayListWithCapacity((int)Iterables.size(objects));
        List missingObjects = null;
        List missingOffsets = null;
        for (Serializable object : objects) {
            Integer key = index.get(object);
            result.add(key);
            if (key != null) continue;
            Preconditions.checkNotNull((Object)object);
            if (missingOffsets == null) {
                missingObjects = Lists.newArrayList();
                missingOffsets = Lists.newArrayList();
            }
            assert (missingObjects != null);
            missingObjects.add(object);
            missingOffsets.add(result.size());
        }
        if (missingObjects != null && mayGenerate) {
            assert (missingOffsets != null);
            this.update(missingObjects);
            index = this.objectToKeyIndex;
            for (int i = 0; i < missingObjects.size(); ++i) {
                int offset = (Integer)missingOffsets.get(i);
                Serializable object = (Serializable)missingObjects.get(i);
                Integer key = this.objectToKeyIndex.get(object);
                result.set(offset, key);
            }
        }
        return result;
    }

    public <M extends Map<? super Integer, ? super T>> M toMap(@Nullable M map) throws IOException {
        Object actualMap = map != null ? map : Maps.newHashMap();
        this.reload();
        List<T> index = this.keyToObjectIndex;
        for (int i = 0; i < index.size(); ++i) {
            actualMap.put(i, index.get(i));
        }
        return (M)actualMap;
    }

    public <L extends List<? super T>> L toList(@Nullable L list) throws IOException {
        Object actualList = list != null ? list : Lists.newArrayList();
        this.reload();
        actualList.addAll(this.keyToObjectIndex);
        return (L)actualList;
    }
}

