/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.slf4j.LoggerFactory;

public final class Files {
    private static FileSystem rawLocalFileSystem = null;

    public static FileSystem getFileSystem(String url, Map<String, String> properties) throws IOException {
        URI uri = URI.create(url.replace('\\', '/'));
        Configuration conf = new Configuration(true);
        conf.set("fs.default.name", uri.toString());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            conf.set(name, value);
        }
        FileSystem fs = url.startsWith("file://") ? Files.getRawLocalFileSystem() : FileSystem.get((Configuration)conf);
        fs.setWorkingDirectory(new Path(uri.getPath()));
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystem getRawLocalFileSystem() {
        Class<Files> clazz = Files.class;
        synchronized (Files.class) {
            if (rawLocalFileSystem == null) {
                LoggerFactory.getLogger(Files.class).debug("You can safely ignore the following reported IOException - it's the way Hadoop people report where the Configuration is initialized )");
                Configuration conf = new Configuration(true);
                rawLocalFileSystem = new RawLocalFileSystem();
                try {
                    rawLocalFileSystem.initialize(new File(System.getProperty("user.dir")).toURI(), conf);
                }
                catch (IOException ex) {
                    throw new Error("Failed to initialize local raw filesystem (!)", ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return rawLocalFileSystem;
        }
    }

    @Nullable
    public static FSDataInputStream readWithBackup(FileSystem fs, Path path) throws IOException {
        Path backupPath;
        IOException exception;
        block8: {
            exception = null;
            try {
                FSDataInputStream result = fs.open(path);
                if (result != null) {
                    return result;
                }
            }
            catch (IOException ex) {
                exception = ex;
            }
            backupPath = new Path(path.getParent() + "/." + path.getName() + ".backup");
            try {
                FSDataInputStream result = fs.open(backupPath);
                if (result != null) {
                    return result;
                }
            }
            catch (IOException ex) {
                if (exception != null) break block8;
                exception = ex;
            }
        }
        boolean fileExists = fs.exists(path);
        boolean backupExists = fs.exists(backupPath);
        if (!fileExists && !backupExists) {
            return null;
        }
        if (exception == null) {
            exception = new IOException("Cannot read " + (fileExists ? path : Boolean.valueOf(backupExists)) + " (file reported to exist)");
        }
        throw exception;
    }

    public static FSDataOutputStream writeWithBackup(final FileSystem fs, final Path path) throws IOException {
        final Path newPath = new Path(path.getParent() + "/." + path.getName() + ".new");
        Path backupPath = new Path(path.getParent() + "/." + path.getName() + ".backup");
        Files.delete(fs, newPath);
        if (fs.exists(path)) {
            Files.delete(fs, backupPath);
            Files.rename(fs, path, backupPath);
        }
        return new FSDataOutputStream((OutputStream)fs.create(newPath), null){

            public void close() throws IOException {
                super.close();
                Files.rename(fs, newPath, path);
            }
        };
    }

    public static void delete(FileSystem fs, Path path) throws IOException {
        IOException exception = null;
        try {
            if (fs.delete(path, false)) {
                return;
            }
        }
        catch (IOException ex) {
            exception = ex;
        }
        if (fs.exists(path)) {
            throw exception != null ? exception : new IOException("Cannot delete " + path);
        }
    }

    public static void rename(FileSystem fs, Path from, Path to) throws IOException {
        if (from.equals((Object)to)) {
            return;
        }
        boolean renamed = fs.rename(from, to);
        if (!renamed) {
            String message = "Cannot rename " + from + " to " + to;
            if (fs.exists(to)) {
                message = message + ": destination already exists";
            } else if (fs.exists(from)) {
                message = message + ": source does not exist";
            }
            throw new IOException(message);
        }
    }

    @Nullable
    public static FileStatus stat(FileSystem fs, Path path) throws IOException {
        block3: {
            try {
                FileStatus status = fs.getFileStatus(path);
                if (status != null) {
                    return status;
                }
            }
            catch (IOException ex) {
                if (!fs.exists(path)) break block3;
                throw ex;
            }
        }
        return null;
    }

    private Files() {
    }
}

