/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.runtime.Dictionary;
import eu.fbk.knowledgestore.runtime.Smaz;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;

public final class Serializer {
    private static final String LANG_NS = "lang:";
    private static final int TYPE_NULL = 0;
    private static final int TYPE_LIST = 16;
    private static final int TYPE_RECORD = 32;
    private static final int TYPE_LIT_STRING = 64;
    private static final int TYPE_LIT_STRING_LANG = 128;
    private static final int TYPE_LIT_TRUE = 1;
    private static final int TYPE_LIT_FALSE = 2;
    private static final int TYPE_LIT_LONG = 3;
    private static final int TYPE_LIT_INT = 4;
    private static final int TYPE_LIT_SHORT = 5;
    private static final int TYPE_LIT_BYTE = 6;
    private static final int TYPE_LIT_DOUBLE = 7;
    private static final int TYPE_LIT_FLOAT = 8;
    private static final int TYPE_LIT_BIG_INTEGER = 9;
    private static final int TYPE_LIT_BIG_DECIMAL = 10;
    private static final int TYPE_LIT_DATETIME = 11;
    private static final int TYPE_BNODE = 48;
    private static final int TYPE_URI_PLAIN = 192;
    private static final int TYPE_URI_COMPRESSED = 12;
    private static final int TYPE_STATEMENT = 13;
    private final boolean compress;
    @Nullable
    private final Dictionary<URI> dictionary;
    private final ValueFactory factory;

    public Serializer() {
        this(false, null, null);
    }

    public Serializer(boolean compress, @Nullable Dictionary<URI> dictionary, @Nullable ValueFactory factory) {
        this.compress = compress;
        this.dictionary = dictionary;
        this.factory = (ValueFactory)Objects.firstNonNull((Object)factory, (Object)Data.getValueFactory());
    }

    public byte[] toBytes(Object object) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.toStream(stream, object);
            return stream.toByteArray();
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public Object fromBytes(byte[] bytes) {
        try {
            return this.fromStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public void toStream(OutputStream stream, Object object) throws IOException {
        if (this.compress) {
            Deflater deflater = new Deflater(9, true);
            DeflaterOutputStream compressStream = new DeflaterOutputStream(stream, deflater);
            this.writeObject(compressStream, object);
            compressStream.finish();
        } else {
            this.writeObject(stream, object);
        }
    }

    public Object fromStream(InputStream stream) throws IOException {
        if (this.compress) {
            Inflater inflater = new Inflater(true);
            InflaterInputStream compressStream = new InflaterInputStream(stream, inflater);
            return this.readObject(compressStream);
        }
        return this.readObject(stream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeObject(OutputStream stream, Object object) throws IOException {
        if (object == null) {
            this.writeHeader(stream, 0, 0);
            return;
        } else if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            int size = Iterables.size((Iterable)iterable);
            this.writeHeader(stream, 16, size);
            for (Object element : iterable) {
                this.writeObject(stream, element);
            }
            return;
        } else if (object instanceof Record) {
            Record record = (Record)object;
            this.writeHeader(stream, 32, record.getProperties().size());
            this.writeObject(stream, record.getID());
            for (URI property : record.getProperties()) {
                this.writeCompressedURI(stream, property);
                List nodes = record.get(property);
                this.writeObject(stream, nodes.size() == 1 ? nodes.get(0) : nodes);
            }
            return;
        } else if (object instanceof Literal) {
            Literal literal = (Literal)object;
            URI datatype = literal.getDatatype();
            if (datatype == null || datatype.equals((Object)XMLSchema.STRING)) {
                String language = literal.getLanguage();
                byte[] label = this.encodeString(literal.getLabel());
                if (language == null) {
                    this.writeHeader(stream, 64, label.length);
                } else {
                    this.writeHeader(stream, 128, label.length);
                    URI langURI = this.factory.createURI(LANG_NS + language);
                    this.writeCompressedURI(stream, langURI);
                }
                stream.write(label);
                return;
            } else if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                this.writeHeader(stream, literal.booleanValue() ? 1 : 2, 0);
                return;
            } else if (datatype.equals((Object)XMLSchema.LONG)) {
                this.writeHeader(stream, 3, 0);
                this.writeNumber(stream, literal.longValue());
                return;
            } else if (datatype.equals((Object)XMLSchema.INT)) {
                this.writeHeader(stream, 4, 0);
                this.writeNumber(stream, literal.longValue());
                return;
            } else if (datatype.equals((Object)XMLSchema.DOUBLE)) {
                this.writeHeader(stream, 7, 0);
                stream.write(Longs.toByteArray((long)Double.doubleToLongBits(literal.doubleValue())));
                return;
            } else if (datatype.equals((Object)XMLSchema.FLOAT)) {
                this.writeHeader(stream, 8, 0);
                stream.write(Ints.toByteArray((int)Float.floatToIntBits(literal.floatValue())));
                return;
            } else if (datatype.equals((Object)XMLSchema.SHORT)) {
                this.writeHeader(stream, 5, 0);
                this.writeNumber(stream, literal.longValue());
                return;
            } else if (datatype.equals((Object)XMLSchema.BYTE)) {
                this.writeHeader(stream, 6, 0);
                this.writeNumber(stream, literal.longValue());
                return;
            } else if (datatype.equals((Object)XMLSchema.INTEGER)) {
                this.writeHeader(stream, 9, 0);
                byte[] bytes = literal.integerValue().toByteArray();
                this.writeNumber(stream, bytes.length);
                stream.write(bytes);
                return;
            } else if (datatype.equals((Object)XMLSchema.DECIMAL)) {
                this.writeHeader(stream, 10, 0);
                byte[] bytes = this.encodeString(literal.decimalValue().toString());
                this.writeNumber(stream, bytes.length);
                stream.write(bytes);
                return;
            } else {
                if (!datatype.equals((Object)XMLSchema.DATETIME)) throw new UnsupportedOperationException("Don't know how to serialize: " + literal);
                this.writeHeader(stream, 11, 0);
                XMLGregorianCalendar calendar = literal.calendarValue();
                this.writeNumber(stream, calendar.getTimezone());
                this.writeNumber(stream, calendar.toGregorianCalendar().getTimeInMillis());
            }
            return;
        } else if (object instanceof BNode) {
            byte[] id = this.encodeString(((BNode)object).getID());
            this.writeHeader(stream, 48, id.length);
            stream.write(id);
            return;
        } else if (object instanceof URI) {
            boolean isVocabTerm;
            URI uri = (URI)object;
            boolean bl = isVocabTerm = Data.namespaceToPrefix((String)uri.getNamespace(), (Map)Data.getNamespaceMap()) != null;
            if (isVocabTerm) {
                this.writeHeader(stream, 12, 0);
                this.writeCompressedURI(stream, uri);
                return;
            } else {
                byte[] string = this.encodeString(uri.stringValue());
                this.writeHeader(stream, 192, string.length);
                stream.write(string);
            }
            return;
        } else {
            if (!(object instanceof Statement)) throw new UnsupportedOperationException("Don't know how to serialize " + object.getClass());
            Statement statement = (Statement)object;
            this.writeHeader(stream, 13, 0);
            this.writeObject(stream, statement.getSubject());
            this.writeObject(stream, statement.getPredicate());
            this.writeObject(stream, statement.getObject());
            this.writeObject(stream, statement.getContext());
        }
    }

    private void writeHeader(OutputStream stream, int type, int number) throws IOException {
        if ((type & 0xC0) != 0 && number <= 62) {
            stream.write(type | number + 1);
        } else if ((type & 0x30) != 0 && number <= 14) {
            stream.write(type | number + 1);
        } else if ((type & 0xF0) != 0) {
            stream.write(type);
            this.writeNumber(stream, number);
        } else {
            stream.write(type);
        }
    }

    private void writeCompressedURI(OutputStream stream, URI uri) throws IOException {
        if (this.dictionary != null) {
            int key = this.dictionary.keyFor(uri, true);
            this.writeNumber(stream, key);
        } else {
            String ns = uri.getNamespace();
            if (LANG_NS.equals(ns)) {
                byte[] utf8 = this.encodeString(uri.getLocalName());
                this.writeNumber(stream, utf8.length << 2 | 1);
                stream.write(utf8);
            } else {
                String prefix = Data.namespaceToPrefix((String)uri.getNamespace(), (Map)Data.getNamespaceMap());
                if (prefix != null) {
                    byte[] utf8 = this.encodeString(prefix + ":" + uri.getLocalName());
                    this.writeNumber(stream, utf8.length << 2 | 3);
                    stream.write(utf8);
                } else {
                    byte[] utf8 = this.encodeString(uri.stringValue());
                    this.writeNumber(stream, utf8.length << 1);
                    stream.write(utf8);
                }
            }
        }
    }

    private void writeNumber(OutputStream stream, long num) throws IOException {
        if (num < 0L || num > 0xFFFFFFFFFFFFFFL) {
            this.writeNumberHelper(stream, 9, 255, num);
        } else if (num <= 127L) {
            this.writeNumberHelper(stream, 1, 0, num);
        } else if (num <= 16383L) {
            this.writeNumberHelper(stream, 2, 128, num);
        } else if (num <= 0x1FFFFFL) {
            this.writeNumberHelper(stream, 3, 192, num);
        } else if (num <= 0xFFFFFFFL) {
            this.writeNumberHelper(stream, 4, 224, num);
        } else if (num <= 0x7FFFFFFFFL) {
            this.writeNumberHelper(stream, 5, 240, num);
        } else if (num <= 0x3FFFFFFFFFFL) {
            this.writeNumberHelper(stream, 6, 248, num);
        } else if (num <= 0x1FFFFFFFFFFFFL) {
            this.writeNumberHelper(stream, 7, 252, num);
        } else {
            this.writeNumberHelper(stream, 8, 254, num);
        }
    }

    private void writeNumberHelper(OutputStream stream, int len, int mask, long num) throws IOException {
        stream.write(mask | (int)(num >>> (len - 1) * 8));
        for (int i = len - 2; i >= 0; --i) {
            stream.write((int)(num >>> i * 8 & 0xFFL));
        }
    }

    private Object readObject(InputStream stream) throws IOException {
        int n;
        int type = stream.read();
        if (type < 0) {
            throw new EOFException();
        }
        int num = 0;
        if ((type & 0xC0) != 0) {
            n = type & 0x3F;
            num = n > 0 ? n - 1 : (int)this.readNumber(stream);
            type &= 0xC0;
        } else if ((type & 0x30) != 0) {
            n = type & 0xF;
            num = n > 0 ? n - 1 : (int)this.readNumber(stream);
            type &= 0x30;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 16: {
                ArrayList list = Lists.newArrayListWithCapacity((int)num);
                for (int i = 0; i < num; ++i) {
                    list.add(this.readObject(stream));
                }
                return list;
            }
            case 32: {
                Record record = Record.create();
                record.setID((URI)this.readObject(stream));
                for (int i = 0; i < num; ++i) {
                    URI property = this.readCompressedURI(stream);
                    Object value = this.readObject(stream);
                    record.set(property, value, new Object[0]);
                }
                return record;
            }
            case 48: {
                String bnodeID = this.decodeString(this.readBytes(stream, num));
                return this.factory.createBNode(bnodeID);
            }
            case 12: {
                return this.readCompressedURI(stream);
            }
            case 192: {
                String uriString = this.decodeString(this.readBytes(stream, num));
                return this.factory.createURI(uriString);
            }
            case 64: {
                String plainLabel = this.decodeString(this.readBytes(stream, num));
                return this.factory.createLiteral(plainLabel);
            }
            case 128: {
                String lang = this.readCompressedURI(stream).getLocalName();
                String label = this.decodeString(this.readBytes(stream, num));
                return this.factory.createLiteral(label, lang);
            }
            case 1: {
                return this.factory.createLiteral(true);
            }
            case 2: {
                return this.factory.createLiteral(false);
            }
            case 3: {
                long longVal = this.readNumber(stream);
                return this.factory.createLiteral(longVal);
            }
            case 4: {
                int intVal = (int)this.readNumber(stream);
                return this.factory.createLiteral(intVal);
            }
            case 5: {
                short shortVal = (short)this.readNumber(stream);
                return this.factory.createLiteral(shortVal);
            }
            case 6: {
                byte byteVal = (byte)this.readNumber(stream);
                return this.factory.createLiteral(byteVal);
            }
            case 7: {
                byte[] doubleBytes = this.readBytes(stream, 8);
                double doubleVal = Double.longBitsToDouble(Longs.fromByteArray((byte[])doubleBytes));
                return this.factory.createLiteral(doubleVal);
            }
            case 8: {
                byte[] floatBytes = this.readBytes(stream, 4);
                float floatVal = Float.intBitsToFloat(Ints.fromByteArray((byte[])floatBytes));
                return this.factory.createLiteral(floatVal);
            }
            case 9: {
                int bigintLen = (int)this.readNumber(stream);
                String bigintVal = new BigInteger(this.readBytes(stream, bigintLen)).toString();
                return this.factory.createLiteral(bigintVal, XMLSchema.INTEGER);
            }
            case 10: {
                int bigdecLen = (int)this.readNumber(stream);
                String bigdecVal = this.decodeString(this.readBytes(stream, bigdecLen));
                return this.factory.createLiteral(bigdecVal, XMLSchema.DECIMAL);
            }
            case 11: {
                int tz = (int)this.readNumber(stream);
                long millis = this.readNumber(stream);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeInMillis(millis);
                calendar.setTimeZone(TimeZone.getTimeZone(String.format("GMT%s%02d:%02d", tz >= 0 ? "+" : "-", Math.abs(tz) / 60, Math.abs(tz) % 60)));
                return this.factory.createLiteral(Data.getDatatypeFactory().newXMLGregorianCalendar(calendar));
            }
            case 13: {
                Resource subj = (Resource)this.readObject(stream);
                URI pred = (URI)this.readObject(stream);
                Value obj = (Value)this.readObject(stream);
                Resource ctx = (Resource)this.readObject(stream);
                return ctx == null ? this.factory.createStatement(subj, pred, obj) : this.factory.createStatement(subj, pred, obj, ctx);
            }
        }
        throw new UnsupportedOperationException("Don't know how to deserialize type " + type);
    }

    private byte[] readBytes(InputStream stream, int length) throws IOException {
        byte[] bytes = new byte[length];
        ByteStreams.readFully((InputStream)stream, (byte[])bytes);
        return bytes;
    }

    private URI readCompressedURI(InputStream stream) throws IOException {
        if (this.dictionary != null) {
            int key = (int)this.readNumber(stream);
            return this.dictionary.objectFor(key);
        }
        int header = (int)this.readNumber(stream);
        if ((header & 1) == 0) {
            String string = this.decodeString(this.readBytes(stream, header >> 1));
            return this.factory.createURI(string);
        }
        String string = this.decodeString(this.readBytes(stream, header >> 2));
        return (header & 3) == 1 ? this.factory.createURI(LANG_NS, string) : (URI)Data.parseValue((String)string, (Map)Data.getNamespaceMap());
    }

    private long readNumber(InputStream stream) throws IOException {
        int b = stream.read();
        if (b < 0) {
            throw new EOFException();
        }
        if (b <= 127) {
            return this.readNumberHelper(stream, 1, b & 0x7F);
        }
        if (b <= 191) {
            return this.readNumberHelper(stream, 2, b & 0x3F);
        }
        if (b <= 223) {
            return this.readNumberHelper(stream, 3, b & 0x1F);
        }
        if (b <= 239) {
            return this.readNumberHelper(stream, 4, b & 0xF);
        }
        if (b <= 247) {
            return this.readNumberHelper(stream, 5, b & 7);
        }
        if (b <= 251) {
            return this.readNumberHelper(stream, 6, b & 3);
        }
        if (b <= 253) {
            return this.readNumberHelper(stream, 7, b & 1);
        }
        if (b <= 255) {
            return this.readNumberHelper(stream, 8, b & 0);
        }
        return this.readNumberHelper(stream, 9, b & 0);
    }

    private long readNumberHelper(InputStream stream, int len, int start) throws IOException {
        long num = start;
        for (int i = 1; i < len; ++i) {
            int c = stream.read();
            if (c < 0) {
                throw new EOFException();
            }
            num = num << 8 | (long)(c & 0xFF);
        }
        return num;
    }

    private byte[] encodeString(String string) {
        return Smaz.compress(string);
    }

    private String decodeString(byte[] bytes) {
        return Smaz.decompress(bytes);
    }
}

