/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.filestore;

import com.google.common.base.Preconditions;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.filestore.FileExistsException;
import eu.fbk.knowledgestore.filestore.FileMissingException;
import eu.fbk.knowledgestore.filestore.FileStore;
import eu.fbk.knowledgestore.filestore.ForwardingFileStore;
import eu.fbk.knowledgestore.internal.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFileStore
extends ForwardingFileStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFileStore.class);
    private final FileStore delegate;

    public LoggingFileStore(FileStore delegate) {
        this.delegate = (FileStore)Preconditions.checkNotNull((Object)delegate);
        LOGGER.debug("{} configured", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected FileStore delegate() {
        return this.delegate;
    }

    @Nullable
    private <T> Stream<T> logClose(@Nullable Stream<T> stream, final String name, final long ts) {
        final AtomicLong count = new AtomicLong(0L);
        final AtomicBoolean eof = new AtomicBoolean(false);
        return stream.track(count, eof).onClose(new Object[]{new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("{} - {} closed after {} ms, {} files, eof={}", new Object[]{LoggingFileStore.this, name, System.currentTimeMillis() - ts, count, eof});
            }
        }});
    }

    @Override
    public void init() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.init();
            LOGGER.debug("{} - initialized in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.init();
        }
    }

    @Override
    public InputStream read(final String filename) throws FileMissingException, IOException {
        if (LOGGER.isDebugEnabled()) {
            final long ts = System.currentTimeMillis();
            InputStream result = Util.interceptClose((InputStream)super.read(filename), (Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.debug("{} - {} input stream closed in {} ms", new Object[]{LoggingFileStore.this, filename, System.currentTimeMillis() - ts});
                }
            });
            LOGGER.debug("{} - {} opened for read in {} ms", new Object[]{this, filename, System.currentTimeMillis() - ts});
            return result;
        }
        return super.read(filename);
    }

    @Override
    public OutputStream write(final String filename) throws FileExistsException, IOException {
        if (LOGGER.isDebugEnabled()) {
            final long ts = System.currentTimeMillis();
            OutputStream result = Util.interceptClose((OutputStream)super.write(filename), (Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.debug("{} - {} output stream closed in {} ms", new Object[]{LoggingFileStore.this, filename, System.currentTimeMillis() - ts});
                }
            });
            LOGGER.debug("{} - {} opened for write in {} ms", new Object[]{this, filename, System.currentTimeMillis() - ts});
            return result;
        }
        return super.write(filename);
    }

    @Override
    public void delete(String filename) throws FileMissingException, IOException {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.delete(filename);
            LOGGER.debug("{} - {} deleted in {} ms", new Object[]{this, filename, System.currentTimeMillis() - ts});
        } else {
            super.delete(filename);
        }
    }

    @Override
    public Stream<String> list() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            String name = "list() result stream";
            long ts = System.currentTimeMillis();
            Stream<String> result = this.logClose(super.list(), "list() result stream", ts);
            LOGGER.debug("{} - {} obtained in {} ms", new Object[]{this, "list() result stream", System.currentTimeMillis() - ts});
            return result;
        }
        return super.list();
    }

    @Override
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            long ts = System.currentTimeMillis();
            super.close();
            LOGGER.debug("{} - closed in {} ms", (Object)this, (Object)(System.currentTimeMillis() - ts));
        } else {
            super.close();
        }
    }
}

