/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.server;

import com.google.common.base.Preconditions;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.openrdf.model.BNode;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.IncompatibleOperationException;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.DescribeOperator;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.iterator.DescribeIteration;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.BaseDeclProcessor;
import org.openrdf.query.parser.sparql.BlankNodeVarProcessor;
import org.openrdf.query.parser.sparql.DatasetDeclProcessor;
import org.openrdf.query.parser.sparql.StringEscapesProcessor;
import org.openrdf.query.parser.sparql.TupleExprBuilder;
import org.openrdf.query.parser.sparql.WildcardProjectionProcessor;
import org.openrdf.query.parser.sparql.ast.ASTAskQuery;
import org.openrdf.query.parser.sparql.ast.ASTConstructQuery;
import org.openrdf.query.parser.sparql.ast.ASTDescribeQuery;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;
import org.openrdf.query.parser.sparql.ast.ASTPrefixDecl;
import org.openrdf.query.parser.sparql.ast.ASTQName;
import org.openrdf.query.parser.sparql.ast.ASTQuery;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTSelectQuery;
import org.openrdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.openrdf.query.parser.sparql.ast.Node;
import org.openrdf.query.parser.sparql.ast.ParseException;
import org.openrdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import org.openrdf.query.parser.sparql.ast.SyntaxTreeBuilderVisitor;
import org.openrdf.query.parser.sparql.ast.TokenMgrError;
import org.openrdf.query.parser.sparql.ast.VisitorException;

final class SparqlHelper {
    SparqlHelper() {
    }

    static ParsedQuery parse(String queryStr, String baseURI) throws MalformedQueryException {
        try {
            ASTQueryContainer qc = SyntaxTreeBuilder.parseQuery((String)queryStr);
            StringEscapesProcessor.process((ASTOperationContainer)qc);
            BaseDeclProcessor.process((ASTOperationContainer)qc, (String)baseURI);
            Map<String, String> prefixes = SparqlHelper.parseHelper((ASTOperationContainer)qc);
            WildcardProjectionProcessor.process((ASTQueryContainer)qc);
            BlankNodeVarProcessor.process((ASTOperationContainer)qc);
            if (qc.containsQuery()) {
                ParsedTupleQuery query;
                TupleExpr tupleExpr;
                TupleExprBuilder tupleExprBuilder = new TupleExprBuilder(Data.getValueFactory());
                try {
                    tupleExpr = (TupleExpr)qc.jjtAccept((SyntaxTreeBuilderVisitor)tupleExprBuilder, null);
                }
                catch (VisitorException e) {
                    throw new MalformedQueryException(e.getMessage(), (Throwable)e);
                }
                ASTQuery queryNode = qc.getQuery();
                if (queryNode instanceof ASTSelectQuery) {
                    query = new ParsedTupleQuery(queryStr, tupleExpr);
                } else if (queryNode instanceof ASTConstructQuery) {
                    query = new ParsedGraphQuery(queryStr, tupleExpr, prefixes);
                } else if (queryNode instanceof ASTAskQuery) {
                    query = new ParsedBooleanQuery(queryStr, tupleExpr);
                } else if (queryNode instanceof ASTDescribeQuery) {
                    query = new ParsedGraphQuery(queryStr, tupleExpr, prefixes);
                } else {
                    throw new RuntimeException("Unexpected query type: " + queryNode.getClass());
                }
                Dataset dataset = DatasetDeclProcessor.process((ASTOperationContainer)qc);
                if (dataset != null) {
                    query.setDataset(dataset);
                }
                return query;
            }
            throw new IncompatibleOperationException("supplied string is not a query operation");
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, String> parseHelper(ASTOperationContainer qc) throws MalformedQueryException {
        List prefixDeclList = qc.getPrefixDeclList();
        LinkedHashMap<String, String> prefixMap = new LinkedHashMap<String, String>();
        for (ASTPrefixDecl prefixDecl : prefixDeclList) {
            String prefix = prefixDecl.getPrefix();
            String iri = prefixDecl.getIRI().getValue();
            if (prefixMap.containsKey(prefix)) {
                throw new MalformedQueryException("Multiple prefix declarations for prefix '" + prefix + "'");
            }
            prefixMap.put(prefix, iri);
        }
        QNameProcessor visitor = new QNameProcessor(prefixMap);
        try {
            qc.jjtAccept((SyntaxTreeBuilderVisitor)visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
        return prefixMap;
    }

    static CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TripleTransaction transaction, TupleExpr expr, @Nullable Dataset dataset, @Nullable BindingSet bindings, @Nullable Long timeout) throws QueryEvaluationException {
        Preconditions.checkNotNull((Object)transaction);
        final AtomicBoolean delegate = new AtomicBoolean(false);
        expr.visit((QueryModelVisitor)new QueryModelVisitorBase<RuntimeException>(){

            public void meet(StatementPattern node) throws RuntimeException {
                delegate.set(true);
            }
        });
        EvaluationStrategyImpl strategy = delegate.get() ? new DelegatingEvaluationStrategy(transaction, dataset, timeout, false) : new LocalEvaluationStrategy(transaction, dataset, timeout);
        return strategy.evaluate(expr, bindings != null ? bindings : EmptyBindingSet.getInstance());
    }

    private static Value skolemize(Value value) {
        return value instanceof BNode ? Data.getValueFactory().createURI("bnode:", ((BNode)value).getID()) : value;
    }

    private static BindingSet skolemize(BindingSet bindings) {
        QueryBindingSet result = new QueryBindingSet();
        for (String name : bindings.getBindingNames()) {
            result.setBinding(name, SparqlHelper.skolemize(bindings.getValue(name)));
        }
        return result;
    }

    private static CloseableIteration<BindingSet, QueryEvaluationException> skolemize(CloseableIteration<BindingSet, QueryEvaluationException> iter) {
        return new ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException>(iter){

            protected BindingSet convert(BindingSet bindings) throws QueryEvaluationException {
                return SparqlHelper.skolemize(bindings);
            }
        };
    }

    private static Value deskolemize(Value value) {
        URI uri;
        if (value instanceof URI && (uri = (URI)value).getNamespace().equals("bnode:")) {
            return Data.getValueFactory().createBNode(uri.getLocalName());
        }
        return value;
    }

    @Nullable
    private static BindingSet deskolemize(@Nullable BindingSet bindings) {
        QueryBindingSet result = new QueryBindingSet();
        for (String name : bindings.getBindingNames()) {
            result.setBinding(name, SparqlHelper.deskolemize(bindings.getValue(name)));
        }
        return result;
    }

    private static CloseableIteration<BindingSet, QueryEvaluationException> deskolemize(CloseableIteration<BindingSet, QueryEvaluationException> iter) {
        return new ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException>(iter){

            protected BindingSet convert(BindingSet bindings) throws QueryEvaluationException {
                return SparqlHelper.deskolemize(bindings);
            }
        };
    }

    private static class QNameProcessor
    extends ASTVisitorBase {
        private final Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setPrefixDeclarations(this.prefixMap);
            return super.visit(node, data);
        }

        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace = this.prefixMap.get(prefix);
            if (namespace == null) {
                namespace = (String)Data.getNamespaceMap().get(prefix);
            }
            if (namespace == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            localName = this.processEscapesAndHex(localName);
            ASTIRI iriNode = new ASTIRI(44);
            iriNode.setValue(namespace + localName);
            qnameNode.jjtReplaceWith((Node)iriNode);
            return null;
        }

        private String processEscapesAndHex(String localName) {
            StringBuffer unencoded = new StringBuffer();
            Pattern hexPattern = Pattern.compile("([^\\\\]|^)(%[A-F\\d][A-F\\d])", 2);
            Matcher m = hexPattern.matcher(localName);
            boolean result = m.find();
            while (result) {
                String previousChar = m.group(1);
                String encoded = m.group(2);
                int codePoint = Integer.parseInt(encoded.substring(1), 16);
                String decoded = String.valueOf(Character.toChars(codePoint));
                m.appendReplacement(unencoded, previousChar + decoded);
                result = m.find();
            }
            m.appendTail(unencoded);
            StringBuffer unescaped = new StringBuffer();
            Pattern escapedCharPattern = Pattern.compile("\\\\[_~\\.\\-!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\/\\?#\\@\\%]");
            m = escapedCharPattern.matcher(unencoded.toString());
            result = m.find();
            while (result) {
                String escaped = m.group();
                m.appendReplacement(unescaped, escaped.substring(1));
                result = m.find();
            }
            m.appendTail(unescaped);
            return unescaped.toString();
        }
    }

    private static final class DelegatingEvaluationStrategy
    extends EvaluationStrategyImpl {
        private final TripleTransaction transaction;
        @Nullable
        private final Long timeout;
        private final boolean skolemize;

        public DelegatingEvaluationStrategy(TripleTransaction transaction, Dataset dataset, @Nullable Long timeout, boolean skolemize) {
            super(null, dataset);
            this.transaction = transaction;
            this.timeout = timeout;
            this.skolemize = skolemize;
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(DescribeOperator expr, BindingSet bindings) throws QueryEvaluationException {
            return SparqlHelper.skolemize((CloseableIteration<BindingSet, QueryEvaluationException>)((CloseableIteration)new DescribeIteration((Iteration)SparqlHelper.deskolemize((CloseableIteration<BindingSet, QueryEvaluationException>)this.evaluate(expr.getArg(), bindings)), (EvaluationStrategy)(this.skolemize ? this : new DelegatingEvaluationStrategy(this.transaction, this.dataset, this.timeout, true)), expr.getBindingNames(), bindings)));
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Projection expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BinaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(StatementPattern expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Filter expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ZeroLengthPath expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Slice expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Group expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate((TupleExpr)expr, bindings);
        }

        private CloseableIteration<BindingSet, QueryEvaluationException> delegate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
            try {
                BindingSet actualBindings = this.skolemize ? SparqlHelper.skolemize(bindings) : bindings;
                SelectQuery query = SelectQuery.from(expr, this.dataset);
                return this.transaction.query(query, actualBindings, this.timeout);
            }
            catch (IOException ex) {
                throw new QueryEvaluationException((Throwable)ex);
            }
        }
    }

    private static final class LocalEvaluationStrategy
    extends EvaluationStrategyImpl {
        private final TripleTransaction transaction;
        @Nullable
        private final Long timeout;

        public LocalEvaluationStrategy(TripleTransaction transaction, Dataset dataset, @Nullable Long timeout) {
            super(null, dataset);
            this.transaction = (TripleTransaction)Preconditions.checkNotNull((Object)transaction);
            this.timeout = timeout;
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(DescribeOperator expr, BindingSet bindings) throws QueryEvaluationException {
            return SparqlHelper.skolemize((CloseableIteration<BindingSet, QueryEvaluationException>)((CloseableIteration)new DescribeIteration((Iteration)SparqlHelper.deskolemize((CloseableIteration<BindingSet, QueryEvaluationException>)this.evaluate(expr.getArg(), bindings)), (EvaluationStrategy)new DelegatingEvaluationStrategy(this.transaction, this.dataset, this.timeout, true), expr.getBindingNames(), bindings)));
        }
    }
}

