/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.datastore;

import com.google.common.collect.Iterables;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.runtime.SerializerAvro;
import eu.fbk.knowledgestore.vocabulary.KS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDataStore
implements DataStore {
    private String mentionsFolder;
    private String resourcesFolder;
    private HashMap<URI, IndexReader> readers = new HashMap();
    private HashMap<URI, IndexWriter> writers = new HashMap();
    private HashMap<URI, AtomicInteger> writingOperations = new HashMap();
    private SerializerAvro serializer;
    private final int MAX_LUCENE_SEGMENTS = 100;
    private static final HashMap<URI, Integer> OPTIMIZATION_THRESHOLD = new HashMap();
    static Logger logger;

    public LuceneDataStore(String folder, @Nullable SerializerAvro serializer) {
        this.mentionsFolder = folder + File.separator + "mentions";
        this.resourcesFolder = folder + File.separator + "resources";
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeRecord(Record record, @Nullable SerializerAvro serializer) throws IOException {
        if (serializer == null) {
            byte[] returnBytes;
            try (ObjectOutput out = null;
                 ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                out = new ObjectOutputStream(bos);
                out.writeObject(record);
                returnBytes = bos.toByteArray();
            }
            return returnBytes;
        }
        return serializer.toBytes(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Record unserializeRecord(byte[] bytes, @Nullable SerializerAvro serializer) throws IOException {
        if (serializer == null) {
            Record returnRecord;
            try (ObjectInput in = null;
                 ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
                in = new ObjectInputStream(bis);
                try {
                    returnRecord = (Record)in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            return returnRecord;
        }
        return (Record)serializer.fromBytes(bytes);
    }

    @Override
    public DataTransaction begin(boolean readOnly) throws DataCorruptedException, IOException, IllegalStateException {
        LuceneTransaction ret = new LuceneTransaction(readOnly);
        return ret;
    }

    @Override
    public void init() throws IOException, IllegalStateException {
        Files.createDirectories(Paths.get(this.mentionsFolder, new String[0]), new FileAttribute[0]);
        Files.createDirectories(Paths.get(this.resourcesFolder, new String[0]), new FileAttribute[0]);
        this.writingOperations.put(KS.RESOURCE, new AtomicInteger(0));
        this.writingOperations.put(KS.MENTION, new AtomicInteger(0));
        try {
            this.writers.put(KS.RESOURCE, new IndexWriter((Directory)FSDirectory.open((File)new File(this.resourcesFolder)), (Analyzer)new WhitespaceAnalyzer(), IndexWriter.MaxFieldLength.LIMITED));
            this.writers.put(KS.MENTION, new IndexWriter((Directory)FSDirectory.open((File)new File(this.mentionsFolder)), (Analyzer)new WhitespaceAnalyzer(), IndexWriter.MaxFieldLength.LIMITED));
            this.writers.get(KS.RESOURCE).optimize(100);
            this.writers.get(KS.MENTION).optimize(100);
            this.readers.put(KS.RESOURCE, this.writers.get(KS.RESOURCE).getReader());
            this.readers.put(KS.MENTION, this.writers.get(KS.MENTION).getReader());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.readers.get(KS.RESOURCE).close();
            this.readers.get(KS.MENTION).close();
            this.writers.get(KS.RESOURCE).close();
            this.writers.get(KS.MENTION).close();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void resetOperationCount(URI type) {
        this.writingOperations.get(type).set(0);
    }

    static {
        OPTIMIZATION_THRESHOLD.put(KS.RESOURCE, 1000);
        OPTIMIZATION_THRESHOLD.put(KS.MENTION, 10000);
        logger = LoggerFactory.getLogger(LuceneDataStore.class);
    }

    public class LuceneTransaction
    implements DataTransaction {
        boolean readOnly;
        public static final String KEY_NAME = "key";
        public static final String VALUE_NAME = "value";

        public LuceneTransaction(boolean readOnly) throws IOException {
            this.readOnly = readOnly;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void optimize(URI type) throws IOException {
            if (!((IndexReader)LuceneDataStore.this.readers.get(type)).isOptimized()) {
                AtomicInteger atomicInteger = (AtomicInteger)LuceneDataStore.this.writingOperations.get(type);
                synchronized (atomicInteger) {
                    if (((AtomicInteger)LuceneDataStore.this.writingOperations.get(type)).intValue() > (Integer)OPTIMIZATION_THRESHOLD.get(type)) {
                        logger.info("Optimizing index {}", (Object)type.toString());
                        ((IndexWriter)LuceneDataStore.this.writers.get(type)).optimize(100);
                        ((AtomicInteger)LuceneDataStore.this.writingOperations.get(type)).set(0);
                    }
                }
            }
            ((IndexReader)LuceneDataStore.this.readers.get(type)).close();
            LuceneDataStore.this.readers.put(type, ((IndexWriter)LuceneDataStore.this.writers.get(type)).getReader());
        }

        @Override
        public Stream<Record> lookup(URI type, Set<? extends URI> ids, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            this.optimize(type);
            ArrayList<Record> returns = new ArrayList<Record>();
            for (URI uRI : ids) {
                String uri;
                try {
                    uri = uRI.toString();
                }
                catch (NullPointerException e) {
                    throw new IOException(e);
                }
                logger.debug("Selecting {}", (Object)uri);
                Term s = new Term(KEY_NAME, uri);
                TermDocs termDocs = ((IndexReader)LuceneDataStore.this.readers.get(type)).termDocs(s);
                if (!termDocs.next()) continue;
                Document doc = ((IndexReader)LuceneDataStore.this.readers.get(type)).document(termDocs.doc());
                Record r = LuceneDataStore.unserializeRecord(doc.getBinaryValue(VALUE_NAME), LuceneDataStore.this.serializer);
                if (properties != null && !properties.isEmpty()) {
                    r.retain((URI[])Iterables.toArray(properties, URI.class));
                }
                returns.add(r);
            }
            return Stream.create(returns);
        }

        @Override
        public Stream<Record> retrieve(URI type, @Nullable XPath condition, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            this.optimize(type);
            ArrayList<Record> returns = new ArrayList<Record>();
            for (int i = 0; i < ((IndexReader)LuceneDataStore.this.readers.get(type)).numDocs(); ++i) {
                Document doc = ((IndexReader)LuceneDataStore.this.readers.get(type)).document(i);
                Record r = LuceneDataStore.unserializeRecord(doc.getBinaryValue(VALUE_NAME), LuceneDataStore.this.serializer);
                if (condition != null && !condition.evalBoolean((Object)r)) continue;
                if (properties != null) {
                    r.retain((URI[])Iterables.toArray(properties, URI.class));
                }
                returns.add(r);
            }
            return Stream.create(returns);
        }

        @Override
        public long count(URI type, @Nullable XPath condition) throws IOException, IllegalArgumentException, IllegalStateException {
            this.optimize(type);
            if (condition == null) {
                return ((IndexReader)LuceneDataStore.this.readers.get(type)).numDocs();
            }
            Stream<Record> stream = this.retrieve(type, condition, null);
            return stream.count();
        }

        @Override
        public Stream<Record> match(Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws IOException, IllegalStateException {
            return null;
        }

        @Override
        public void store(URI type, Record record) throws IOException, IllegalStateException {
            String uri;
            ((AtomicInteger)LuceneDataStore.this.writingOperations.get(type)).incrementAndGet();
            IndexWriter indexWriter = (IndexWriter)LuceneDataStore.this.writers.get(type);
            try {
                uri = record.getID().toString();
            }
            catch (NullPointerException e) {
                throw new IOException(e);
            }
            logger.debug(String.format("Inserting %s", uri));
            Document doc = new Document();
            doc.add((Fieldable)new Field(KEY_NAME, uri, Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field(VALUE_NAME, LuceneDataStore.serializeRecord(record, LuceneDataStore.this.serializer), Field.Store.YES));
            indexWriter.updateDocument(new Term(KEY_NAME, uri), doc);
        }

        @Override
        public void delete(URI type, URI id) throws IOException, IllegalStateException {
            ((AtomicInteger)LuceneDataStore.this.writingOperations.get(type)).incrementAndGet();
            Term s = new Term(KEY_NAME, id.toString());
            ((IndexWriter)LuceneDataStore.this.writers.get(type)).deleteDocuments(s);
            ((IndexWriter)LuceneDataStore.this.writers.get(type)).commit();
            this.optimize(type);
        }

        @Override
        public void end(boolean commit) throws DataCorruptedException, IOException, IllegalStateException {
        }
    }
}

