/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.datastore;

import com.google.common.collect.Iterables;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.vocabulary.KS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataStore
implements DataStore {
    static Logger logger = LoggerFactory.getLogger(MySQLDataStore.class);
    public HikariDataSource dataSource;
    final HikariConfig config = new HikariConfig();

    public MySQLDataStore(String host, String username, String password, String databaseName) {
        this.config.setMinimumIdle(2);
        this.config.setMaximumPoolSize(10);
        this.config.setConnectionTimeout(30000L);
        this.config.setIdleTimeout(600000L);
        this.config.setMaxLifetime(1800000L);
        this.config.setLeakDetectionThreshold(600000L);
        this.config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        this.config.addDataSourceProperty("serverName", (Object)host);
        this.config.addDataSourceProperty("port", (Object)"3306");
        this.config.addDataSourceProperty("databaseName", (Object)databaseName);
        this.config.addDataSourceProperty("user", (Object)username);
        this.config.addDataSourceProperty("password", (Object)password);
        this.config.addDataSourceProperty("cachePrepStmts", (Object)true);
        this.config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        this.config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        this.config.addDataSourceProperty("useServerPrepStmts", (Object)true);
    }

    @Override
    public DataTransaction begin(boolean readOnly) throws DataCorruptedException, IOException, IllegalStateException {
        MySQLTransaction ret = null;
        try {
            ret = new MySQLTransaction(readOnly);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ret;
    }

    @Override
    public void init() throws IOException, IllegalStateException {
        this.dataSource = new HikariDataSource(this.config);
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    public class MySQLTransaction
    implements DataTransaction {
        private Connection con;
        boolean readOnly;
        private static final String insertQuery = "INSERT INTO $tableName (`key`, `value`) VALUES (MD5(?), ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)";
        private static final String selectQuery = "SELECT `value` FROM $tableName WHERE `key` = MD5(?)";
        private static final String deleteQuery = "DELETE FROM $tableName WHERE `key` = MD5(?)";
        private static final String countQuery = "SELECT COUNT(*) FROM $tableName";
        private static final String selectAllQuery = "SELECT `value` FROM $tableName";
        HashMap<URI, PreparedStatement> insertBatchStatements = new HashMap();

        public MySQLTransaction(boolean readOnly) throws SQLException {
            this.readOnly = readOnly;
            this.con = MySQLDataStore.this.dataSource.getConnection();
            this.con.setAutoCommit(false);
            this.insertBatchStatements.put(KS.MENTION, this.con.prepareStatement(insertQuery.replace("$tableName", "mentions")));
            this.insertBatchStatements.put(KS.RESOURCE, this.con.prepareStatement(insertQuery.replace("$tableName", "resources")));
        }

        private void connect(String dbUser, String dbPass) throws SQLException {
        }

        private String getTableName(URI type) throws IOException {
            if (type.equals((Object)KS.MENTION)) {
                return "mentions";
            }
            if (type.equals((Object)KS.RESOURCE)) {
                return "resources";
            }
            throw new IOException(String.format("Unknown URI: %s", type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] serializeRecord(Record record) throws IOException {
            byte[] returnBytes;
            try (ObjectOutput out = null;
                 ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                out = new ObjectOutputStream(bos);
                out.writeObject(record);
                returnBytes = bos.toByteArray();
            }
            return returnBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Record unserializeRecord(byte[] bytes) throws IOException {
            Record returnRecord;
            try (ObjectInput in = null;
                 ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
                in = new ObjectInputStream(bis);
                try {
                    returnRecord = (Record)in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            return returnRecord;
        }

        @Override
        public Stream<Record> lookup(URI type, Set<? extends URI> ids, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            String tableName = this.getTableName(type);
            ArrayList<Record> returns = new ArrayList<Record>();
            for (URI uRI : ids) {
                String uri;
                try {
                    uri = uRI.toString();
                }
                catch (NullPointerException e) {
                    throw new IOException(e);
                }
                logger.debug(String.format("Selecting %s", uri));
                String query = selectQuery.replace("$tableName", tableName);
                try {
                    PreparedStatement stmt = this.con.prepareStatement(query);
                    stmt.setString(1, uri);
                    ResultSet set = stmt.executeQuery();
                    while (set.next()) {
                        Record r = this.unserializeRecord(set.getBytes("value"));
                        if (properties != null) {
                            r.retain((URI[])Iterables.toArray(properties, URI.class));
                        }
                        returns.add(r);
                    }
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            return Stream.create(returns);
        }

        @Override
        public Stream<Record> retrieve(URI type, @Nullable XPath condition, @Nullable Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            String tableName = this.getTableName(type);
            ArrayList<Record> returns = new ArrayList<Record>();
            logger.debug("Retrieving all lines");
            String query = selectAllQuery.replace("$tableName", tableName);
            try {
                Statement statement = this.con.createStatement();
                ResultSet resultSet = statement.executeQuery(query);
                while (resultSet.next()) {
                    Record r = this.unserializeRecord(resultSet.getBytes("value"));
                    if (condition != null && !condition.evalBoolean((Object)r)) continue;
                    if (properties != null) {
                        r.retain((URI[])Iterables.toArray(properties, URI.class));
                    }
                    returns.add(r);
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            return Stream.create(returns);
        }

        @Override
        public long count(URI type, @Nullable XPath condition) throws IOException, IllegalArgumentException, IllegalStateException {
            String tableName = this.getTableName(type);
            logger.debug("Counting rows");
            String query = countQuery.replace("$tableName", tableName);
            try {
                Statement statement = this.con.createStatement();
                ResultSet resultSet = statement.executeQuery(query);
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            throw new IOException();
        }

        @Override
        public Stream<Record> match(Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws IOException, IllegalStateException {
            return null;
        }

        @Override
        public void store(URI type, Record record) throws IOException, IllegalStateException {
            String uri;
            try {
                uri = record.getID().toString();
            }
            catch (NullPointerException e) {
                throw new IOException(e);
            }
            logger.debug(String.format("Inserting %s", uri));
            try {
                this.insertBatchStatements.get(type).setString(1, uri);
                this.insertBatchStatements.get(type).setBytes(2, this.serializeRecord(record));
                this.insertBatchStatements.get(type).addBatch();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void delete(URI type, URI id) throws IOException, IllegalStateException {
            String uri;
            String tableName = this.getTableName(type);
            try {
                uri = id.toString();
            }
            catch (NullPointerException e) {
                throw new IOException(e);
            }
            logger.debug(String.format("Deleting %s", uri));
            String query = deleteQuery.replace("$tableName", tableName);
            try {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, uri);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void end(boolean commit) throws DataCorruptedException, IOException, IllegalStateException {
            try {
                if (commit) {
                    for (URI type : this.insertBatchStatements.keySet()) {
                        this.insertBatchStatements.get(type).executeBatch();
                    }
                    this.con.commit();
                } else {
                    this.con.rollback();
                }
                this.con.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

