/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.internal.rdf.CompactBindingSet;
import eu.fbk.knowledgestore.triplestore.ForwardingTripleStore;
import eu.fbk.knowledgestore.triplestore.ForwardingTripleTransaction;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.ListBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RewritingTripleStore
extends ForwardingTripleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RewritingTripleStore.class);
    private final TripleStore delegate;
    private final Rewriter in;
    private final Rewriter out;

    public RewritingTripleStore(TripleStore delegate, String internalPrefix, String externalPrefix) {
        this.delegate = (TripleStore)Preconditions.checkNotNull((Object)delegate);
        this.in = new Rewriter(externalPrefix, internalPrefix);
        this.out = new Rewriter(internalPrefix, externalPrefix);
        LOGGER.debug("{} configured", (Object)this.getClass().getSimpleName());
    }

    @Override
    public TripleTransaction begin(boolean readOnly) throws IOException {
        return new RewritingTripleTransaction(super.begin(readOnly));
    }

    @Override
    protected TripleStore delegate() {
        return this.delegate;
    }

    private static class Rewriter {
        private final String fromPrefix;
        private final String toPrefix;

        Rewriter(String fromPrefix, String toPrefix) {
            this.fromPrefix = (String)Preconditions.checkNotNull((Object)fromPrefix);
            this.toPrefix = (String)Preconditions.checkNotNull((Object)toPrefix);
        }

        @Nullable
        SelectQuery rewriteQuery(@Nullable SelectQuery query) {
            TupleExpr expr = query.getExpression().clone();
            expr.visit((QueryModelVisitor)new QueryModelVisitorBase<RuntimeException>(){

                public void meet(BindingSetAssignment node) throws RuntimeException {
                    ArrayList bindingsList = Lists.newArrayList();
                    for (BindingSet bindings : node.getBindingSets()) {
                        bindingsList.add(this.rewriteBindings(bindings));
                    }
                    node.setBindingSets((Iterable)bindingsList);
                }

                public void meet(ValueConstant node) throws RuntimeException {
                    node.setValue(this.rewriteValue(node.getValue()));
                }

                public void meet(Var node) throws RuntimeException {
                    node.setValue(this.rewriteValue(node.getValue()));
                }
            });
            return SelectQuery.from(expr, query.getDataset());
        }

        @Nullable
        <E extends Exception> CloseableIteration<BindingSet, E> rewriteBindings(final List<String> variables, @Nullable CloseableIteration<? extends BindingSet, ? extends E> iteration) {
            if (iteration == null) {
                return null;
            }
            final CompactBindingSet.Builder builder = CompactBindingSet.builder(variables);
            return new ConvertingIteration<BindingSet, BindingSet, E>((Iteration)iteration){

                protected BindingSet convert(BindingSet bindings) throws Exception {
                    for (int i = 0; i < variables.size(); ++i) {
                        String variable = (String)variables.get(i);
                        builder.set(i, this.rewriteValue(bindings.getValue(variable)));
                    }
                    return builder.build();
                }
            };
        }

        @Nullable
        BindingSet rewriteBindings(@Nullable BindingSet bindings) {
            if (bindings != null) {
                Set names = bindings.getBindingNames();
                Value[] values = new Value[names.size()];
                boolean changed = false;
                int index = 0;
                for (String name : names) {
                    Value oldValue = bindings.getValue(name);
                    Value newValue = this.rewriteValue(oldValue);
                    values[index++] = newValue;
                    changed |= oldValue != newValue;
                }
                if (changed) {
                    return new ListBindingSet((List)ImmutableList.copyOf((Collection)names), values);
                }
            }
            return bindings;
        }

        Handler<Statement> rewriteStatements(final Handler<? super Statement> handler) {
            return new Handler<Statement>(){

                public void handle(Statement statement) throws Throwable {
                    handler.handle(statement == null ? null : this.rewriteStatement(statement));
                }
            };
        }

        @Nullable
        <E extends Exception> CloseableIteration<Statement, E> rewriteStatements(@Nullable CloseableIteration<? extends Statement, ? extends E> iteration) {
            return iteration == null ? null : new ConvertingIteration<Statement, Statement, E>((Iteration)iteration){

                protected Statement convert(Statement statement) throws Exception {
                    return this.rewriteStatement(statement);
                }
            };
        }

        @Nullable
        Iterable<Statement> rewriteStatements(@Nullable Iterable<? extends Statement> statements) {
            return statements == null ? null : Iterables.transform(statements, (Function)new Function<Statement, Statement>(){

                @Nullable
                public Statement apply(@Nullable Statement statement) {
                    return this.rewriteStatement(statement);
                }
            });
        }

        @Nullable
        Statement rewriteStatement(@Nullable Statement statement) {
            if (statement == null) {
                return null;
            }
            Resource oldSubj = statement.getSubject();
            URI oldPred = statement.getPredicate();
            Value oldObj = statement.getObject();
            Resource oldCtx = statement.getContext();
            Resource newSubj = this.rewriteValue(oldSubj);
            URI newPred = this.rewriteValue(oldPred);
            Value newObj = this.rewriteValue(oldObj);
            Resource newCtx = this.rewriteValue(oldCtx);
            if (oldSubj == newSubj && oldPred == newPred && oldObj == newObj && oldCtx == newCtx) {
                return statement;
            }
            if (newCtx != null) {
                return Data.getValueFactory().createStatement(newSubj, newPred, newObj, newCtx);
            }
            return Data.getValueFactory().createStatement(newSubj, newPred, newObj);
        }

        @Nullable
        <T extends Value> T rewriteValue(@Nullable T value) {
            URI uri;
            String string;
            if (value instanceof URI && (string = (uri = (URI)value).stringValue()).startsWith(this.fromPrefix)) {
                return (T)Data.getValueFactory().createURI(this.toPrefix + string.substring(this.fromPrefix.length()));
            }
            return value;
        }
    }

    private class RewritingTripleTransaction
    extends ForwardingTripleTransaction {
        private final TripleTransaction delegate;

        RewritingTripleTransaction(TripleTransaction delegate) {
            this.delegate = (TripleTransaction)Preconditions.checkNotNull((Object)delegate);
        }

        @Override
        protected TripleTransaction delegate() {
            return this.delegate;
        }

        @Override
        public CloseableIteration<? extends Statement, ? extends Exception> get(@Nullable Resource subject, @Nullable URI predicate, @Nullable Value object, @Nullable Resource context) throws IOException, IllegalStateException {
            return RewritingTripleStore.this.out.rewriteStatements(this.delegate().get(RewritingTripleStore.this.in.rewriteValue(subject), RewritingTripleStore.this.in.rewriteValue(predicate), RewritingTripleStore.this.in.rewriteValue(object), RewritingTripleStore.this.in.rewriteValue(context)));
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> query(SelectQuery query, @Nullable BindingSet bindings, @Nullable Long timeout) throws IOException, UnsupportedOperationException {
            return RewritingTripleStore.this.out.rewriteBindings((List<String>)ImmutableList.copyOf((Collection)query.getExpression().getBindingNames()), super.query(RewritingTripleStore.this.in.rewriteQuery(query), RewritingTripleStore.this.in.rewriteBindings(bindings), timeout));
        }

        @Override
        public void infer(@Nullable Handler<? super Statement> handler) throws IOException, IllegalStateException {
            this.delegate().infer(RewritingTripleStore.this.out.rewriteStatements(handler));
        }

        @Override
        public void add(Iterable<? extends Statement> statements) throws IOException, IllegalStateException {
            this.delegate().add(RewritingTripleStore.this.in.rewriteStatements(statements));
        }

        @Override
        public void remove(Iterable<? extends Statement> statements) throws IOException, IllegalStateException {
            this.delegate().remove(RewritingTripleStore.this.in.rewriteStatements(statements));
        }
    }
}

