/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.datastore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.runtime.DataCorruptedException;
import eu.fbk.knowledgestore.triplestore.SelectQuery;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import eu.fbk.knowledgestore.vocabulary.KS;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TripleDataStore
implements DataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleDataStore.class);
    private final TripleStore tripleStore;
    private boolean initialized;
    private boolean closed;

    public TripleDataStore(TripleStore tripleStore) {
        this.tripleStore = (TripleStore)Preconditions.checkNotNull((Object)tripleStore);
        this.initialized = false;
        this.closed = false;
        LOGGER.info("{} configured, triplestore={}", (Object)this, (Object)this.tripleStore);
    }

    @Override
    public synchronized void init() throws IOException, IllegalStateException {
        Preconditions.checkState((!this.initialized && !this.closed ? 1 : 0) != 0);
        this.initialized = true;
        LOGGER.info("{} initialized", (Object)this);
    }

    @Override
    public synchronized DataTransaction begin(boolean readOnly) throws DataCorruptedException, IOException, IllegalStateException {
        Preconditions.checkState((this.initialized && !this.closed ? 1 : 0) != 0);
        return new TripleDataTransaction(this.tripleStore.begin(readOnly));
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static final class TripleDataTransaction
    implements DataTransaction {
        private final TripleTransaction transaction;

        TripleDataTransaction(TripleTransaction transaction) {
            this.transaction = transaction;
        }

        private Stream<Record> query(String spoPattern, URI type, @Nullable Set<? extends URI> properties, @Nullable XPath condition) throws IOException {
            StringBuilder builder = new StringBuilder();
            if (KS.RESOURCE.equals((Object)type)) {
                builder.append("SELECT ?s ?p ?o ?p1 ?o1 ?p2 ?o2 {\n  ?s ?p ?o .\n  OPTIONAL {\n    ?o ?p1 ?o1\n    FILTER (?p = <http://dkm.fbk.eu/ontologies/knowledgestore#storedAs>)\n    OPTIONAL {\n      ?o1 ?p2 ?o2\n      FILTER (?p1 = <http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#hasHash>)\n    }\n  }\n ");
            } else {
                builder.append("SELECT ?s ?p ?o {\n  ?s ?p ?o .\n");
            }
            builder.append("  ?s a ").append(Data.toString((Object)type, null)).append(" .\n");
            builder.append(spoPattern);
            builder.append("\n}");
            String query = builder.toString();
            Stream bindingStream = Stream.create(this.transaction.query(SelectQuery.from(query), null, null));
            Stream stmtStream = KS.RESOURCE.equals((Object)type) ? bindingStream.transform(null, (Function)new Function<Handler<Statement>, Handler<BindingSet>>(){

                public Handler<BindingSet> apply(final Handler<Statement> handler) {
                    return new Handler<BindingSet>(){
                        private final Set<Statement> set = Sets.newHashSet();
                        private Resource subject = null;

                        public void handle(BindingSet bindings) throws Throwable {
                            if (bindings == null) {
                                handler.handle(null);
                                return;
                            }
                            Resource s = (Resource)bindings.getValue("s");
                            URI p = (URI)bindings.getValue("p");
                            Value o = bindings.getValue("o");
                            URI p1 = (URI)bindings.getValue("p1");
                            Value o1 = bindings.getValue("o1");
                            URI p2 = (URI)bindings.getValue("p2");
                            Value o2 = bindings.getValue("o2");
                            ValueFactory vf = Data.getValueFactory();
                            if (!s.equals(this.subject)) {
                                this.set.clear();
                                this.subject = s;
                            }
                            this.emit((Handler<Statement>)handler, vf.createStatement(s, p, o));
                            if (o1 != null) {
                                this.emit((Handler<Statement>)handler, vf.createStatement((Resource)((URI)o), p1, o1));
                                if (o2 != null) {
                                    this.emit((Handler<Statement>)handler, vf.createStatement((Resource)((URI)o1), p2, o2));
                                }
                            }
                        }

                        private void emit(Handler<Statement> handler2, Statement statement) throws Throwable {
                            if (this.set.add(statement)) {
                                handler2.handle((Object)statement);
                            }
                        }
                    };
                }
            }) : bindingStream.transform((Function)new Function<BindingSet, Statement>(){

                public Statement apply(BindingSet bindings) {
                    Resource s = (Resource)bindings.getValue("s");
                    URI p = (URI)bindings.getValue("p");
                    Value o = bindings.getValue("o");
                    return Data.getValueFactory().createStatement(s, p, o);
                }
            }, 1);
            Stream recordStream = Record.decode((Stream)stmtStream, (Iterable)ImmutableList.of((Object)type), (Boolean)true);
            if (condition != null) {
                recordStream = recordStream.filter(condition.asPredicate(), 1);
            }
            if (properties != null && !properties.isEmpty()) {
                final URI[] props = properties.toArray(new URI[properties.size()]);
                recordStream = recordStream.transform((Function)new Function<Record, Record>(){

                    public Record apply(Record record) {
                        record.retain(props);
                        return null;
                    }
                }, 1);
            }
            return recordStream;
        }

        @Override
        public Stream<Record> lookup(final URI type, Set<? extends URI> ids, final Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            return Stream.concat((Iterable)Stream.create(ids).chunk(64).transform((Function)new Function<List<? extends URI>, Stream<Record>>(){

                public Stream<Record> apply(List<? extends URI> input) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("  VALUES ?s {");
                    for (URI uRI : input) {
                        builder.append(" <").append(uRI.toString()).append(">");
                    }
                    builder.append(" }");
                    try {
                        return this.query(builder.toString(), type, properties, null);
                    }
                    catch (IOException ex) {
                        throw Throwables.propagate((Throwable)ex);
                    }
                }
            }, 1));
        }

        @Override
        public Stream<Record> retrieve(URI type, XPath condition, Set<? extends URI> properties) throws IOException, IllegalArgumentException, IllegalStateException {
            return this.query("  ?s a <" + type.toString() + "> .", type, properties, condition);
        }

        @Override
        public long count(URI type, XPath condition) throws IOException, IllegalArgumentException, IllegalStateException {
            return this.query("  ?s a <" + type.toString() + "> .", type, null, condition).count();
        }

        @Override
        public Stream<Record> match(Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws IOException, IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void store(URI type, Record record) throws IOException, IllegalStateException {
            this.delete(type, record.getID());
            List statements = Record.encode((Stream)Stream.create((Object[])new Record[]{record}), (Iterable)ImmutableList.of((Object)type)).toList();
            this.transaction.add(statements);
        }

        @Override
        public void delete(URI type, URI id) throws IOException, IllegalStateException {
            List statements = Record.encode(this.lookup(type, (Set<? extends URI>)ImmutableSet.of((Object)id), null), (Iterable)ImmutableList.of((Object)type)).toList();
            this.transaction.remove(statements);
        }

        @Override
        public void end(boolean commit) throws DataCorruptedException, IOException, IllegalStateException {
            this.transaction.end(commit);
        }
    }
}

