/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.filestore;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.filestore.FileExistsException;
import eu.fbk.knowledgestore.filestore.FileMissingException;
import eu.fbk.knowledgestore.filestore.FileStore;
import eu.fbk.knowledgestore.filestore.ForwardingFileStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GzippedFileStore
extends ForwardingFileStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(GzippedFileStore.class);
    private static final int DEFAULT_COMPRESSION_LEVEL = -1;
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final FileStore delegate;
    private final int compressionLevel;
    private final int bufferSize;

    public GzippedFileStore(FileStore delegate) {
        this(delegate, null, null);
    }

    public GzippedFileStore(FileStore delegate, @Nullable Integer compressionLevel, @Nullable Integer bufferSize) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkArgument((compressionLevel == null || compressionLevel == -1 || compressionLevel >= 1 && compressionLevel <= 9 ? 1 : 0) != 0);
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        this.delegate = (FileStore)Preconditions.checkNotNull((Object)delegate);
        this.compressionLevel = (Integer)MoreObjects.firstNonNull((Object)compressionLevel, (Object)-1);
        this.bufferSize = (Integer)MoreObjects.firstNonNull((Object)bufferSize, (Object)512);
        LOGGER.info("GZippedFileStore configured, compression={}, buffer={}", (Object)compressionLevel, (Object)bufferSize);
    }

    @Override
    protected FileStore delegate() {
        return this.delegate;
    }

    @Override
    public InputStream read(String filename) throws FileMissingException, IOException {
        String internalFilename = GzippedFileStore.toInternalFilename(filename);
        if (internalFilename.equals(filename)) {
            return super.read(filename);
        }
        return new GZIPInputStream(super.read(internalFilename), this.bufferSize);
    }

    @Override
    public OutputStream write(String filename) throws FileExistsException, IOException {
        String internalFilename = GzippedFileStore.toInternalFilename(filename);
        if (internalFilename.equals(filename)) {
            return super.write(filename);
        }
        return new GZIPOutputStream(super.write(internalFilename), this.bufferSize){
            {
                this.def.setLevel(GzippedFileStore.this.compressionLevel);
            }
        };
    }

    @Override
    public void delete(String filename) throws FileMissingException, IOException {
        super.delete(GzippedFileStore.toInternalFilename(filename));
    }

    @Override
    public Stream<String> list() throws IOException {
        return super.list().transform((Function)new Function<String, String>(){

            public String apply(String filename) {
                return GzippedFileStore.toExternalFilename(filename);
            }
        }, 0);
    }

    private static String toInternalFilename(String filename) {
        String mimeType = Data.extensionToMimeType((String)filename);
        return Data.isMimeTypeCompressible((String)mimeType) ? filename + ".gz" : filename;
    }

    private static String toExternalFilename(String filename) {
        return filename.endsWith(".gz") ? filename.substring(0, filename.length() - 3) : filename;
    }
}

