/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.filestore;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.filestore.FileExistsException;
import eu.fbk.knowledgestore.filestore.FileMissingException;
import eu.fbk.knowledgestore.filestore.FileStore;
import eu.fbk.knowledgestore.filestore.ForwardingFileStore;
import eu.fbk.knowledgestore.runtime.Synchronizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SynchronizedFileStore
extends ForwardingFileStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedFileStore.class);
    private static final int NUM_LOCKS = 255;
    private static final int NEW = 0;
    private static final int INITIALIZED = 1;
    private static final int CLOSED = 2;
    private final FileStore delegate;
    private final Synchronizer synchronizer;
    private final AtomicInteger state;
    private final Object[] fileLocks;
    private final Set<Stream<String>> pendingListStreams;

    public SynchronizedFileStore(FileStore delegate, String synchronizerSpec) {
        this.delegate = (FileStore)Preconditions.checkNotNull((Object)delegate);
        this.synchronizer = Synchronizer.create(synchronizerSpec);
        this.state = new AtomicInteger(0);
        this.fileLocks = new Object[255];
        for (int i = 0; i < 255; ++i) {
            this.fileLocks[i] = new Object();
        }
        this.pendingListStreams = Sets.newHashSet();
    }

    @Override
    protected FileStore delegate() {
        return this.delegate;
    }

    private void checkState(int expected) {
        int state = this.state.get();
        if (state != expected) {
            throw new IllegalStateException("FileStore " + (state == 0 ? "not initialized" : (state == 1 ? "already initialized" : "already closed")));
        }
    }

    private Object lockFor(String fileName) {
        return this.fileLocks[Math.abs(fileName.hashCode()) % 255];
    }

    @Override
    public void init() throws IOException {
        this.checkState(0);
        super.init();
        this.state.set(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream read(String fileName) throws FileMissingException, IOException {
        this.checkState(1);
        Preconditions.checkNotNull((Object)fileName);
        this.synchronizer.beginTransaction(true);
        try {
            this.checkState(1);
            Object object = this.lockFor(fileName);
            synchronized (object) {
                InputStream inputStream = super.read(fileName);
                return inputStream;
            }
        }
        finally {
            this.synchronizer.endTransaction(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream write(String fileName) throws FileExistsException, IOException {
        this.checkState(1);
        Preconditions.checkNotNull((Object)fileName);
        this.synchronizer.beginTransaction(false);
        try {
            this.checkState(1);
            Object object = this.lockFor(fileName);
            synchronized (object) {
                OutputStream outputStream = super.write(fileName);
                return outputStream;
            }
        }
        finally {
            this.synchronizer.endTransaction(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String fileName) throws FileMissingException, IOException {
        this.checkState(1);
        Preconditions.checkNotNull((Object)fileName);
        this.synchronizer.beginTransaction(false);
        try {
            this.checkState(1);
            Object object = this.lockFor(fileName);
            synchronized (object) {
                super.delete(fileName);
            }
        }
        finally {
            this.synchronizer.endTransaction(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<String> list() throws IOException {
        this.checkState(1);
        this.synchronizer.beginTransaction(true);
        try {
            this.checkState(1);
            Stream<String> stream = super.list();
            Set<Stream<String>> set = this.pendingListStreams;
            synchronized (set) {
                this.pendingListStreams.add(stream);
            }
            stream.onClose(new Object[]{new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SynchronizedFileStore.this.synchronizer.endTransaction(true);
                    Set set = SynchronizedFileStore.this.pendingListStreams;
                    synchronized (set) {
                        SynchronizedFileStore.this.pendingListStreams.remove(this);
                    }
                }
            }});
            return stream;
        }
        catch (Throwable ex) {
            this.synchronizer.endTransaction(true);
            Throwables.propagateIfPossible((Throwable)ex, IOException.class);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList streamsToEnd;
        if (!this.state.compareAndSet(1, 2) && !this.state.compareAndSet(0, 2)) {
            return;
        }
        Set<Stream<String>> set = this.pendingListStreams;
        synchronized (set) {
            streamsToEnd = Lists.newArrayList(this.pendingListStreams);
        }
        try {
            for (Stream stream : streamsToEnd) {
                try {
                    LOGGER.warn("Forcing closure of stream due to FileStore closure");
                    stream.close();
                }
                catch (Throwable ex) {
                    LOGGER.error("Exception caught while closing stream: " + ex.getMessage(), ex);
                }
            }
        }
        finally {
            super.close();
        }
    }
}

