/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.concurrent.Semaphore;
import javax.annotation.Nullable;

public final class Synchronizer {
    public static final int WX = -1;
    public static final int CX = -2;
    private final int maxConcurrentTx;
    private final int maxWriteTx;
    private final Semaphore mainSemaphore;
    @Nullable
    private final Semaphore writeSemaphore;
    @Nullable
    private final Semaphore commitSemaphore;

    private Synchronizer(int maxConcurrentTx, int maxWriteTx) {
        Preconditions.checkArgument((maxConcurrentTx > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxWriteTx >= 0 && maxWriteTx <= maxConcurrentTx || maxWriteTx == -1 || maxWriteTx == -2 ? 1 : 0) != 0);
        this.maxConcurrentTx = maxConcurrentTx;
        this.maxWriteTx = maxWriteTx;
        this.mainSemaphore = new Semaphore(maxConcurrentTx, true);
        this.writeSemaphore = maxWriteTx != 0 ? new Semaphore(Math.max(maxWriteTx, 1), true) : null;
        this.commitSemaphore = maxWriteTx == -2 ? new Semaphore(1, true) : null;
    }

    public static Synchronizer create(String spec) {
        int index = spec.indexOf(58);
        String first = (index <= 0 ? spec : spec.substring(0, index)).trim();
        String second = index <= 0 ? null : spec.substring(index + 1).trim().toUpperCase();
        try {
            int maxConcurrentTx = Integer.parseInt(first);
            int maxWriteTx = second == null ? 0 : (second.equals("WX") ? -1 : (second.equals("CX") ? -2 : Integer.parseInt(second)));
            return new Synchronizer(maxConcurrentTx, maxWriteTx);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Illegal synchronizer specification '" + spec + "'", ex);
        }
    }

    public static Synchronizer create(int maxConcurrentTx, int maxWriteTx) {
        return new Synchronizer(maxConcurrentTx, maxWriteTx);
    }

    public void beginExclusive() {
        try {
            this.mainSemaphore.acquire(this.maxConcurrentTx);
        }
        catch (Throwable ex) {
            Throwables.propagate((Throwable)ex);
        }
    }

    public void endExclusive() {
        this.mainSemaphore.release(this.maxConcurrentTx);
    }

    public void beginTransaction(boolean readOnly) {
        boolean writeAcquired = false;
        try {
            if (readOnly) {
                this.mainSemaphore.acquire();
            } else {
                if (this.writeSemaphore == null) {
                    throw new IllegalStateException("Write transactions have been disabled");
                }
                this.writeSemaphore.acquire();
                writeAcquired = true;
                this.mainSemaphore.acquire(this.maxWriteTx == -1 ? this.maxConcurrentTx : 1);
            }
        }
        catch (Throwable ex) {
            if (writeAcquired) {
                this.writeSemaphore.release();
            }
            Throwables.propagate((Throwable)ex);
        }
    }

    public void endTransaction(boolean readOnly) {
        if (readOnly) {
            this.mainSemaphore.release(1);
        } else {
            this.mainSemaphore.release(this.maxWriteTx == -1 ? this.maxConcurrentTx : 1);
            this.writeSemaphore.release();
        }
    }

    public void beginCommit() {
        if (this.maxWriteTx == -2) {
            boolean commitAcquired = false;
            try {
                this.commitSemaphore.acquire();
                commitAcquired = true;
                this.mainSemaphore.acquire(this.maxConcurrentTx - 1);
            }
            catch (Throwable ex) {
                if (commitAcquired) {
                    this.commitSemaphore.release();
                }
                Throwables.propagate((Throwable)ex);
            }
        }
    }

    public void endCommit() {
        if (this.maxWriteTx == -2) {
            this.mainSemaphore.release(this.maxConcurrentTx - 1);
            this.commitSemaphore.release();
        }
    }

    public String toString() {
        return this.maxConcurrentTx + ":" + (this.maxWriteTx == -1 ? "WX" : (this.maxWriteTx == -2 ? "CX" : Integer.valueOf(this.maxWriteTx)));
    }
}

