/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.triplestore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.algebra.Add;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.Avg;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.BinaryValueOperator;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Clear;
import org.openrdf.query.algebra.Coalesce;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.CompareAll;
import org.openrdf.query.algebra.CompareAny;
import org.openrdf.query.algebra.Copy;
import org.openrdf.query.algebra.Count;
import org.openrdf.query.algebra.Create;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.DeleteData;
import org.openrdf.query.algebra.DescribeOperator;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.GroupConcat;
import org.openrdf.query.algebra.GroupElem;
import org.openrdf.query.algebra.IRIFunction;
import org.openrdf.query.algebra.If;
import org.openrdf.query.algebra.In;
import org.openrdf.query.algebra.InsertData;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsNumeric;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Label;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Like;
import org.openrdf.query.algebra.ListMemberOperator;
import org.openrdf.query.algebra.Load;
import org.openrdf.query.algebra.LocalName;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.Max;
import org.openrdf.query.algebra.Min;
import org.openrdf.query.algebra.Modify;
import org.openrdf.query.algebra.Move;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Namespace;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.Sample;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.Sum;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.queryrender.QueryRenderer;

final class SPARQLRenderer
implements QueryRenderer {
    private static final Map<String, String> NAMES;
    private final Map<String, String> prefixes;
    private final boolean forceSelect;

    public SPARQLRenderer(@Nullable Map<String, String> prefixes, @Nullable boolean forceSelect) {
        this.prefixes = prefixes != null ? prefixes : Collections.emptyMap();
        this.forceSelect = forceSelect;
    }

    public QueryLanguage getLanguage() {
        return QueryLanguage.SPARQL;
    }

    public String render(ParsedQuery query) {
        return this.render(query.getTupleExpr(), query.getDataset());
    }

    public String render(TupleExpr expr, Dataset dataset) {
        Rendering rendering = new Rendering(expr, dataset);
        StringBuilder builder = new StringBuilder();
        boolean newline = false;
        if (!rendering.namespaces.isEmpty()) {
            for (String namespace : Ordering.natural().sortedCopy((Iterable)rendering.namespaces)) {
                String prefix = this.prefixes.get(namespace);
                if ("bif".equals(prefix) && "http://www.openlinksw.com/schema/sparql/extensions#".equals(namespace)) continue;
                builder.append("PREFIX ").append(prefix).append(": <");
                SPARQLRenderer.escape(namespace, builder);
                builder.append(">\n");
                newline = true;
            }
        }
        if (rendering.base != null) {
            builder.append("BASE <");
            SPARQLRenderer.escape(rendering.base, builder);
            builder.append(">\n");
            newline = true;
        }
        if (newline) {
            builder.append("\n");
        }
        builder.append(rendering.body);
        return builder.toString();
    }

    private static void escape(String label, StringBuilder builder) {
        int length = label.length();
        for (int i = 0; i < length; ++i) {
            char c = label.charAt(i);
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            builder.append(Character.toString(c));
        }
    }

    private static String sanitize(String string) {
        int length = string.length();
        StringBuilder builder = new StringBuilder(length + 10);
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (Character.isLetter(ch) || ch == '_' || i > 0 && Character.isDigit(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append("_");
        }
        return builder.toString();
    }

    private static <T> boolean equalOrNull(@Nullable T first, @Nullable T second) {
        return first != null && first.equals(second) || first == null && second == null;
    }

    private static <T> T defaultIfNull(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    private static List<StatementPattern> getBGP(QueryModelNode n) {
        if (n instanceof StatementPattern) {
            return Collections.singletonList((StatementPattern)n);
        }
        if (!(n instanceof Join)) {
            return null;
        }
        Join j = (Join)n;
        List<StatementPattern> l = SPARQLRenderer.getBGP((QueryModelNode)j.getLeftArg());
        List<StatementPattern> r = SPARQLRenderer.getBGP((QueryModelNode)j.getRightArg());
        if (l == null || r == null) {
            return null;
        }
        if (l.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return l;
        }
        if (!SPARQLRenderer.equalOrNull(l.get(0).getContextVar(), r.get(0).getContextVar())) {
            return null;
        }
        ArrayList<StatementPattern> s = new ArrayList<StatementPattern>(l.size() + r.size());
        s.addAll(l);
        s.addAll(r);
        return s;
    }

    private static int getVarRefs(QueryModelNode node, final String name) {
        final AtomicInteger count = new AtomicInteger(0);
        node.visit((QueryModelVisitor)new QueryModelVisitorBase<RuntimeException>(){

            public void meet(Var var) {
                if (var.getName().equals(name)) {
                    count.set(count.get() + 1);
                }
            }
        });
        return count.get();
    }

    private static ValueExpr getVarExpr(QueryModelNode node, final String name) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        node.visit((QueryModelVisitor)new QueryModelVisitorBase<RuntimeException>(){

            protected void meetNode(QueryModelNode node) throws RuntimeException {
                if (result.get() == null) {
                    super.meetNode(node);
                }
            }

            public void meet(Var var) {
                if (var.getName().equals(name) && var.getValue() != null) {
                    result.set(new ValueConstant(var.getValue()));
                }
            }

            public void meet(ExtensionElem node) throws RuntimeException {
                if (node.getName().equals(name)) {
                    result.set(node.getExpr());
                } else {
                    super.meet(node);
                }
            }
        });
        return result.get();
    }

    static {
        HashMap names = Maps.newHashMap();
        names.put("RAND", "RAND");
        names.put("TZ", "TZ");
        names.put("NOW", "NOW");
        names.put("UUID", "UUID");
        names.put("STRUUID", "STRUUID");
        names.put("MD5", "MD5");
        names.put("SHA1", "SHA1");
        names.put("SHA256", "SHA256");
        names.put("SHA384", "SHA384");
        names.put("SHA512", "SHA512");
        names.put("STRLANG", "STRLANG");
        names.put("STRDT", "STRDT");
        names.put(FN.STRING_LENGTH.stringValue(), "STRLEN");
        names.put(FN.SUBSTRING.stringValue(), "SUBSTR");
        names.put(FN.UPPER_CASE.stringValue(), "UCASE");
        names.put(FN.LOWER_CASE.stringValue(), "LCASE");
        names.put(FN.STARTS_WITH.stringValue(), "STRSTARTS");
        names.put(FN.ENDS_WITH.stringValue(), "STRENDS");
        names.put(FN.CONTAINS.stringValue(), "CONTAINS");
        names.put(FN.SUBSTRING_BEFORE.stringValue(), "STRBEFORE");
        names.put(FN.SUBSTRING_AFTER.stringValue(), "STRAFTER");
        names.put(FN.ENCODE_FOR_URI.stringValue(), "ENCODE_FOR_URI");
        names.put(FN.CONCAT.stringValue(), "CONCAT");
        names.put("http://www.w3.org/2005/xpath-functions#matches", "REGEX");
        names.put(FN.REPLACE.stringValue(), "REPLACE");
        names.put(FN.NUMERIC_ABS.stringValue(), "ABS");
        names.put(FN.NUMERIC_ROUND.stringValue(), "ROUND");
        names.put(FN.NUMERIC_CEIL.stringValue(), "CEIL");
        names.put(FN.NUMERIC_FLOOR.stringValue(), "FLOOR");
        names.put(FN.YEAR_FROM_DATETIME.stringValue(), "YEAR");
        names.put(FN.MONTH_FROM_DATETIME.stringValue(), "MONTH");
        names.put(FN.DAY_FROM_DATETIME.stringValue(), "DAY");
        names.put(FN.HOURS_FROM_DATETIME.stringValue(), "HOURS");
        names.put(FN.MINUTES_FROM_DATETIME.stringValue(), "MINUTES");
        names.put(FN.SECONDS_FROM_DATETIME.stringValue(), "SECONDS");
        names.put(FN.TIMEZONE_FROM_DATETIME.stringValue(), "TIMEZONE");
        NAMES = Collections.unmodifiableMap(names);
    }

    private static final class Query {
        final QueryModelNode root;
        final Form form;
        @Nullable
        final Modifier modifier;
        final List<ProjectionElem> select;
        @Nullable
        final TupleExpr construct;
        @Nullable
        final Dataset from;
        final TupleExpr where;
        final List<ProjectionElem> groupBy;
        @Nullable
        final ValueExpr having;
        final List<OrderElem> orderBy;
        @Nullable
        final Long offset;
        @Nullable
        final Long limit;

        static Query create(TupleExpr rootNode, @Nullable Dataset dataset, boolean forceSelect) {
            Preconditions.checkNotNull((Object)rootNode);
            if (rootNode instanceof EmptySet) {
                return new Query((QueryModelNode)rootNode, Form.CONSTRUCT, null, null, rootNode, dataset, rootNode, null, null, null, null, null);
            }
            Form form = null;
            Modifier modifier = null;
            ArrayList select = Lists.newArrayList();
            SingletonSet construct = null;
            TupleExpr where = null;
            ArrayList groupBy = Lists.newArrayList();
            ValueExpr having = null;
            ArrayList orderBy = Lists.newArrayList();
            Long offset = null;
            Long limit = null;
            List<UnaryTupleOperator> nodes = Query.extractQueryNodes(rootNode, false);
            where = nodes.size() > 0 ? nodes.get(nodes.size() - 1).getArg() : rootNode;
            for (UnaryTupleOperator node : nodes) {
                if (node instanceof DescribeOperator) {
                    form = Form.DESCRIBE;
                    continue;
                }
                if (node instanceof Distinct) {
                    modifier = Modifier.DISTINCT;
                    continue;
                }
                if (node instanceof Reduced) {
                    modifier = Modifier.REDUCED;
                    continue;
                }
                if (node instanceof Projection) {
                    boolean isConstruct;
                    Map<String, ExtensionElem> extensions = Query.extractExtensions((TupleExpr)node);
                    List projections = ((Projection)node).getProjectionElemList().getElements();
                    boolean bl = isConstruct = projections.size() >= 3 && "subject".equals(((ProjectionElem)projections.get(0)).getTargetName()) && "predicate".equals(((ProjectionElem)projections.get(1)).getTargetName()) && "object".equals(((ProjectionElem)projections.get(2)).getTargetName()) && (projections.size() == 3 || projections.size() == 4 && "context".equals(((ProjectionElem)projections.get(3)).getTargetName()));
                    if (isConstruct && !forceSelect) {
                        form = Form.CONSTRUCT;
                        construct = Query.extractConstructExpression(extensions, Collections.singleton(((Projection)node).getProjectionElemList()));
                        continue;
                    }
                    form = form == null ? Form.SELECT : form;
                    for (ProjectionElem projection : projections) {
                        String variable = projection.getTargetName();
                        ExtensionElem extension = extensions.get(variable);
                        if (extension == null && projection.getSourceName() != null) {
                            extension = extensions.get(projection.getSourceName());
                        }
                        ProjectionElem newProjection = new ProjectionElem();
                        newProjection.setTargetName(variable);
                        newProjection.setSourceExpression(extension);
                        newProjection.setSourceName(extension == null || !(extension.getExpr() instanceof Var) ? projection.getSourceName() : ((Var)extension.getExpr()).getName());
                        select.add(newProjection);
                    }
                    continue;
                }
                if (node instanceof MultiProjection) {
                    form = Form.CONSTRUCT;
                    construct = Query.extractConstructExpression(Query.extractExtensions((TupleExpr)node), ((MultiProjection)node).getProjections());
                    continue;
                }
                if (node instanceof Group) {
                    Group group = (Group)node;
                    Map<String, ExtensionElem> extensions = Query.extractExtensions(group.getArg());
                    for (String variableName : group.getGroupBindingNames()) {
                        ExtensionElem extension = extensions.get(variableName);
                        ProjectionElem projection = new ProjectionElem();
                        projection.setTargetName(variableName);
                        projection.setSourceExpression(extension);
                        projection.setSourceName(extension == null || !(extension.getExpr() instanceof Var) ? variableName : ((Var)extension.getExpr()).getName());
                        groupBy.add(projection);
                    }
                    continue;
                }
                if (node instanceof Order) {
                    orderBy.addAll(((Order)node).getElements());
                    continue;
                }
                if (node instanceof Slice) {
                    Slice slice = (Slice)node;
                    offset = slice.getOffset() < 0L ? null : Long.valueOf(slice.getOffset());
                    Long l = limit = slice.getLimit() < 0L ? null : Long.valueOf(slice.getLimit());
                    if (form != null || slice.getOffset() != 0L || slice.getLimit() != 1L) continue;
                    if (forceSelect) {
                        form = Form.SELECT;
                        limit = 1L;
                        continue;
                    }
                    form = Form.ASK;
                    continue;
                }
                if (!(node instanceof Filter)) continue;
                having = ((Filter)node).getCondition();
            }
            if ((form = (Form)((Object)SPARQLRenderer.defaultIfNull(form, (Object)Form.SELECT))) == Form.CONSTRUCT && construct == null) {
                construct = new SingletonSet();
            }
            return new Query((QueryModelNode)rootNode, form, modifier, select, (TupleExpr)construct, dataset, where, groupBy, having, orderBy, offset, limit);
        }

        private static List<UnaryTupleOperator> extractQueryNodes(TupleExpr rootNode, boolean haltOnGroup) {
            int index;
            ArrayList nodes = Lists.newArrayList();
            TupleExpr queryNode = rootNode;
            while (queryNode instanceof UnaryTupleOperator) {
                nodes.add((UnaryTupleOperator)queryNode);
                queryNode = ((UnaryTupleOperator)queryNode).getArg();
            }
            boolean describeFound = false;
            boolean modifierFound = false;
            boolean projectionFound = false;
            boolean groupFound = false;
            boolean orderFound = false;
            boolean sliceFound = false;
            boolean extensionFound = false;
            for (index = 0; index < nodes.size(); ++index) {
                UnaryTupleOperator node = (UnaryTupleOperator)nodes.get(index);
                if (node instanceof DescribeOperator && !describeFound) {
                    describeFound = true;
                    continue;
                }
                if ((node instanceof Distinct || node instanceof Reduced) && !modifierFound && !projectionFound) {
                    modifierFound = true;
                    continue;
                }
                if ((node instanceof Projection || node instanceof MultiProjection) && !projectionFound) {
                    projectionFound = true;
                    continue;
                }
                if (node instanceof Group && !groupFound && !haltOnGroup) {
                    groupFound = true;
                    continue;
                }
                if (node instanceof Order && !orderFound) {
                    orderFound = true;
                    continue;
                }
                if (node instanceof Slice && !sliceFound) {
                    sliceFound = true;
                    continue;
                }
                if (node instanceof Filter && !groupFound && !haltOnGroup) {
                    int i;
                    for (i = index + 1; i < nodes.size() && nodes.get(i) instanceof Extension; ++i) {
                    }
                    if (i >= nodes.size() || !(nodes.get(i) instanceof Group)) break;
                    groupFound = true;
                    index = i;
                    continue;
                }
                if (node instanceof Extension && !extensionFound) {
                    extensionFound = true;
                    continue;
                }
                if (!(node instanceof QueryRoot) || index > 0) break;
            }
            return nodes.subList(0, index);
        }

        private static Map<String, ExtensionElem> extractExtensions(TupleExpr rootNode) {
            HashMap map = Maps.newHashMap();
            for (UnaryTupleOperator node : Query.extractQueryNodes(rootNode, true)) {
                if (!(node instanceof Extension)) continue;
                for (ExtensionElem elem : ((Extension)node).getElements()) {
                    String variable = elem.getName();
                    ValueExpr expression = elem.getExpr();
                    if (expression instanceof Var && ((Var)expression).getName().equals(variable)) continue;
                    map.put(variable, elem);
                }
            }
            return map;
        }

        private static TupleExpr extractConstructExpression(Map<String, ExtensionElem> extensions, Iterable<? extends ProjectionElemList> multiProjections) {
            StatementPattern expression = null;
            for (ProjectionElemList projectionElemList : multiProjections) {
                Var subj = Query.extractConstructVar(extensions, (ProjectionElem)projectionElemList.getElements().get(0));
                Var pred = Query.extractConstructVar(extensions, (ProjectionElem)projectionElemList.getElements().get(1));
                Var obj = Query.extractConstructVar(extensions, (ProjectionElem)projectionElemList.getElements().get(2));
                Var ctx = projectionElemList.getElements().size() < 4 ? null : Query.extractConstructVar(extensions, (ProjectionElem)projectionElemList.getElements().get(3));
                StatementPattern pattern = new StatementPattern(ctx == null ? StatementPattern.Scope.DEFAULT_CONTEXTS : StatementPattern.Scope.NAMED_CONTEXTS, subj, pred, obj, ctx);
                expression = expression == null ? pattern : new Join((TupleExpr)expression, (TupleExpr)pattern);
            }
            return expression;
        }

        private static Var extractConstructVar(Map<String, ExtensionElem> extensions, ProjectionElem projection) {
            ExtensionElem extension = extensions.get(projection.getSourceName());
            String name = projection.getSourceName();
            if (name.startsWith("-anon-")) {
                name = name + "-construct";
            }
            if (extension == null || extension.getExpr() instanceof BNodeGenerator) {
                Var var = new Var(name);
                var.setAnonymous(name.startsWith("-anon-"));
                return var;
            }
            if (extension.getExpr() instanceof ValueConstant) {
                ValueConstant constant = (ValueConstant)extension.getExpr();
                return new Var(name, constant.getValue());
            }
            throw new UnsupportedOperationException("Unsupported extension in construct query: " + extension);
        }

        private Query(QueryModelNode root, Form form, @Nullable Modifier modifier, @Nullable Iterable<? extends ProjectionElem> selectist, @Nullable TupleExpr construct, @Nullable Dataset from, TupleExpr where, @Nullable Iterable<? extends ProjectionElem> groupByt, @Nullable ValueExpr having, @Nullable Iterable<? extends OrderElem> orderBy, @Nullable Long offset, @Nullable Long limit) {
            this.root = (QueryModelNode)Preconditions.checkNotNull((Object)root);
            this.form = (Form)((Object)Preconditions.checkNotNull((Object)((Object)form)));
            this.modifier = modifier;
            this.select = selectist == null ? ImmutableList.of() : ImmutableList.copyOf(selectist);
            this.construct = construct;
            this.from = from;
            this.where = (TupleExpr)Preconditions.checkNotNull((Object)where);
            this.groupBy = groupByt == null ? ImmutableList.of() : ImmutableList.copyOf(groupByt);
            this.having = having;
            this.orderBy = orderBy == null ? ImmutableList.of() : ImmutableList.copyOf(orderBy);
            this.offset = offset;
            this.limit = limit;
        }
    }

    private static enum Modifier {
        DISTINCT,
        REDUCED;

    }

    private static enum Form {
        SELECT,
        CONSTRUCT,
        ASK,
        DESCRIBE;

    }

    private final class Rendering
    implements QueryModelVisitor<RuntimeException> {
        final TupleExpr root;
        @Nullable
        final Dataset dataset;
        final String body;
        String base;
        private final StringBuilder builder;
        private final Set<String> namespaces;
        private int indent;

        private Rendering(@Nullable TupleExpr node, Dataset dataset) {
            this.root = new QueryRoot((TupleExpr)Preconditions.checkNotNull((Object)node));
            this.dataset = dataset;
            this.builder = new StringBuilder();
            this.namespaces = Sets.newHashSet();
            this.indent = 0;
            this.emit(Query.create(this.root, this.dataset, SPARQLRenderer.this.forceSelect));
            this.body = this.builder.toString();
            this.builder.setLength(0);
        }

        private Rendering emitIf(boolean condition, Object object) {
            if (condition) {
                this.emit(object);
            }
            return this;
        }

        private Rendering emit(Iterable<?> values, String separator) {
            boolean first = true;
            for (Object value : values) {
                if (!first) {
                    this.emit(separator);
                }
                this.emit(value);
                first = false;
            }
            return this;
        }

        private Rendering emit(Object value) {
            if (value instanceof String) {
                return this.emit((String)value);
            }
            if (value instanceof QueryModelNode) {
                this.emit((QueryModelNode)value);
            } else if (value instanceof BNode) {
                this.emit((BNode)value);
            } else if (value instanceof URI) {
                this.emit((URI)value);
            } else if (value instanceof Literal) {
                this.emit((Literal)value);
            } else if (value instanceof List) {
                this.emit((List)value);
            } else if (value instanceof Query) {
                this.emit((Query)value);
            }
            return this;
        }

        private Rendering emit(String string) {
            this.builder.append(string);
            return this;
        }

        private Rendering emit(Literal literal) {
            if (XMLSchema.INTEGER.equals((Object)literal.getDatatype())) {
                this.builder.append(literal.getLabel());
            } else {
                this.builder.append("\"");
                SPARQLRenderer.escape(literal.getLabel(), this.builder);
                this.builder.append("\"");
                if (literal.getDatatype() != null) {
                    this.builder.append("^^");
                    this.emit(literal.getDatatype());
                } else if (literal.getLanguage() != null) {
                    this.builder.append("@").append(literal.getLanguage());
                }
            }
            return this;
        }

        private Rendering emit(BNode bnode) {
            this.builder.append("_:").append(bnode.getID());
            return this;
        }

        private Rendering emit(URI uri) {
            if (uri.getNamespace().equals("http://www.openlinksw.com/schema/sparql/extensions#")) {
                this.builder.append("bif:").append(uri.getLocalName());
            } else {
                String prefix = (String)SPARQLRenderer.this.prefixes.get(uri.getNamespace());
                if (prefix != null) {
                    if (this.namespaces != null) {
                        this.namespaces.add(uri.getNamespace());
                    }
                    this.builder.append(prefix).append(':').append(uri.getLocalName());
                } else {
                    this.builder.append("<");
                    SPARQLRenderer.escape(uri.toString(), this.builder);
                    this.builder.append(">");
                }
            }
            return this;
        }

        private Rendering emit(List<StatementPattern> bgp) {
            if (bgp.isEmpty()) {
                return this;
            }
            Var c = bgp.get(0).getContextVar();
            if (c != null) {
                this.emit("GRAPH ").emit((QueryModelNode)c).emit(" ").openBrace();
            }
            StatementPattern l = null;
            for (StatementPattern n : bgp) {
                Var s = n.getSubjectVar();
                Var p = n.getPredicateVar();
                Var o = n.getObjectVar();
                if (l == null) {
                    this.emit((QueryModelNode)s).emit(" ").emit((QueryModelNode)p).emit(" ").emit((QueryModelNode)o);
                } else if (!l.getSubjectVar().equals((Object)n.getSubjectVar())) {
                    this.emit(" .").newline().emit((QueryModelNode)s).emit(" ").emit((QueryModelNode)p).emit(" ").emit((QueryModelNode)o);
                } else if (!l.getPredicateVar().equals((Object)n.getPredicateVar())) {
                    this.emit(" ;").newline().emit("\t").emit((QueryModelNode)p).emit(" ").emit((QueryModelNode)o);
                } else if (!l.getObjectVar().equals((Object)n.getObjectVar())) {
                    this.emit(" , ").emit((QueryModelNode)o);
                }
                l = n;
            }
            this.emit(" .");
            if (c != null) {
                this.closeBrace();
            }
            return this;
        }

        private Rendering emit(Query query) {
            if (query.root != this.root) {
                this.openBrace();
            }
            if (query.form == Form.ASK) {
                this.emit("ASK");
            } else if (query.form == Form.CONSTRUCT) {
                this.emit("CONSTRUCT ").openBrace().emit((QueryModelNode)query.construct).closeBrace();
            } else if (query.form == Form.DESCRIBE) {
                this.emit("DESCRIBE");
                for (ProjectionElem projectionElem : query.select) {
                    ExtensionElem e = projectionElem.getSourceExpression();
                    this.emit(" ").emit((QueryModelNode)(e != null && e.getExpr() instanceof ValueConstant ? e.getExpr() : projectionElem));
                }
            } else if (query.form == Form.SELECT) {
                this.emit("SELECT");
                if (query.modifier != null) {
                    this.emit(" ").emit(query.modifier.toString().toUpperCase());
                }
                if (query.select.isEmpty()) {
                    int count = 0;
                    for (String var : query.where.getBindingNames()) {
                        ValueExpr expr = SPARQLRenderer.getVarExpr((QueryModelNode)query.where, var);
                        if (var.startsWith("-")) continue;
                        if (expr == null) {
                            this.emit(" ?").emit(var);
                        } else {
                            this.emit(" (").emit((QueryModelNode)expr).emit(" AS ?").emit(var).emit(")");
                        }
                        ++count;
                    }
                    if (count == 0) {
                        this.emit(" *");
                    }
                } else {
                    this.emit(" ").emit(query.select, " ");
                }
            }
            if (query.from != null) {
                for (URI uRI : query.from.getDefaultGraphs()) {
                    this.newline().emit("FROM ").emit(uRI);
                }
                for (URI uRI : query.from.getNamedGraphs()) {
                    this.newline().emit("FROM NAMED ").emit(uRI);
                }
            }
            if (query.form != Form.DESCRIBE || !(query.where instanceof SingletonSet)) {
                this.newline().emit("WHERE ").openBrace().emit((QueryModelNode)query.where).closeBrace();
            }
            if (!query.groupBy.isEmpty()) {
                this.newline().emit("GROUP BY");
                for (ProjectionElem projectionElem : query.groupBy) {
                    this.emit(" ?").emit(projectionElem.getTargetName());
                }
            }
            if (query.having != null) {
                this.newline().emit("HAVING (").emit((QueryModelNode)query.having).emit(")");
            }
            if (!query.orderBy.isEmpty()) {
                this.newline().emit("ORDER BY ").emit(query.orderBy, " ");
            }
            if (query.form != Form.ASK) {
                if (query.offset != null) {
                    this.newline().emit("OFFSET " + query.offset);
                }
                if (query.limit != null) {
                    this.newline().emit("LIMIT " + query.limit);
                }
            }
            if (query.root != this.root) {
                this.closeBrace();
            }
            return this;
        }

        private Rendering emit(QueryModelNode n) {
            boolean braces;
            QueryModelNode p = n.getParentNode();
            boolean bl = braces = n instanceof TupleExpr && p != null && !(p instanceof TupleExpr);
            if (braces) {
                this.openBrace();
            }
            n.visit((QueryModelVisitor)this);
            if (braces) {
                this.closeBrace();
            }
            return this;
        }

        private Rendering emit(QueryModelNode node, boolean parenthesis) {
            if (parenthesis) {
                if (node instanceof TupleExpr) {
                    this.openBrace();
                } else {
                    this.emit("(");
                }
            }
            this.emit(node);
            if (parenthesis) {
                if (node instanceof TupleExpr) {
                    this.closeBrace();
                } else {
                    this.emit(")");
                }
            }
            return this;
        }

        private Rendering openBrace() {
            this.emit("{");
            ++this.indent;
            this.newline();
            return this;
        }

        private Rendering closeBrace() {
            --this.indent;
            this.newline();
            this.emit("}");
            return this;
        }

        private Rendering newline() {
            this.emit("\n");
            for (int i = 0; i < this.indent; ++i) {
                this.emit("\t");
            }
            return this;
        }

        private Rendering fail(String message, QueryModelNode node) {
            throw new IllegalArgumentException("SPARQL rendering failed. " + message + (node == null ? "null" : node.getClass().getSimpleName() + "\n" + node));
        }

        public void meet(OrderElem n) {
            this.emit(n.isAscending() ? "ASC(" : "DESC(").emit((QueryModelNode)n.getExpr()).emit(")");
        }

        public void meet(ProjectionElemList node) {
            this.emit(node.getElements(), " ");
        }

        public void meet(ProjectionElem n) {
            ValueExpr expr;
            String source = n.getSourceName();
            String target = n.getTargetName();
            ValueExpr valueExpr = expr = n.getSourceExpression() == null ? null : n.getSourceExpression().getExpr();
            if (target.startsWith("-")) {
                if (expr != null) {
                    this.emit("(").emit((QueryModelNode)expr).emit(" AS ?").emit(SPARQLRenderer.sanitize(target)).emit(")");
                }
            } else if (expr != null) {
                this.emit("(").emit((QueryModelNode)expr).emit(" AS ?").emit(target).emit(")");
            } else if (!SPARQLRenderer.equalOrNull(source, target)) {
                this.emit("(?").emit(source).emit(" AS ?").emit(target).emit(")");
            } else {
                this.emit("?").emit(target);
            }
        }

        public void meet(GroupElem n) {
            ProjectionElem e = new ProjectionElem();
            e.setTargetName(n.getName());
            e.setSourceName(n.getName());
            e.setSourceExpression(new ExtensionElem((ValueExpr)n.getOperator(), n.getName()));
            this.meet(e);
        }

        public void meet(DescribeOperator n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(QueryRoot n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(Projection n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(MultiProjection n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(Distinct n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(Reduced n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(Group n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(Order n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(Slice n) {
            this.emit(Query.create((TupleExpr)n, null, SPARQLRenderer.this.forceSelect));
        }

        public void meet(EmptySet n) {
            QueryModelNode p = n.getParentNode();
            if (p.getParentNode() != null && !(p.getParentNode() instanceof QueryRoot)) {
                throw new IllegalArgumentException("Cannot translate EmptySet inside the body of a query / update operation");
            }
            this.emit("CONSTRUCT {} WHERE {}");
        }

        public void meet(SingletonSet n) {
        }

        public void meet(BindingSetAssignment n) {
            Set names = n.getBindingNames();
            if (names.isEmpty()) {
                this.emit("VALUES {}");
            } else if (names.size() == 1) {
                String name = (String)names.iterator().next();
                this.emit("VALUES ?").emit(name).emit(" ").openBrace();
                boolean first = true;
                for (BindingSet bindings : n.getBindingSets()) {
                    this.emitIf(!first, " ").emit(SPARQLRenderer.defaultIfNull(bindings.getValue(name), "UNDEF"));
                    first = false;
                }
                this.closeBrace();
            } else {
                this.emit("VALUES (?").emit(names, " ?").emit(") ").openBrace();
                boolean firstBinding = true;
                for (BindingSet bindings : n.getBindingSets()) {
                    if (!firstBinding) {
                        this.newline();
                    }
                    this.emit("(");
                    boolean first = true;
                    for (String name : names) {
                        this.emitIf(!first, " ").emit(SPARQLRenderer.defaultIfNull(bindings.getValue(name), "UNDEF"));
                        first = false;
                    }
                    this.emit(")");
                    firstBinding = false;
                }
                this.closeBrace();
            }
        }

        public void meet(StatementPattern n) {
            this.emit(SPARQLRenderer.getBGP((QueryModelNode)n));
        }

        public void meet(Extension n) {
            this.emit((QueryModelNode)n.getArg());
            if (!(n.getArg() instanceof SingletonSet)) {
                this.newline();
            }
            boolean first = true;
            for (ExtensionElem e : n.getElements()) {
                ValueExpr expr = e.getExpr();
                if (expr instanceof Var && ((Var)expr).getName().equals(e.getName())) continue;
                if (!first) {
                    this.newline();
                }
                this.emit("BIND (").emit((QueryModelNode)expr).emit(" AS ?").emit(e.getName()).emit(")");
                first = false;
            }
        }

        public void meet(ExtensionElem n) {
            throw new Error("Should not be directly called");
        }

        public void meet(Filter n) {
            ValueExpr cond = n.getCondition();
            boolean nopar = cond instanceof Exists || cond instanceof Not && ((Not)cond).getArg() instanceof Exists;
            this.emit((QueryModelNode)n.getArg());
            if (!(n.getArg() instanceof SingletonSet)) {
                this.newline();
            }
            this.emit("FILTER ").emit((QueryModelNode)cond, !nopar);
        }

        public void meet(Service n) {
            this.newline().emit("SERVICE ").emitIf(n.isSilent(), "SILENT ").openBrace().emit((QueryModelNode)n.getServiceExpr()).closeBrace().emit(" ").emit((QueryModelNode)n.getServiceRef());
        }

        public void meet(Join n) {
            List bgp = SPARQLRenderer.getBGP((QueryModelNode)n);
            if (bgp != null) {
                this.emit(bgp);
            } else {
                TupleExpr l = n.getLeftArg();
                TupleExpr r = n.getRightArg();
                boolean norpar = r instanceof Join || r instanceof StatementPattern || r instanceof SingletonSet || r instanceof Service || r instanceof Union || r instanceof BindingSetAssignment || r instanceof ArbitraryLengthPath;
                this.emit((QueryModelNode)l).newline().emit((QueryModelNode)r, !norpar);
            }
        }

        public void meet(LeftJoin n) {
            TupleExpr l = n.getLeftArg();
            TupleExpr r = n.getCondition() == null ? n.getRightArg() : new Filter(n.getRightArg(), n.getCondition());
            this.emit((QueryModelNode)l);
            if (!(l instanceof SingletonSet)) {
                this.newline();
            }
            this.emit("OPTIONAL ").emit((QueryModelNode)r, true);
        }

        public void meet(Union n) {
            ZeroLengthPath p;
            TupleExpr l = n.getLeftArg();
            TupleExpr r = n.getRightArg();
            Object object = l instanceof ZeroLengthPath ? (ZeroLengthPath)l : (p = r instanceof ZeroLengthPath ? (ZeroLengthPath)r : null);
            if (p == null) {
                this.emit((QueryModelNode)l, !(l instanceof Union)).emit(" UNION ").emit((QueryModelNode)r, !(r instanceof Union));
            } else {
                Var s = p.getSubjectVar();
                Var o = p.getObjectVar();
                Var c = p.getContextVar();
                if (c != null) {
                    this.emit("GRAPH ").emit((QueryModelNode)c).emit(" ").openBrace();
                }
                this.emit((QueryModelNode)s).emit(" ").emitPropertyPath((TupleExpr)n, s, o).emit(" ").emit((QueryModelNode)o);
                if (c != null) {
                    this.closeBrace();
                }
            }
        }

        public void meet(Difference n) {
            TupleExpr l = n.getLeftArg();
            TupleExpr r = n.getRightArg();
            this.emit((QueryModelNode)l, true).emit(" MINUS ").emit((QueryModelNode)r, true);
        }

        public void meet(ArbitraryLengthPath n) {
            Var s = n.getSubjectVar();
            Var o = n.getObjectVar();
            Var c = n.getContextVar();
            if (c != null) {
                this.emit("GRAPH ").emit((QueryModelNode)c).openBrace();
            }
            this.emit((QueryModelNode)s).emit(" ").emitPropertyPath((TupleExpr)n, s, o).emit(" ").emit((QueryModelNode)o).emit(" .");
            if (c != null) {
                this.closeBrace();
            }
        }

        public void meet(ZeroLengthPath node) {
            throw new Error("Should not be directly called");
        }

        private Rendering emitPropertyPath(TupleExpr node, Var start, Var end) {
            boolean parenthesis = !(node instanceof StatementPattern) && (node.getParentNode() instanceof ArbitraryLengthPath || node.getParentNode() instanceof Union);
            this.emitIf(parenthesis, "(");
            if (node instanceof StatementPattern) {
                StatementPattern pattern = (StatementPattern)node;
                boolean inverse = this.isInversePath(pattern, start, end);
                if (!pattern.getPredicateVar().hasValue() || !pattern.getPredicateVar().isAnonymous()) {
                    this.fail("Unsupported path expression. Check node: ", (QueryModelNode)node);
                }
                this.emitIf(inverse, "^").emit(pattern.getPredicateVar().getValue());
            } else if (node instanceof Join) {
                StatementPattern s;
                Join j = (Join)node;
                TupleExpr l = j.getLeftArg();
                TupleExpr r = j.getRightArg();
                Object object = l instanceof StatementPattern ? (StatementPattern)l : (s = r instanceof StatementPattern ? (StatementPattern)r : null);
                if (s == null) {
                    return this.fail("Cannot process property path", (QueryModelNode)node);
                }
                Var m = s.getSubjectVar().equals((Object)start) || s.getSubjectVar().equals((Object)end) ? s.getObjectVar() : s.getSubjectVar();
                this.emitPropertyPath(l, start, m);
                this.emit("/");
                this.emitPropertyPath(r, m, end);
            } else if (node instanceof ArbitraryLengthPath) {
                ArbitraryLengthPath path = (ArbitraryLengthPath)node;
                Preconditions.checkArgument((path.getMinLength() <= 1L ? 1 : 0) != 0, (Object)"Invalid path length");
                this.emitPropertyPath(path.getPathExpression(), start, end).emit(path.getMinLength() == 0L ? "*" : "+");
            } else if (node instanceof Union) {
                Union union = (Union)node;
                if (union.getLeftArg() instanceof ZeroLengthPath) {
                    this.emitPropertyPath(union.getRightArg(), start, end).emit("?");
                } else if (union.getRightArg() instanceof ZeroLengthPath) {
                    this.emitPropertyPath(union.getLeftArg(), start, end).emit("?");
                } else {
                    this.emitPropertyPath(union.getLeftArg(), start, end);
                    this.emit("|");
                    this.emitPropertyPath(union.getRightArg(), start, end);
                }
            } else if (node instanceof Filter) {
                Filter filter = (Filter)node;
                Preconditions.checkArgument((boolean)(filter.getArg() instanceof StatementPattern));
                StatementPattern pattern = (StatementPattern)filter.getArg();
                boolean inverse = this.isInversePath(pattern, start, end);
                Preconditions.checkArgument((!pattern.getPredicateVar().hasValue() && pattern.getPredicateVar().isAnonymous() ? 1 : 0) != 0);
                LinkedHashSet negatedProperties = Sets.newLinkedHashSet();
                this.extractNegatedProperties(filter.getCondition(), negatedProperties);
                if (negatedProperties.size() == 1) {
                    this.emit("!").emitIf(inverse, "^").emit((URI)negatedProperties.iterator().next());
                } else {
                    this.emit("!(");
                    boolean first = true;
                    for (URI negatedProperty : negatedProperties) {
                        this.emitIf(!first, "|").emitIf(inverse, "^").emit(negatedProperty);
                        first = false;
                    }
                    this.emit(")");
                }
            } else {
                this.fail("Unsupported path expression node", (QueryModelNode)node);
            }
            return this.emitIf(parenthesis, ")");
        }

        private void extractNegatedProperties(ValueExpr condition, Set<URI> negatedProperties) {
            if (condition instanceof And) {
                And and = (And)condition;
                this.extractNegatedProperties(and.getLeftArg(), negatedProperties);
                this.extractNegatedProperties(and.getRightArg(), negatedProperties);
            } else if (condition instanceof Compare) {
                Compare compare = (Compare)condition;
                Preconditions.checkArgument((compare.getOperator() == Compare.CompareOp.NE ? 1 : 0) != 0);
                if (compare.getLeftArg() instanceof ValueConstant) {
                    Preconditions.checkArgument((boolean)(compare.getRightArg() instanceof Var));
                    negatedProperties.add((URI)((ValueConstant)compare.getLeftArg()).getValue());
                } else if (compare.getRightArg() instanceof ValueConstant) {
                    Preconditions.checkArgument((boolean)(compare.getLeftArg() instanceof Var));
                    negatedProperties.add((URI)((ValueConstant)compare.getRightArg()).getValue());
                } else {
                    this.fail("Unsupported path expression. Check condition node: ", (QueryModelNode)condition);
                }
            }
        }

        private boolean isInversePath(StatementPattern node, Var start, Var end) {
            if (node.getSubjectVar().equals((Object)start)) {
                Preconditions.checkArgument((boolean)node.getObjectVar().equals((Object)end));
                return false;
            }
            if (node.getObjectVar().equals((Object)start)) {
                Preconditions.checkArgument((boolean)node.getSubjectVar().equals((Object)end));
                return true;
            }
            this.fail("Unsupported path expression. Check node: ", (QueryModelNode)node);
            return false;
        }

        public void meet(Intersection n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(Add add) {
            throw new UnsupportedOperationException();
        }

        public void meet(Clear clear) {
            throw new UnsupportedOperationException();
        }

        public void meet(Copy copy) {
            throw new UnsupportedOperationException();
        }

        public void meet(Create create) {
            throw new UnsupportedOperationException();
        }

        public void meet(DeleteData deleteData) {
            throw new UnsupportedOperationException();
        }

        public void meet(InsertData insertData) {
            throw new UnsupportedOperationException();
        }

        public void meet(Load load) {
            throw new UnsupportedOperationException();
        }

        public void meet(Modify modify) {
            throw new UnsupportedOperationException();
        }

        public void meet(Move move) {
            throw new UnsupportedOperationException();
        }

        public void meet(ValueConstant n) {
            this.emit(n.getValue());
        }

        public void meet(Var n) {
            String name = n.getName();
            if (n.getValue() != null) {
                this.emit(n.getValue());
            } else if (!n.isAnonymous()) {
                this.emit("?" + n.getName());
            } else {
                ValueExpr expr = SPARQLRenderer.getVarExpr((QueryModelNode)this.root, n.getName());
                if (expr != null) {
                    this.emit((QueryModelNode)expr);
                } else if (SPARQLRenderer.getVarRefs((QueryModelNode)this.root, n.getName()) <= 1) {
                    this.emit("[]");
                } else {
                    this.emit("?").emit(SPARQLRenderer.sanitize(name));
                }
            }
        }

        public void meet(Compare n) {
            QueryModelNode p = n.getParentNode();
            boolean par = p instanceof Not || p instanceof MathExpr;
            this.emitIf(par, "(").emit((QueryModelNode)n.getLeftArg()).emit(" ").emit(n.getOperator().getSymbol()).emit(" ").emit((QueryModelNode)n.getRightArg()).emitIf(par, ")");
        }

        public void meet(ListMemberOperator n) {
            QueryModelNode p = n.getParentNode();
            boolean par = p instanceof Not || p instanceof MathExpr;
            List args = n.getArguments();
            this.emitIf(par, "(").emit((QueryModelNode)args.get(0)).emit(" in (").emit(args.subList(1, args.size()), ", ").emit(")").emitIf(par, ")");
        }

        public void meet(MathExpr n) {
            QueryModelNode p = n.getParentNode();
            MathExpr.MathOp op = n.getOperator();
            MathExpr.MathOp pop = p instanceof MathExpr ? ((MathExpr)p).getOperator() : null;
            boolean r = p instanceof BinaryValueOperator && n == ((BinaryValueOperator)p).getRightArg();
            boolean par = p instanceof Not || (op == MathExpr.MathOp.PLUS || op == MathExpr.MathOp.MINUS) && (pop == MathExpr.MathOp.MINUS && r || pop == MathExpr.MathOp.DIVIDE || pop == MathExpr.MathOp.MULTIPLY) || (op == MathExpr.MathOp.MULTIPLY || op == MathExpr.MathOp.DIVIDE) && pop == MathExpr.MathOp.DIVIDE && r;
            this.emitIf(par, "(").emit((QueryModelNode)n.getLeftArg()).emit(" ").emit(op.getSymbol()).emit(" ").emit((QueryModelNode)n.getRightArg()).emitIf(par, ")");
        }

        public void meet(And n) {
            QueryModelNode p = n.getParentNode();
            boolean needPar = p instanceof Not || p instanceof MathExpr || p instanceof ListMemberOperator || p instanceof Compare;
            this.emitIf(needPar, "(").emit((QueryModelNode)n.getLeftArg()).emit(" && ").emit((QueryModelNode)n.getRightArg()).emitIf(needPar, ")");
        }

        public void meet(Or n) {
            QueryModelNode p = n.getParentNode();
            boolean needPar = p instanceof Not || p instanceof And || p instanceof MathExpr || p instanceof ListMemberOperator || p instanceof Compare;
            this.emitIf(needPar, "(").emit((QueryModelNode)n.getLeftArg()).emit(" || ").emit((QueryModelNode)n.getRightArg()).emitIf(needPar, ")");
        }

        public void meet(Not n) {
            String op = n.getArg() instanceof Exists ? "NOT " : "!";
            this.emit(op).emit((QueryModelNode)n.getArg());
        }

        public void meet(Count node) {
            this.emit("COUNT(").emitIf(node.isDistinct(), "DISTINCT ").emit(SPARQLRenderer.defaultIfNull(node.getArg(), "*")).emit(")");
        }

        public void meet(Sum node) {
            this.emit("SUM(").emitIf(node.isDistinct(), "DISTINCT ").emit((QueryModelNode)node.getArg()).emit(")");
        }

        public void meet(Min node) {
            this.emit("MIN(").emitIf(node.isDistinct(), "DISTINCT ").emit((QueryModelNode)node.getArg()).emit(")");
        }

        public void meet(Max node) {
            this.emit("MAX(").emitIf(node.isDistinct(), "DISTINCT ").emit((QueryModelNode)node.getArg()).emit(")");
        }

        public void meet(Avg node) {
            this.emit("AVG(").emitIf(node.isDistinct(), "DISTINCT ").emit((QueryModelNode)node.getArg()).emit(")");
        }

        public void meet(Sample node) {
            this.emit("SAMPLE(").emitIf(node.isDistinct(), "DISTINCT ").emit((QueryModelNode)node.getArg()).emit(")");
        }

        public void meet(GroupConcat node) {
            this.emit("GROUP_CONCAT(").emitIf(node.isDistinct(), "DISTINCT ").emit((QueryModelNode)node.getArg());
            if (node.getSeparator() != null) {
                this.emit(" ; separator=").emit((QueryModelNode)node.getSeparator());
            }
            this.emit(")");
        }

        public void meet(Str n) {
            this.emit("STR(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(Lang n) {
            this.emit("LANG(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(LangMatches n) {
            this.emit("LANGMATCHES(").emit((QueryModelNode)n.getLeftArg()).emit(", ").emit((QueryModelNode)n.getRightArg()).emit(")");
        }

        public void meet(Datatype n) {
            this.emit("DATATYPE(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(Bound n) {
            this.emit("BOUND(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(IRIFunction n) {
            this.emit("IRI(").emit((QueryModelNode)n.getArg()).emit(")");
            if (n.getBaseURI() != null) {
                this.base = n.getBaseURI();
            }
        }

        public void meet(BNodeGenerator n) {
            ValueExpr expr = n.getNodeIdExpr();
            this.emit("BNODE(").emitIf(expr != null, expr).emit(")");
        }

        public void meet(FunctionCall n) {
            String uri = n.getURI();
            String name = (String)NAMES.get(uri);
            if (name == null && NAMES.values().contains(uri.toUpperCase())) {
                name = n.getURI().toUpperCase();
            }
            this.emit((Object)(name != null ? name : new URIImpl(uri))).emit("(").emit(n.getArgs(), ", ").emit(")");
        }

        public void meet(Coalesce n) {
            this.emit("COALESCE(").emit(n.getArguments(), ", ").emit(")");
        }

        public void meet(If n) {
            this.emit("IF(").emit((QueryModelNode)n.getCondition()).emit(", ").emit((QueryModelNode)n.getResult()).emit(", ").emit((QueryModelNode)n.getAlternative()).emit(")");
        }

        public void meet(SameTerm n) {
            this.emit("sameTerm(").emit((QueryModelNode)n.getLeftArg()).emit(", ").emit((QueryModelNode)n.getRightArg()).emit(")");
        }

        public void meet(IsURI n) {
            this.emit("isIRI(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(IsBNode n) {
            this.emit("isBLANK(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(IsLiteral n) {
            this.emit("isLITERAL(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(IsNumeric n) {
            this.emit("isNUMERIC(").emit((QueryModelNode)n.getArg()).emit(")");
        }

        public void meet(Regex n) {
            this.emit("REGEX(").emit((QueryModelNode)n.getArg()).emit(", ").emit((QueryModelNode)n.getPatternArg());
            if (n.getFlagsArg() != null) {
                this.emit(", ").emit((QueryModelNode)n.getFlagsArg());
            }
            this.emit(")");
        }

        public void meet(Exists node) {
            this.emit("EXISTS ").emit((QueryModelNode)node.getSubQuery());
        }

        public void meet(IsResource n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(Label n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(Like n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(LocalName n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(Namespace n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(In n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(CompareAll n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meet(CompareAny n) {
            this.fail("Not a SPARQL 1.1 node", (QueryModelNode)n);
        }

        public void meetOther(QueryModelNode n) {
            this.fail("Unknown node", n);
        }
    }
}

