/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Dictionary;
import eu.fbk.knowledgestore.data.Record;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public final class SerializerAvro {
    private final Dictionary<URI> dictionary;
    private final ValueFactory factory;
    private final DatatypeFactory datatypeFactory;

    public SerializerAvro() {
        this((Dictionary<URI>)((Dictionary)null));
    }

    public SerializerAvro(@Nullable Dictionary<URI> dictionary) {
        this.dictionary = dictionary;
        this.factory = Data.getValueFactory();
        this.datatypeFactory = Data.getDatatypeFactory();
    }

    public SerializerAvro(String fileName) throws IOException {
        this.dictionary = Dictionary.createHadoopDictionary(URI.class, (String)fileName);
        this.factory = Data.getValueFactory();
        this.datatypeFactory = Data.getDatatypeFactory();
    }

    public Dictionary<URI> getDictionary() {
        return this.dictionary;
    }

    public byte[] compressURI(URI uri) {
        Preconditions.checkNotNull((Object)uri);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)stream, null);
            GenericDatumWriter writer = new GenericDatumWriter(Schemas.COMPRESSED_IDENTIFIER);
            this.dictionary.keyFor((Serializable)uri);
            Object generic = this.encodeIdentifier((Resource)uri);
            writer.write(generic, (Encoder)encoder);
            return stream.toByteArray();
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public URI expandURI(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)stream, null);
            GenericDatumReader reader = new GenericDatumReader(Schemas.COMPRESSED_IDENTIFIER);
            Object generic = reader.read(null, (Decoder)decoder);
            return (URI)this.decodeNode(generic);
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public byte[] toBytes(Object object) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.toStream(stream, object);
            return stream.toByteArray();
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public byte[] toBytes(Record object, @Nullable Set<URI> propertiesToSerialize) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.toStream(stream, object, propertiesToSerialize);
            return stream.toByteArray();
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public Object fromBytes(byte[] bytes) {
        try {
            return this.fromStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public Record fromBytes(byte[] bytes, @Nullable Set<URI> propertiesToDeserialize) {
        try {
            return this.fromStream(new ByteArrayInputStream(bytes), propertiesToDeserialize);
        }
        catch (IOException ex) {
            throw new Error("Unexpected exception (!): " + ex.getMessage(), ex);
        }
    }

    public void toStream(OutputStream stream, Object object) throws IOException {
        Object generic = this.encodeNode(object);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(stream, null);
        GenericDatumWriter writer = new GenericDatumWriter(Schemas.NODE);
        writer.write(generic, (Encoder)encoder);
        encoder.flush();
    }

    public void toStream(OutputStream stream, Record object, @Nullable Set<URI> propertiesToSerialize) throws IOException {
        Object generic = this.encodeRecord(object, propertiesToSerialize);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(stream, null);
        GenericDatumWriter writer = new GenericDatumWriter(Schemas.NODE);
        writer.write(generic, (Encoder)encoder);
        encoder.flush();
    }

    public Object fromStream(InputStream stream) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(stream, null);
        GenericDatumReader reader = new GenericDatumReader(Schemas.NODE);
        Object generic = reader.read(null, (Decoder)decoder);
        return this.decodeNode(generic);
    }

    public Record fromStream(InputStream stream, @Nullable Set<URI> propertiesToDeserialize) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(stream, null);
        GenericDatumReader reader = new GenericDatumReader(Schemas.NODE);
        GenericRecord generic = (GenericRecord)reader.read(null, (Decoder)decoder);
        return this.decodeRecord(generic, propertiesToDeserialize);
    }

    private List<Object> decodeNodes(Object generic) {
        if (generic instanceof Iterable) {
            Iterable iterable = (Iterable)generic;
            int size = Iterables.size((Iterable)iterable);
            ArrayList nodes = Lists.newArrayListWithCapacity((int)size);
            for (Object element : iterable) {
                nodes.add(this.decodeNode(element));
            }
            return nodes;
        }
        Preconditions.checkNotNull((Object)generic);
        return ImmutableList.of((Object)this.decodeNode(generic));
    }

    private Object decodeNode(Object generic) {
        if (generic instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)generic;
            Schema schema = record.getSchema();
            if (schema.equals((Object)Schemas.RECORD)) {
                return this.decodeRecord(record, null);
            }
            if (schema.equals((Object)Schemas.PLAIN_IDENTIFIER) || schema.equals((Object)Schemas.COMPRESSED_IDENTIFIER)) {
                return this.decodeIdentifier(record);
            }
            if (schema.equals((Object)Schemas.STATEMENT)) {
                return this.decodeStatement(record);
            }
        }
        return this.decodeLiteral(generic);
    }

    private Record decodeRecord(GenericRecord generic, @Nullable Set<URI> propertiesToDecode) {
        Record record = Record.create();
        GenericRecord encodedID = (GenericRecord)generic.get(0);
        if (encodedID != null) {
            record.setID((URI)this.decodeIdentifier(encodedID));
        }
        for (GenericRecord prop : (Iterable)generic.get(1)) {
            URI property = (URI)this.decodeIdentifier((GenericRecord)prop.get(0));
            List<Object> values = this.decodeNodes(prop.get(1));
            if (propertiesToDecode != null && !propertiesToDecode.contains(property)) continue;
            record.set(property, values, new Object[0]);
        }
        return record;
    }

    private Value decodeValue(Object generic) {
        GenericRecord record;
        Schema schema;
        if (generic instanceof GenericRecord && ((schema = (record = (GenericRecord)generic).getSchema()).equals((Object)Schemas.COMPRESSED_IDENTIFIER) || schema.equals((Object)Schemas.PLAIN_IDENTIFIER))) {
            return this.decodeIdentifier(record);
        }
        return this.decodeLiteral(generic);
    }

    private Resource decodeIdentifier(GenericRecord record) {
        Schema schema = record.getSchema();
        if (schema.equals((Object)Schemas.COMPRESSED_IDENTIFIER)) {
            try {
                return (Resource)this.dictionary.objectFor(((Integer)record.get(0)).intValue());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot access dictionary: " + ex.getMessage(), ex);
            }
        }
        if (schema.equals((Object)Schemas.PLAIN_IDENTIFIER)) {
            String string = record.get(0).toString();
            if (string.startsWith("_:")) {
                return this.factory.createBNode(string.substring(2));
            }
            return this.factory.createURI(string);
        }
        throw new IllegalArgumentException("Unsupported encoded identifier: " + record);
    }

    private Literal decodeLiteral(Object generic) {
        if (generic instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)generic;
            Schema schema = record.getSchema();
            if (schema.equals((Object)Schemas.STRING_LANG)) {
                String label = record.get(0).toString();
                Object language = record.get(1);
                return this.factory.createLiteral(label, language.toString());
            }
            if (schema.equals((Object)Schemas.SHORT)) {
                return this.factory.createLiteral(((Integer)record.get(0)).shortValue());
            }
            if (schema.equals((Object)Schemas.BYTE)) {
                return this.factory.createLiteral(((Integer)record.get(0)).byteValue());
            }
            if (schema.equals((Object)Schemas.BIGINTEGER)) {
                return this.factory.createLiteral(record.get(0).toString(), XMLSchema.INTEGER);
            }
            if (schema.equals((Object)Schemas.BIGDECIMAL)) {
                return this.factory.createLiteral(record.get(0).toString(), XMLSchema.DECIMAL);
            }
            if (schema.equals((Object)Schemas.CALENDAR)) {
                int tz = (Integer)record.get(0);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeInMillis((Long)record.get(1));
                calendar.setTimeZone(TimeZone.getTimeZone(String.format("GMT%s%02d:%02d", tz >= 0 ? "+" : "-", Math.abs(tz) / 60, Math.abs(tz) % 60)));
                return this.factory.createLiteral(this.datatypeFactory.newXMLGregorianCalendar(calendar));
            }
        } else {
            if (generic instanceof CharSequence) {
                return this.factory.createLiteral(generic.toString());
            }
            if (generic instanceof Boolean) {
                return this.factory.createLiteral(((Boolean)generic).booleanValue());
            }
            if (generic instanceof Long) {
                return this.factory.createLiteral(((Long)generic).longValue());
            }
            if (generic instanceof Integer) {
                return this.factory.createLiteral(((Integer)generic).intValue());
            }
            if (generic instanceof Double) {
                return this.factory.createLiteral(((Double)generic).doubleValue());
            }
            if (generic instanceof Float) {
                return this.factory.createLiteral(((Float)generic).floatValue());
            }
        }
        Preconditions.checkNotNull((Object)generic);
        throw new IllegalArgumentException("Unsupported generic data: " + generic);
    }

    private Statement decodeStatement(GenericRecord record) {
        Resource subj = this.decodeIdentifier((GenericRecord)record.get(0));
        URI pred = (URI)this.decodeIdentifier((GenericRecord)record.get(1));
        Value obj = this.decodeValue(record.get(2));
        Resource ctx = this.decodeIdentifier((GenericRecord)record.get(3));
        if (ctx == null) {
            return this.factory.createStatement(subj, pred, obj);
        }
        return this.factory.createStatement(subj, pred, obj, ctx);
    }

    private Object encodeNodes(Iterable<? extends Object> nodes) {
        int size = Iterables.size(nodes);
        if (size == 1) {
            return this.encodeNode(Iterables.get(nodes, (int)0));
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)size);
        for (Object object : nodes) {
            list.add(this.encodeNode(object));
        }
        return list;
    }

    private Object encodeNode(Object node) {
        if (node instanceof Record) {
            return this.encodeRecord((Record)node, null);
        }
        if (node instanceof Literal) {
            return this.encodeLiteral((Literal)node);
        }
        if (node instanceof Resource) {
            return this.encodeIdentifier((Resource)node);
        }
        if (node instanceof Statement) {
            return this.encodeStatement((Statement)node);
        }
        Preconditions.checkNotNull((Object)node);
        throw new IllegalArgumentException("Unsupported node: " + node);
    }

    private Object encodeRecord(Record record, @Nullable Set<URI> propertiesToEncode) {
        URI id = record.getID();
        Object encodedID = id == null ? null : this.encodeIdentifier((Resource)id);
        ArrayList props = Lists.newArrayList();
        for (URI property : record.getProperties()) {
            if (propertiesToEncode != null && !propertiesToEncode.contains(property)) continue;
            this.ensureInDictionary(property);
            List nodes = record.get(property);
            if (property.equals((Object)RDF.TYPE)) {
                for (Object value : nodes) {
                    if (!(value instanceof URI)) continue;
                    this.ensureInDictionary((URI)value);
                }
            }
            GenericData.Record prop = new GenericData.Record(Schemas.PROPERTY);
            prop.put("propertyURI", this.encodeIdentifier((Resource)property));
            prop.put("propertyValue", this.encodeNodes(nodes));
            props.add(prop);
        }
        return SerializerAvro.newGenericRecord(Schemas.RECORD, encodedID, props);
    }

    private Object encodeValue(Value value) {
        if (value instanceof Literal) {
            return this.encodeLiteral((Literal)value);
        }
        if (value instanceof Resource) {
            return this.encodeIdentifier((Resource)value);
        }
        throw new IllegalArgumentException("Unsupported value: " + value);
    }

    private Object encodeIdentifier(Resource identifier) {
        if (identifier instanceof URI) {
            try {
                Integer key = this.dictionary.keyFor((Serializable)((URI)identifier), false);
                if (key != null) {
                    return SerializerAvro.newGenericRecord(Schemas.COMPRESSED_IDENTIFIER, key);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot access dictionary: " + ex.getMessage(), ex);
            }
        }
        String id = identifier instanceof BNode ? "_:" + ((BNode)identifier).getID() : identifier.stringValue();
        return SerializerAvro.newGenericRecord(Schemas.PLAIN_IDENTIFIER, id);
    }

    private Object encodeLiteral(Literal literal) {
        URI datatype = literal.getDatatype();
        if (datatype == null || datatype.equals((Object)XMLSchema.STRING)) {
            String language = literal.getLanguage();
            if (language == null) {
                return literal.getLabel();
            }
            return SerializerAvro.newGenericRecord(Schemas.STRING_LANG, literal.getLabel(), language);
        }
        if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
            return literal.booleanValue();
        }
        if (datatype.equals((Object)XMLSchema.LONG)) {
            return literal.longValue();
        }
        if (datatype.equals((Object)XMLSchema.INT)) {
            return literal.intValue();
        }
        if (datatype.equals((Object)XMLSchema.DOUBLE)) {
            return literal.doubleValue();
        }
        if (datatype.equals((Object)XMLSchema.FLOAT)) {
            return Float.valueOf(literal.floatValue());
        }
        if (datatype.equals((Object)XMLSchema.SHORT)) {
            return SerializerAvro.newGenericRecord(Schemas.SHORT, literal.intValue());
        }
        if (datatype.equals((Object)XMLSchema.BYTE)) {
            return SerializerAvro.newGenericRecord(Schemas.BYTE, literal.intValue());
        }
        if (datatype.equals((Object)XMLSchema.INTEGER)) {
            return SerializerAvro.newGenericRecord(Schemas.BIGINTEGER, literal.stringValue());
        }
        if (datatype.equals((Object)XMLSchema.DECIMAL)) {
            return SerializerAvro.newGenericRecord(Schemas.BIGDECIMAL, literal.stringValue());
        }
        if (datatype.equals((Object)XMLSchema.DATETIME)) {
            XMLGregorianCalendar calendar = literal.calendarValue();
            return SerializerAvro.newGenericRecord(Schemas.CALENDAR, calendar.getTimezone(), calendar.toGregorianCalendar().getTimeInMillis());
        }
        throw new IllegalArgumentException("Unsupported literal: " + literal);
    }

    private Object encodeStatement(Statement statement) {
        return SerializerAvro.newGenericRecord(Schemas.STATEMENT, this.encodeIdentifier(statement.getSubject()), this.encodeIdentifier((Resource)statement.getPredicate()), this.encodeValue(statement.getObject()), this.encodeIdentifier(statement.getContext()));
    }

    private URI ensureInDictionary(URI uri) {
        try {
            this.dictionary.keyFor((Serializable)uri);
            return uri;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot access dictionary: " + ex.getMessage(), ex);
        }
    }

    private static GenericData.Record newGenericRecord(Schema schema, Object ... fieldValues) {
        GenericData.Record record = new GenericData.Record(schema);
        for (int i = 0; i < fieldValues.length; ++i) {
            record.put(i, fieldValues[i]);
        }
        return record;
    }

    private static final class Schemas {
        public static final String NAMESPACE = "eu.fbk.knowledgestore";
        public static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
        public static final Schema BOOLEAN = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        public static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);
        public static final Schema STRING_LANG = Schema.createRecord((String)"stringlang", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema LONG = Schema.create((Schema.Type)Schema.Type.LONG);
        public static final Schema INT = Schema.create((Schema.Type)Schema.Type.INT);
        public static final Schema SHORT = Schema.createRecord((String)"short", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema BYTE = Schema.createRecord((String)"byte", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema DOUBLE = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        public static final Schema FLOAT = Schema.create((Schema.Type)Schema.Type.FLOAT);
        public static final Schema BIGINTEGER = Schema.createRecord((String)"biginteger", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema BIGDECIMAL = Schema.createRecord((String)"bigdecimal", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema PLAIN_IDENTIFIER = Schema.createRecord((String)"plainidentifier", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema COMPRESSED_IDENTIFIER = Schema.createRecord((String)"compressedidentifier", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema IDENTIFIER = Schema.createUnion((List)ImmutableList.of((Object)PLAIN_IDENTIFIER, (Object)COMPRESSED_IDENTIFIER));
        public static final Schema CALENDAR = Schema.createRecord((String)"calendar", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema STATEMENT = Schema.createRecord((String)"statement", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema RECORD = Schema.createRecord((String)"struct", null, (String)"eu.fbk.knowledgestore", (boolean)false);
        public static final Schema NODE = Schema.createUnion((List)ImmutableList.of((Object)BOOLEAN, (Object)STRING, (Object)STRING_LANG, (Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object)DOUBLE, (Object)FLOAT, (Object)BIGINTEGER, (Object)BIGDECIMAL, (Object)PLAIN_IDENTIFIER, (Object[])new Schema[]{COMPRESSED_IDENTIFIER, CALENDAR, STATEMENT, RECORD}));
        public static final Schema LIST = Schema.createArray((Schema)NODE);
        public static final Schema PROPERTY = Schema.createRecord((String)"property", null, (String)"eu.fbk.knowledgestore", (boolean)false);

        private Schemas() {
        }

        static {
            STRING_LANG.setFields((List)ImmutableList.of((Object)new Schema.Field("label", STRING, null, null), (Object)new Schema.Field("language", STRING, null, null)));
            SHORT.setFields((List)ImmutableList.of((Object)new Schema.Field("short", INT, null, null)));
            BYTE.setFields((List)ImmutableList.of((Object)new Schema.Field("byte", INT, null, null)));
            BIGINTEGER.setFields((List)ImmutableList.of((Object)new Schema.Field("biginteger", STRING, null, null)));
            BIGDECIMAL.setFields((List)ImmutableList.of((Object)new Schema.Field("bigdecimal", STRING, null, null)));
            PLAIN_IDENTIFIER.setFields((List)ImmutableList.of((Object)new Schema.Field("identifier", STRING, null, null)));
            COMPRESSED_IDENTIFIER.setFields((List)ImmutableList.of((Object)new Schema.Field("identifier", INT, null, null)));
            CALENDAR.setFields((List)ImmutableList.of((Object)new Schema.Field("timezone", INT, null, null), (Object)new Schema.Field("timestamp", LONG, null, null)));
            STATEMENT.setFields((List)ImmutableList.of((Object)new Schema.Field("subject", IDENTIFIER, null, null), (Object)new Schema.Field("predicate", IDENTIFIER, null, null), (Object)new Schema.Field("object", Schema.createUnion((List)ImmutableList.of((Object)BOOLEAN, (Object)STRING, (Object)STRING_LANG, (Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object)DOUBLE, (Object)FLOAT, (Object)BIGINTEGER, (Object)BIGDECIMAL, (Object)CALENDAR, (Object[])new Schema[]{PLAIN_IDENTIFIER, COMPRESSED_IDENTIFIER})), null, null), (Object)new Schema.Field("context", IDENTIFIER, null, null)));
            PROPERTY.setFields((List)ImmutableList.of((Object)new Schema.Field("propertyURI", COMPRESSED_IDENTIFIER, null, null), (Object)new Schema.Field("propertyValue", Schema.createUnion((List)ImmutableList.of((Object)BOOLEAN, (Object)STRING, (Object)STRING_LANG, (Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object)DOUBLE, (Object)FLOAT, (Object)BIGINTEGER, (Object)BIGDECIMAL, (Object)CALENDAR, (Object[])new Schema[]{PLAIN_IDENTIFIER, COMPRESSED_IDENTIFIER, STATEMENT, RECORD, LIST})), null, null)));
            RECORD.setFields((List)ImmutableList.of((Object)new Schema.Field("id", Schema.createUnion((List)ImmutableList.of((Object)NULL, (Object)PLAIN_IDENTIFIER, (Object)COMPRESSED_IDENTIFIER)), null, null), (Object)new Schema.Field("properties", Schema.createArray((Schema)PROPERTY), null, null)));
        }
    }
}

