/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.knowledgestore.server;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.common.html.HtmlEscapers;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import com.google.common.net.MediaType;
import com.google.common.net.UrlEscapers;
import eu.fbk.knowledgestore.AbstractKnowledgeStore;
import eu.fbk.knowledgestore.AbstractSession;
import eu.fbk.knowledgestore.OperationException;
import eu.fbk.knowledgestore.Outcome;
import eu.fbk.knowledgestore.Session;
import eu.fbk.knowledgestore.data.Criteria;
import eu.fbk.knowledgestore.data.Data;
import eu.fbk.knowledgestore.data.Handler;
import eu.fbk.knowledgestore.data.Record;
import eu.fbk.knowledgestore.data.Representation;
import eu.fbk.knowledgestore.data.Stream;
import eu.fbk.knowledgestore.data.XPath;
import eu.fbk.knowledgestore.datastore.DataStore;
import eu.fbk.knowledgestore.datastore.DataTransaction;
import eu.fbk.knowledgestore.filestore.FileStore;
import eu.fbk.knowledgestore.internal.rdf.RDFUtil;
import eu.fbk.knowledgestore.server.SparqlHelper;
import eu.fbk.knowledgestore.triplestore.TripleStore;
import eu.fbk.knowledgestore.triplestore.TripleTransaction;
import eu.fbk.knowledgestore.vocabulary.KS;
import eu.fbk.knowledgestore.vocabulary.NFO;
import eu.fbk.knowledgestore.vocabulary.NIE;
import info.aduna.iteration.CloseableIteration;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.ParsedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Server
extends AbstractKnowledgeStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    private static final int DEFAULT_BUFFER_SIZE = 0x1000000;
    private static long fileVersionCounter = 0L;
    private final FileStore fileStore;
    private final DataStore dataStore;
    private final TripleStore tripleStore;
    private final int chunkSize;
    private final int bufferSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server(Builder builder) {
        boolean success = false;
        this.fileStore = (FileStore)Preconditions.checkNotNull((Object)builder.fileStore);
        this.dataStore = (DataStore)Preconditions.checkNotNull((Object)builder.dataStore);
        this.tripleStore = (TripleStore)Preconditions.checkNotNull((Object)builder.tripleStore);
        try {
            this.chunkSize = (Integer)MoreObjects.firstNonNull((Object)builder.chunkSize, (Object)1024);
            this.bufferSize = (Integer)MoreObjects.firstNonNull((Object)builder.bufferSize, (Object)0x1000000);
            Preconditions.checkArgument((this.chunkSize > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.bufferSize > 0 ? 1 : 0) != 0);
            try {
                this.fileStore.init();
                this.dataStore.init();
                this.tripleStore.init();
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
            success = true;
        }
        finally {
            if (!success) {
                Server.closeQuietly(this.fileStore);
                Server.closeQuietly(this.dataStore);
                Server.closeQuietly(this.tripleStore);
            }
        }
    }

    protected Session doNewSession(@Nullable String username, @Nullable String password) {
        return new SessionImpl(username, password);
    }

    protected void doClose() {
        Server.closeQuietly(this.fileStore);
        Server.closeQuietly(this.dataStore);
        Server.closeQuietly(this.tripleStore);
    }

    private static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                LOGGER.error("Error closing " + closeable.getClass().getSimpleName() + ": " + ex.getMessage(), ex);
            }
        }
    }

    private void preprocess(Record record) throws Throwable {
        if (KS.RESOURCE.equals((Object)record.getSystemType())) {
            record.set(KS.STORED_AS, null, new Object[0]);
        }
    }

    private void expand(Record record) throws Throwable {
    }

    private Map<URI, Record> extractRelated(Record record) throws Throwable {
        URI id = record.getID();
        URI type = record.getSystemType();
        HashMap map = Maps.newHashMap();
        if (type.equals((Object)KS.RESOURCE)) {
            for (URI mentionID : record.get(KS.HAS_MENTION, URI.class)) {
                map.put(mentionID, Record.create((URI)mentionID, (URI[])new URI[]{KS.MENTION}).add(KS.MENTION_OF, (Object)id, new Object[0]));
            }
        } else if (type.equals((Object)KS.MENTION)) {
            URI resourceID = (URI)record.getUnique(KS.MENTION_OF, URI.class);
            if (resourceID != null) {
                map.put(resourceID, Record.create((URI)resourceID, (URI[])new URI[]{KS.RESOURCE}).add(KS.HAS_MENTION, (Object)id, new Object[0]));
            }
        } else {
            throw new Error("Unexpected type: " + type);
        }
        return map;
    }

    public static Builder builder(FileStore fileStore, DataStore dataStore, TripleStore tripleStore) {
        return new Builder(fileStore, dataStore, tripleStore);
    }

    public static class Builder {
        private final FileStore fileStore;
        private final DataStore dataStore;
        private final TripleStore tripleStore;
        @Nullable
        private Integer chunkSize;
        @Nullable
        private Integer bufferSize;

        Builder(FileStore fileStore, DataStore dataStore, TripleStore tripleStore) {
            this.fileStore = (FileStore)Preconditions.checkNotNull((Object)fileStore);
            this.dataStore = (DataStore)Preconditions.checkNotNull((Object)dataStore);
            this.tripleStore = (TripleStore)Preconditions.checkNotNull((Object)tripleStore);
        }

        public Builder chunkSize(@Nullable Integer chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder bufferSize(@Nullable Integer bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Server build() {
            return new Server(this);
        }
    }

    private static interface RecordUpdater {
        @Nullable
        public Record computeNewRecord(URI var1, @Nullable Record var2, @Nullable Record var3) throws Throwable;
    }

    private final class SessionImpl
    extends AbstractSession {
        SessionImpl(@Nullable String username, String password) {
            super(Data.newNamespaceMap((Map)Data.newNamespaceMap(), (Map)Data.getNamespaceMap()), username, password);
        }

        private void check(boolean condition, Outcome.Status status, @Nullable URI objectID, @Nullable String message, Object ... args) throws OperationException {
            if (!condition) {
                throw this.newException(status, objectID, message == null ? null : String.format(message, args), new Throwable[0]);
            }
        }

        private Outcome newOutcome(@Nullable Outcome.Status status, @Nullable URI objectID, @Nullable String message, Object ... args) {
            return Outcome.create((Outcome.Status)(status == null ? Outcome.Status.ERROR_UNEXPECTED : status), (URI)this.getInvocationID(), (URI)objectID, message == null ? null : String.format(message, args));
        }

        private OperationException newException(@Nullable Outcome.Status status, @Nullable URI objectID, @Nullable String message, Throwable ... causes) {
            return new OperationException(this.newOutcome(status, objectID, message, new Object[0]), causes);
        }

        private <T> Stream<T> attach(final DataTransaction transaction, Stream<T> stream) {
            return stream.onClose(new Object[]{new Closeable(){

                @Override
                public void close() throws IOException {
                    transaction.end(true);
                }
            }});
        }

        private <T> Stream<T> attach(final TripleTransaction transaction, Stream<T> stream) {
            return stream.onClose(new Object[]{new Closeable(){

                @Override
                public void close() throws IOException {
                    transaction.end(true);
                }
            }});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Representation doDownload(@Nullable Long timeout, URI resourceID, @Nullable Set<String> mimeTypes, boolean useCaches) throws Throwable {
            DataTransaction transaction = Server.this.dataStore.begin(true);
            try {
                InputStream stream;
                Record resource = (Record)transaction.lookup(KS.RESOURCE, (Set<? extends URI>)ImmutableSet.of((Object)resourceID), (Set<? extends URI>)ImmutableSet.of((Object)KS.STORED_AS)).getUnique();
                if (resource == null) {
                    Representation representation = null;
                    return representation;
                }
                Record metadata = (Record)resource.getUnique(KS.STORED_AS, Record.class);
                if (metadata == null) {
                    Representation representation = null;
                    return representation;
                }
                String fileName = (String)metadata.getUnique(NFO.FILE_NAME, String.class);
                this.check(fileName != null, null, resourceID, "No filename stored for resource (!)", new Object[0]);
                String transformToType = null;
                String fileTypeString = (String)metadata.getUnique(NIE.MIME_TYPE, String.class);
                if (mimeTypes != null) {
                    this.check(fileTypeString != null, Outcome.Status.ERROR_NOT_ACCEPTABLE, resourceID, "No MIME type stored for file %s", fileName);
                    boolean compatible = false;
                    MediaType fileType = MediaType.parse((String)fileTypeString);
                    for (String type : mimeTypes) {
                        try {
                            boolean matches = fileType.is(MediaType.parse((String)type).withoutParameters());
                            boolean transform = !matches && !compatible && this.canTransform(fileTypeString, type);
                            compatible = compatible || matches || transform;
                            transformToType = transform ? type : null;
                        }
                        catch (IllegalArgumentException matches) {}
                    }
                    this.check(compatible, Outcome.Status.ERROR_NOT_ACCEPTABLE, resourceID, "Incompatible MIME type %s for file %s", fileType, fileName);
                }
                this.check((stream = Server.this.fileStore.read(fileName)) != null, null, resourceID, "File %s missing for resource %s (!)", fileName);
                if (transformToType != null) {
                    String ext = (String)Iterables.getFirst((Iterable)Data.mimeTypeToExtensions(transformToType), (Object)"bin");
                    String name = (String)MoreObjects.firstNonNull((Object)metadata.getUnique(NFO.FILE_NAME, String.class, null), (Object)"download") + "." + ext;
                    stream = this.transform(fileTypeString, transformToType, stream);
                    Representation representation = Representation.create((InputStream)stream);
                    Record meta = representation.getMetadata();
                    meta.setID(metadata.getID());
                    meta.set(NIE.MIME_TYPE, (Object)transformToType, new Object[0]);
                    meta.set(NFO.FILE_NAME, (Object)name, new Object[0]);
                    meta.set(NFO.FILE_LAST_MODIFIED, metadata.getUnique(NFO.FILE_LAST_MODIFIED), new Object[0]);
                    Representation representation2 = representation;
                    return representation2;
                }
                Representation representation = Representation.create((InputStream)stream);
                representation.getMetadata().setID(metadata.getID());
                for (URI property : metadata.getProperties()) {
                    representation.getMetadata().set(property, (Object)metadata.get(property), new Object[0]);
                }
                Iterator<String> iterator = representation;
                return iterator;
            }
            finally {
                transaction.end(true);
            }
        }

        private boolean canTransform(String fromType, String toType) {
            String type = toType.trim().toLowerCase();
            return type.equals("text/html") || type.equals("text/plain");
        }

        private InputStream transform(String fromType, String toType, InputStream fromStream) throws IOException {
            String type = toType.trim().toLowerCase();
            if (type.equals("text/html")) {
                byte[] data = ByteStreams.toByteArray((InputStream)fromStream);
                String string = new String(data, Charsets.UTF_8);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, Charsets.UTF_8);
                writer.append("<html>\n");
                writer.append("<head>\n");
                writer.append("<meta http-equiv=\"Content-type\" content=\"text/html;charset=UTF-8\"/>\n");
                writer.append("</head>\n");
                writer.append("<body>\n");
                writer.append("<pre>");
                writer.append(HtmlEscapers.htmlEscaper().escape(string));
                writer.append("</pre>\n");
                writer.append("</body>\n");
                writer.append("</html>\n");
                writer.close();
                return new ByteArrayInputStream(out.toByteArray());
            }
            if (type.equals("text/plain")) {
                return fromStream;
            }
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Outcome doUpload(@Nullable Long timeout, URI resourceID, @Nullable Representation representation) throws Throwable {
            String fileName = null;
            DataTransaction transaction = Server.this.dataStore.begin(false);
            try {
                Outcome.Status status;
                Record resource = (Record)transaction.lookup(KS.RESOURCE, (Set<? extends URI>)ImmutableSet.of((Object)resourceID), null).getUnique();
                if (resource == null) {
                    throw this.newException(Outcome.Status.ERROR_DEPENDENCY_NOT_FOUND, resourceID, "Specified resource does not exist", new Throwable[0]);
                }
                Record oldMetadata = (Record)resource.getUnique(KS.STORED_AS, Record.class);
                if (representation == null) {
                    status = oldMetadata == null ? Outcome.Status.OK_UNMODIFIED : Outcome.Status.OK_DELETED;
                    resource.set(KS.STORED_AS, null, new Object[0]);
                } else {
                    status = oldMetadata == null ? Outcome.Status.OK_CREATED : Outcome.Status.OK_MODIFIED;
                    Record metadata = representation.getMetadata();
                    metadata.setID(Data.getValueFactory().createURI(resourceID + "_file"));
                    fileName = (String)metadata.getUnique(NFO.FILE_NAME, String.class);
                    String fileType = (String)metadata.getUnique(NIE.MIME_TYPE, String.class);
                    if (fileType != null) {
                        try {
                            MediaType.parse((String)fileType);
                        }
                        catch (IllegalArgumentException ex) {
                            fileType = null;
                            metadata.set(NIE.MIME_TYPE, null, new Object[0]);
                        }
                    }
                    fileName = this.generateFileName(resourceID, fileName, fileType);
                    fileType = fileType != null ? fileType : Data.extensionToMimeType((String)fileName);
                    metadata.set(NFO.FILE_NAME, (Object)fileName, new Object[0]);
                    metadata.set(NIE.MIME_TYPE, (Object)fileType, new Object[0]);
                    try (OutputStream stream = Server.this.fileStore.write(fileName);){
                        CountingOutputStream cos = new CountingOutputStream(stream);
                        HashingOutputStream hos = new HashingOutputStream(Hashing.md5(), (OutputStream)cos);
                        representation.writeTo((OutputStream)hos);
                        hos.close();
                        Record hash = Record.create();
                        hash.set(NFO.HASH_ALGORITHM, (Object)"MD5", new Object[0]);
                        hash.set(NFO.HASH_VALUE, (Object)hos.hash().toString(), new Object[0]);
                        metadata.set(NFO.HAS_HASH, (Object)hash, new Object[0]);
                        metadata.set(NFO.FILE_SIZE, (Object)cos.getCount(), new Object[0]);
                        if (metadata.isNull(NFO.FILE_LAST_MODIFIED)) {
                            metadata.set(NFO.FILE_LAST_MODIFIED, (Object)new Date(), new Object[0]);
                        }
                    }
                    resource.set(KS.STORED_AS, (Object)Record.create((Record)metadata, (boolean)true), new Object[0]);
                }
                if (status != Outcome.Status.OK_UNMODIFIED) {
                    transaction.store(KS.RESOURCE, resource);
                }
                if (oldMetadata != null) {
                    this.deleteFileQuietly((String)oldMetadata.getUnique(NFO.FILE_NAME, String.class));
                }
                transaction.end(true);
                return this.newOutcome(status, resourceID, null, new Object[0]);
            }
            catch (Throwable ex) {
                this.deleteFileQuietly(fileName);
                transaction.end(false);
                throw ex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String generateFileName(URI resourceID, @Nullable String suppliedFileName, @Nullable String suppliedFileType) {
            List mimeExtensions;
            String name;
            int index;
            String fileName = "file";
            String fileExt = "bin";
            if (suppliedFileName != null && (index = (name = UrlEscapers.urlPathSegmentEscaper().escape(suppliedFileName)).lastIndexOf(46)) > 0 && index < name.length() - 1) {
                fileName = name.substring(0, index);
                fileExt = name.substring(index + 1);
            }
            if (suppliedFileType != null && !(mimeExtensions = Data.mimeTypeToExtensions((String)suppliedFileType)).isEmpty()) {
                fileExt = (String)mimeExtensions.get(0);
            }
            String uri = resourceID.stringValue();
            int start = 0;
            int end = uri.length();
            for (int index2 = 0; index2 < uri.length(); ++index2) {
                char ch = uri.charAt(index2);
                if (ch == '/' || ch == ':') {
                    start = index2 + 1;
                    continue;
                }
                if (ch == '.') {
                    end = index2;
                    continue;
                }
                if (ch != '#' && ch != '?') continue;
                end = Math.min(end, index2);
                break;
            }
            if (start < end) {
                fileName = uri.substring(start, end);
            }
            long ts = System.currentTimeMillis();
            Class<Server> clazz = Server.class;
            synchronized (Server.class) {
                ++fileVersionCounter;
                if (fileVersionCounter < ts) {
                    fileVersionCounter = ts;
                }
                long fileVersion = fileVersionCounter;
                // ** MonitorExit[var13_13] (shouldn't be in output)
                return fileName + "." + Long.toString(fileVersion, 32) + "." + fileExt;
            }
        }

        private void deleteFileQuietly(@Nullable String fileName) {
            if (fileName != null) {
                try {
                    Server.this.fileStore.delete(fileName);
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to delete file " + fileName + " (will be garbage collected)", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long doCount(@Nullable Long timeout, URI type, @Nullable XPath condition, @Nullable Set<URI> ids) throws Throwable {
            Set<URI> actualIDs;
            Set<URI> set = actualIDs = ids != null ? ids : this.retrieveToLookup(type, condition);
            if (actualIDs != null) {
                return this.doRetrieve(timeout, type, condition, actualIDs, condition == null ? null : condition.getProperties(), null, null).count();
            }
            DataTransaction tx = Server.this.dataStore.begin(true);
            try {
                long l = tx.count(type, condition);
                return l;
            }
            finally {
                tx.end(true);
            }
        }

        protected Stream<Record> doRetrieve(@Nullable Long timeout, URI type, @Nullable XPath condition, @Nullable Set<URI> ids, @Nullable Set<URI> properties, @Nullable Long offset, @Nullable Long limit) throws Throwable {
            Stream stream;
            Set<URI> actualIDs = ids != null ? ids : this.retrieveToLookup(type, condition);
            DataTransaction tx = Server.this.dataStore.begin(true);
            if (actualIDs == null) {
                stream = tx.retrieve(type, condition, (Set<? extends URI>)properties);
            } else {
                Sets.SetView props = properties;
                if (props != null && condition != null && !props.containsAll(condition.getProperties())) {
                    props = Sets.union(properties, (Set)condition.getProperties());
                }
                stream = tx.lookup(type, (Set<? extends URI>)actualIDs, (Set<? extends URI>)props);
                if (condition != null) {
                    stream = stream.filter(condition.asPredicate(), 0);
                }
                if (props != properties) {
                    final URI[] array = properties.toArray(new URI[properties.size()]);
                    stream = stream.transform((Function)new Function<Record, Record>(){

                        public Record apply(Record record) {
                            record.retain(array);
                            return record;
                        }
                    }, 0);
                }
            }
            if (offset != null || limit != null) {
                stream = stream.slice(((Long)MoreObjects.firstNonNull((Object)offset, (Object)0L)).longValue(), ((Long)MoreObjects.firstNonNull((Object)limit, (Object)Long.MAX_VALUE)).longValue());
            }
            return this.attach(tx, stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<URI> retrieveToLookup(URI type, @Nullable XPath condition) throws IOException {
            if (condition == null) {
                return null;
            }
            HashMap restrictions = Maps.newHashMap();
            condition.decompose((Map)restrictions);
            DataTransaction tx = null;
            HashSet ids = null;
            try {
                if (KS.RESOURCE.equals((Object)type) && restrictions.containsKey(KS.HAS_MENTION)) {
                    ids = Sets.newHashSet();
                    tx = Server.this.dataStore.begin(true);
                    tx.lookup(KS.MENTION, (Set)restrictions.get(KS.HAS_MENTION), (Set<? extends URI>)ImmutableSet.of((Object)KS.MENTION_OF)).transform(URI.class, true, new Object[]{KS.MENTION_OF}).toCollection((Collection)ids);
                } else if (KS.MENTION.equals((Object)type) && restrictions.containsKey(KS.MENTION_OF)) {
                    ids = Sets.newHashSet();
                    tx = Server.this.dataStore.begin(true);
                    tx.lookup(KS.RESOURCE, (Set)restrictions.get(KS.MENTION_OF), (Set<? extends URI>)ImmutableSet.of((Object)KS.HAS_MENTION)).transform(URI.class, true, new Object[]{KS.HAS_MENTION}).toCollection((Collection)ids);
                }
            }
            finally {
                if (tx != null) {
                    tx.end(false);
                }
            }
            return ids;
        }

        protected void doCreate(@Nullable Long timeout, URI type, @Nullable Stream<? extends Record> records, Handler<? super Outcome> handler) throws Throwable {
            this.modify(new RecordUpdater(){

                @Override
                public Record computeNewRecord(URI id, @Nullable Record oldRecord, @Nullable Record suppliedRecord) throws Throwable {
                    assert (suppliedRecord != null);
                    SessionImpl.this.check(oldRecord == null, Outcome.Status.ERROR_OBJECT_ALREADY_EXISTS, id, null, new Object[0]);
                    return suppliedRecord;
                }
            }, type, null, records, handler);
        }

        protected void doMerge(@Nullable Long timeout, final URI type, @Nullable Stream<? extends Record> records, final @Nullable Criteria criteria, Handler<? super Outcome> handler) throws Throwable {
            this.modify(new RecordUpdater(){

                @Override
                public Record computeNewRecord(URI id, @Nullable Record oldRecord, @Nullable Record suppliedRecord) throws Throwable {
                    assert (suppliedRecord != null);
                    if (criteria == null) {
                        return oldRecord;
                    }
                    Record record = oldRecord == null ? Record.create((URI)id, (URI[])new URI[]{type}) : Record.create((Record)oldRecord, (boolean)true);
                    criteria.merge(record, suppliedRecord);
                    return record;
                }
            }, type, null, records, handler);
        }

        protected void doUpdate(@Nullable Long timeout, URI type, @Nullable XPath condition, @Nullable Set<URI> ids, final @Nullable Record record, final @Nullable Criteria criteria, Handler<? super Outcome> handler) throws Throwable {
            this.modify(new RecordUpdater(){

                @Override
                public Record computeNewRecord(URI id, @Nullable Record oldRecord, @Nullable Record suppliedRecord) throws Throwable {
                    assert (oldRecord != null);
                    assert (suppliedRecord == null);
                    Record newRecord = Record.create((Record)oldRecord, (boolean)true);
                    criteria.merge(newRecord, record);
                    return newRecord;
                }
            }, type, condition, ids == null ? null : Stream.create(ids), handler);
        }

        protected void doDelete(@Nullable Long timeout, URI type, @Nullable XPath condition, @Nullable Set<URI> ids, Handler<? super Outcome> handler) throws Throwable {
            this.modify(new RecordUpdater(){

                @Override
                public Record computeNewRecord(URI id, @Nullable Record oldRecord, @Nullable Record suppliedRecord) throws Throwable {
                    assert (oldRecord != null);
                    assert (suppliedRecord == null);
                    return null;
                }
            }, type, condition, ids == null ? null : Stream.create(ids), handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void modify(final RecordUpdater updater, final URI type, final @Nullable XPath condition, @Nullable Stream<?> recordOrIDStream, final Handler<? super Outcome> handler) throws Throwable {
            Stream<?> stream = recordOrIDStream != null ? recordOrIDStream : this.retrieveIDs(type, condition);
            try {
                stream.chunk(Server.this.chunkSize).toHandler(new Handler<List<?>>(){
                    private final AtomicLong index = new AtomicLong(0L);

                    public void handle(@Nullable List<?> chunk) throws Throwable {
                        boolean success;
                        long startIndex = this.index.get();
                        if (chunk != null && !(success = SessionImpl.this.modifyChunk(updater, type, condition, chunk, (Handler<? super Outcome>)handler, this.index, false))) {
                            this.index.set(startIndex);
                            for (int i = 0; !Thread.interrupted() && i < chunk.size(); ++i) {
                                ImmutableList newChunk = ImmutableList.of(chunk.get(i));
                                SessionImpl.this.modifyChunk(updater, type, condition, (List)newChunk, (Handler<? super Outcome>)handler, this.index, true);
                            }
                        }
                    }
                });
                handler.handle(null);
            }
            finally {
                Server.closeQuietly(stream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean modifyChunk(RecordUpdater updater, URI type, @Nullable XPath condition, List<?> suppliedRecordsOrIDs, Handler<? super Outcome> handler, AtomicLong index, boolean reportFailure) throws Throwable {
            long startIndex = index.get();
            ValueFactory factory = Data.getValueFactory();
            int size = suppliedRecordsOrIDs.size();
            ArrayList outcomes = Lists.newArrayListWithCapacity((int)size);
            ArrayList ids = Lists.newArrayListWithCapacity((int)size);
            ArrayList suppliedRecords = Lists.newArrayListWithExpectedSize((int)size);
            for (Object input : suppliedRecordsOrIDs) {
                if (input instanceof URI) {
                    ids.add((URI)input);
                    suppliedRecords.add(null);
                    continue;
                }
                Record record = (Record)input;
                ids.add(record.getID());
                suppliedRecords.add(record);
            }
            DataTransaction tx = Server.this.dataStore.begin(false);
            try {
                Stream<Record> stream = tx.lookup(type, (Set<? extends URI>)ImmutableSet.copyOf((Collection)ids), null);
                Map oldRecords = stream.toMap((Function)new Function<Record, URI>(){

                    public URI apply(Record record) {
                        return record.getID();
                    }
                }, Functions.identity());
                for (int i = 0; !Thread.interrupted() && i < size; ++i) {
                    URI id = (URI)ids.get(i);
                    Record oldRecord = (Record)oldRecords.get(id);
                    Record suppliedRecord = (Record)suppliedRecords.get(i);
                    if (id == null) {
                        assert (suppliedRecord != null);
                        outcomes.add(this.newOutcome(Outcome.Status.ERROR_INVALID_INPUT, null, "Missing ID for record:\n" + suppliedRecord.toString(Data.getNamespaceMap(), true), new Object[0]));
                        continue;
                    }
                    if (suppliedRecord == null && (oldRecord == null || condition != null && !condition.evalBoolean((Object)oldRecord))) continue;
                    URI oldInvocationID = this.getInvocationID();
                    this.setInvocationID(factory.createURI(oldInvocationID + "#" + index.incrementAndGet()));
                    try {
                        outcomes.add(this.modifyRecord(updater, tx, id, oldRecord, suppliedRecord));
                        continue;
                    }
                    catch (OperationException ex) {
                        outcomes.add(ex.getOutcome());
                        continue;
                    }
                    finally {
                        this.setInvocationID(oldInvocationID);
                    }
                }
                tx.end(true);
                for (Outcome outcome : outcomes) {
                    handler.handle((Object)outcome);
                }
                return true;
            }
            catch (Throwable ex) {
                LOGGER.error("Data processing error", ex);
                if (reportFailure) {
                    for (int i = 0; i < ids.size(); ++i) {
                        index.set(startIndex);
                        handler.handle((Object)Outcome.create((Outcome.Status)Outcome.Status.ERROR_UNEXPECTED, (URI)factory.createURI(this.getInvocationID() + "#" + index.incrementAndGet()), (URI)((URI)ids.get(i)), (String)ex.getMessage()));
                    }
                }
                tx.end(false);
                return false;
            }
        }

        private Outcome modifyRecord(RecordUpdater updater, DataTransaction transaction, URI recordID, @Nullable Record oldRecord, @Nullable Record suppliedRecord) throws Throwable {
            Record newRecord;
            HashSet recordsToStore = Sets.newHashSet();
            HashSet recordsToDelete = Sets.newHashSet();
            if (suppliedRecord != null) {
                Server.this.preprocess(suppliedRecord);
            }
            if ((newRecord = updater.computeNewRecord(recordID, oldRecord, suppliedRecord)) != null) {
                Server.this.expand(newRecord);
            }
            Outcome.Status status = Outcome.Status.OK_UNMODIFIED;
            if (newRecord == null) {
                if (oldRecord != null) {
                    recordsToDelete.add(oldRecord);
                    status = Outcome.Status.OK_DELETED;
                }
            } else if (oldRecord == null) {
                recordsToStore.add(newRecord);
                status = Outcome.Status.OK_CREATED;
            } else if (!oldRecord.hash(new URI[0]).equals(newRecord.hash(new URI[0]))) {
                recordsToStore.add(newRecord);
                status = Outcome.Status.OK_MODIFIED;
            }
            if (status == Outcome.Status.OK_UNMODIFIED) {
                return this.newOutcome(status, recordID, null, new Object[0]);
            }
            ImmutableMap nilMap = ImmutableMap.of();
            ImmutableMap oldMap = oldRecord == null ? nilMap : Server.this.extractRelated(oldRecord);
            ImmutableMap newMap = newRecord == null ? nilMap : Server.this.extractRelated(newRecord);
            for (URI id : Sets.union(oldMap.keySet(), newMap.keySet())) {
                URI property;
                Object newProperties;
                Record oldRel = (Record)oldMap.get(id);
                Record newRel = (Record)newMap.get(id);
                URI type = ((Record)MoreObjects.firstNonNull((Object)oldRel, (Object)newRel)).getSystemType();
                if (oldRel != null && newRel != null) {
                    for (URI property2 : oldRel.getProperties()) {
                        List newValues = newRel.get(property2, URI.class);
                        if (newValues.isEmpty()) continue;
                        List oldValues = oldRel.get(property2, URI.class);
                        oldRel.remove(property2, (Object)newValues, new Object[0]);
                        newRel.remove(property2, (Object)oldValues, new Object[0]);
                    }
                }
                ImmutableList nilList = ImmutableList.of();
                Object oldProperties = oldRel == null ? nilList : oldRel.getProperties();
                Object object = newProperties = newRel == null ? nilList : newRel.getProperties();
                if (oldProperties.isEmpty() && newProperties.isEmpty()) continue;
                Record related = (Record)transaction.lookup(type, (Set<? extends URI>)ImmutableSet.of((Object)id), null).getUnique();
                if (related == null) {
                    related = Record.create((URI)id, (URI[])new URI[]{type});
                }
                recordsToStore.add(related);
                Iterator iterator = oldProperties.iterator();
                while (iterator.hasNext()) {
                    property = (URI)iterator.next();
                    assert (oldRel != null);
                    if (property.equals((Object)RDF.TYPE)) continue;
                    related.remove(property, (Object)oldRel.get(property), new Object[0]);
                }
                iterator = newProperties.iterator();
                while (iterator.hasNext()) {
                    property = (URI)iterator.next();
                    assert (newRel != null);
                    if (property.equals((Object)RDF.TYPE)) continue;
                    related.add(property, (Object)newRel.get(property), new Object[0]);
                }
                Server.this.expand(related);
            }
            for (Record record : recordsToStore) {
                transaction.store(record.getSystemType(), record);
            }
            for (Record record : recordsToDelete) {
                transaction.delete(record.getSystemType(), record.getID());
            }
            return this.newOutcome(status, recordID, null, new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Stream<URI> retrieveIDs(URI type, @Nullable XPath condition) throws Throwable {
            FileBackedOutputStream buffer = new FileBackedOutputStream(Server.this.bufferSize);
            try {
                final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buffer, Charsets.UTF_8);
                DataTransaction tx = Server.this.dataStore.begin(true);
                Stream<Record> cursor = null;
                try {
                    cursor = tx.retrieve(type, condition, (Set<? extends URI>)ImmutableSet.of());
                    cursor.toHandler((Handler)new Handler<Record>(){

                        public void handle(Record record) throws Throwable {
                            if (record != null) {
                                writer.write(record.getID().stringValue());
                                writer.write("\n");
                            }
                        }
                    });
                }
                finally {
                    Server.closeQuietly(cursor);
                    tx.end(true);
                    ((Writer)writer).flush();
                }
                final BufferedReader reader = buffer.asByteSource().asCharSource(Charsets.UTF_8).openBufferedStream();
                return Stream.create((Iterator)new AbstractIterator<URI>(){

                    protected URI computeNext() {
                        try {
                            String line = reader.readLine();
                            return line == null ? (URI)this.endOfData() : Data.getValueFactory().createURI(line);
                        }
                        catch (Throwable ex) {
                            throw Throwables.propagate((Throwable)ex);
                        }
                    }
                }).onClose(new Object[]{buffer});
            }
            catch (Throwable ex) {
                buffer.close();
                throw ex;
            }
        }

        protected Stream<Record> doMatch(@Nullable Long timeout, Map<URI, XPath> conditions, Map<URI, Set<URI>> ids, Map<URI, Set<URI>> properties) throws Throwable {
            throw new UnsupportedOperationException();
        }

        protected Outcome doSparqlUpdate(@Nullable Long timeout, @Nullable Stream<? extends Statement> statements) throws Throwable {
            LOGGER.debug("Server.UPDATING");
            TripleTransaction tx = Server.this.tripleStore.begin(false);
            try {
                tx.add((Iterable<? extends Statement>)statements);
                Outcome outcome = this.newOutcome(Outcome.Status.OK_BULK, null, null, new Object[0]);
                tx.end(true);
                return outcome;
            }
            catch (Throwable ex) {
                tx.end(false);
                throw ex;
            }
        }

        protected Outcome doSparqlDelete(@Nullable Long timeout, @Nullable Stream<? extends Statement> statements) throws Throwable {
            LOGGER.debug("Server.REMOVING");
            TripleTransaction tx = Server.this.tripleStore.begin(false);
            try {
                tx.remove((Iterable<? extends Statement>)statements);
                Outcome outcome = this.newOutcome(Outcome.Status.OK_BULK, null, null, new Object[0]);
                tx.end(true);
                return outcome;
            }
            catch (Throwable ex) {
                tx.end(false);
                throw ex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected <T> Stream<T> doSparql(@Nullable Long timeout, Class<T> type, String expression, @Nullable Set<URI> defaultGraphs, @Nullable Set<URI> namedGraphs) throws Throwable {
            Stream<T> stream;
            ParsedQuery parsedQuery;
            try {
                parsedQuery = SparqlHelper.parse(expression, null);
            }
            catch (Throwable ex) {
                throw this.newException(Outcome.Status.ERROR_INVALID_INPUT, null, ex.getMessage(), ex);
            }
            Dataset dataset = parsedQuery.getDataset();
            if (defaultGraphs != null || namedGraphs != null) {
                DatasetImpl ds = new DatasetImpl();
                ImmutableSet emptyGraphs = ImmutableSet.of();
                for (URI graph : (Set)MoreObjects.firstNonNull(defaultGraphs, (Object)emptyGraphs)) {
                    ds.addDefaultGraph(graph);
                }
                for (URI graph : (Set)MoreObjects.firstNonNull(namedGraphs, (Object)emptyGraphs)) {
                    ds.addNamedGraph(graph);
                }
                dataset = ds;
            }
            TripleTransaction tx = Server.this.tripleStore.begin(true);
            TupleExpr expr = parsedQuery.getTupleExpr();
            CloseableIteration<BindingSet, QueryEvaluationException> iteration = SparqlHelper.evaluate(tx, expr, dataset, null, timeout);
            if (type == BindingSet.class) {
                return this.attach(tx, RDFUtil.toBindingsStream(iteration, (Iterable)parsedQuery.getTupleExpr().getBindingNames()));
            }
            if (type == Statement.class) {
                return this.attach(tx, RDFUtil.toStatementStream(iteration));
            }
            if (type != Boolean.class) throw new Error("Unexpected result type: " + type);
            try {
                stream = this.attach(tx, Stream.create((Object[])new Boolean[]{iteration.hasNext()}));
            }
            catch (Throwable throwable) {
                try {
                    iteration.close();
                    throw throwable;
                }
                catch (Throwable ex) {
                    tx.end(true);
                    throw ex;
                }
            }
            iteration.close();
            return stream;
        }

        protected void doClose() {
            Server.this.evictClosedSessions();
        }
    }
}

