/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package eu.fispace.api;

import eu.fispace.api.ag.CropFieldAdviceRequestMessage;
import eu.fispace.api.ag.CropFieldDetailMessage;
import eu.fispace.api.ag.GreenhouseAdvice;
import eu.fispace.api.ag.GreenhouseSensorInformation;
import eu.fispace.api.ag.PhythophthoraAdviceMessage;
import eu.limetri.platform.api.CapabilityTypeRegistration;
import eu.limetri.platform.api.CapabilityType;
import eu.limetri.platform.api.Messages;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainAgriculture {

    public static final String DOMAIN = "ag";
    public static final String SCHEMA = "classpath:/schema/domain/ag/AGMessages.xsd";

    /**
     * Capability to produce phytophthora advice
     *
     * @since 0.5.0
     * @see PhythophthoraAdviceMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PRODUCE_PHYTOPHTHORA_ADVICE = new CapabilityType()
            .withName("phytophthora advice")
            .withSchemaLocation(SCHEMA)
            .withResponseMessageType(PhythophthoraAdviceMessage.class.getSimpleName());

    /**
     * Capability to produce cropfield details
     *
     * @since 0.5.0
     * @see CropFieldDetailMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PRODUCE_CROPFIELD_DETAILS = new CapabilityType()
            .withName("cropfield details")
            .withSchemaLocation(SCHEMA)
            .withResponseMessageType(CropFieldDetailMessage.class.getSimpleName());

    /**
     *
     * @since 0.5.0
     * @see GreenhouseSensorInformation
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_SENSOR_VALUES = new CapabilityType()
            .withName("receive sensor values")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(GreenhouseSensorInformation.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());

    /**
     *
     * @deprecated advice should be pulled, not pushed. use combination of resourceAvailableNotification and PRODUCE_ADVICE capability
     * @since 0.5.0
     * @see GreenhouseAdvice
     */
    @Deprecated
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_GREENHOUSE_ADVICE = new CapabilityType()
            .withName("greenhouse advice")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(GreenhouseAdvice.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());

    /**
     *
     * @since 0.7.2
     * @see CropFieldAdviceRequestMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_ADVICE_REQUEST = new CapabilityType()
            .withName("greenhouse advice")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(CropFieldAdviceRequestMessage.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());
}
