/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.fispace.api;

import eu.fispace.api.common.ResourceAvailableNotificationMessage;
import eu.fispace.api.common.TextNotificationMessage;
import eu.limetri.platform.api.CapabilityTypeRegistration;
import eu.limetri.platform.api.CapabilityType;
import eu.limetri.platform.api.Messages;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainCommon {
    public static final String DOMAIN = "common";
    public static final String SCHEMA = "classpath:/schema/domain/common/CommonMessages.xsd";
    
    /**
     * Capability to receive text notifications
     * 
     * @since 0.7.0
     * @see TextNotificationMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_TEXT_NOTIFICATION = new CapabilityType()
            .withName("receive text notification")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(TextNotificationMessage.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());   
    
    /**
     * Capability to receive resource available notifications
     * For example, when an advice is ready
     * 
     * @since 0.7.0
     * @see ResourceAvailableNotificationMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_RESOURCE_AVAILABLE_NOTIFICATION =new CapabilityType()
            .withName("receive resource available notification")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(ResourceAvailableNotificationMessage.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());      
}
