/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.fispace.api;

import eu.fispace.api.lg.LegDeadlineExceeded;
import eu.fispace.api.lg.LegFinished;
import eu.fispace.api.lg.Notification;
import eu.fispace.api.lg.NotifyDelay;
import eu.fispace.api.lg.TransportPlan;
import eu.limetri.platform.api.CapabilityType;
import eu.limetri.platform.api.CapabilityTypeRegistration;

/**
 *
 * @author Timon Veenstra <timon@agrosense.eu>
 */
public class DomainLogistics {

    public static final String DOMAIN = "lg";
    public static final String SCHEMA = "classpath:/schema/domain/lg/LGMessages.xsd";
    /**
     * message Logistics planning app -> FIspace, notification of logistis plan,
     * can be used for either new logistics plan as well as updates
     *
     * @since 0.7.2
     * @see TransportPlan
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_TRANSPORT_PLAN = new CapabilityType()
            .withName("receive transport plan")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(TransportPlan.class.getSimpleName());
    /**
     * message Logistics planning app -> FIspace, notification that the deadline
     * of a leg has exceeded
     *
     * @since 0.7.2
     * @see LegDeadlineExceeded
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_LEG_DEADLINE_EXCEEDED = new CapabilityType()
            .withName("receive leg deadline exceeded")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(LegDeadlineExceeded.class.getSimpleName());

    /**
     * message FIspace ->Logistics planning app, notification of delay
     *
     * @since 0.7.2
     * @see NotifyDelay
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_NOTIFY_DELAY =  new CapabilityType()
            .withName("receive notification of delay")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(NotifyDelay.class.getSimpleName());
    
    /**
     *  message FIspace -> Logistics planning app, notification about a leg that was finished
     *
     * @since 0.7.2
     * @see LegFinished
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_LEG_FINISHED = new CapabilityType() 
            .withName("receive leg finished")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType(LegFinished.class.getSimpleName());
    
    /**
     * Capability to produce shipment notifications
     * @since 0.7.2
     * @see Notification
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PRODUCE_NOTIFICATION = new CapabilityType()
            .withName("cropfield details")
            .withSchemaLocation(SCHEMA)
            .withResponseMessageType(Notification.class.getSimpleName());        
    
    /**
     * Capability to receive PIA shipment status message
     * @since 0.9.0
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_PIA_SHIPMENT_STATUS_MESSAGE = new CapabilityType()
            .withName("receive PIA shipment status")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType("PIAShipmentStatusMessage");        
    
    /**
     * Capability to receive TIC push message
     * @since 0.9.0
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_TIC_PUSH_MESSAGE =new CapabilityType()
            .withName("receive TIC push message")
            .withSchemaLocation(SCHEMA)
            .withRequestMessageType("TICPushMessage");        
}
