/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package eu.fispace.api;

import eu.fispace.api.ag.AdviceAvailableNotification;
import eu.fispace.api.ag.CropFieldAdviceRequestMessage;
import eu.fispace.api.ag.CropFieldDetailMessage;
import eu.fispace.api.ag.PhythophthoraAdviceMessage;
import eu.fispace.api.ag.ProvideAdviceRequestMessage;
import eu.fispace.api.ag.ProvideAdviceResponseMessage;
import eu.fispace.api.ag.ProvideSensorValuesRequestMessage;
import eu.fispace.api.ag.ProvideSensorValuesResponseMessage;
import eu.fispace.api.ag.ReceiveSensorValuesRequestMessage;
import eu.limetri.ygg.api.CapabilityType;
import eu.limetri.ygg.api.CapabilityTypeRegistration;
import eu.limetri.ygg.api.Messages;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainAgriculture {

    public static final String DOMAIN = "ag";
    public static final String SCHEMA = "classpath:/schema/domain/ag/AGMessages.xsd";
    public static final String CONTEXT_PATH = "eu.fispace.api.ag";

    /**
     * Capability to produce phytophthora advice
     *
     * @since 0.5.0
     * @see PhythophthoraAdviceMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PRODUCE_PHYTOPHTHORA_ADVICE = new CapabilityType()
            .withName("phytophthora advice")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withResponseMessageType(PhythophthoraAdviceMessage.class.getSimpleName());

    /**
     * Capability to produce cropfield details
     *
     * @since 0.5.0
     * @see CropFieldDetailMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PRODUCE_CROPFIELD_DETAILS = new CapabilityType()
            .withName("cropfield details")	
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withResponseMessageType(CropFieldDetailMessage.class.getSimpleName());

    /**
     * Capability to receive sensor values
     * 
     * Example: FIspace provides this capabilty so that an external system can send sensor values for event detection
     * 
     * @since 0.10.1
     * @see ReceiveSensorValuesRequestMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_SENSOR_VALUES = new CapabilityType()
            .withName("receive sensor values")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(ReceiveSensorValuesRequestMessage.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());

    /**
     * Capability to receive an "advice available notification"
     * 
     * Example: a farm management system, that is requesting advices from experts, could provide 
     * this capability so that it can be informed by an expert system as soon as the advice that was 
     * requested by the farmer (via the capability @PROVIDE_ADVICE) is ready.
     * 
     * @since 0.11.0
     * @see AdviceAvailableNotification
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_ADVICE_AVAILABLE_NOTIFICATION = new CapabilityType()
            .withName("RECEIVE_ADVICE_AVAILABLE_NOTIFICATION")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(AdviceAvailableNotification.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());

    /**
     *
     * @since 0.7.2
     * @see CropFieldAdviceRequestMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_ADVICE_REQUEST = new CapabilityType()
            .withName("greenhouse advice")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(CropFieldAdviceRequestMessage.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());
    
     /**
     * Capability to provide sensor values on request
     * 
     * Example: a farmer could provide this capability, so that business partners 
     * could use this capability to get sensor values from the farmer's system
     *
     * @since 0.10.1
     * @see ProvideSensorValuesRequestMessage
     * @see ProvideSensorValuesResponseMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PROVIDE_SENSOR_VALUES = new CapabilityType()
            .withName("provide sensor values")	
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(ProvideSensorValuesRequestMessage.class.getSimpleName())
            .withResponseMessageType(ProvideSensorValuesResponseMessage.class.getSimpleName());

    
     /**
     * Capability to be implemented by a system that is capable of providing an (expert) advice.
     * 
     * Example: an expert system could provice this capability, then a farm management system could use 
     * this capability to get an advice from the expert system
     *
     * @since 0.10.1
     * @see ProvideAdviceRequestMessage
     * @see ProvideAdviceResponseMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PROVIDE_ADVICE = new CapabilityType()
            .withName("provide advice")	
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(ProvideAdviceRequestMessage.class.getSimpleName())
            .withResponseMessageType(ProvideAdviceResponseMessage.class.getSimpleName());
}
