/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.fispace.api;

import eu.fispace.api.lg.*;
import eu.limetri.ygg.api.CapabilityType;
import eu.limetri.ygg.api.CapabilityTypeRegistration;

/**
 *
 * @author Timon Veenstra <timon@agrosense.eu>
 */
public class DomainLogistics {

    public static final String DOMAIN = "lg";
    public static final String SCHEMA = "classpath:/schema/domain/lg/LGMessages.xsd";
    public static final String CONTEXT_PATH = "eu.fispace.api.lg";
    /**
     * message Logistics planning app -> FIspace, notification of logistis plan,
     * can be used for either new logistics plan as well as updates
     *
     * @since 0.7.2
     * @see TransportPlan
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_TRANSPORT_PLAN = new CapabilityType()
            .withName("receive transport plan")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(TransportPlan.class.getSimpleName());
    /**
     * message Logistics planning app -> FIspace, notification that the deadline
     * of a leg has exceeded
     *
     * @since 0.7.2
     * @see LegDeadlineExceeded
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_LEG_DEADLINE_EXCEEDED = new CapabilityType()
            .withName("receive leg deadline exceeded")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(LegDeadlineExceeded.class.getSimpleName());

    /**
     * message FIspace ->Logistics planning app, notification of delay
     *
     * @since 0.7.2
     * @see NotifyDelay
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_NOTIFY_DELAY =  new CapabilityType()
            .withName("receive notification of delay")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(NotifyDelay.class.getSimpleName());

    /**
     *  message FIspace -> Logistics planning app, notification about a leg that was finished
     *
     * @since 0.7.2
     * @see LegFinished
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_LEG_FINISHED = new CapabilityType()
            .withName("receive leg finished")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(LegFinished.class.getSimpleName());

    /**
     * Capability to produce shipment notifications
     * @since 0.7.2
     * @see Notification
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PRODUCE_NOTIFICATION = new CapabilityType()
            .withName("cropfield details")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withResponseMessageType(Notification.class.getSimpleName());

    /**
     * Capability to receive shipment status message
     * Sent by the PIA app, for example when a shipment status changes from
     * "announced" to "in transport"
     *
     * @since 0.11.0
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_SHIPMENT_STATUS = new CapabilityType()
            .withName("RECEIVE_SHIPMENT_STATUS")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(ReceiveShipmentStatusRequestMessage.class.getSimpleName());

    /**
     * Capability to provide detailed information about a specific shipment.
     * Used e.g. by a customer's PIA app to get details about a shipment from the
     * supplier's PIA app.
     *
     * @since 0.11.0
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PROVIDE_SHIPMENT_DETAILS = new CapabilityType()
            .withName("PROVIDE_SHIPMENT_DETAILS")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(ProvideShipmentDetailsRequestMessage.class.getSimpleName())
	    	.withResponseMessageType(ProvideShipmentDetailsResponseMessage.class.getSimpleName());

    /**
     * Capability to receive TIC push message
     * @since 0.9.0
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_TIC_PUSH_MESSAGE =new CapabilityType()
            .withName("receive TIC push message")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType("TICPushMessage");
}
